/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Phaser;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.RubyThread;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.subsystems.SafepointAction;

public class SafepointManager {
    private final RubyContext context;
    private final Set<Thread> runningThreads = Collections.newSetFromMap(new ConcurrentHashMap());
    @CompilerDirectives.CompilationFinal
    private Assumption assumption = Truffle.getRuntime().createAssumption("SafepointManager");
    private final ReentrantLock lock = new ReentrantLock();
    private final Phaser phaser = new Phaser();
    private volatile SafepointAction action;
    private volatile boolean deferred;

    public SafepointManager(RubyContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterThread() {
        CompilerAsserts.neverPartOfCompilation();
        this.lock.lock();
        try {
            this.phaser.register();
            this.runningThreads.add(Thread.currentThread());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void leaveThread() {
        CompilerAsserts.neverPartOfCompilation();
        this.phaser.arriveAndDeregister();
        this.runningThreads.remove(Thread.currentThread());
    }

    public void poll(Node currentNode) {
        this.poll(currentNode, false);
    }

    public void pollFromBlockingCall(Node currentNode) {
        this.poll(currentNode, true);
    }

    private void poll(Node currentNode, boolean fromBlockingCall) {
        block3: {
            try {
                this.assumption.check();
            }
            catch (InvalidAssumptionException e) {
                boolean interruptible;
                RubyThread thread = this.context.getThreadManager().getCurrentThread();
                boolean bl = interruptible = thread.getInterruptMode() == RubyThread.InterruptMode.IMMEDIATE || fromBlockingCall && thread.getInterruptMode() == RubyThread.InterruptMode.ON_BLOCKING;
                if (!interruptible) {
                    return;
                }
                SafepointAction deferredAction = this.assumptionInvalidated(currentNode, true, false);
                if (deferredAction == null) break block3;
                deferredAction.run(thread, currentNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SafepointAction assumptionInvalidated(Node currentNode, boolean holdsGlobalLock, boolean isDrivingThread) {
        SafepointAction deferredAction = this.deferred ? this.action : null;
        RubyThread thread = null;
        if (holdsGlobalLock) {
            thread = this.context.getThreadManager().leaveGlobalLock();
        }
        try {
            this.step(currentNode, thread, isDrivingThread);
        }
        finally {
            if (!isDrivingThread && holdsGlobalLock) {
                this.context.getThreadManager().enterGlobalLock(thread);
            }
        }
        return deferredAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void step(Node currentNode, RubyThread thread, boolean isDrivingThread) {
        this.phaser.arriveAndAwaitAdvance();
        if (isDrivingThread) {
            this.assumption = Truffle.getRuntime().createAssumption("SafepointManager");
        }
        this.phaser.arriveAndAwaitAdvance();
        try {
            if (!this.deferred && thread != null && thread.getStatus() != RubyThread.Status.ABORTING) {
                this.action.run(thread, currentNode);
            }
        }
        finally {
            this.phaser.arriveAndAwaitAdvance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseAllThreadsAndExecute(Node currentNode, boolean deferred, SafepointAction action) {
        if (this.lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Re-entered SafepointManager");
        }
        RubyThread thread = this.context.getThreadManager().getCurrentThread();
        while (!this.lock.tryLock()) {
            this.poll(currentNode);
        }
        try {
            this.pauseAllThreadsAndExecute(currentNode, true, action, deferred);
        }
        finally {
            this.lock.unlock();
            this.context.getThreadManager().enterGlobalLock(thread);
        }
        if (deferred) {
            action.run(thread, currentNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseAllThreadsAndExecuteFromNonRubyThread(boolean deferred, SafepointAction action) {
        if (this.lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Re-entered SafepointManager");
        }
        assert (!this.runningThreads.contains(Thread.currentThread()));
        this.lock.lock();
        try {
            this.enterThread();
            try {
                this.pauseAllThreadsAndExecute(null, false, action, deferred);
            }
            finally {
                this.leaveThread();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void pauseAllThreadsAndExecute(Node currentNode, boolean holdsGlobalLock, SafepointAction action, boolean deferred) {
        this.action = action;
        this.deferred = deferred;
        this.assumption.invalidate();
        this.interruptOtherThreads();
        this.assumptionInvalidated(currentNode, holdsGlobalLock, true);
    }

    public void pauseThreadAndExecuteLater(final Thread thread, RubyNode currentNode, final SafepointAction action) {
        if (Thread.currentThread() == thread) {
            RubyThread rubyThread = this.context.getThreadManager().getCurrentThread();
            action.run(rubyThread, currentNode);
        } else {
            this.pauseAllThreadsAndExecute(currentNode, true, new SafepointAction(){

                @Override
                public void run(RubyThread rubyThread, Node currentNode) {
                    if (Thread.currentThread() == thread) {
                        action.run(rubyThread, currentNode);
                    }
                }
            });
        }
    }

    public void pauseMainThreadAndExecuteLaterFromNonRubyThread(final Thread thread, final SafepointAction action) {
        this.pauseAllThreadsAndExecuteFromNonRubyThread(true, new SafepointAction(){

            @Override
            public void run(RubyThread rubyThread, Node currentNode) {
                if (Thread.currentThread() == thread) {
                    action.run(rubyThread, currentNode);
                }
            }
        });
    }

    private void interruptOtherThreads() {
        Thread current = Thread.currentThread();
        for (Thread thread : this.runningThreads) {
            if (thread == current) continue;
            thread.interrupt();
        }
    }
}

