/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.signal;

import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.subsystems.SafepointAction;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ProcSignalHandler
implements SignalHandler {
    private final RubyContext context;
    private final RubyBasicObject proc;

    public ProcSignalHandler(RubyContext context, RubyBasicObject proc) {
        assert (RubyGuards.isRubyProc(proc));
        this.context = context;
        this.proc = proc;
    }

    @Override
    public void handle(Signal signal) {
        Thread mainThread = this.context.getThreadManager().getRootThread().getCurrentFiberJavaThread();
        this.context.getSafepointManager().pauseMainThreadAndExecuteLaterFromNonRubyThread(mainThread, new SafepointAction(){

            @Override
            public void run(RubyThread thread, Node currentNode) {
                ProcNodes.rootCall(ProcSignalHandler.this.proc, new Object[0]);
            }
        });
    }
}

