/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.ModuleChain;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.CoreSourceSection;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;

public class RubyModule
extends RubyBasicObject
implements ModuleChain {
    public static final Object VISIBILITY_FRAME_SLOT_ID = new Object();
    private final RubyContext context;
    protected final ModuleChain start = new PrependMarker(this);
    @CompilerDirectives.CompilationFinal
    protected ModuleChain parentModule;
    private final RubyModule lexicalParent;
    private final String givenBaseName;
    private String name;
    private final Map<String, InternalMethod> methods = new ConcurrentHashMap<String, InternalMethod>();
    private final Map<String, RubyConstant> constants = new ConcurrentHashMap<String, RubyConstant>();
    private final Map<String, Object> classVariables = new ConcurrentHashMap<String, Object>();
    private final CyclicAssumption unmodifiedAssumption;
    private final Set<RubyModule> dependents = Collections.newSetFromMap(new WeakHashMap());
    private final Set<RubyModule> lexicalDependents = Collections.newSetFromMap(new WeakHashMap());

    public static void debugModuleChain(RubyModule module) {
        for (ModuleChain chain = module; chain != null; chain = chain.getParentModule()) {
            System.err.print(chain.getClass());
            if (!(chain instanceof PrependMarker)) {
                RubyModule real = chain.getActualModule();
                System.err.print(" " + real.getName());
            }
            System.err.println();
        }
    }

    public RubyModule(RubyContext context, RubyClass selfClass, RubyModule lexicalParent, String name, Node currentNode) {
        super(context, selfClass);
        this.context = context;
        this.lexicalParent = lexicalParent;
        this.givenBaseName = name;
        this.unmodifiedAssumption = new CyclicAssumption(name + " is unmodified");
        if (lexicalParent == null) {
            this.name = this.givenBaseName;
        } else {
            this.getAdoptedByLexicalParent(lexicalParent, name, currentNode);
        }
    }

    public void getAdoptedByLexicalParent(RubyModule lexicalParent, String name, Node currentNode) {
        lexicalParent.setConstantInternal(currentNode, name, this, false);
        lexicalParent.addLexicalDependent(this);
        if (this.name == null) {
            RubyClass classClass = this.getLogicalClass().getLogicalClass();
            RubyClass objectClass = classClass.getSuperClass().getSuperClass();
            if (lexicalParent == objectClass) {
                this.name = name;
                this.updateAnonymousChildrenModules();
            } else if (lexicalParent.hasName()) {
                this.name = lexicalParent.getName() + "::" + name;
                this.updateAnonymousChildrenModules();
            }
        }
    }

    private void updateAnonymousChildrenModules() {
        for (Map.Entry<String, RubyConstant> entry : this.constants.entrySet()) {
            RubyModule module;
            RubyConstant constant = entry.getValue();
            if (!(constant.getValue() instanceof RubyModule) || (module = (RubyModule)constant.getValue()).hasName()) continue;
            module.getAdoptedByLexicalParent(this, entry.getKey(), null);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void initCopy(RubyModule from) {
        this.methods.putAll(from.methods);
        this.constants.putAll(from.constants);
        this.classVariables.putAll(from.classVariables);
        this.parentModule = from.start.getParentModule() != from ? from.start.getParentModule() : from.parentModule;
        for (RubyModule ancestor : from.ancestors()) {
            ancestor.addDependent(this);
        }
    }

    public boolean isOnlyAModule() {
        return !(this instanceof RubyClass);
    }

    private void checkFrozen(Node currentNode) {
        if (this.getContext().getCoreLibrary() != null && DebugOperations.verySlowIsFrozen(this.getContext(), this)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().frozenError(this.getLogicalClass().getName(), currentNode));
        }
    }

    @Override
    public void insertAfter(RubyModule module) {
        this.parentModule = new IncludedModule(module, this.parentModule);
    }

    @CompilerDirectives.TruffleBoundary
    public void include(Node currentNode, RubyModule module) {
        this.checkFrozen(currentNode);
        if (ModuleOperations.includesModule(module, this)) {
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("cyclic include detected", currentNode));
        }
        ModuleChain inclusionPoint = this;
        Stack<RubyModule> modulesToInclude = new Stack<RubyModule>();
        for (RubyModule ancestor : module.ancestors()) {
            if (ModuleOperations.includesModule(this, ancestor)) {
                if (!this.isIncludedModuleBeforeSuperClass(ancestor)) continue;
                this.performIncludes(inclusionPoint, modulesToInclude);
                assert (modulesToInclude.isEmpty());
                inclusionPoint = this.parentModule;
                while (inclusionPoint.getActualModule() != ancestor) {
                    inclusionPoint = inclusionPoint.getParentModule();
                }
                continue;
            }
            modulesToInclude.push(ancestor);
        }
        this.performIncludes(inclusionPoint, modulesToInclude);
        this.newVersion();
    }

    private void performIncludes(ModuleChain inclusionPoint, Stack<RubyModule> moduleAncestors) {
        while (!moduleAncestors.isEmpty()) {
            RubyModule mod = moduleAncestors.pop();
            inclusionPoint.insertAfter(mod);
            mod.addDependent(this);
        }
    }

    private boolean isIncludedModuleBeforeSuperClass(RubyModule module) {
        ModuleChain included = this.parentModule;
        while (included instanceof IncludedModule) {
            if (included.getActualModule() == module) {
                return true;
            }
            included = included.getParentModule();
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public void prepend(Node currentNode, RubyModule module) {
        this.checkFrozen(currentNode);
        if (ModuleOperations.includesModule(module, this)) {
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("cyclic prepend detected", currentNode));
        }
        ModuleChain cur = this.start;
        for (ModuleChain mod = module.start; mod != null && !(mod instanceof RubyClass); mod = mod.getParentModule()) {
            if (mod instanceof PrependMarker || ModuleOperations.includesModule(this, mod.getActualModule())) continue;
            cur.insertAfter(mod.getActualModule());
            mod.getActualModule().addDependent(this);
            cur = cur.getParentModule();
        }
        this.newVersion();
    }

    @CompilerDirectives.TruffleBoundary
    public void setConstant(Node currentNode, String name, Object value) {
        RubyConstant currentConstant;
        if (this.getContext().getCoreLibrary().isLoadingRubyCore() && (currentConstant = this.constants.get(name)) != null) {
            return;
        }
        if (value instanceof RubyModule) {
            ((RubyModule)value).getAdoptedByLexicalParent(this, name, currentNode);
        } else {
            this.setConstantInternal(currentNode, name, value, false);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void setAutoloadConstant(Node currentNode, String name, RubyBasicObject filename) {
        assert (RubyGuards.isRubyString(filename));
        this.setConstantInternal(currentNode, name, filename, true);
    }

    private void setConstantInternal(Node currentNode, String name, Object value, boolean autoload) {
        this.checkFrozen(currentNode);
        RubyConstant previous = this.constants.get(name);
        if (previous == null) {
            this.constants.put(name, new RubyConstant(this, value, false, autoload));
        } else {
            this.constants.put(name, new RubyConstant(this, value, previous.isPrivate(), autoload));
        }
        this.newLexicalVersion();
    }

    @CompilerDirectives.TruffleBoundary
    public RubyConstant removeConstant(Node currentNode, String name) {
        this.checkFrozen(currentNode);
        RubyConstant oldConstant = this.constants.remove(name);
        this.newLexicalVersion();
        return oldConstant;
    }

    @CompilerDirectives.TruffleBoundary
    public void setClassVariable(Node currentNode, String variableName, Object value) {
        this.checkFrozen(currentNode);
        this.classVariables.put(variableName, value);
    }

    @CompilerDirectives.TruffleBoundary
    public Object removeClassVariable(Node currentNode, String name) {
        this.checkFrozen(currentNode);
        Object found = this.classVariables.remove(name);
        if (found == null) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.context.getCoreLibrary().nameErrorClassVariableNotDefined(name, this, currentNode));
        }
        return found;
    }

    @CompilerDirectives.TruffleBoundary
    public void addMethod(Node currentNode, InternalMethod method) {
        InternalMethod currentMethod;
        assert (method != null);
        if (this.getContext().getCoreLibrary().isLoadingRubyCore() && (currentMethod = this.methods.get(method.getName())) != null && currentMethod.getSharedMethodInfo().getSourceSection() instanceof CoreSourceSection) {
            return;
        }
        this.checkFrozen(currentNode);
        this.methods.put(method.getName(), method.withDeclaringModule(this));
        this.newVersion();
        if (this.context.getCoreLibrary().isLoaded() && !method.isUndefined()) {
            DebugOperations.send(this.context, this, "method_added", null, this.context.getSymbolTable().getSymbol(method.getName()));
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void removeMethod(String methodName) {
        this.methods.remove(methodName);
        this.newVersion();
    }

    @CompilerDirectives.TruffleBoundary
    public void undefMethod(Node currentNode, String methodName) {
        InternalMethod method = ModuleOperations.lookupMethod(this, methodName);
        if (method == null) {
            throw new UnsupportedOperationException();
        }
        this.undefMethod(currentNode, method);
    }

    @CompilerDirectives.TruffleBoundary
    public void undefMethod(Node currentNode, InternalMethod method) {
        this.addMethod(currentNode, method.undefined());
    }

    @CompilerDirectives.TruffleBoundary
    public InternalMethod deepMethodSearch(String name) {
        InternalMethod method = ModuleOperations.lookupMethod(this, name);
        if (method != null && !method.isUndefined()) {
            return method;
        }
        if (this.isOnlyAModule() && (method = ModuleOperations.lookupMethod(this.context.getCoreLibrary().getObjectClass(), name)) != null && !method.isUndefined()) {
            return method;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public void alias(Node currentNode, String newName, String oldName) {
        InternalMethod method = this.deepMethodSearch(oldName);
        if (method == null) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().noMethodErrorOnModule(oldName, this, currentNode));
        }
        InternalMethod aliasMethod = method.withName(newName);
        if (ModuleOperations.isMethodPrivateFromName(newName)) {
            aliasMethod = aliasMethod.withVisibility(Visibility.PRIVATE);
        }
        this.addMethod(currentNode, aliasMethod);
    }

    @CompilerDirectives.TruffleBoundary
    public void changeConstantVisibility(Node currentNode, String name, boolean isPrivate) {
        this.checkFrozen(currentNode);
        RubyConstant rubyConstant = this.constants.get(name);
        if (rubyConstant == null) {
            throw new RaiseException(this.context.getCoreLibrary().nameErrorUninitializedConstant(this, name, currentNode));
        }
        rubyConstant.setPrivate(isPrivate);
        this.newLexicalVersion();
    }

    @Override
    public RubyContext getContext() {
        return this.context;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        CompilerDirectives.transferToInterpreter();
        if (this.givenBaseName != null) {
            return this.lexicalParent.getName() + "::" + this.givenBaseName;
        }
        if (this.getLogicalClass() == this) {
            return "#<cyclic>";
        }
        return "#<" + this.getLogicalClass().getName() + ":0x" + Long.toHexString(this.verySlowGetObjectID()) + ">";
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasPartialName() {
        return this.hasName() || this.givenBaseName != null;
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.getName() + ")";
    }

    public void newVersion() {
        this.newVersion(new HashSet<RubyModule>(), false);
    }

    public void newLexicalVersion() {
        this.newVersion(new HashSet<RubyModule>(), true);
    }

    private void newVersion(Set<RubyModule> alreadyInvalidated, boolean considerLexicalDependents) {
        if (alreadyInvalidated.contains(this)) {
            return;
        }
        this.unmodifiedAssumption.invalidate();
        alreadyInvalidated.add(this);
        for (RubyModule dependent : this.dependents) {
            dependent.newVersion(alreadyInvalidated, considerLexicalDependents);
        }
        if (considerLexicalDependents) {
            for (RubyModule dependent : this.lexicalDependents) {
                dependent.newVersion(alreadyInvalidated, considerLexicalDependents);
            }
        }
    }

    public void addDependent(RubyModule dependent) {
        this.dependents.add(dependent);
    }

    public void addLexicalDependent(RubyModule lexicalChild) {
        if (lexicalChild != this) {
            this.lexicalDependents.add(lexicalChild);
        }
    }

    public Assumption getUnmodifiedAssumption() {
        return this.unmodifiedAssumption.getAssumption();
    }

    public Map<String, RubyConstant> getConstants() {
        return this.constants;
    }

    public Map<String, InternalMethod> getMethods() {
        return this.methods;
    }

    public Map<String, Object> getClassVariables() {
        return this.classVariables;
    }

    @Override
    public void visitObjectGraphChildren(ObjectSpaceManager.ObjectGraphVisitor visitor) {
        for (RubyConstant constant : this.constants.values()) {
            if (!(constant.getValue() instanceof RubyBasicObject)) continue;
            ((RubyBasicObject)constant.getValue()).visitObjectGraph(visitor);
        }
        for (Object classVariable : this.classVariables.values()) {
            if (!(classVariable instanceof RubyBasicObject)) continue;
            ((RubyBasicObject)classVariable).visitObjectGraph(visitor);
        }
        for (InternalMethod method : this.methods.values()) {
            if (method.getDeclarationFrame() == null) continue;
            this.getContext().getObjectSpaceManager().visitFrame((Frame)method.getDeclarationFrame(), visitor);
        }
        for (RubyModule ancestor : this.ancestors()) {
            ancestor.visitObjectGraph(visitor);
        }
    }

    @Override
    public ModuleChain getParentModule() {
        return this.parentModule;
    }

    @Override
    public RubyModule getActualModule() {
        return this;
    }

    public Iterable<RubyModule> ancestors() {
        final ModuleChain top = this.start;
        return new Iterable<RubyModule>(){

            @Override
            public Iterator<RubyModule> iterator() {
                return new AncestorIterator(top);
            }
        };
    }

    public Iterable<RubyModule> parentAncestors() {
        final ModuleChain top = this.start;
        return new Iterable<RubyModule>(){

            @Override
            public Iterator<RubyModule> iterator() {
                AncestorIterator iterator = new AncestorIterator(top);
                if (iterator.hasNext()) {
                    iterator.next();
                }
                return iterator;
            }
        };
    }

    public Iterable<RubyModule> prependedAndIncludedModules() {
        final ModuleChain top = this.start;
        final RubyModule currentModule = this;
        return new Iterable<RubyModule>(){

            @Override
            public Iterator<RubyModule> iterator() {
                return new IncludedModulesIterator(top, currentModule);
            }
        };
    }

    public Collection<RubyBasicObject> filterMethods(boolean includeAncestors, MethodFilter filter) {
        Map<String, InternalMethod> allMethods = includeAncestors ? ModuleOperations.getAllMethods(this) : this.getMethods();
        return this.filterMethods(allMethods, filter);
    }

    public Collection<RubyBasicObject> filterMethodsOnObject(boolean includeAncestors, MethodFilter filter) {
        Map<String, InternalMethod> allMethods = includeAncestors ? ModuleOperations.getAllMethods(this) : ModuleOperations.getMethodsUntilLogicalClass(this);
        return this.filterMethods(allMethods, filter);
    }

    public Collection<RubyBasicObject> filterSingletonMethods(boolean includeAncestors, MethodFilter filter) {
        Map<String, InternalMethod> allMethods = includeAncestors ? ModuleOperations.getMethodsBeforeLogicalClass(this) : this.getMethods();
        return this.filterMethods(allMethods, filter);
    }

    private Collection<RubyBasicObject> filterMethods(Map<String, InternalMethod> allMethods, MethodFilter filter) {
        Map<String, InternalMethod> methods = ModuleOperations.withoutUndefinedMethods(allMethods);
        HashSet<RubyBasicObject> filtered = new HashSet<RubyBasicObject>();
        for (InternalMethod method : methods.values()) {
            if (!filter.filter(method)) continue;
            filtered.add(this.getContext().getSymbolTable().getSymbol(method.getName()));
        }
        return filtered;
    }

    public static class ModuleAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyModule(context, rubyClass, null, null, currentNode);
        }
    }

    public static interface MethodFilter {
        public static final MethodFilter PUBLIC = new MethodFilter(){

            @Override
            public boolean filter(InternalMethod method) {
                return method.getVisibility() == Visibility.PUBLIC;
            }
        };
        public static final MethodFilter PUBLIC_PROTECTED = new MethodFilter(){

            @Override
            public boolean filter(InternalMethod method) {
                return method.getVisibility() == Visibility.PUBLIC || method.getVisibility() == Visibility.PROTECTED;
            }
        };
        public static final MethodFilter PROTECTED = new MethodFilter(){

            @Override
            public boolean filter(InternalMethod method) {
                return method.getVisibility() == Visibility.PROTECTED;
            }
        };
        public static final MethodFilter PRIVATE = new MethodFilter(){

            @Override
            public boolean filter(InternalMethod method) {
                return method.getVisibility() == Visibility.PRIVATE;
            }
        };

        public boolean filter(InternalMethod var1);
    }

    private static class IncludedModulesIterator
    extends AncestorIterator {
        private final RubyModule currentModule;

        public IncludedModulesIterator(ModuleChain top, RubyModule currentModule) {
            super(top instanceof PrependMarker ? top.getParentModule() : top);
            this.currentModule = currentModule;
        }

        @Override
        public boolean hasNext() {
            if (!super.hasNext()) {
                return false;
            }
            if (this.module == this.currentModule) {
                this.module = this.module.getParentModule();
                return this.hasNext();
            }
            return this.module instanceof IncludedModule;
        }
    }

    private static class AncestorIterator
    implements Iterator<RubyModule> {
        ModuleChain module;

        public AncestorIterator(ModuleChain top) {
            this.module = top;
        }

        @Override
        public boolean hasNext() {
            return this.module != null;
        }

        @Override
        public RubyModule next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ModuleChain mod = this.module;
            if (mod instanceof PrependMarker) {
                mod = mod.getParentModule();
            }
            this.module = mod.getParentModule();
            return mod.getActualModule();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static class PrependMarker
    implements ModuleChain {
        @CompilerDirectives.CompilationFinal
        private ModuleChain parentModule;

        public PrependMarker(ModuleChain parentModule) {
            this.parentModule = parentModule;
        }

        @Override
        public ModuleChain getParentModule() {
            return this.parentModule;
        }

        @Override
        public RubyModule getActualModule() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertAfter(RubyModule module) {
            this.parentModule = new IncludedModule(module, this.parentModule);
        }
    }

    private static class IncludedModule
    implements ModuleChain {
        private final RubyModule includedModule;
        @CompilerDirectives.CompilationFinal
        private ModuleChain parentModule;

        public IncludedModule(RubyModule includedModule, ModuleChain parentModule) {
            this.includedModule = includedModule;
            this.parentModule = parentModule;
        }

        @Override
        public ModuleChain getParentModule() {
            return this.parentModule;
        }

        @Override
        public RubyModule getActualModule() {
            return this.includedModule;
        }

        public String toString() {
            return super.toString() + "(" + this.includedModule + ")";
        }

        @Override
        public void insertAfter(RubyModule module) {
            this.parentModule = new IncludedModule(module, this.parentModule);
        }
    }
}

