/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.ReturnException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.subsystems.FiberManager;
import org.jruby.truffle.runtime.subsystems.ThreadManager;

public class RubyFiber
extends RubyBasicObject {
    private final FiberManager fiberManager;
    private final ThreadManager threadManager;
    private final RubyThread rubyThread;
    private String name;
    private final boolean isRootFiber;
    private final BlockingQueue<FiberMessage> messageQueue = new LinkedBlockingQueue<FiberMessage>(2);
    private RubyFiber lastResumedByFiber = null;
    private boolean alive = true;
    private volatile Thread thread;

    public RubyFiber(RubyThread parent, RubyClass rubyClass, String name) {
        this(parent, parent.getFiberManager(), parent.getThreadManager(), rubyClass, name, false);
    }

    public static RubyFiber newRootFiber(RubyThread thread, FiberManager fiberManager, ThreadManager threadManager) {
        RubyContext context = thread.getContext();
        return new RubyFiber(thread, fiberManager, threadManager, context.getCoreLibrary().getFiberClass(), "root Fiber for Thread", true);
    }

    private RubyFiber(RubyThread parent, FiberManager fiberManager, ThreadManager threadManager, RubyClass rubyClass, String name, boolean isRootFiber) {
        super(rubyClass);
        this.rubyThread = parent;
        this.fiberManager = fiberManager;
        this.threadManager = threadManager;
        this.name = name;
        this.isRootFiber = isRootFiber;
    }

    public void initialize(final RubyBasicObject block) {
        assert (RubyGuards.isRubyProc(block));
        this.name = "Ruby Fiber@" + ProcNodes.getSharedMethodInfo(block).getSourceSection().getShortDescription();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                RubyFiber.this.handleFiberExceptions(block);
            }
        });
        thread.setName(this.name);
        thread.start();
    }

    private void handleFiberExceptions(final RubyBasicObject block) {
        assert (RubyGuards.isRubyProc(block));
        this.run(new Runnable(){

            @Override
            public void run() {
                try {
                    Object[] args = RubyFiber.this.waitForResume();
                    Object result = ProcNodes.rootCall(block, args);
                    RubyFiber.this.resume(RubyFiber.this.lastResumedByFiber, true, new Object[]{result});
                }
                catch (FiberExitException e) {
                    assert (!RubyFiber.this.isRootFiber);
                }
                catch (ReturnException e) {
                    RubyFiber.this.sendMessageTo(RubyFiber.this.lastResumedByFiber, new FiberExceptionMessage(RubyFiber.this.getContext().getCoreLibrary().unexpectedReturn(null)));
                }
                catch (RaiseException e) {
                    RubyFiber.this.sendMessageTo(RubyFiber.this.lastResumedByFiber, new FiberExceptionMessage(e.getRubyException()));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(Runnable task) {
        this.start();
        try {
            task.run();
        }
        finally {
            this.cleanup();
        }
    }

    public void start() {
        this.thread = Thread.currentThread();
        this.fiberManager.registerFiber(this);
        this.getContext().getSafepointManager().enterThread();
        this.threadManager.enterGlobalLock(this.rubyThread);
    }

    public void cleanup() {
        this.alive = false;
        this.threadManager.leaveGlobalLock();
        this.getContext().getSafepointManager().leaveThread();
        this.fiberManager.unregisterFiber(this);
        this.thread = null;
    }

    public Thread getJavaThread() {
        return this.thread;
    }

    public RubyThread getRubyThread() {
        return this.rubyThread;
    }

    private void sendMessageTo(RubyFiber fiber, FiberMessage message) {
        fiber.messageQueue.add(message);
    }

    private Object[] waitForResume() {
        FiberMessage message = this.getContext().getThreadManager().runUntilResult(new ThreadManager.BlockingActionWithoutGlobalLock<FiberMessage>(){

            @Override
            public FiberMessage block() throws InterruptedException {
                return (FiberMessage)RubyFiber.this.messageQueue.take();
            }
        });
        this.fiberManager.setCurrentFiber(this);
        if (message instanceof FiberExitMessage) {
            throw new FiberExitException();
        }
        if (message instanceof FiberExceptionMessage) {
            throw new RaiseException(((FiberExceptionMessage)message).getException());
        }
        if (message instanceof FiberResumeMessage) {
            FiberResumeMessage resumeMessage = (FiberResumeMessage)message;
            assert (this.threadManager.getCurrentThread() == resumeMessage.getSendingFiber().getRubyThread());
            if (!resumeMessage.isYield()) {
                this.lastResumedByFiber = resumeMessage.getSendingFiber();
            }
            return resumeMessage.getArgs();
        }
        throw new UnsupportedOperationException();
    }

    private void resume(RubyFiber fiber, boolean yield, Object ... args) {
        this.sendMessageTo(fiber, new FiberResumeMessage(yield, this, args));
    }

    public Object[] transferControlTo(RubyFiber fiber, boolean yield, Object[] args) {
        this.resume(fiber, yield, args);
        return this.waitForResume();
    }

    public void shutdown() {
        assert (!this.isRootFiber);
        this.sendMessageTo(this, new FiberExitMessage());
    }

    public boolean isAlive() {
        return this.alive || !this.messageQueue.isEmpty();
    }

    public RubyFiber getLastResumedByFiber() {
        return this.lastResumedByFiber;
    }

    public boolean isRootFiber() {
        return this.isRootFiber;
    }

    public String getName() {
        return this.name;
    }

    public static class FiberAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            RubyThread parent = context.getThreadManager().getCurrentThread();
            return new RubyFiber(parent, rubyClass, null);
        }
    }

    public static class FiberExitException
    extends ControlFlowException {
        private static final long serialVersionUID = 1522270454305076317L;
    }

    private static class FiberExceptionMessage
    implements FiberMessage {
        private final RubyException exception;

        public FiberExceptionMessage(RubyException exception) {
            this.exception = exception;
        }

        public RubyException getException() {
            return this.exception;
        }
    }

    private static class FiberExitMessage
    implements FiberMessage {
        private FiberExitMessage() {
        }
    }

    private static class FiberResumeMessage
    implements FiberMessage {
        private final boolean yield;
        private final RubyFiber sendingFiber;
        private final Object[] args;

        public FiberResumeMessage(boolean yield, RubyFiber sendingFiber, Object[] args) {
            this.yield = yield;
            this.sendingFiber = sendingFiber;
            this.args = args;
        }

        public boolean isYield() {
            return this.yield;
        }

        public RubyFiber getSendingFiber() {
            return this.sendingFiber;
        }

        public Object[] getArgs() {
            return this.args;
        }
    }

    private static interface FiberMessage {
    }
}

