/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.arguments.NodeArrayToObjectArrayNode;
import org.jruby.truffle.nodes.arguments.ReadAllArgumentsNode;
import org.jruby.truffle.nodes.arguments.ReadBlockNode;
import org.jruby.truffle.nodes.core.MethodNodes;
import org.jruby.truffle.nodes.core.MethodNodesFactory;
import org.jruby.truffle.nodes.literal.LiteralNode;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveConstructor;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

public class RubiniusPrimitiveCallConstructor
implements RubiniusPrimitiveConstructor {
    private final RubyBasicObject method;

    public RubiniusPrimitiveCallConstructor(RubyBasicObject method) {
        assert (RubyGuards.isRubyMethod(method));
        this.method = method;
    }

    @Override
    public int getPrimitiveArity() {
        return MethodNodes.getMethod(this.method).getSharedMethodInfo().getArity().getRequired();
    }

    @Override
    public RubyNode createCallPrimitiveNode(RubyContext context, SourceSection sourceSection, long returnID) {
        return MethodNodesFactory.CallNodeFactory.create(context, sourceSection, new RubyNode[]{new LiteralNode(context, sourceSection, this.method), new ReadAllArgumentsNode(context, sourceSection), new ReadBlockNode(context, sourceSection, NotProvided.INSTANCE)});
    }

    @Override
    public RubyNode createInvokePrimitiveNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
        return MethodNodesFactory.CallNodeFactory.create(context, sourceSection, new RubyNode[]{new LiteralNode(context, sourceSection, this.method), new NodeArrayToObjectArrayNode(context, sourceSection, arguments), new ReadBlockNode(context, sourceSection, NotProvided.INSTANCE)});
    }
}

