/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.ReadClassVariableNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyModule;

public class WriteClassVariableNode
extends RubyNode {
    private final String name;
    private final LexicalScope lexicalScope;
    @Node.Child
    private RubyNode rhs;

    public WriteClassVariableNode(RubyContext context, SourceSection sourceSection, String name, LexicalScope lexicalScope, RubyNode rhs) {
        super(context, sourceSection);
        this.name = name;
        this.lexicalScope = lexicalScope;
        this.rhs = rhs;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        Object rhsValue = this.rhs.execute(frame);
        RubyModule module = ReadClassVariableNode.resolveTargetModule(this.lexicalScope);
        ModuleOperations.setClassVariable(module, this.name, rhsValue, this);
        return rhsValue;
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.createString("assignment");
    }
}

