/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;

public class ReadClassVariableNode
extends RubyNode {
    private final String name;
    private final LexicalScope lexicalScope;

    public ReadClassVariableNode(RubyContext context, SourceSection sourceSection, String name, LexicalScope lexicalScope) {
        super(context, sourceSection);
        this.name = name;
        this.lexicalScope = lexicalScope;
    }

    public static RubyModule resolveTargetModule(LexicalScope lexicalScope) {
        while (lexicalScope.getLiveModule() instanceof RubyClass && ((RubyClass)lexicalScope.getLiveModule()).isSingleton()) {
            lexicalScope = lexicalScope.getParent();
        }
        return lexicalScope.getLiveModule();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        RubyModule module = ReadClassVariableNode.resolveTargetModule(this.lexicalScope);
        Object value = ModuleOperations.lookupClassVariable(module, this.name);
        if (value == null) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUninitializedClassVariable(module, this.name, this));
        }
        return value;
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        RubyModule module = ReadClassVariableNode.resolveTargetModule(this.lexicalScope);
        Object value = ModuleOperations.lookupClassVariable(module, this.name);
        if (value == null) {
            return this.nil();
        }
        return this.createString("class variable");
    }
}

