/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.exceptions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.exceptions.RescueNode;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyException;

public class RescueSplatNode
extends RescueNode {
    @Node.Child
    RubyNode handlingClassesArray;

    public RescueSplatNode(RubyContext context, SourceSection sourceSection, RubyNode handlingClassesArray, RubyNode body) {
        super(context, sourceSection, body);
        this.handlingClassesArray = handlingClassesArray;
    }

    @Override
    public boolean canHandle(VirtualFrame frame, RubyException exception) {
        CompilerDirectives.transferToInterpreter();
        RubyBasicObject handlingClasses = (RubyBasicObject)this.handlingClassesArray.execute(frame);
        RubyClass exceptionRubyClass = exception.getLogicalClass();
        for (Object handlingClass : ArrayNodes.slowToArray(handlingClasses)) {
            if (!ModuleOperations.assignableTo(exceptionRubyClass, (RubyClass)handlingClass)) continue;
            return true;
        }
        return false;
    }
}

