/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

public abstract class CachedDispatchNode
extends DispatchNode {
    private final Object cachedName;
    private final RubyBasicObject cachedNameAsSymbol;
    private final boolean indirect;
    @Node.Child
    protected DispatchNode next;
    private final BranchProfile moreThanReferenceCompare = BranchProfile.create();

    public CachedDispatchNode(RubyContext context, Object cachedName, DispatchNode next, boolean indirect, DispatchAction dispatchAction) {
        super(context, dispatchAction);
        assert (cachedName instanceof String || RubyGuards.isRubySymbol(cachedName) || RubyGuards.isRubyString(cachedName));
        this.cachedName = cachedName;
        if (RubyGuards.isRubySymbol(cachedName)) {
            this.cachedNameAsSymbol = (RubyBasicObject)cachedName;
        } else if (RubyGuards.isRubyString(cachedName)) {
            this.cachedNameAsSymbol = context.getSymbol(StringNodes.getByteList((RubyBasicObject)cachedName));
        } else if (cachedName instanceof String) {
            this.cachedNameAsSymbol = context.getSymbol((String)cachedName);
        } else {
            throw new UnsupportedOperationException();
        }
        this.indirect = indirect;
        this.next = next;
    }

    @Override
    protected DispatchNode getNext() {
        return this.next;
    }

    protected final boolean guardName(Object methodName) {
        if (this.cachedName == methodName) {
            return true;
        }
        this.moreThanReferenceCompare.enter();
        if (this.cachedName instanceof String) {
            return this.cachedName.equals(methodName);
        }
        if (RubyGuards.isRubySymbol(this.cachedName)) {
            return this.cachedName == methodName;
        }
        if (RubyGuards.isRubyString(this.cachedName)) {
            return RubyGuards.isRubyString(methodName) && StringNodes.getByteList((RubyBasicObject)this.cachedName).equal(StringNodes.getByteList((RubyBasicObject)methodName));
        }
        throw new UnsupportedOperationException();
    }

    protected RubyBasicObject getCachedNameAsSymbol() {
        return this.cachedNameAsSymbol;
    }

    public boolean isIndirect() {
        return this.indirect;
    }
}

