/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.core.array.EnsureCapacityArrayNode;
import org.jruby.truffle.nodes.core.array.EnsureCapacityArrayNodeGen;
import org.jruby.truffle.nodes.core.array.GeneralizeArrayNode;
import org.jruby.truffle.nodes.core.array.GeneralizeArrayNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="index", type=RubyNode.class), @NodeChild(value="value", type=RubyNode.class)})
public abstract class ArrayWriteNormalizedNode
extends RubyNode {
    @Node.Child
    private EnsureCapacityArrayNode ensureCapacityNode;
    @Node.Child
    private GeneralizeArrayNode generalizeNode;

    public ArrayWriteNormalizedNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.ensureCapacityNode = EnsureCapacityArrayNodeGen.create(context, sourceSection, null, null);
        this.generalizeNode = GeneralizeArrayNodeGen.create(context, sourceSection, null, null);
    }

    public abstract Object executeWrite(VirtualFrame var1, RubyBasicObject var2, int var3, Object var4);

    @Specialization(guards={"isRubyArray(array)", "isNullArray(array)", "index == 0"})
    public boolean writeNull0(RubyBasicObject array, int index, boolean value) {
        ArrayNodes.setStore(array, new Object[]{value}, 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isNullArray(array)", "index == 0"})
    public int writeNull0(RubyBasicObject array, int index, int value) {
        ArrayNodes.setStore(array, new int[]{value}, 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isNullArray(array)", "index == 0"})
    public long writeNull0(RubyBasicObject array, int index, long value) {
        ArrayNodes.setStore(array, new long[]{value}, 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isNullArray(array)", "index == 0"})
    public double writeNull0(RubyBasicObject array, int index, double value) {
        ArrayNodes.setStore(array, new double[]{value}, 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isNullArray(array)", "index == 0"})
    public RubyBasicObject writeNull0(RubyBasicObject array, int index, RubyBasicObject value) {
        ArrayNodes.setStore(array, new Object[]{value}, 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isNullArray(array)", "index != 0"})
    public Object writeNullBeyond(RubyBasicObject array, int index, Object value) {
        Object[] store = new Object[index + 1];
        for (int n = 0; n < index; ++n) {
            store[n] = this.nil();
        }
        store[index] = value;
        ArrayNodes.setStore(array, store, store.length);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isObjectArray(array)", "isInBounds(array, index)"})
    public boolean writeWithin(RubyBasicObject array, int index, boolean value) {
        Object[] store = (Object[])ArrayNodes.getStore(array);
        store[index] = value;
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)", "isInBounds(array, index)"})
    public int writeWithin(RubyBasicObject array, int index, int value) {
        int[] store = (int[])ArrayNodes.getStore(array);
        store[index] = value;
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isLongArray(array)", "isInBounds(array, index)"})
    public int writeWithinIntIntoLong(RubyBasicObject array, int index, int value) {
        this.writeWithin(array, index, (long)value);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isLongArray(array)", "isInBounds(array, index)"})
    public long writeWithin(RubyBasicObject array, int index, long value) {
        long[] store = (long[])ArrayNodes.getStore(array);
        store[index] = value;
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isDoubleArray(array)", "isInBounds(array, index)"})
    public double writeWithin(RubyBasicObject array, int index, double value) {
        double[] store = (double[])ArrayNodes.getStore(array);
        store[index] = value;
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isObjectArray(array)", "isInBounds(array, index)"})
    public Object writeWithin(RubyBasicObject array, int index, Object value) {
        Object[] store = (Object[])ArrayNodes.getStore(array);
        store[index] = value;
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)", "isInBounds(array, index)"})
    public long writeWithinInt(RubyBasicObject array, int index, long value) {
        int[] intStore = (int[])ArrayNodes.getStore(array);
        long[] longStore = new long[ArrayNodes.getSize(array)];
        for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
            longStore[n] = intStore[n];
        }
        longStore[index] = value;
        ArrayNodes.setStore(array, longStore, ArrayNodes.getSize(array));
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)", "isInBounds(array, index)", "!isInteger(value)", "!isLong(value)"})
    public Object writeWithinInt(RubyBasicObject array, int index, Object value) {
        Object[] objectStore = ArrayUtils.box((int[])ArrayNodes.getStore(array));
        objectStore[index] = value;
        ArrayNodes.setStore(array, objectStore, ArrayNodes.getSize(array));
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isLongArray(array)", "isInBounds(array, index)", "!isInteger(value)", "!isLong(value)"})
    public Object writeWithinLong(RubyBasicObject array, int index, Object value) {
        Object[] objectStore = ArrayUtils.box((long[])ArrayNodes.getStore(array));
        objectStore[index] = value;
        ArrayNodes.setStore(array, objectStore, ArrayNodes.getSize(array));
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isDoubleArray(array)", "isInBounds(array, index)", "!isDouble(value)"})
    public Object writeWithinDouble(RubyBasicObject array, int index, Object value) {
        Object[] objectStore = ArrayUtils.box((double[])ArrayNodes.getStore(array));
        objectStore[index] = value;
        ArrayNodes.setStore(array, objectStore, ArrayNodes.getSize(array));
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isObjectArray(array)", "isExtendingByOne(array, index)"})
    public boolean writeExtendByOne(VirtualFrame frame, RubyBasicObject array, int index, boolean value) {
        this.ensureCapacityNode.executeEnsureCapacity(frame, array, index + 1);
        ((Object[])ArrayNodes.getStore((RubyBasicObject)array))[index] = value;
        ArrayNodes.setStore(array, ArrayNodes.getStore(array), index + 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)", "isExtendingByOne(array, index)"})
    public int writeExtendByOne(VirtualFrame frame, RubyBasicObject array, int index, int value) {
        this.ensureCapacityNode.executeEnsureCapacity(frame, array, index + 1);
        ((int[])ArrayNodes.getStore((RubyBasicObject)array))[index] = value;
        ArrayNodes.setStore(array, ArrayNodes.getStore(array), index + 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isLongArray(array)", "isExtendingByOne(array, index)"})
    public int writeExtendByOneIntIntoLong(VirtualFrame frame, RubyBasicObject array, int index, int value) {
        this.ensureCapacityNode.executeEnsureCapacity(frame, array, index + 1);
        ((long[])ArrayNodes.getStore((RubyBasicObject)array))[index] = value;
        ArrayNodes.setStore(array, ArrayNodes.getStore(array), index + 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isLongArray(array)", "isExtendingByOne(array, index)"})
    public long writeExtendByOne(VirtualFrame frame, RubyBasicObject array, int index, long value) {
        this.ensureCapacityNode.executeEnsureCapacity(frame, array, index + 1);
        ((long[])ArrayNodes.getStore((RubyBasicObject)array))[index] = value;
        ArrayNodes.setStore(array, ArrayNodes.getStore(array), index + 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isDoubleArray(array)", "isExtendingByOne(array, index)"})
    public double writeExtendByOne(VirtualFrame frame, RubyBasicObject array, int index, double value) {
        this.ensureCapacityNode.executeEnsureCapacity(frame, array, index + 1);
        ((double[])ArrayNodes.getStore((RubyBasicObject)array))[index] = value;
        ArrayNodes.setStore(array, ArrayNodes.getStore(array), index + 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isObjectArray(array)", "isExtendingByOne(array, index)"})
    public RubyBasicObject writeExtendByOne(VirtualFrame frame, RubyBasicObject array, int index, RubyBasicObject value) {
        this.ensureCapacityNode.executeEnsureCapacity(frame, array, index + 1);
        ((Object[])ArrayNodes.getStore((RubyBasicObject)array))[index] = value;
        ArrayNodes.setStore(array, ArrayNodes.getStore(array), index + 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isObjectArray(array)", "isExtendingByOne(array, index)"})
    public int writeObjectExtendByOne(VirtualFrame frame, RubyBasicObject array, int index, int value) {
        this.ensureCapacityNode.executeEnsureCapacity(frame, array, index + 1);
        ((Object[])ArrayNodes.getStore((RubyBasicObject)array))[index] = value;
        ArrayNodes.setStore(array, ArrayNodes.getStore(array), index + 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "!isObjectArray(array)", "!isInBounds(array, index)", "!isExtendingByOne(array, index)"})
    public Object writeBeyondPrimitive(VirtualFrame frame, RubyBasicObject array, int index, Object value) {
        this.generalizeNode.executeGeneralize(frame, array, index + 1);
        Object[] objectStore = (Object[])ArrayNodes.getStore(array);
        for (int n = ArrayNodes.getSize(array); n < index; ++n) {
            objectStore[n] = this.nil();
        }
        objectStore[index] = value;
        ArrayNodes.setStore(array, ArrayNodes.getStore(array), index + 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isObjectArray(array)", "!isInBounds(array, index)", "!isExtendingByOne(array, index)"})
    public Object writeBeyondObject(VirtualFrame frame, RubyBasicObject array, int index, Object value) {
        this.ensureCapacityNode.executeEnsureCapacity(frame, array, index + 1);
        Object[] objectStore = (Object[])ArrayNodes.getStore(array);
        for (int n = ArrayNodes.getSize(array); n < index; ++n) {
            objectStore[n] = this.nil();
        }
        objectStore[index] = value;
        ArrayNodes.setStore(array, ArrayNodes.getStore(array), index + 1);
        return value;
    }

    protected static boolean isInBounds(RubyBasicObject array, int index) {
        return index >= 0 && index < ArrayNodes.getSize(array);
    }

    protected static boolean isExtendingByOne(RubyBasicObject array, int index) {
        return index == ArrayNodes.getSize(array);
    }
}

