/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class)})
public abstract class ArraySliceNode
extends RubyNode {
    final int from;
    final int to;

    public ArraySliceNode(RubyContext context, SourceSection sourceSection, int from, int to) {
        super(context, sourceSection);
        assert (from >= 0);
        assert (to <= 0);
        this.from = from;
        this.to = to;
    }

    @Specialization(guards={"isRubyArray(array)", "isNullArray(array)"})
    public RubyBasicObject sliceNull(RubyBasicObject array) {
        CompilerDirectives.transferToInterpreter();
        return this.createEmptyArray();
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)"})
    public RubyBasicObject sliceIntegerFixnum(RubyBasicObject array) {
        CompilerDirectives.transferToInterpreter();
        int to = ArrayNodes.getSize(array) + this.to;
        if (this.from >= to) {
            return this.createEmptyArray();
        }
        return this.createArray(ArrayUtils.extractRange((int[])ArrayNodes.getStore(array), this.from, to), to - this.from);
    }

    @Specialization(guards={"isRubyArray(array)", "isLongArray(array)"})
    public RubyBasicObject sliceLongFixnum(RubyBasicObject array) {
        CompilerDirectives.transferToInterpreter();
        int to = ArrayNodes.getSize(array) + this.to;
        if (this.from >= to) {
            return this.createEmptyArray();
        }
        return this.createArray(ArrayUtils.extractRange((long[])ArrayNodes.getStore(array), this.from, to), to - this.from);
    }

    @Specialization(guards={"isRubyArray(array)", "isDoubleArray(array)"})
    public RubyBasicObject sliceFloat(RubyBasicObject array) {
        CompilerDirectives.transferToInterpreter();
        int to = ArrayNodes.getSize(array) + this.to;
        if (this.from >= to) {
            return this.createEmptyArray();
        }
        return this.createArray(ArrayUtils.extractRange((double[])ArrayNodes.getStore(array), this.from, to), to - this.from);
    }

    @Specialization(guards={"isRubyArray(array)", "isObjectArray(array)"})
    public RubyBasicObject sliceObject(RubyBasicObject array) {
        CompilerDirectives.transferToInterpreter();
        int to = ArrayNodes.getSize(array) + this.to;
        if (this.from >= to) {
            return this.createEmptyArray();
        }
        return this.createArray(ArrayUtils.extractRange((Object[])ArrayNodes.getStore(array), this.from, to), to - this.from);
    }
}

