/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayReadDenormalizedNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@GeneratedBy(value=ArrayReadDenormalizedNode.class)
public final class ArrayReadDenormalizedNodeGen
extends ArrayReadDenormalizedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode index_;

    private ArrayReadDenormalizedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
        super(context, sourceSection);
        this.array_ = array;
        this.index_ = index;
    }

    public NodeCost getCost() {
        return NodeCost.MONOMORPHIC;
    }

    @Override
    public Object executeRead(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue) {
        if (RubyGuards.isRubyArray(arrayValue)) {
            return this.read(frameValue, arrayValue, indexValue);
        }
        throw this.unsupported(arrayValue, indexValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int indexValue_;
        RubyBasicObject arrayValue_;
        try {
            arrayValue_ = this.array_.executeRubyBasicObject(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object indexValue = this.index_.execute(frameValue);
            throw this.unsupported(ex.getResult(), indexValue);
        }
        try {
            indexValue_ = this.index_.executeInteger(frameValue);
        }
        catch (UnexpectedResultException ex) {
            throw this.unsupported(arrayValue_, ex.getResult());
        }
        if (RubyGuards.isRubyArray(arrayValue_)) {
            return this.read(frameValue, arrayValue_, indexValue_);
        }
        throw this.unsupported(arrayValue_, indexValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    protected UnsupportedSpecializationException unsupported(Object arrayValue, Object indexValue) {
        return new UnsupportedSpecializationException((Node)this, new Node[]{this.array_, this.index_}, new Object[]{arrayValue, indexValue});
    }

    public static ArrayReadDenormalizedNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
        return new ArrayReadDenormalizedNodeGen(context, sourceSection, array, index);
    }
}

