/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

public class ArrayPushNode
extends RubyNode {
    @Node.Child
    private RubyNode array;
    @Node.Child
    private RubyNode pushed;

    public ArrayPushNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode pushed) {
        super(context, sourceSection);
        this.array = array;
        this.pushed = pushed;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        Object arrayObject = this.array.execute(frame);
        assert (RubyGuards.isRubyArray(arrayObject));
        RubyBasicObject originalArray = (RubyBasicObject)arrayObject;
        RubyBasicObject newArray = this.createArray(ArrayNodes.slowToArray(originalArray), ArrayNodes.getSize(originalArray));
        ArrayNodes.slowPush(newArray, this.pushed.execute(frame));
        return newArray;
    }
}

