/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

public abstract class ArrayLiteralNode
extends RubyNode {
    @Node.Children
    protected final RubyNode[] values;

    public ArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values) {
        super(context, sourceSection);
        this.values = values;
    }

    protected RubyBasicObject makeGeneric(VirtualFrame frame, Object[] alreadyExecuted) {
        CompilerAsserts.neverPartOfCompilation();
        this.replace(new ObjectArrayLiteralNode(this.getContext(), this.getSourceSection(), this.values));
        Object[] executedValues = new Object[this.values.length];
        for (int n = 0; n < this.values.length; ++n) {
            executedValues[n] = n < alreadyExecuted.length ? alreadyExecuted[n] : this.values[n].execute(frame);
        }
        return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), executedValues);
    }

    @Override
    public abstract Object execute(VirtualFrame var1);

    @Override
    @ExplodeLoop
    public void executeVoid(VirtualFrame frame) {
        for (RubyNode value : this.values) {
            value.executeVoid(frame);
        }
    }

    @Override
    @ExplodeLoop
    public Object isDefined(VirtualFrame frame) {
        for (RubyNode value : this.values) {
            if (value.isDefined(frame) != this.nil()) continue;
            return this.nil();
        }
        return super.isDefined(frame);
    }

    public RubyNode[] getValues() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public static class UninitialisedArrayLiteralNode
    extends ArrayLiteralNode {
        public UninitialisedArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values) {
            super(context, sourceSection, values);
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            Object[] executedValues = new Object[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                executedValues[n] = this.values[n].execute(frame);
            }
            RubyBasicObject array = ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), executedValues);
            Object store = ArrayNodes.getStore(array);
            if (store == null) {
                this.replace(new EmptyArrayLiteralNode(this.getContext(), this.getSourceSection(), this.values));
            }
            if (store instanceof int[]) {
                this.replace(new IntegerFixnumArrayLiteralNode(this.getContext(), this.getSourceSection(), this.values));
            } else if (store instanceof long[]) {
                this.replace(new LongFixnumArrayLiteralNode(this.getContext(), this.getSourceSection(), this.values));
            } else if (store instanceof double[]) {
                this.replace(new FloatArrayLiteralNode(this.getContext(), this.getSourceSection(), this.values));
            } else {
                this.replace(new ObjectArrayLiteralNode(this.getContext(), this.getSourceSection(), this.values));
            }
            return array;
        }
    }

    public static class ObjectArrayLiteralNode
    extends ArrayLiteralNode {
        public ObjectArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values) {
            super(context, sourceSection, values);
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frame) {
            Object[] executedValues = new Object[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                executedValues[n] = this.values[n].execute(frame);
            }
            return this.createArray(executedValues, this.values.length);
        }
    }

    public static class LongFixnumArrayLiteralNode
    extends ArrayLiteralNode {
        public LongFixnumArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values) {
            super(context, sourceSection, values);
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frame) {
            long[] executedValues = new long[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                try {
                    executedValues[n] = this.values[n].executeLong(frame);
                    continue;
                }
                catch (UnexpectedResultException e) {
                    return this.makeGeneric(frame, executedValues, n);
                }
            }
            return this.createArray(executedValues, this.values.length);
        }

        private RubyBasicObject makeGeneric(VirtualFrame frame, long[] executedValues, int n) {
            Object[] executedObjects = new Object[n];
            for (int i = 0; i < n; ++i) {
                executedObjects[i] = executedValues[i];
            }
            return this.makeGeneric(frame, executedObjects);
        }
    }

    public static class IntegerFixnumArrayLiteralNode
    extends ArrayLiteralNode {
        public IntegerFixnumArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values) {
            super(context, sourceSection, values);
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frame) {
            int[] executedValues = new int[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                try {
                    executedValues[n] = this.values[n].executeInteger(frame);
                    continue;
                }
                catch (UnexpectedResultException e) {
                    return this.makeGeneric(frame, executedValues, n);
                }
            }
            return this.createArray(executedValues, this.values.length);
        }

        private RubyBasicObject makeGeneric(VirtualFrame frame, int[] executedValues, int n) {
            Object[] executedObjects = new Object[n];
            for (int i = 0; i < n; ++i) {
                executedObjects[i] = executedValues[i];
            }
            return this.makeGeneric(frame, executedObjects);
        }
    }

    public static class FloatArrayLiteralNode
    extends ArrayLiteralNode {
        public FloatArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values) {
            super(context, sourceSection, values);
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frame) {
            double[] executedValues = new double[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                try {
                    executedValues[n] = this.values[n].executeDouble(frame);
                    continue;
                }
                catch (UnexpectedResultException e) {
                    return this.makeGeneric(frame, executedValues, n);
                }
            }
            return this.createArray(executedValues, this.values.length);
        }

        private RubyBasicObject makeGeneric(VirtualFrame frame, double[] executedValues, int n) {
            Object[] executedObjects = new Object[n];
            for (int i = 0; i < n; ++i) {
                executedObjects[i] = executedValues[i];
            }
            return this.makeGeneric(frame, executedObjects);
        }
    }

    public static class EmptyArrayLiteralNode
    extends ArrayLiteralNode {
        public EmptyArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values) {
            super(context, sourceSection, values);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.createEmptyArray();
        }
    }
}

