/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.SourceSection;
import java.util.EnumSet;
import org.jruby.Ruby;
import org.jruby.ast.ArgsNode;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.MethodNodes;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.methods.CanBindMethodToModuleNode;
import org.jruby.truffle.nodes.methods.CanBindMethodToModuleNodeGen;
import org.jruby.truffle.nodes.objects.MetaClassNode;
import org.jruby.truffle.nodes.objects.MetaClassNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.object.BasicObjectType;

@CoreClass(name="UnboundMethod")
public abstract class UnboundMethodNodes {
    public static final MethodType UNBOUND_METHOD_TYPE = new MethodType();
    private static final HiddenKey ORIGIN_IDENTIFIER = new HiddenKey("origin");
    public static final Property ORIGIN_PROPERTY;
    private static final HiddenKey METHOD_IDENTIFIER;
    public static final Property METHOD_PROPERTY;
    private static final DynamicObjectFactory UNBOUND_METHOD_FACTORY;

    public static RubyBasicObject createUnboundMethod(RubyClass rubyClass, RubyModule origin, InternalMethod method) {
        return new RubyBasicObject(rubyClass, UNBOUND_METHOD_FACTORY.newInstance(new Object[]{origin, method}));
    }

    public static RubyModule getOrigin(RubyBasicObject method) {
        assert (method.getDynamicObject().getShape().hasProperty((Object)ORIGIN_IDENTIFIER));
        return (RubyModule)ORIGIN_PROPERTY.get(method.getDynamicObject(), true);
    }

    public static InternalMethod getMethod(RubyBasicObject method) {
        assert (method.getDynamicObject().getShape().hasProperty((Object)METHOD_IDENTIFIER));
        return (InternalMethod)METHOD_PROPERTY.get(method.getDynamicObject(), true);
    }

    static {
        METHOD_IDENTIFIER = new HiddenKey("method");
        Shape.Allocator allocator = RubyBasicObject.LAYOUT.createAllocator();
        ORIGIN_PROPERTY = Property.create((Object)ORIGIN_IDENTIFIER, (Location)allocator.locationForType(RubyModule.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)), (int)0);
        METHOD_PROPERTY = Property.create((Object)METHOD_IDENTIFIER, (Location)allocator.locationForType(InternalMethod.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)), (int)0);
        Shape shape = RubyBasicObject.LAYOUT.createShape((ObjectType)UNBOUND_METHOD_TYPE).addProperty(ORIGIN_PROPERTY).addProperty(METHOD_PROPERTY);
        UNBOUND_METHOD_FACTORY = shape.createFactory();
    }

    @CoreMethod(names={"source_location"})
    public static abstract class SourceLocationNode
    extends CoreMethodArrayArgumentsNode {
        public SourceLocationNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object sourceLocation(RubyBasicObject unboundMethod) {
            SourceSection sourceSection = UnboundMethodNodes.getMethod(unboundMethod).getSharedMethodInfo().getSourceSection();
            if (sourceSection instanceof NullSourceSection) {
                return this.nil();
            }
            RubyBasicObject file = this.createString(sourceSection.getSource().getName());
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), file, sourceSection.getStartLine());
        }
    }

    @CoreMethod(names={"parameters"})
    public static abstract class ParametersNode
    extends CoreMethodArrayArgumentsNode {
        public ParametersNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject parameters(RubyBasicObject method) {
            ArgsNode argsNode = (ArgsNode)UnboundMethodNodes.getMethod(method).getSharedMethodInfo().getParseTree().findFirstChild(ArgsNode.class);
            ArgumentDescriptor[] argsDesc = Helpers.argsNodeToArgumentDescriptors((ArgsNode)argsNode);
            return this.getContext().toTruffle(Helpers.argumentDescriptorsToParameters((Ruby)this.getContext().getRuntime(), (ArgumentDescriptor[])argsDesc, (boolean)true));
        }
    }

    @CoreMethod(names={"owner"})
    public static abstract class OwnerNode
    extends CoreMethodArrayArgumentsNode {
        public OwnerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyModule owner(RubyBasicObject unboundMethod) {
            return UnboundMethodNodes.getMethod(unboundMethod).getDeclaringModule();
        }
    }

    @CoreMethod(names={"origin"}, visibility=Visibility.PRIVATE)
    public static abstract class OriginNode
    extends CoreMethodArrayArgumentsNode {
        public OriginNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyModule origin(RubyBasicObject unboundMethod) {
            return UnboundMethodNodes.getOrigin(unboundMethod);
        }
    }

    @CoreMethod(names={"name"})
    public static abstract class NameNode
    extends CoreMethodArrayArgumentsNode {
        public NameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject name(RubyBasicObject unboundMethod) {
            return this.getSymbol(UnboundMethodNodes.getMethod(unboundMethod).getName());
        }
    }

    @CoreMethod(names={"bind"}, required=1)
    public static abstract class BindNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private MetaClassNode metaClassNode;
        @Node.Child
        private CanBindMethodToModuleNode canBindMethodToModuleNode;

        public BindNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
            this.canBindMethodToModuleNode = CanBindMethodToModuleNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public RubyBasicObject bind(VirtualFrame frame, RubyBasicObject unboundMethod, Object object) {
            RubyClass objectMetaClass = this.metaClass(frame, object);
            if (!this.canBindMethodToModuleNode.executeCanBindMethodToModule(frame, UnboundMethodNodes.getMethod(unboundMethod), objectMetaClass)) {
                CompilerDirectives.transferToInterpreter();
                RubyModule declaringModule = UnboundMethodNodes.getMethod(unboundMethod).getDeclaringModule();
                if (declaringModule instanceof RubyClass && ((RubyClass)declaringModule).isSingleton()) {
                    throw new RaiseException(this.getContext().getCoreLibrary().typeError("singleton method called for a different object", this));
                }
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("bind argument must be an instance of " + declaringModule.getName(), this));
            }
            return MethodNodes.createMethod(this.getContext().getCoreLibrary().getMethodClass(), object, UnboundMethodNodes.getMethod(unboundMethod));
        }

        protected RubyClass metaClass(VirtualFrame frame, Object object) {
            return this.metaClassNode.executeMetaClass(frame, object);
        }
    }

    @CoreMethod(names={"arity"})
    public static abstract class ArityNode
    extends CoreMethodArrayArgumentsNode {
        public ArityNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int arity(RubyBasicObject method) {
            return UnboundMethodNodes.getMethod(method).getSharedMethodInfo().getArity().getArityNumber();
        }
    }

    @CoreMethod(names={"=="}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyUnboundMethod(other)"})
        boolean equal(RubyBasicObject self, RubyBasicObject other) {
            return UnboundMethodNodes.getMethod(self) == UnboundMethodNodes.getMethod(other) && UnboundMethodNodes.getOrigin(self) == UnboundMethodNodes.getOrigin(other);
        }

        @Specialization(guards={"!isRubyUnboundMethod(other)"})
        boolean equal(RubyBasicObject self, Object other) {
            return false;
        }
    }

    public static class MethodType
    extends BasicObjectType {
    }
}

