/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyTime;

@CoreClass(name="Time")
public abstract class TimeNodes {
    private static final DateTime ZERO = new DateTime(0L);

    public static DateTime getDateTime(RubyBasicObject time) {
        assert (RubyGuards.isRubyTime(time));
        return ((RubyTime)time).dateTime;
    }

    public static void setDateTime(RubyBasicObject time, DateTime dateTime) {
        assert (RubyGuards.isRubyTime(time));
        ((RubyTime)time).dateTime = dateTime;
    }

    public static Object getOffset(RubyBasicObject time) {
        assert (RubyGuards.isRubyTime(time));
        return ((RubyTime)time).offset;
    }

    public static void setOffset(RubyBasicObject time, Object offset) {
        assert (RubyGuards.isRubyTime(time));
        assert (offset != null);
        ((RubyTime)time).offset = offset;
    }

    public static RubyBasicObject createRubyTime(RubyClass timeClass, DateTime dateTime, Object offset) {
        return new RubyTime(timeClass, dateTime, offset);
    }

    public static class TimeAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return TimeNodes.createRubyTime(rubyClass, ZERO, context.getCoreLibrary().getNilObject());
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="offset")})
    public static abstract class InternalSetOffsetNode
    extends CoreMethodNode {
        public InternalSetOffsetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object internalSetOffset(RubyBasicObject time, Object offset) {
            TimeNodes.setOffset(time, offset);
            return offset;
        }
    }

    @NodeChild(type=RubyNode.class, value="self")
    public static abstract class InternalOffsetNode
    extends CoreMethodNode {
        public InternalOffsetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object internalOffset(RubyBasicObject time) {
            return TimeNodes.getOffset(time);
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="isGMT")})
    public static abstract class InternalSetGMTNode
    extends CoreMethodNode {
        public InternalSetGMTNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean internalSetGMT(RubyBasicObject time, boolean isGMT) {
            if (isGMT) {
                TimeNodes.setDateTime(time, TimeNodes.getDateTime(time).withZone(DateTimeZone.UTC));
            }
            return isGMT;
        }
    }

    @NodeChild(type=RubyNode.class, value="self")
    public static abstract class InternalGMTNode
    extends CoreMethodNode {
        public InternalGMTNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean internalGMT(RubyBasicObject time) {
            return TimeNodes.getOffset(time) == this.nil() && (TimeNodes.getDateTime(time).getZone().equals((Object)DateTimeZone.UTC) || TimeNodes.getDateTime(time).getZone().getOffset(TimeNodes.getDateTime(time).getMillis()) == 0);
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyTime(from)"})
        public Object initializeCopy(RubyBasicObject self, RubyBasicObject from) {
            TimeNodes.setDateTime(self, TimeNodes.getDateTime(from));
            TimeNodes.setOffset(self, TimeNodes.getOffset(from));
            return self;
        }
    }
}

