/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import java.math.BigInteger;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.FixnumOrBignumNode;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@CoreClass(name="Integer")
public abstract class IntegerNodes {

    @CoreMethod(names={"upto"}, needsBlock=true, required=1, returnsEnumeratorIfNoBlock=true, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class UpToNode
    extends YieldingCoreMethodNode {
        public UpToNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isRubyProc(block)"})
        public Object upto(VirtualFrame frame, int from, int to, RubyBasicObject block) {
            int count = 0;
            try {
                for (int i = from; i <= to; ++i) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, i);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return this.nil();
        }

        @Specialization(guards={"isRubyProc(block)"})
        public Object upto(VirtualFrame frame, int from, double to, RubyBasicObject block) {
            return this.upto(frame, from, (int)Math.floor(to), block);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isRubyProc(block)"})
        public Object upto(VirtualFrame frame, long from, long to, RubyBasicObject block) {
            int count = 0;
            try {
                for (long i = from; i <= to; ++i) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, i);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"to_i", "to_int"})
    public static abstract class ToINode
    extends CoreMethodArrayArgumentsNode {
        public ToINode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int toI(int n) {
            return n;
        }

        @Specialization
        public long toI(long n) {
            return n;
        }

        @Specialization(guards={"isRubyBignum(n)"})
        public RubyBasicObject toI(RubyBasicObject n) {
            return n;
        }
    }

    @CoreMethod(names={"times"}, needsBlock=true)
    public static abstract class TimesNode
    extends YieldingCoreMethodNode {
        public TimesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject times(VirtualFrame frame, int n, NotProvided block) {
            int[] array = new int[n];
            for (int i = 0; i < n; ++i) {
                array[i] = i;
            }
            return this.createArray(array, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isRubyProc(block)"})
        public Object times(VirtualFrame frame, int n, RubyBasicObject block) {
            int count = 0;
            try {
                for (int i = 0; i < n; ++i) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, i);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isRubyProc(block)"})
        public Object times(VirtualFrame frame, long n, RubyBasicObject block) {
            int count = 0;
            try {
                for (long i = 0L; i < n; ++i) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, i);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return n;
        }

        @Specialization(guards={"isRubyBignum(n)", "isRubyProc(block)"})
        public Object times(VirtualFrame frame, RubyBasicObject n, RubyBasicObject block, @Cached(value="create(getContext(), getSourceSection())") FixnumOrBignumNode fixnumOrBignumNode) {
            BigInteger i = BigInteger.ZERO;
            while (i.compareTo(BignumNodes.getBigIntegerValue(n)) < 0) {
                this.yield(frame, block, fixnumOrBignumNode.fixnumOrBignum(i));
                i = i.add(BigInteger.ONE);
            }
            return n;
        }
    }

    @CoreMethod(names={"downto"}, needsBlock=true, required=1, returnsEnumeratorIfNoBlock=true, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class DownToNode
    extends YieldingCoreMethodNode {
        public DownToNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isRubyProc(block)"})
        public Object downto(VirtualFrame frame, int from, int to, RubyBasicObject block) {
            int count = 0;
            try {
                for (int i = from; i >= to; --i) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, i);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return this.nil();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isRubyProc(block)"})
        public Object downto(VirtualFrame frame, long from, long to, RubyBasicObject block) {
            int count = 0;
            try {
                for (long i = from; i >= to; --i) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, i);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return this.nil();
        }

        @Specialization(guards={"isRubyProc(block)"})
        public Object downto(VirtualFrame frame, int from, double to, RubyBasicObject block) {
            return this.downto(frame, from, (int)Math.ceil(to), block);
        }
    }
}

