/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.ext;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.EnumSet;
import java.util.regex.Pattern;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.cast.IntegerCastNode;
import org.jruby.truffle.nodes.cast.IntegerCastNodeGen;
import org.jruby.truffle.nodes.coerce.ToIntNode;
import org.jruby.truffle.nodes.coerce.ToIntNodeGen;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.FixnumOrBignumNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.object.BasicObjectType;

@CoreClass(name="Truffle::BigDecimal")
public abstract class BigDecimalNodes {
    public static final BigDecimalType BIG_DECIMAL_TYPE = new BigDecimalType();
    public static final Property VALUE_PROPERTY;
    public static final Property TYPE_PROPERTY;
    private static final HiddenKey VALUE_IDENTIFIER;
    private static final HiddenKey TYPE_IDENTIFIER;
    private static final DynamicObjectFactory BIG_DECIMAL_FACTORY;

    public static BigDecimal getBigDecimalValue(long v) {
        return BigDecimal.valueOf(v);
    }

    public static BigDecimal getBigDecimalValue(double v) {
        return BigDecimal.valueOf(v);
    }

    public static BigDecimal getBignumBigDecimalValue(RubyBasicObject v) {
        return new BigDecimal(BignumNodes.getBigIntegerValue(v));
    }

    public static BigDecimal getBigDecimalValue(RubyBasicObject bigdecimal) {
        assert (RubyGuards.isRubyBigDecimal(bigdecimal));
        assert (bigdecimal.getDynamicObject().getShape().hasProperty((Object)VALUE_IDENTIFIER));
        return (BigDecimal)VALUE_PROPERTY.get(bigdecimal.getDynamicObject(), true);
    }

    public static Type getBigDecimalType(RubyBasicObject bigdecimal) {
        assert (RubyGuards.isRubyBigDecimal(bigdecimal));
        assert (bigdecimal.getDynamicObject().getShape().hasProperty((Object)TYPE_IDENTIFIER));
        return (Type)((Object)TYPE_PROPERTY.get(bigdecimal.getDynamicObject(), true));
    }

    private static void setBigDecimalValue(RubyBasicObject bigdecimal, BigDecimal value) {
        assert (RubyGuards.isRubyBigDecimal(bigdecimal));
        assert (bigdecimal.getDynamicObject().getShape().hasProperty((Object)VALUE_IDENTIFIER));
        VALUE_PROPERTY.setSafe(bigdecimal.getDynamicObject(), (Object)value, null);
        TYPE_PROPERTY.setSafe(bigdecimal.getDynamicObject(), (Object)Type.NORMAL, null);
    }

    private static void setBigDecimalValue(RubyBasicObject bigdecimal, Type type) {
        assert (RubyGuards.isRubyBigDecimal(bigdecimal));
        assert (bigdecimal.getDynamicObject().getShape().hasProperty((Object)TYPE_IDENTIFIER));
        VALUE_PROPERTY.setSafe(bigdecimal.getDynamicObject(), (Object)BigDecimal.ZERO, null);
        TYPE_PROPERTY.setSafe(bigdecimal.getDynamicObject(), (Object)type, null);
    }

    public static RubyBasicObject createRubyBigDecimal(RubyClass rubyClass, Type type) {
        assert (type != Type.NORMAL);
        return new RubyBasicObject(rubyClass, BIG_DECIMAL_FACTORY.newInstance(new Object[]{type, BigDecimal.ZERO}));
    }

    public static RubyBasicObject createRubyBigDecimal(RubyClass rubyClass, BigDecimal value) {
        return new RubyBasicObject(rubyClass, BIG_DECIMAL_FACTORY.newInstance(new Object[]{Type.NORMAL, value}));
    }

    private static int nearestBiggerMultipleOf4(int value) {
        return (value / 4 + 1) * 4;
    }

    static {
        VALUE_IDENTIFIER = new HiddenKey("value");
        TYPE_IDENTIFIER = new HiddenKey("type");
        Shape.Allocator allocator = RubyBasicObject.LAYOUT.createAllocator();
        VALUE_PROPERTY = Property.create((Object)VALUE_IDENTIFIER, (Location)allocator.locationForType(BigDecimal.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
        TYPE_PROPERTY = Property.create((Object)TYPE_IDENTIFIER, (Location)allocator.locationForType(Type.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
        BIG_DECIMAL_FACTORY = RubyBasicObject.LAYOUT.createShape((ObjectType)BIG_DECIMAL_TYPE).addProperty(TYPE_PROPERTY).addProperty(VALUE_PROPERTY).createFactory();
    }

    @CoreMethod(names={"to_i", "to_int"})
    public static abstract class ToINode
    extends BigDecimalCoreMethodNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public ToINode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)"})
        public Object toINormal(RubyBasicObject value) {
            return this.fixnumOrBignum.fixnumOrBignum(BigDecimalNodes.getBigDecimalValue(value).toBigInteger());
        }

        @Specialization(guards={"!isNormal(value)"})
        public int toISpecial(RubyBasicObject value) {
            Type type = BigDecimalNodes.getBigDecimalType(value);
            switch (type) {
                case NEGATIVE_INFINITY: {
                    throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError(type.getRepresentation(), this));
                }
                case POSITIVE_INFINITY: {
                    throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError(type.getRepresentation(), this));
                }
                case NAN: {
                    throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError(type.getRepresentation(), this));
                }
                case NEGATIVE_ZERO: {
                    return 0;
                }
            }
            throw new RuntimeException();
        }
    }

    @CoreMethod(names={"split"})
    public static abstract class SplitNode
    extends BigDecimalCoreMethodNode {
        private final ConditionProfile wasNormal = ConditionProfile.createBinaryProfile();
        @Node.Child
        private CallDispatchHeadNode signCall;
        @Node.Child
        private CallDispatchHeadNode exponentCall;
        @Node.Child
        private ToIntNode signToInt;
        @Node.Child
        private ToIntNode exponentToInt;
        @Node.Child
        private IntegerCastNode signIntegerCast;

        public SplitNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.signCall = DispatchHeadNodeFactory.createMethodCall(context);
            this.exponentCall = DispatchHeadNodeFactory.createMethodCall(context);
            this.signToInt = ToIntNodeGen.create(context, sourceSection, null);
            this.exponentToInt = ToIntNodeGen.create(context, sourceSection, null);
            this.signIntegerCast = IntegerCastNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public RubyBasicObject split(VirtualFrame frame, RubyBasicObject value) {
            String type;
            String digits = this.wasNormal.profile(SplitNode.isNormal(value)) ? this.getNormalDigits(value) : ((type = BigDecimalNodes.getBigDecimalType(value).getRepresentation()).startsWith("-") ? type.substring(1) : type);
            int sign = Integer.signum(this.signIntegerCast.executeInteger(frame, this.signToInt.executeIntOrLong(frame, this.signCall.call(frame, value, "sign", null, new Object[0]))));
            Object exponent = this.exponentToInt.executeIntOrLong(frame, this.exponentCall.call(frame, value, "exponent", null, new Object[0]));
            return this.createArray(new Object[]{sign, this.createString(digits), 10, exponent}, 4);
        }

        @CompilerDirectives.TruffleBoundary
        private String getNormalDigits(RubyBasicObject value) {
            return BigDecimalNodes.getBigDecimalValue(value).abs().stripTrailingZeros().unscaledValue().toString();
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends BigDecimalCoreMethodNode {
        public ToFNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)"})
        public double toFNormal(RubyBasicObject value) {
            return BigDecimalNodes.getBigDecimalValue(value).doubleValue();
        }

        @Specialization(guards={"!isNormal(value)"})
        public double toFSpecial(RubyBasicObject value) {
            switch (BigDecimalNodes.getBigDecimalType(value)) {
                case NEGATIVE_INFINITY: {
                    return Double.NEGATIVE_INFINITY;
                }
                case POSITIVE_INFINITY: {
                    return Double.POSITIVE_INFINITY;
                }
                case NEGATIVE_ZERO: {
                    return 0.0;
                }
                case NAN: {
                    return Double.NaN;
                }
            }
            throw new RuntimeException();
        }
    }

    @CoreMethod(names={"to_s", "inspect"})
    public static abstract class ToSNode
    extends BigDecimalCoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)"})
        public RubyBasicObject toSNormal(RubyBasicObject value) {
            BigDecimal bigDecimal = BigDecimalNodes.getBigDecimalValue(value);
            boolean negative = bigDecimal.signum() == -1;
            return this.createString((negative ? "-" : "") + "0." + (negative ? bigDecimal.unscaledValue().toString().substring(1) : bigDecimal.unscaledValue()) + "E" + (bigDecimal.precision() - bigDecimal.scale()));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isNormal(value)"})
        public RubyBasicObject toSSpecial(RubyBasicObject value) {
            return this.createString(BigDecimalNodes.getBigDecimalType(value).getRepresentation());
        }
    }

    @CoreMethod(names={"precs"})
    public static abstract class PrecsNode
    extends BigDecimalCoreMethodNode {
        public PrecsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)"})
        public RubyBasicObject precsNormal(RubyBasicObject value) {
            BigDecimal bigDecimalValue = BigDecimalNodes.getBigDecimalValue(value).abs();
            return this.createArray(new int[]{bigDecimalValue.stripTrailingZeros().unscaledValue().toString().length(), BigDecimalNodes.nearestBiggerMultipleOf4(bigDecimalValue.unscaledValue().toString().length())}, 2);
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object precsSpecial(RubyBasicObject value) {
            return this.createArray(new int[]{1, 1}, 2);
        }
    }

    @CoreMethod(names={"infinite?"})
    public static abstract class InfiniteNode
    extends BigDecimalCoreMethodNode {
        public InfiniteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNormal(value)"})
        public RubyBasicObject infiniteNormal(RubyBasicObject value) {
            return this.nil();
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object infiniteSpecial(RubyBasicObject value) {
            switch (BigDecimalNodes.getBigDecimalType(value)) {
                case POSITIVE_INFINITY: {
                    return 1;
                }
                case NEGATIVE_INFINITY: {
                    return -1;
                }
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"finite?"})
    public static abstract class FiniteNode
    extends BigDecimalCoreMethodNode {
        public FiniteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNormal(value)"})
        public boolean finiteNormal(RubyBasicObject value) {
            return true;
        }

        @Specialization(guards={"!isNormal(value)"})
        public boolean finiteSpecial(RubyBasicObject value) {
            switch (BigDecimalNodes.getBigDecimalType(value)) {
                case POSITIVE_INFINITY: 
                case NEGATIVE_INFINITY: 
                case NAN: {
                    return false;
                }
            }
            return true;
        }
    }

    @CoreMethod(names={"abs"})
    public static abstract class AbsNode
    extends BigDecimalCoreMethodNode {
        public AbsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)"})
        public RubyBasicObject abs(RubyBasicObject value) {
            return this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(value).abs());
        }

        @Specialization(guards={"!isNormal(value)"})
        public RubyBasicObject absSpecial(RubyBasicObject value) {
            switch (BigDecimalNodes.getBigDecimalType(value)) {
                case NEGATIVE_INFINITY: {
                    return this.createRubyBigDecimal(Type.POSITIVE_INFINITY);
                }
                case NEGATIVE_ZERO: {
                    return this.createRubyBigDecimal(BigDecimal.ZERO);
                }
                case POSITIVE_INFINITY: 
                case NAN: {
                    return value;
                }
            }
            throw new RuntimeException();
        }
    }

    @CoreMethod(names={"exponent"})
    public static abstract class ExponentNode
    extends BigDecimalCoreMethodNode {
        public ExponentNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)", "!isNormalZero(value)"})
        public long exponent(RubyBasicObject value) {
            BigDecimal val = BigDecimalNodes.getBigDecimalValue(value).abs().stripTrailingZeros();
            return val.precision() - val.scale();
        }

        @Specialization(guards={"isNormal(value)", "isNormalZero(value)"})
        public int exponentZero(RubyBasicObject value) {
            return 0;
        }

        @Specialization(guards={"!isNormal(value)"})
        public int exponentSpecial(RubyBasicObject value) {
            return 0;
        }
    }

    @CoreMethod(names={"nan?"})
    public static abstract class NanNode
    extends BigDecimalCoreMethodNode {
        public NanNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNormal(value)"})
        public boolean nanNormal(RubyBasicObject value) {
            return false;
        }

        @Specialization(guards={"!isNormal(value)"})
        public boolean nanSpecial(RubyBasicObject value) {
            return BigDecimalNodes.getBigDecimalType(value) == Type.NAN;
        }
    }

    @CoreMethod(names={"sign"})
    public static abstract class SignNode
    extends BigDecimalCoreMethodNode {
        public SignNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNormal(value)", "isNormalZero(value)"})
        public int signNormalZero(RubyBasicObject value) {
            return 1;
        }

        @Specialization(guards={"isNormal(value)", "!isNormalZero(value)"})
        public int signNormal(RubyBasicObject value) {
            return BigDecimalNodes.getBigDecimalValue(value).signum() * 2;
        }

        @Specialization(guards={"!isNormal(value)"})
        public int signSpecial(RubyBasicObject value) {
            switch (BigDecimalNodes.getBigDecimalType(value)) {
                case NEGATIVE_INFINITY: {
                    return -3;
                }
                case POSITIVE_INFINITY: {
                    return 3;
                }
                case NEGATIVE_ZERO: {
                    return -1;
                }
                case NAN: {
                    return 0;
                }
            }
            throw new RuntimeException();
        }
    }

    @CoreMethod(names={"zero?"})
    public static abstract class ZeroNode
    extends BigDecimalCoreMethodNode {
        public ZeroNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNormal(value)"})
        public boolean zeroNormal(RubyBasicObject value) {
            return BigDecimalNodes.getBigDecimalValue(value).compareTo(BigDecimal.ZERO) == 0;
        }

        @Specialization(guards={"!isNormal(value)"})
        public boolean zeroSpecial(RubyBasicObject value) {
            switch (BigDecimalNodes.getBigDecimalType(value)) {
                case NEGATIVE_ZERO: {
                    return true;
                }
            }
            return false;
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends BigDecimalCoreMethodNode {
        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        private int compareBigDecimal(RubyBasicObject a, BigDecimal b) {
            return BigDecimalNodes.getBigDecimalValue(a).compareTo(b);
        }

        @Specialization(guards={"isNormal(a)"})
        public int compare(RubyBasicObject a, long b) {
            return this.compareBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)"})
        public int compare(RubyBasicObject a, double b) {
            return this.compareBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)", "isRubyBignum(b)"})
        public int compare(RubyBasicObject a, RubyBasicObject b) {
            return this.compareBigDecimal(a, BigDecimalNodes.getBignumBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)", "isRubyBigDecimal(b)", "isNormal(b)"})
        public int compareNormal(RubyBasicObject a, RubyBasicObject b) {
            return this.compareBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"!isNormal(a)"})
        public Object compareSpecial(RubyBasicObject a, long b) {
            return this.compareSpecial(a, this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(b)));
        }

        @Specialization(guards={"!isNormal(a)"})
        public Object compareSpecial(RubyBasicObject a, double b) {
            return this.compareSpecial(a, this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(b)));
        }

        @Specialization(guards={"!isNormal(a)", "isRubyBignum(b)"})
        public Object compareSpecialBignum(RubyBasicObject a, RubyBasicObject b) {
            return this.compareSpecial(a, this.createRubyBigDecimal(BigDecimalNodes.getBignumBigDecimalValue(b)));
        }

        @Specialization(guards={"!isNormal(a)", "isNan(a)"})
        public Object compareSpecialNan(RubyBasicObject a, RubyBasicObject b) {
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)", "isNormal(a) || !isNan(a)"})
        public Object compareSpecial(RubyBasicObject a, RubyBasicObject b) {
            Type aType = BigDecimalNodes.getBigDecimalType(a);
            Type bType = BigDecimalNodes.getBigDecimalType(b);
            if (aType == Type.NAN || bType == Type.NAN) {
                return this.nil();
            }
            if (aType == bType) {
                return 0;
            }
            if (aType == Type.POSITIVE_INFINITY || bType == Type.NEGATIVE_INFINITY) {
                return 1;
            }
            if (aType == Type.NEGATIVE_INFINITY || bType == Type.POSITIVE_INFINITY) {
                return -1;
            }
            BigDecimal aCompare = aType == Type.NEGATIVE_ZERO ? BigDecimal.ZERO : BigDecimalNodes.getBigDecimalValue(a);
            BigDecimal bCompare = bType == Type.NEGATIVE_ZERO ? BigDecimal.ZERO : BigDecimalNodes.getBigDecimalValue(b);
            return aCompare.compareTo(bCompare);
        }

        @Specialization(guards={"isNil(b)"})
        public Object compareNil(RubyBasicObject a, RubyBasicObject b) {
            return this.nil();
        }

        @Specialization(guards={"!isRubyBigDecimal(b)", "!isNil(b)"})
        public Object compareCoerced(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :<=>, b", "b", b);
        }
    }

    @CoreMethod(names={"/", "quo"}, required=1)
    public static abstract class DivOpNode
    extends BigDecimalCoreMethodNode {
        final ConditionProfile normalZero = ConditionProfile.createBinaryProfile();

        public DivOpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        private Object div(RubyBasicObject a, BigDecimal b) {
            if (this.normalZero.profile(b.signum() == 0)) {
                switch (BigDecimalNodes.getBigDecimalValue(a).signum()) {
                    case 1: {
                        return this.createRubyBigDecimal(Type.POSITIVE_INFINITY);
                    }
                    case 0: {
                        return this.createRubyBigDecimal(Type.NAN);
                    }
                    case -1: {
                        return this.createRubyBigDecimal(Type.NEGATIVE_INFINITY);
                    }
                }
                throw new RuntimeException();
            }
            int sumOfPrecisions = BigDecimalNodes.getBigDecimalValue(a).precision() + b.precision();
            int precision = BigDecimalNodes.nearestBiggerMultipleOf4(sumOfPrecisions) * 2;
            return this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(a).divide(b, new MathContext(precision)));
        }

        @Specialization(guards={"isNormal(a)"})
        public Object div(RubyBasicObject a, long b) {
            return this.div(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)"})
        public Object div(RubyBasicObject a, double b) {
            return this.div(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)", "isRubyBignum(b)"})
        public Object divBignum(RubyBasicObject a, RubyBasicObject b) {
            return this.div(a, BigDecimalNodes.getBignumBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)", "isRubyBigDecimal(b)", "isNormal(b)"})
        public Object div(RubyBasicObject a, RubyBasicObject b) {
            return this.div(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)", "isRubyBigDecimal(b)", "!isNormal(b)"})
        public Object divNormalSpecial(RubyBasicObject a, RubyBasicObject b) {
            switch (BigDecimalNodes.getBigDecimalType(b)) {
                case NAN: {
                    return b;
                }
                case NEGATIVE_ZERO: {
                    switch (BigDecimalNodes.getBigDecimalValue(a).signum()) {
                        case 1: {
                            return this.createRubyBigDecimal(Type.NEGATIVE_INFINITY);
                        }
                        case 0: {
                            return this.createRubyBigDecimal(Type.NAN);
                        }
                        case -1: {
                            return this.createRubyBigDecimal(Type.POSITIVE_INFINITY);
                        }
                    }
                }
                case POSITIVE_INFINITY: {
                    switch (BigDecimalNodes.getBigDecimalValue(a).signum()) {
                        case 0: 
                        case 1: {
                            return this.createRubyBigDecimal(BigDecimal.ZERO);
                        }
                        case -1: {
                            return this.createRubyBigDecimal(Type.NEGATIVE_ZERO);
                        }
                    }
                }
                case NEGATIVE_INFINITY: {
                    switch (BigDecimalNodes.getBigDecimalValue(b).signum()) {
                        case 1: {
                            return this.createRubyBigDecimal(Type.NEGATIVE_ZERO);
                        }
                        case -1: 
                        case 0: {
                            return this.createRubyBigDecimal(BigDecimal.ZERO);
                        }
                    }
                }
            }
            throw new RuntimeException();
        }

        @Specialization(guards={"!isNormal(a)"})
        public Object divSpecialNormal(RubyBasicObject a, long b) {
            return this.divSpecialNormal(a, this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(b)));
        }

        @Specialization(guards={"!isNormal(a)"})
        public Object divSpecialNormal(RubyBasicObject a, double b) {
            return this.divSpecialNormal(a, this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(b)));
        }

        @Specialization(guards={"!isNormal(a)", "isRubyBignum(b)"})
        public Object divSpecialNormalBignum(RubyBasicObject a, RubyBasicObject b) {
            return this.divSpecialNormal(a, this.createRubyBigDecimal(BigDecimalNodes.getBignumBigDecimalValue(b)));
        }

        @Specialization(guards={"!isNormal(a)", "isRubyBigDecimal(b)", "isNormal(b)"})
        public Object divSpecialNormal(RubyBasicObject a, RubyBasicObject b) {
            switch (BigDecimalNodes.getBigDecimalType(a)) {
                case NAN: {
                    return a;
                }
                case NEGATIVE_ZERO: {
                    switch (BigDecimalNodes.getBigDecimalValue(b).signum()) {
                        case 1: {
                            return a;
                        }
                        case 0: {
                            return this.createRubyBigDecimal(Type.NAN);
                        }
                        case -1: {
                            return this.createRubyBigDecimal(BigDecimal.ZERO);
                        }
                    }
                }
                case POSITIVE_INFINITY: {
                    switch (BigDecimalNodes.getBigDecimalValue(b).signum()) {
                        case 1: {
                            return a;
                        }
                        case 0: {
                            return a;
                        }
                        case -1: {
                            return this.createRubyBigDecimal(Type.NEGATIVE_INFINITY);
                        }
                    }
                }
                case NEGATIVE_INFINITY: {
                    switch (BigDecimalNodes.getBigDecimalValue(b).signum()) {
                        case 1: {
                            return a;
                        }
                        case 0: {
                            return a;
                        }
                        case -1: {
                            return this.createRubyBigDecimal(Type.POSITIVE_INFINITY);
                        }
                    }
                }
            }
            throw new RuntimeException();
        }

        @Specialization(guards={"!isNormal(a)", "isRubyBigDecimal(b)", "!isNormal(b)"})
        public Object divSpecialSpecia(RubyBasicObject a, RubyBasicObject b) {
            Type aType = BigDecimalNodes.getBigDecimalType(a);
            Type bType = BigDecimalNodes.getBigDecimalType(b);
            if (aType == Type.NAN || bType == Type.NAN || aType == Type.NEGATIVE_ZERO && bType == Type.NEGATIVE_ZERO) {
                return this.createRubyBigDecimal(Type.NAN);
            }
            if (aType == Type.NEGATIVE_ZERO) {
                if (bType == Type.POSITIVE_INFINITY) {
                    return a;
                }
                return this.createRubyBigDecimal(Type.POSITIVE_INFINITY);
            }
            if (bType == Type.NEGATIVE_ZERO) {
                if (aType == Type.POSITIVE_INFINITY) {
                    return this.createRubyBigDecimal(Type.NEGATIVE_INFINITY);
                }
                return this.createRubyBigDecimal(Type.POSITIVE_INFINITY);
            }
            return this.createRubyBigDecimal(Type.NAN);
        }
    }

    @CoreMethod(names={"mult"}, required=2)
    public static abstract class MultNode
    extends BigDecimalCoreMethodNode {
        public MultNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        private Object mulBigDecimal(RubyBasicObject a, BigDecimal b, int precision) {
            return this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(a).multiply(b, new MathContext(precision)));
        }

        @Specialization(guards={"isNormal(a)"})
        public Object mult(RubyBasicObject a, long b, int precision) {
            return this.mulBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b), precision);
        }

        @Specialization(guards={"isNormal(a)"})
        public Object mult(RubyBasicObject a, double b, int precision) {
            return this.mulBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b), precision);
        }

        @Specialization(guards={"isNormal(a)", "isRubyBignum(b)"})
        public Object multBignum(RubyBasicObject a, RubyBasicObject b, int precision) {
            return this.mulBigDecimal(a, BigDecimalNodes.getBignumBigDecimalValue(b), precision);
        }

        @Specialization(guards={"isNormal(a)", "isRubyBigDecimal(b)", "isNormal(b)"})
        public Object mult(RubyBasicObject a, RubyBasicObject b, int precision) {
            return this.mulBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b), precision);
        }
    }

    @CoreMethod(names={"*"}, required=1)
    public static abstract class MultOpNode
    extends BigDecimalCoreMethodNode {
        private final ConditionProfile zeroNormal = ConditionProfile.createBinaryProfile();

        public MultOpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        private Object multBigDecimal(RubyBasicObject a, BigDecimal b) {
            if (this.zeroNormal.profile(MultOpNode.isNormalZero(a) && b.signum() == -1)) {
                return this.createRubyBigDecimal(Type.NEGATIVE_ZERO);
            }
            return this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(a).multiply(b));
        }

        @Specialization(guards={"isNormal(a)"})
        public Object mult(RubyBasicObject a, long b) {
            return this.multBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)"})
        public Object mult(RubyBasicObject a, double b) {
            return this.multBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)", "isRubyBignum(b)"})
        public Object multBignum(RubyBasicObject a, RubyBasicObject b) {
            return this.multBigDecimal(a, BigDecimalNodes.getBignumBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)", "isRubyBigDecimal(b)", "isNormal(b)"})
        public Object mult(RubyBasicObject a, RubyBasicObject b) {
            return this.multBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)", "isRubyBigDecimal(b)", "!isNormal(b)"})
        public Object multNormalSpecial(RubyBasicObject a, RubyBasicObject b) {
            return this.multSpecialNormal(b, a);
        }

        @Specialization(guards={"!isNormal(a)"})
        public Object multSpecialNormal(RubyBasicObject a, long b) {
            return this.multSpecialNormal(a, this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(b)));
        }

        @Specialization(guards={"!isNormal(a)"})
        public Object multSpecialNormal(RubyBasicObject a, double b) {
            return this.multSpecialNormal(a, this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(b)));
        }

        @Specialization(guards={"!isNormal(a)", "isRubyBignum(b)"})
        public Object multSpecialNormalBignum(RubyBasicObject a, RubyBasicObject b) {
            return this.multSpecialNormal(a, this.createRubyBigDecimal(BigDecimalNodes.getBignumBigDecimalValue(b)));
        }

        @Specialization(guards={"!isNormal(a)", "isRubyBigDecimal(b)", "isNormal(b)"})
        public Object multSpecialNormal(RubyBasicObject a, RubyBasicObject b) {
            switch (BigDecimalNodes.getBigDecimalType(a)) {
                case NAN: {
                    return a;
                }
                case NEGATIVE_ZERO: {
                    switch (BigDecimalNodes.getBigDecimalValue(b).signum()) {
                        case 0: 
                        case 1: {
                            return a;
                        }
                        case -1: {
                            return this.createRubyBigDecimal(BigDecimal.ZERO);
                        }
                    }
                }
                case POSITIVE_INFINITY: {
                    switch (BigDecimalNodes.getBigDecimalValue(b).signum()) {
                        case 1: {
                            return a;
                        }
                        case 0: {
                            return this.createRubyBigDecimal(Type.NAN);
                        }
                        case -1: {
                            return this.createRubyBigDecimal(Type.NEGATIVE_INFINITY);
                        }
                    }
                }
                case NEGATIVE_INFINITY: {
                    switch (BigDecimalNodes.getBigDecimalValue(b).signum()) {
                        case 1: {
                            return a;
                        }
                        case 0: {
                            return this.createRubyBigDecimal(Type.NAN);
                        }
                        case -1: {
                            return this.createRubyBigDecimal(Type.POSITIVE_INFINITY);
                        }
                    }
                }
            }
            throw new RuntimeException();
        }

        @Specialization(guards={"!isNormal(a)", "isRubyBigDecimal(b)", "!isNormal(b)"})
        public Object multSpecial(RubyBasicObject a, RubyBasicObject b) {
            Type aType = BigDecimalNodes.getBigDecimalType(a);
            Type bType = BigDecimalNodes.getBigDecimalType(b);
            if (aType == Type.NAN || bType == Type.NAN) {
                return this.createRubyBigDecimal(Type.NAN);
            }
            if (aType == Type.NEGATIVE_ZERO && bType == Type.NEGATIVE_ZERO) {
                return this.createRubyBigDecimal(BigDecimal.ZERO);
            }
            if (aType == Type.NEGATIVE_ZERO || bType == Type.NEGATIVE_ZERO) {
                return this.createRubyBigDecimal(Type.NAN);
            }
            if (aType == Type.POSITIVE_INFINITY) {
                return bType == Type.POSITIVE_INFINITY ? a : this.createRubyBigDecimal(Type.NEGATIVE_INFINITY);
            }
            if (aType == Type.NEGATIVE_INFINITY) {
                return bType == Type.POSITIVE_INFINITY ? a : this.createRubyBigDecimal(Type.POSITIVE_INFINITY);
            }
            throw new RuntimeException();
        }
    }

    @CoreMethod(names={"sub"}, required=2)
    public static abstract class SubNode
    extends BigDecimalCoreMethodNode {
        public SubNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        private Object subBigDecimal(RubyBasicObject a, BigDecimal b, int precision) {
            return this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(a).subtract(b, new MathContext(precision)));
        }

        @Specialization(guards={"isNormal(a)"})
        public Object sub(RubyBasicObject a, long b, int precision) {
            return this.subBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b), precision);
        }

        @Specialization(guards={"isNormal(a)"})
        public Object sub(RubyBasicObject a, double b, int precision) {
            return this.subBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b), precision);
        }

        @Specialization(guards={"isNormal(a)", "isRubyBignum(b)"})
        public Object subBignum(RubyBasicObject a, RubyBasicObject b, int precision) {
            return this.subBigDecimal(a, BigDecimalNodes.getBignumBigDecimalValue(b), precision);
        }

        @Specialization(guards={"isNormal(a)", "isRubyBigDecimal(b)", "isNormal(b)"})
        public Object sub(RubyBasicObject a, RubyBasicObject b, int precision) {
            return this.subBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b), precision);
        }
    }

    @CoreMethod(names={"-@"})
    public static abstract class NegNode
    extends BigDecimalCoreMethodNode {
        public NegNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNormal(value)", "!isNormalZero(value)"})
        public Object negNormal(RubyBasicObject value) {
            return this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(value).negate());
        }

        @Specialization(guards={"isNormal(value)", "isNormalZero(value)"})
        public Object negNormalZero(RubyBasicObject value) {
            return this.createRubyBigDecimal(Type.NEGATIVE_ZERO);
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object negSpecial(RubyBasicObject value) {
            switch (BigDecimalNodes.getBigDecimalType(value)) {
                case POSITIVE_INFINITY: {
                    return this.createRubyBigDecimal(Type.NEGATIVE_INFINITY);
                }
                case NEGATIVE_INFINITY: {
                    return this.createRubyBigDecimal(Type.POSITIVE_INFINITY);
                }
                case NEGATIVE_ZERO: {
                    return this.createRubyBigDecimal(BigDecimal.ZERO);
                }
                case NAN: {
                    return value;
                }
            }
            throw new RuntimeException();
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubOpNode
    extends BigDecimalCoreMethodNode {
        public SubOpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        private Object subBigDecimal(RubyBasicObject a, BigDecimal b) {
            return this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(a).subtract(b));
        }

        @Specialization(guards={"isNormal(a)"})
        public Object sub(RubyBasicObject a, long b) {
            return this.subBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)"})
        public Object sub(RubyBasicObject a, double b) {
            return this.subBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)", "isRubyBignum(b)"})
        public Object subBignum(RubyBasicObject a, RubyBasicObject b) {
            return this.subBigDecimal(a, BigDecimalNodes.getBignumBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)", "isRubyBigDecimal(b)", "isNormal(b)"})
        public Object subNormal(RubyBasicObject a, RubyBasicObject b) {
            return this.subBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"!isNormal(a)"})
        public Object subSpecial(RubyBasicObject a, long b) {
            return this.subSpecial(a, this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(b)));
        }

        @Specialization(guards={"!isNormal(a)"})
        public Object subSpecial(RubyBasicObject a, double b) {
            return this.subSpecial(a, this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(b)));
        }

        @Specialization(guards={"!isNormal(a)", "isRubyBignum(b)"})
        public Object subSpecialBignum(RubyBasicObject a, RubyBasicObject b) {
            return this.subSpecial(a, this.createRubyBigDecimal(BigDecimalNodes.getBignumBigDecimalValue(b)));
        }

        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object subSpecial(RubyBasicObject a, RubyBasicObject b) {
            Type aType = BigDecimalNodes.getBigDecimalType(a);
            Type bType = BigDecimalNodes.getBigDecimalType(b);
            if (aType == Type.NAN || bType == Type.NAN || aType == Type.POSITIVE_INFINITY && bType == Type.POSITIVE_INFINITY || aType == Type.NEGATIVE_INFINITY && bType == Type.NEGATIVE_INFINITY) {
                return this.createRubyBigDecimal(Type.NAN);
            }
            if (aType == Type.POSITIVE_INFINITY || bType == Type.NEGATIVE_INFINITY) {
                return this.createRubyBigDecimal(Type.POSITIVE_INFINITY);
            }
            if (aType == Type.NEGATIVE_INFINITY || bType == Type.POSITIVE_INFINITY) {
                return this.createRubyBigDecimal(Type.NEGATIVE_INFINITY);
            }
            if (SubOpNode.isNormal(a)) {
                return a;
            }
            return this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(b).negate());
        }
    }

    @CoreMethod(names={"add"}, required=2)
    public static abstract class AddNode
    extends BigDecimalCoreMethodNode {
        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        private Object addBigDecimal(RubyBasicObject a, BigDecimal b, int precision) {
            return this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(a).add(b, new MathContext(precision)));
        }

        @Specialization(guards={"isNormal(a)"})
        public Object add(RubyBasicObject a, long b, int precision) {
            return this.addBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b), precision);
        }

        @Specialization(guards={"isNormal(a)"})
        public Object add(RubyBasicObject a, double b, int precision) {
            return this.addBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b), precision);
        }

        @Specialization(guards={"isNormal(a)", "isRubyBignum(b)"})
        public Object addBignum(RubyBasicObject a, RubyBasicObject b, int precision) {
            return this.addBigDecimal(a, BigDecimalNodes.getBignumBigDecimalValue(b), precision);
        }

        @Specialization(guards={"isNormal(a)", "isRubyBigDecimal(b)", "isNormal(b)"})
        public Object add(RubyBasicObject a, RubyBasicObject b, int precision) {
            return this.addBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b), precision);
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddOpNode
    extends BigDecimalCoreMethodNode {
        public AddOpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        private Object addBigDecimal(RubyBasicObject a, BigDecimal b) {
            return this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(a).add(b));
        }

        @Specialization(guards={"isNormal(a)"})
        public Object add(RubyBasicObject a, long b) {
            return this.addBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)"})
        public Object add(RubyBasicObject a, double b) {
            return this.addBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)", "isRubyBignum(b)"})
        public Object addBignum(RubyBasicObject a, RubyBasicObject b) {
            return this.addBigDecimal(a, BigDecimalNodes.getBignumBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)", "isRubyBigDecimal(b)", "isNormal(b)"})
        public Object add(RubyBasicObject a, RubyBasicObject b) {
            return this.addBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"!isNormal(a)"})
        public Object addSpecial(RubyBasicObject a, long b) {
            return this.addSpecial(a, this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(b)));
        }

        @Specialization(guards={"!isNormal(a)"})
        public Object addSpecial(RubyBasicObject a, double b) {
            return this.addSpecial(a, this.createRubyBigDecimal(BigDecimalNodes.getBigDecimalValue(b)));
        }

        @Specialization(guards={"!isNormal(a)", "isRubyBignum(b)"})
        public Object addSpecialBignum(RubyBasicObject a, RubyBasicObject b) {
            return this.addSpecial(a, this.createRubyBigDecimal(BigDecimalNodes.getBignumBigDecimalValue(b)));
        }

        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object addSpecial(RubyBasicObject a, RubyBasicObject b) {
            Type aType = BigDecimalNodes.getBigDecimalType(a);
            Type bType = BigDecimalNodes.getBigDecimalType(b);
            if (aType == Type.NAN || bType == Type.NAN || aType == Type.POSITIVE_INFINITY && bType == Type.NEGATIVE_INFINITY || aType == Type.NEGATIVE_INFINITY && bType == Type.POSITIVE_INFINITY) {
                return this.createRubyBigDecimal(Type.NAN);
            }
            if (aType == Type.POSITIVE_INFINITY || bType == Type.POSITIVE_INFINITY) {
                return this.createRubyBigDecimal(Type.POSITIVE_INFINITY);
            }
            if (aType == Type.NEGATIVE_INFINITY || bType == Type.NEGATIVE_INFINITY) {
                return this.createRubyBigDecimal(Type.NEGATIVE_INFINITY);
            }
            if (AddOpNode.isNormal(a)) {
                return a;
            }
            return b;
        }
    }

    @CoreMethod(names={"initialize"}, required=1, optional=1)
    public static abstract class InitializeNode
    extends BigDecimalCoreMethodNode {
        private static final Pattern NUMBER_PATTERN;
        private static final Pattern ZERO_PATTERN;

        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject initialize(RubyBasicObject self, long value, NotProvided digits) {
            BigDecimalNodes.setBigDecimalValue(self, BigDecimalNodes.getBigDecimalValue(value));
            return self;
        }

        @Specialization
        public RubyBasicObject initialize(RubyBasicObject self, double value, NotProvided digits) {
            BigDecimalNodes.setBigDecimalValue(self, BigDecimalNodes.getBigDecimalValue(value));
            return self;
        }

        @Specialization(guards={"isRubyBignum(value)"})
        public RubyBasicObject initializeBignum(RubyBasicObject self, RubyBasicObject value, NotProvided digits) {
            BigDecimalNodes.setBigDecimalValue(self, BigDecimalNodes.getBignumBigDecimalValue(value));
            return self;
        }

        @Specialization(guards={"isRubyBigDecimal(value)"})
        public RubyBasicObject initializeBigDecimal(RubyBasicObject self, RubyBasicObject value, NotProvided digits) {
            BigDecimalNodes.setBigDecimalValue(self, BigDecimalNodes.getBigDecimalValue(value));
            return self;
        }

        @Specialization(guards={"isRubyString(v)"})
        public RubyBasicObject initializeFromString(RubyBasicObject self, RubyBasicObject v, NotProvided digits) {
            return this.initializeFromString(self, v, 0);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(v)"})
        public RubyBasicObject initializeFromString(RubyBasicObject self, RubyBasicObject v, int digits) {
            String strValue;
            switch (strValue = v.toString().trim()) {
                case "NaN": {
                    BigDecimalNodes.setBigDecimalValue(self, Type.NAN);
                    return self;
                }
                case "Infinity": 
                case "+Infinity": {
                    BigDecimalNodes.setBigDecimalValue(self, Type.POSITIVE_INFINITY);
                    return self;
                }
                case "-Infinity": {
                    BigDecimalNodes.setBigDecimalValue(self, Type.NEGATIVE_INFINITY);
                    return self;
                }
                case "-0": {
                    BigDecimalNodes.setBigDecimalValue(self, Type.NEGATIVE_ZERO);
                    return self;
                }
            }
            strValue = strValue.replaceFirst("[dD]", "E");
            strValue = strValue.replaceAll("_", "");
            strValue = NUMBER_PATTERN.matcher(strValue).replaceFirst("$1");
            try {
                BigDecimal value = new BigDecimal(strValue, new MathContext(digits));
                BigDecimalNodes.setBigDecimalValue(self, value);
                if (value.compareTo(BigDecimal.ZERO) == 0 && strValue.startsWith("-")) {
                    BigDecimalNodes.setBigDecimalValue(self, Type.NEGATIVE_ZERO);
                }
            }
            catch (NumberFormatException e) {
                if (ZERO_PATTERN.matcher(strValue).matches()) {
                    BigDecimalNodes.setBigDecimalValue(self, BigDecimal.ZERO);
                }
                throw e;
            }
            return self;
        }

        static {
            String exponent = "([eE][+-]?)?\\d*";
            NUMBER_PATTERN = Pattern.compile("^([+-]?\\d*\\.?\\d*([eE][+-]?)?\\d*).*");
            ZERO_PATTERN = Pattern.compile("^[+-]?0*\\.?0*([eE][+-]?)?\\d*");
        }
    }

    public static abstract class BigDecimalCoreMethodNode
    extends CoreMethodArrayArgumentsNode {
        public BigDecimalCoreMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public static boolean isNormal(RubyBasicObject value) {
            return BigDecimalNodes.getBigDecimalType(value) == Type.NORMAL;
        }

        public static boolean isNormalZero(RubyBasicObject value) {
            return BigDecimalNodes.getBigDecimalValue(value).compareTo(BigDecimal.ZERO) == 0;
        }

        public static boolean isNan(RubyBasicObject value) {
            return BigDecimalNodes.getBigDecimalType(value) == Type.NAN;
        }

        protected RubyBasicObject createRubyBigDecimal(Type type) {
            return BigDecimalNodes.createRubyBigDecimal(this.getContext().getCoreLibrary().getBigDecimalClass(), type);
        }

        protected RubyBasicObject createRubyBigDecimal(BigDecimal value) {
            return BigDecimalNodes.createRubyBigDecimal(this.getContext().getCoreLibrary().getBigDecimalClass(), value);
        }
    }

    public static class RubyBigDecimalAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return BigDecimalNodes.createRubyBigDecimal(rubyClass, BigDecimal.ZERO);
        }
    }

    public static class BigDecimalType
    extends BasicObjectType {
        private BigDecimalType() {
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type NEGATIVE_INFINITY = new Type("-Infinity");
        public static final /* enum */ Type POSITIVE_INFINITY = new Type("Infinity");
        public static final /* enum */ Type NAN = new Type("NaN");
        public static final /* enum */ Type NEGATIVE_ZERO = new Type("-0");
        public static final /* enum */ Type NORMAL = new Type(null);
        private final String representation;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(String representation) {
            this.representation = representation;
        }

        public String getRepresentation() {
            assert (this.representation != null);
            return this.representation;
        }

        static {
            $VALUES = new Type[]{NEGATIVE_INFINITY, POSITIVE_INFINITY, NAN, NEGATIVE_ZERO, NORMAL};
        }
    }
}

