/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class)})
public abstract class ArraySliceNode
extends RubyNode {
    final int from;
    final int to;

    public ArraySliceNode(RubyContext context, SourceSection sourceSection, int from, int to) {
        super(context, sourceSection);
        assert (from >= 0);
        assert (to <= 0);
        this.from = from;
        this.to = to;
    }

    @Specialization(guards={"isNullArray(array)"})
    public RubyBasicObject sliceNull(RubyArray array) {
        CompilerDirectives.transferToInterpreter();
        return this.createEmptyArray();
    }

    @Specialization(guards={"isIntArray(array)"})
    public RubyBasicObject sliceIntegerFixnum(RubyArray array) {
        CompilerDirectives.transferToInterpreter();
        int to = ArrayNodes.getSize(array) + this.to;
        if (this.from >= to) {
            return this.createEmptyArray();
        }
        return this.createArray(ArrayUtils.extractRange((int[])ArrayNodes.getStore(array), this.from, to), to - this.from);
    }

    @Specialization(guards={"isLongArray(array)"})
    public RubyBasicObject sliceLongFixnum(RubyArray array) {
        CompilerDirectives.transferToInterpreter();
        int to = ArrayNodes.getSize(array) + this.to;
        if (this.from >= to) {
            return this.createEmptyArray();
        }
        return this.createArray(ArrayUtils.extractRange((long[])ArrayNodes.getStore(array), this.from, to), to - this.from);
    }

    @Specialization(guards={"isDoubleArray(array)"})
    public RubyBasicObject sliceFloat(RubyArray array) {
        CompilerDirectives.transferToInterpreter();
        int to = ArrayNodes.getSize(array) + this.to;
        if (this.from >= to) {
            return this.createEmptyArray();
        }
        return this.createArray(ArrayUtils.extractRange((double[])ArrayNodes.getStore(array), this.from, to), to - this.from);
    }

    @Specialization(guards={"isObjectArray(array)"})
    public RubyBasicObject sliceObject(RubyArray array) {
        CompilerDirectives.transferToInterpreter();
        int to = ArrayNodes.getSize(array) + this.to;
        if (this.from >= to) {
            return this.createEmptyArray();
        }
        return this.createArray(ArrayUtils.extractRange((Object[])ArrayNodes.getStore(array), this.from, to), to - this.from);
    }
}

