/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import java.util.Arrays;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.util.cli.Options;

public abstract class ArrayBuilderNode
extends Node {
    public static final int ARRAYS_UNINITIALIZED_SIZE = (Integer)Options.TRUFFLE_ARRAYS_UNINITIALIZED_SIZE.load();
    private final RubyContext context;

    public ArrayBuilderNode(RubyContext context) {
        this.context = context;
    }

    public abstract Object start();

    public abstract Object start(int var1);

    public abstract Object ensure(Object var1, int var2);

    public abstract Object append(Object var1, int var2, RubyArray var3);

    public abstract Object append(Object var1, int var2, Object var3);

    public abstract Object finish(Object var1, int var2);

    protected RubyContext getContext() {
        return this.context;
    }

    public static class ObjectArrayBuilderNode
    extends ArrayBuilderNode {
        private final int expectedLength;
        @CompilerDirectives.CompilationFinal
        private boolean hasAppendedObjectArray = false;
        @CompilerDirectives.CompilationFinal
        private boolean hasAppendedIntArray = false;

        public ObjectArrayBuilderNode(RubyContext context, int expectedLength) {
            super(context);
            this.expectedLength = expectedLength;
        }

        @Override
        public Object start() {
            return new Object[this.expectedLength];
        }

        @Override
        public Object start(int length) {
            if (length > this.expectedLength) {
                CompilerDirectives.transferToInterpreter();
                UninitializedArrayBuilderNode newNode = new UninitializedArrayBuilderNode(this.getContext());
                this.replace(newNode);
                return newNode.start(length);
            }
            return new Object[this.expectedLength];
        }

        @Override
        public Object ensure(Object store, int length) {
            if (length > ((Object[])store).length) {
                CompilerDirectives.transferToInterpreter();
                UninitializedArrayBuilderNode newNode = new UninitializedArrayBuilderNode(this.getContext());
                this.replace(newNode);
                newNode.resume((Object[])store);
                return newNode.ensure(store, length);
            }
            return store;
        }

        @Override
        public Object append(Object store, int index, RubyArray array) {
            Object otherStore = ArrayNodes.getStore(array);
            if (otherStore == null) {
                return store;
            }
            if (this.hasAppendedObjectArray && otherStore instanceof Object[]) {
                System.arraycopy(otherStore, 0, store, index, ArrayNodes.getSize(array));
                return store;
            }
            if (this.hasAppendedIntArray && otherStore instanceof int[]) {
                Object[] objectStore = (Object[])store;
                int[] otherIntStore = (int[])otherStore;
                for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    objectStore[index + n] = otherIntStore[n];
                }
                return store;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            if (otherStore instanceof int[]) {
                this.hasAppendedIntArray = true;
                for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    ((Object[])store)[index + n] = ((int[])otherStore)[n];
                }
                return store;
            }
            if (otherStore instanceof long[]) {
                for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    ((Object[])store)[index + n] = ((long[])otherStore)[n];
                }
                return store;
            }
            if (otherStore instanceof double[]) {
                for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    ((Object[])store)[index + n] = ((double[])otherStore)[n];
                }
                return store;
            }
            if (otherStore instanceof Object[]) {
                this.hasAppendedObjectArray = true;
                System.arraycopy(otherStore, 0, store, index, ArrayNodes.getSize(array));
                return store;
            }
            throw new UnsupportedOperationException(ArrayNodes.getStore(array).getClass().getName());
        }

        @Override
        public Object append(Object store, int index, Object value) {
            if (index >= ((Object[])store).length) {
                new Exception().printStackTrace();
            }
            ((Object[])store)[index] = value;
            return store;
        }

        @Override
        public Object finish(Object store, int length) {
            return store;
        }
    }

    public static class DoubleArrayBuilderNode
    extends ArrayBuilderNode {
        private final int expectedLength;

        public DoubleArrayBuilderNode(RubyContext context, int expectedLength) {
            super(context);
            this.expectedLength = expectedLength;
        }

        @Override
        public Object start() {
            return new double[this.expectedLength];
        }

        @Override
        public Object start(int length) {
            if (length > this.expectedLength) {
                CompilerDirectives.transferToInterpreter();
                UninitializedArrayBuilderNode newNode = new UninitializedArrayBuilderNode(this.getContext());
                this.replace(newNode);
                return newNode.start(length);
            }
            return new double[this.expectedLength];
        }

        @Override
        public Object ensure(Object store, int length) {
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException();
        }

        @Override
        public Object append(Object store, int index, RubyArray array) {
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException();
        }

        @Override
        public Object append(Object store, int index, Object value) {
            if (store instanceof double[] && value instanceof Double) {
                ((double[])store)[index] = (Double)value;
                return store;
            }
            CompilerDirectives.transferToInterpreter();
            this.replace(new ObjectArrayBuilderNode(this.getContext(), this.expectedLength));
            Object[] newStore = ArrayUtils.box((double[])store);
            newStore[index] = value;
            return newStore;
        }

        @Override
        public Object finish(Object store, int length) {
            return store;
        }
    }

    public static class LongArrayBuilderNode
    extends ArrayBuilderNode {
        private final int expectedLength;

        public LongArrayBuilderNode(RubyContext context, int expectedLength) {
            super(context);
            this.expectedLength = expectedLength;
        }

        @Override
        public Object start() {
            return new long[this.expectedLength];
        }

        @Override
        public Object start(int length) {
            if (length > this.expectedLength) {
                CompilerDirectives.transferToInterpreter();
                UninitializedArrayBuilderNode newNode = new UninitializedArrayBuilderNode(this.getContext());
                this.replace(newNode);
                return newNode.start(length);
            }
            return new long[this.expectedLength];
        }

        @Override
        public Object ensure(Object store, int length) {
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException();
        }

        @Override
        public Object append(Object store, int index, RubyArray array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object append(Object store, int index, Object value) {
            if (store instanceof long[] && value instanceof Long) {
                ((long[])store)[index] = (Long)value;
                return store;
            }
            if (value instanceof Integer) {
                ((long[])store)[index] = ((Integer)value).intValue();
                return store;
            }
            CompilerDirectives.transferToInterpreter();
            this.replace(new ObjectArrayBuilderNode(this.getContext(), this.expectedLength));
            Object[] newStore = ArrayUtils.box((long[])store);
            newStore[index] = value;
            return newStore;
        }

        @Override
        public Object finish(Object store, int length) {
            return store;
        }
    }

    public static class IntegerArrayBuilderNode
    extends ArrayBuilderNode {
        private final int expectedLength;
        @CompilerDirectives.CompilationFinal
        private boolean hasAppendedIntegerArray = false;

        public IntegerArrayBuilderNode(RubyContext context, int expectedLength) {
            super(context);
            this.expectedLength = expectedLength;
        }

        @Override
        public Object start() {
            return new int[this.expectedLength];
        }

        @Override
        public Object start(int length) {
            if (length > this.expectedLength) {
                CompilerDirectives.transferToInterpreter();
                UninitializedArrayBuilderNode newNode = new UninitializedArrayBuilderNode(this.getContext());
                this.replace(newNode);
                return newNode.start(length);
            }
            return new int[this.expectedLength];
        }

        @Override
        public Object ensure(Object store, int length) {
            if (length > ((int[])store).length) {
                CompilerDirectives.transferToInterpreter();
                Object[] newStore = ArrayUtils.box((int[])store);
                UninitializedArrayBuilderNode newNode = new UninitializedArrayBuilderNode(this.getContext());
                this.replace(newNode);
                newNode.resume(newStore);
                return newNode.ensure(newStore, length);
            }
            return store;
        }

        @Override
        public Object append(Object store, int index, RubyArray array) {
            Object otherStore = ArrayNodes.getStore(array);
            if (otherStore == null) {
                return store;
            }
            if (this.hasAppendedIntegerArray && otherStore instanceof int[]) {
                System.arraycopy(otherStore, 0, store, index, ArrayNodes.getSize(array));
                return store;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            if (otherStore instanceof int[]) {
                this.hasAppendedIntegerArray = true;
                System.arraycopy(otherStore, 0, store, index, ArrayNodes.getSize(array));
                return store;
            }
            CompilerDirectives.transferToInterpreter();
            this.replace(new ObjectArrayBuilderNode(this.getContext(), this.expectedLength));
            Object[] newStore = ArrayUtils.box((int[])store);
            System.arraycopy(otherStore, 0, newStore, index, ArrayNodes.getSize(array));
            return newStore;
        }

        @Override
        public Object append(Object store, int index, Object value) {
            Object[] newStore;
            if (store instanceof int[] && value instanceof Integer) {
                ((int[])store)[index] = (Integer)value;
                return store;
            }
            CompilerDirectives.transferToInterpreter();
            this.replace(new ObjectArrayBuilderNode(this.getContext(), this.expectedLength));
            if (store instanceof int[]) {
                newStore = ArrayUtils.box((int[])store);
            } else if (store instanceof Object[]) {
                newStore = (Object[])store;
            } else {
                throw new UnsupportedOperationException();
            }
            newStore[index] = value;
            return newStore;
        }

        @Override
        public Object finish(Object store, int length) {
            return store;
        }
    }

    public static class UninitializedArrayBuilderNode
    extends ArrayBuilderNode {
        private boolean couldUseInteger = true;
        private boolean couldUseLong = true;
        private boolean couldUseDouble = true;

        public UninitializedArrayBuilderNode(RubyContext context) {
            super(context);
        }

        public void resume(Object[] store) {
            for (Object value : store) {
                this.screen(value);
            }
        }

        @Override
        public Object start() {
            CompilerDirectives.transferToInterpreter();
            return new Object[ARRAYS_UNINITIALIZED_SIZE];
        }

        @Override
        public Object start(int length) {
            CompilerDirectives.transferToInterpreter();
            return new Object[length];
        }

        @Override
        public Object ensure(Object store, int length) {
            return store;
        }

        @Override
        public Object append(Object store, int index, RubyArray array) {
            CompilerDirectives.transferToInterpreter();
            for (Object value : ArrayNodes.slowToArray(array)) {
                store = this.append(store, index, value);
                ++index;
            }
            return store;
        }

        @Override
        public Object append(Object store, int index, Object value) {
            CompilerDirectives.transferToInterpreter();
            this.screen(value);
            Object[] storeArray = (Object[])store;
            if (index >= storeArray.length) {
                storeArray = Arrays.copyOf(storeArray, ArrayUtils.capacity(storeArray.length, index + 1));
            }
            storeArray[index] = value;
            return storeArray;
        }

        @Override
        public Object finish(Object store, int length) {
            if (this.couldUseInteger) {
                this.replace(new IntegerArrayBuilderNode(this.getContext(), length));
                return ArrayUtils.unboxInteger((Object[])store, length);
            }
            if (this.couldUseLong) {
                this.replace(new LongArrayBuilderNode(this.getContext(), length));
                return ArrayUtils.unboxLong((Object[])store, length);
            }
            if (this.couldUseDouble) {
                this.replace(new DoubleArrayBuilderNode(this.getContext(), length));
                return ArrayUtils.unboxDouble((Object[])store, length);
            }
            this.replace(new ObjectArrayBuilderNode(this.getContext(), length));
            return store;
        }

        private void screen(Object value) {
            if (value instanceof Integer) {
                this.couldUseDouble = false;
            } else if (value instanceof Long) {
                this.couldUseInteger = false;
                this.couldUseDouble = false;
            } else if (value instanceof Double) {
                this.couldUseInteger = false;
                this.couldUseLong = false;
            } else {
                this.couldUseInteger = false;
                this.couldUseLong = false;
                this.couldUseDouble = false;
            }
        }
    }
}

