/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.SymbolNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubySymbol;

@GeneratedBy(value=SymbolNodes.class)
public final class SymbolNodesFactory {
    public static List<NodeFactory<? extends CoreMethodArrayArgumentsNode>> getFactories() {
        return Arrays.asList(EqualNodeFactory.getInstance(), CompareNodeFactory.getInstance(), AllSymbolsNodeFactory.getInstance(), CapitalizeNodeFactory.getInstance(), CaseCompareNodeFactory.getInstance(), DowncaseNodeFactory.getInstance(), EmptyNodeFactory.getInstance(), EncodingNodeFactory.getInstance(), HashNodeFactory.getInstance(), InternNodeFactory.getInstance(), ToProcNodeFactory.getInstance(), ToSymNodeFactory.getInstance(), ToSNodeFactory.getInstance(), InspectNodeFactory.getInstance(), SizeNodeFactory.getInstance(), SwapcaseNodeFactory.getInstance(), UpcaseNodeFactory.getInstance());
    }

    @GeneratedBy(value=SymbolNodes.UpcaseNode.class)
    public static final class UpcaseNodeFactory
    extends NodeFactoryBase<SymbolNodes.UpcaseNode> {
        private static UpcaseNodeFactory upcaseNodeFactoryInstance;

        private UpcaseNodeFactory() {
            super(SymbolNodes.UpcaseNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.UpcaseNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UpcaseNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SymbolNodes.UpcaseNode> getInstance() {
            if (upcaseNodeFactoryInstance == null) {
                upcaseNodeFactoryInstance = new UpcaseNodeFactory();
            }
            return upcaseNodeFactoryInstance;
        }

        public static SymbolNodes.UpcaseNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new UpcaseNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=SymbolNodes.UpcaseNode.class)
        public static final class UpcaseNodeGen
        extends SymbolNodes.UpcaseNode {
            @Node.Child
            private RubyNode arguments0_;

            private UpcaseNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments0Value_;
                try {
                    arguments0Value_ = UpcaseNodeGen.expectRubySymbol(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.upcase(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }

            private static RubySymbol expectRubySymbol(Object value) throws UnexpectedResultException {
                if (value instanceof RubySymbol) {
                    return (RubySymbol)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.SwapcaseNode.class)
    public static final class SwapcaseNodeFactory
    extends NodeFactoryBase<SymbolNodes.SwapcaseNode> {
        private static SwapcaseNodeFactory swapcaseNodeFactoryInstance;

        private SwapcaseNodeFactory() {
            super(SymbolNodes.SwapcaseNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.SwapcaseNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SwapcaseNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SymbolNodes.SwapcaseNode> getInstance() {
            if (swapcaseNodeFactoryInstance == null) {
                swapcaseNodeFactoryInstance = new SwapcaseNodeFactory();
            }
            return swapcaseNodeFactoryInstance;
        }

        public static SymbolNodes.SwapcaseNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SwapcaseNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=SymbolNodes.SwapcaseNode.class)
        public static final class SwapcaseNodeGen
        extends SymbolNodes.SwapcaseNode {
            @Node.Child
            private RubyNode arguments0_;

            private SwapcaseNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments0Value_;
                try {
                    arguments0Value_ = SwapcaseNodeGen.expectRubySymbol(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.swapcase(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }

            private static RubySymbol expectRubySymbol(Object value) throws UnexpectedResultException {
                if (value instanceof RubySymbol) {
                    return (RubySymbol)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<SymbolNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(SymbolNodes.SizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.SizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SymbolNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        public static SymbolNodes.SizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SizeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=SymbolNodes.SizeNode.class)
        public static final class SizeNodeGen
        extends SymbolNodes.SizeNode {
            @Node.Child
            private RubyNode arguments0_;

            private SizeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                RubySymbol arguments0Value_;
                try {
                    arguments0Value_ = SizeNodeGen.expectRubySymbol(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.size(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }

            private static RubySymbol expectRubySymbol(Object value) throws UnexpectedResultException {
                if (value instanceof RubySymbol) {
                    return (RubySymbol)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.InspectNode.class)
    public static final class InspectNodeFactory
    extends NodeFactoryBase<SymbolNodes.InspectNode> {
        private static InspectNodeFactory inspectNodeFactoryInstance;

        private InspectNodeFactory() {
            super(SymbolNodes.InspectNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.InspectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InspectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SymbolNodes.InspectNode> getInstance() {
            if (inspectNodeFactoryInstance == null) {
                inspectNodeFactoryInstance = new InspectNodeFactory();
            }
            return inspectNodeFactoryInstance;
        }

        public static SymbolNodes.InspectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InspectNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=SymbolNodes.InspectNode.class)
        public static final class InspectNodeGen
        extends SymbolNodes.InspectNode {
            @Node.Child
            private RubyNode arguments0_;

            private InspectNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments0Value_;
                try {
                    arguments0Value_ = InspectNodeGen.expectRubySymbol(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.inspect(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }

            private static RubySymbol expectRubySymbol(Object value) throws UnexpectedResultException {
                if (value instanceof RubySymbol) {
                    return (RubySymbol)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<SymbolNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(SymbolNodes.ToSNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.ToSNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SymbolNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        public static SymbolNodes.ToSNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ToSNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=SymbolNodes.ToSNode.class)
        public static final class ToSNodeGen
        extends SymbolNodes.ToSNode {
            @Node.Child
            private RubyNode arguments0_;

            private ToSNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments0Value_;
                try {
                    arguments0Value_ = ToSNodeGen.expectRubySymbol(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.toS(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }

            private static RubySymbol expectRubySymbol(Object value) throws UnexpectedResultException {
                if (value instanceof RubySymbol) {
                    return (RubySymbol)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.ToSymNode.class)
    public static final class ToSymNodeFactory
    extends NodeFactoryBase<SymbolNodes.ToSymNode> {
        private static ToSymNodeFactory toSymNodeFactoryInstance;

        private ToSymNodeFactory() {
            super(SymbolNodes.ToSymNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.ToSymNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSymNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SymbolNodes.ToSymNode> getInstance() {
            if (toSymNodeFactoryInstance == null) {
                toSymNodeFactoryInstance = new ToSymNodeFactory();
            }
            return toSymNodeFactoryInstance;
        }

        public static SymbolNodes.ToSymNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ToSymNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=SymbolNodes.ToSymNode.class)
        public static final class ToSymNodeGen
        extends SymbolNodes.ToSymNode {
            @Node.Child
            private RubyNode arguments0_;

            private ToSymNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments0Value_;
                try {
                    arguments0Value_ = ToSymNodeGen.expectRubySymbol(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.toSym(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }

            private static RubySymbol expectRubySymbol(Object value) throws UnexpectedResultException {
                if (value instanceof RubySymbol) {
                    return (RubySymbol)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.ToProcNode.class)
    public static final class ToProcNodeFactory
    extends NodeFactoryBase<SymbolNodes.ToProcNode> {
        private static ToProcNodeFactory toProcNodeFactoryInstance;

        private ToProcNodeFactory() {
            super(SymbolNodes.ToProcNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.ToProcNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToProcNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SymbolNodes.ToProcNode> getInstance() {
            if (toProcNodeFactoryInstance == null) {
                toProcNodeFactoryInstance = new ToProcNodeFactory();
            }
            return toProcNodeFactoryInstance;
        }

        public static SymbolNodes.ToProcNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ToProcNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=SymbolNodes.ToProcNode.class)
        public static final class ToProcNodeGen
        extends SymbolNodes.ToProcNode {
            @Node.Child
            private RubyNode arguments0_;

            private ToProcNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments0Value_;
                try {
                    arguments0Value_ = ToProcNodeGen.expectRubySymbol(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.toProc(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }

            private static RubySymbol expectRubySymbol(Object value) throws UnexpectedResultException {
                if (value instanceof RubySymbol) {
                    return (RubySymbol)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.InternNode.class)
    public static final class InternNodeFactory
    extends NodeFactoryBase<SymbolNodes.InternNode> {
        private static InternNodeFactory internNodeFactoryInstance;

        private InternNodeFactory() {
            super(SymbolNodes.InternNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.InternNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InternNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SymbolNodes.InternNode> getInstance() {
            if (internNodeFactoryInstance == null) {
                internNodeFactoryInstance = new InternNodeFactory();
            }
            return internNodeFactoryInstance;
        }

        public static SymbolNodes.InternNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InternNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=SymbolNodes.InternNode.class)
        public static final class InternNodeGen
        extends SymbolNodes.InternNode {
            @Node.Child
            private RubyNode arguments0_;

            private InternNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments0Value_;
                try {
                    arguments0Value_ = InternNodeGen.expectRubySymbol(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.intern(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }

            private static RubySymbol expectRubySymbol(Object value) throws UnexpectedResultException {
                if (value instanceof RubySymbol) {
                    return (RubySymbol)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.HashNode.class)
    public static final class HashNodeFactory
    extends NodeFactoryBase<SymbolNodes.HashNode> {
        private static HashNodeFactory hashNodeFactoryInstance;

        private HashNodeFactory() {
            super(SymbolNodes.HashNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.HashNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return HashNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SymbolNodes.HashNode> getInstance() {
            if (hashNodeFactoryInstance == null) {
                hashNodeFactoryInstance = new HashNodeFactory();
            }
            return hashNodeFactoryInstance;
        }

        public static SymbolNodes.HashNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new HashNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=SymbolNodes.HashNode.class)
        public static final class HashNodeGen
        extends SymbolNodes.HashNode {
            @Node.Child
            private RubyNode arguments0_;

            private HashNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                RubySymbol arguments0Value_;
                try {
                    arguments0Value_ = HashNodeGen.expectRubySymbol(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.hash(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }

            private static RubySymbol expectRubySymbol(Object value) throws UnexpectedResultException {
                if (value instanceof RubySymbol) {
                    return (RubySymbol)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.EncodingNode.class)
    public static final class EncodingNodeFactory
    extends NodeFactoryBase<SymbolNodes.EncodingNode> {
        private static EncodingNodeFactory encodingNodeFactoryInstance;

        private EncodingNodeFactory() {
            super(SymbolNodes.EncodingNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.EncodingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EncodingNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SymbolNodes.EncodingNode> getInstance() {
            if (encodingNodeFactoryInstance == null) {
                encodingNodeFactoryInstance = new EncodingNodeFactory();
            }
            return encodingNodeFactoryInstance;
        }

        public static SymbolNodes.EncodingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EncodingNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=SymbolNodes.EncodingNode.class)
        public static final class EncodingNodeGen
        extends SymbolNodes.EncodingNode {
            @Node.Child
            private RubyNode arguments0_;

            private EncodingNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments0Value_;
                try {
                    arguments0Value_ = EncodingNodeGen.expectRubySymbol(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.encoding(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }

            private static RubySymbol expectRubySymbol(Object value) throws UnexpectedResultException {
                if (value instanceof RubySymbol) {
                    return (RubySymbol)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.EmptyNode.class)
    public static final class EmptyNodeFactory
    extends NodeFactoryBase<SymbolNodes.EmptyNode> {
        private static EmptyNodeFactory emptyNodeFactoryInstance;

        private EmptyNodeFactory() {
            super(SymbolNodes.EmptyNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.EmptyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EmptyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SymbolNodes.EmptyNode> getInstance() {
            if (emptyNodeFactoryInstance == null) {
                emptyNodeFactoryInstance = new EmptyNodeFactory();
            }
            return emptyNodeFactoryInstance;
        }

        public static SymbolNodes.EmptyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EmptyNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=SymbolNodes.EmptyNode.class)
        public static final class EmptyNodeGen
        extends SymbolNodes.EmptyNode {
            @Node.Child
            private RubyNode arguments0_;

            private EmptyNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                RubySymbol arguments0Value_;
                try {
                    arguments0Value_ = EmptyNodeGen.expectRubySymbol(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.empty(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }

            private static RubySymbol expectRubySymbol(Object value) throws UnexpectedResultException {
                if (value instanceof RubySymbol) {
                    return (RubySymbol)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.DowncaseNode.class)
    public static final class DowncaseNodeFactory
    extends NodeFactoryBase<SymbolNodes.DowncaseNode> {
        private static DowncaseNodeFactory downcaseNodeFactoryInstance;

        private DowncaseNodeFactory() {
            super(SymbolNodes.DowncaseNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.DowncaseNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DowncaseNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SymbolNodes.DowncaseNode> getInstance() {
            if (downcaseNodeFactoryInstance == null) {
                downcaseNodeFactoryInstance = new DowncaseNodeFactory();
            }
            return downcaseNodeFactoryInstance;
        }

        public static SymbolNodes.DowncaseNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DowncaseNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=SymbolNodes.DowncaseNode.class)
        public static final class DowncaseNodeGen
        extends SymbolNodes.DowncaseNode {
            @Node.Child
            private RubyNode arguments0_;

            private DowncaseNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments0Value_;
                try {
                    arguments0Value_ = DowncaseNodeGen.expectRubySymbol(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.downcase(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }

            private static RubySymbol expectRubySymbol(Object value) throws UnexpectedResultException {
                if (value instanceof RubySymbol) {
                    return (RubySymbol)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.CaseCompareNode.class)
    public static final class CaseCompareNodeFactory
    extends NodeFactoryBase<SymbolNodes.CaseCompareNode> {
        private static CaseCompareNodeFactory caseCompareNodeFactoryInstance;

        private CaseCompareNodeFactory() {
            super(SymbolNodes.CaseCompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.CaseCompareNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CaseCompareNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SymbolNodes.CaseCompareNode> getInstance() {
            if (caseCompareNodeFactoryInstance == null) {
                caseCompareNodeFactoryInstance = new CaseCompareNodeFactory();
            }
            return caseCompareNodeFactoryInstance;
        }

        public static SymbolNodes.CaseCompareNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CaseCompareNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=SymbolNodes.CaseCompareNode.class)
        public static final class CaseCompareNodeGen
        extends SymbolNodes.CaseCompareNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private CaseCompareNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static RubySymbol expectRubySymbol(Object value) throws UnexpectedResultException {
                if (value instanceof RubySymbol) {
                    return (RubySymbol)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="caseCompare(RubySymbol, Object)", value=SymbolNodes.CaseCompareNode.class)
            private static final class CaseCompare1Node_
            extends BaseNode_ {
                CaseCompare1Node_(CaseCompareNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubySymbol) {
                        RubySymbol arguments0Value_ = (RubySymbol)arguments0Value;
                        if (!RubyGuards.isRubySymbol(arguments1Value)) {
                            return this.root.caseCompare(arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CaseCompareNodeGen root) {
                    return new CaseCompare1Node_(root);
                }
            }

            @GeneratedBy(methodName="caseCompare(RubySymbol, RubySymbol)", value=SymbolNodes.CaseCompareNode.class)
            private static final class CaseCompare0Node_
            extends BaseNode_ {
                CaseCompare0Node_(CaseCompareNodeGen root) {
                    super(root, 1);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubySymbol arguments1Value_;
                    RubySymbol arguments0Value_;
                    try {
                        arguments0Value_ = CaseCompareNodeGen.expectRubySymbol(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return CaseCompareNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = CaseCompareNodeGen.expectRubySymbol(this.root.arguments1_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return CaseCompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.caseCompare(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubySymbol && arguments1Value instanceof RubySymbol) {
                        RubySymbol arguments0Value_ = (RubySymbol)arguments0Value;
                        RubySymbol arguments1Value_ = (RubySymbol)arguments1Value;
                        return this.root.caseCompare(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CaseCompareNodeGen root) {
                    return new CaseCompare0Node_(root);
                }
            }

            @GeneratedBy(value=SymbolNodes.CaseCompareNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CaseCompareNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CaseCompareNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=SymbolNodes.CaseCompareNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CaseCompareNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CaseCompareNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=SymbolNodes.CaseCompareNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final CaseCompareNodeGen root;

                BaseNode_(CaseCompareNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return CaseCompareNodeGen.expectInteger(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubySymbol) {
                        if (arguments1Value instanceof RubySymbol) {
                            return CaseCompare0Node_.create(this.root);
                        }
                        if (!RubyGuards.isRubySymbol(arguments1Value)) {
                            return CaseCompare1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.CapitalizeNode.class)
    public static final class CapitalizeNodeFactory
    extends NodeFactoryBase<SymbolNodes.CapitalizeNode> {
        private static CapitalizeNodeFactory capitalizeNodeFactoryInstance;

        private CapitalizeNodeFactory() {
            super(SymbolNodes.CapitalizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.CapitalizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CapitalizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SymbolNodes.CapitalizeNode> getInstance() {
            if (capitalizeNodeFactoryInstance == null) {
                capitalizeNodeFactoryInstance = new CapitalizeNodeFactory();
            }
            return capitalizeNodeFactoryInstance;
        }

        public static SymbolNodes.CapitalizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CapitalizeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=SymbolNodes.CapitalizeNode.class)
        public static final class CapitalizeNodeGen
        extends SymbolNodes.CapitalizeNode {
            @Node.Child
            private RubyNode arguments0_;

            private CapitalizeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments0Value_;
                try {
                    arguments0Value_ = CapitalizeNodeGen.expectRubySymbol(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.capitalize(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }

            private static RubySymbol expectRubySymbol(Object value) throws UnexpectedResultException {
                if (value instanceof RubySymbol) {
                    return (RubySymbol)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.AllSymbolsNode.class)
    public static final class AllSymbolsNodeFactory
    extends NodeFactoryBase<SymbolNodes.AllSymbolsNode> {
        private static AllSymbolsNodeFactory allSymbolsNodeFactoryInstance;

        private AllSymbolsNodeFactory() {
            super(SymbolNodes.AllSymbolsNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.AllSymbolsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AllSymbolsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SymbolNodes.AllSymbolsNode> getInstance() {
            if (allSymbolsNodeFactoryInstance == null) {
                allSymbolsNodeFactoryInstance = new AllSymbolsNodeFactory();
            }
            return allSymbolsNodeFactoryInstance;
        }

        public static SymbolNodes.AllSymbolsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AllSymbolsNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=SymbolNodes.AllSymbolsNode.class)
        public static final class AllSymbolsNodeGen
        extends SymbolNodes.AllSymbolsNode {
            private AllSymbolsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.allSymbols();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported() {
                return new UnsupportedSpecializationException((Node)this, new Node[0], new Object[0]);
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.CompareNode.class)
    public static final class CompareNodeFactory
    extends NodeFactoryBase<SymbolNodes.CompareNode> {
        private static CompareNodeFactory compareNodeFactoryInstance;

        private CompareNodeFactory() {
            super(SymbolNodes.CompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.CompareNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompareNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SymbolNodes.CompareNode> getInstance() {
            if (compareNodeFactoryInstance == null) {
                compareNodeFactoryInstance = new CompareNodeFactory();
            }
            return compareNodeFactoryInstance;
        }

        public static SymbolNodes.CompareNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CompareNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=SymbolNodes.CompareNode.class)
        public static final class CompareNodeGen
        extends SymbolNodes.CompareNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private CompareNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static RubySymbol expectRubySymbol(Object value) throws UnexpectedResultException {
                if (value instanceof RubySymbol) {
                    return (RubySymbol)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="compare(RubySymbol, Object)", value=SymbolNodes.CompareNode.class)
            private static final class Compare1Node_
            extends BaseNode_ {
                Compare1Node_(CompareNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubySymbol) {
                        RubySymbol arguments0Value_ = (RubySymbol)arguments0Value;
                        if (!RubyGuards.isRubySymbol(arguments1Value)) {
                            return this.root.compare(arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new Compare1Node_(root);
                }
            }

            @GeneratedBy(methodName="compare(RubySymbol, RubySymbol)", value=SymbolNodes.CompareNode.class)
            private static final class Compare0Node_
            extends BaseNode_ {
                Compare0Node_(CompareNodeGen root) {
                    super(root, 1);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubySymbol arguments1Value_;
                    RubySymbol arguments0Value_;
                    try {
                        arguments0Value_ = CompareNodeGen.expectRubySymbol(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = CompareNodeGen.expectRubySymbol(this.root.arguments1_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.compare(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubySymbol && arguments1Value instanceof RubySymbol) {
                        RubySymbol arguments0Value_ = (RubySymbol)arguments0Value;
                        RubySymbol arguments1Value_ = (RubySymbol)arguments1Value;
                        return this.root.compare(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new Compare0Node_(root);
                }
            }

            @GeneratedBy(value=SymbolNodes.CompareNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CompareNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=SymbolNodes.CompareNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CompareNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=SymbolNodes.CompareNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final CompareNodeGen root;

                BaseNode_(CompareNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return CompareNodeGen.expectInteger(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubySymbol) {
                        if (arguments1Value instanceof RubySymbol) {
                            return Compare0Node_.create(this.root);
                        }
                        if (!RubyGuards.isRubySymbol(arguments1Value)) {
                            return Compare1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.EqualNode.class)
    public static final class EqualNodeFactory
    extends NodeFactoryBase<SymbolNodes.EqualNode> {
        private static EqualNodeFactory equalNodeFactoryInstance;

        private EqualNodeFactory() {
            super(SymbolNodes.EqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.EqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SymbolNodes.EqualNode> getInstance() {
            if (equalNodeFactoryInstance == null) {
                equalNodeFactoryInstance = new EqualNodeFactory();
            }
            return equalNodeFactoryInstance;
        }

        public static SymbolNodes.EqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EqualNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=SymbolNodes.EqualNode.class)
        public static final class EqualNodeGen
        extends SymbolNodes.EqualNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private EqualNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static RubySymbol expectRubySymbol(Object value) throws UnexpectedResultException {
                if (value instanceof RubySymbol) {
                    return (RubySymbol)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="equal(RubySymbol, Object)", value=SymbolNodes.EqualNode.class)
            private static final class Equal1Node_
            extends BaseNode_ {
                Equal1Node_(EqualNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    RubySymbol arguments0Value_;
                    try {
                        arguments0Value_ = EqualNodeGen.expectRubySymbol(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    if (!RubyGuards.isRubySymbol(arguments1Value_)) {
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubySymbol) {
                        RubySymbol arguments0Value_ = (RubySymbol)arguments0Value;
                        if (!RubyGuards.isRubySymbol(arguments1Value)) {
                            return this.root.equal(arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new Equal1Node_(root);
                }
            }

            @GeneratedBy(methodName="equal(RubySymbol, RubySymbol)", value=SymbolNodes.EqualNode.class)
            private static final class Equal0Node_
            extends BaseNode_ {
                Equal0Node_(EqualNodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    RubySymbol arguments1Value_;
                    RubySymbol arguments0Value_;
                    try {
                        arguments0Value_ = EqualNodeGen.expectRubySymbol(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = EqualNodeGen.expectRubySymbol(this.root.arguments1_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.equal(arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubySymbol && arguments1Value instanceof RubySymbol) {
                        RubySymbol arguments0Value_ = (RubySymbol)arguments0Value;
                        RubySymbol arguments1Value_ = (RubySymbol)arguments1Value;
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new Equal0Node_(root);
                }
            }

            @GeneratedBy(value=SymbolNodes.EqualNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EqualNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=SymbolNodes.EqualNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EqualNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=SymbolNodes.EqualNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final EqualNodeGen root;

                BaseNode_(EqualNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubySymbol) {
                        if (arguments1Value instanceof RubySymbol) {
                            return Equal0Node_.create(this.root);
                        }
                        if (!RubyGuards.isRubySymbol(arguments1Value)) {
                            return Equal1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }
}

