/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import java.math.BigInteger;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.FixnumOrBignumNode;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.NextException;
import org.jruby.truffle.runtime.control.RedoException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyProc;

@CoreClass(name="Integer")
public abstract class IntegerNodes {

    @CoreMethod(names={"upto"}, needsBlock=true, required=1, returnsEnumeratorIfNoBlock=true, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class UpToNode
    extends YieldingCoreMethodNode {
        private final BranchProfile nextProfile = BranchProfile.create();
        private final BranchProfile redoProfile = BranchProfile.create();

        public UpToNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public Object upto(VirtualFrame frame, int from, int to, RubyProc block) {
            int count = 0;
            try {
                block6: for (int i = from; i <= to; ++i) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, i);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return this.nil();
        }

        @Specialization
        public Object upto(VirtualFrame frame, int from, double to, RubyProc block) {
            return this.upto(frame, from, (int)Math.floor(to), block);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public Object upto(VirtualFrame frame, long from, long to, RubyProc block) {
            int count = 0;
            try {
                block6: for (long i = from; i <= to; ++i) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, i);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"to_i", "to_int"})
    public static abstract class ToINode
    extends CoreMethodArrayArgumentsNode {
        public ToINode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int toI(int n) {
            return n;
        }

        @Specialization
        public long toI(long n) {
            return n;
        }

        @Specialization(guards={"isRubyBignum(n)"})
        public RubyBasicObject toI(RubyBasicObject n) {
            return n;
        }
    }

    @CoreMethod(names={"times"}, needsBlock=true)
    public static abstract class TimesNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;
        private final BranchProfile nextProfile = BranchProfile.create();
        private final BranchProfile redoProfile = BranchProfile.create();

        public TimesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject times(VirtualFrame frame, int n, NotProvided block) {
            int[] array = new int[n];
            for (int i = 0; i < n; ++i) {
                array[i] = i;
            }
            return this.createArray(array, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public Object times(VirtualFrame frame, int n, RubyProc block) {
            int count = 0;
            try {
                block6: for (int i = 0; i < n; ++i) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, i);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public Object times(VirtualFrame frame, long n, RubyProc block) {
            int count = 0;
            try {
                block6: for (long i = 0L; i < n; ++i) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, i);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return n;
        }

        @Specialization(guards={"isRubyBignum(n)"})
        public Object times(VirtualFrame frame, RubyBasicObject n, RubyProc block) {
            if (this.fixnumOrBignum == null) {
                CompilerDirectives.transferToInterpreter();
                this.fixnumOrBignum = (FixnumOrBignumNode)this.insert(new FixnumOrBignumNode(this.getContext(), this.getSourceSection()));
            }
            BigInteger i = BigInteger.ZERO;
            while (i.compareTo(BignumNodes.getBigIntegerValue(n)) < 0) {
                while (true) {
                    try {
                        this.yield(frame, block, this.fixnumOrBignum.fixnumOrBignum(i));
                    }
                    catch (NextException e) {
                        this.nextProfile.enter();
                    }
                    catch (RedoException e) {
                        this.redoProfile.enter();
                        continue;
                    }
                    break;
                }
                i = i.add(BigInteger.ONE);
            }
            return n;
        }
    }

    @CoreMethod(names={"downto"}, needsBlock=true, required=1, returnsEnumeratorIfNoBlock=true, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class DownToNode
    extends YieldingCoreMethodNode {
        private final BranchProfile nextProfile = BranchProfile.create();
        private final BranchProfile redoProfile = BranchProfile.create();

        public DownToNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public Object downto(VirtualFrame frame, int from, int to, RubyProc block) {
            int count = 0;
            try {
                block6: for (int i = from; i >= to; --i) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, i);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return this.nil();
        }

        @Specialization
        public Object downto(VirtualFrame frame, long from, int to, RubyProc block) {
            return this.downto(frame, from, (long)to, block);
        }

        @Specialization
        public Object downto(VirtualFrame frame, int from, long to, RubyProc block) {
            return this.downto(frame, (long)from, to, block);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public Object downto(VirtualFrame frame, long from, long to, RubyProc block) {
            int count = 0;
            try {
                block6: for (long i = from; i >= to; --i) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, i);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return this.nil();
        }

        @Specialization
        public Object downto(VirtualFrame frame, int from, double to, RubyProc block) {
            return this.downto(frame, from, (int)Math.ceil(to), block);
        }
    }
}

