/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callsite;

import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

public class SuperCallSite
extends CallSite {
    protected volatile SuperTuple cache = SuperTuple.NULL_CACHE;

    public SuperCallSite() {
        super("super", CallType.SUPER);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, long fixnum) {
        return this.call(context, caller2, self2, (IRubyObject)RubyFixnum.newFixnum(context.runtime, fixnum));
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, double flote) {
        return this.call(context, caller2, self2, (IRubyObject)RubyFloat.newFloat(context.runtime, flote));
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject ... args2) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        return this.call(context, caller2, self2, klazz, name2, args2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyModule klazz, String name2, IRubyObject ... args2) {
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, this.cache.cache.sourceModule, name2, args2);
        }
        return this.cacheAndCall(caller2, selfType, args2, context, self2, name2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject[] args2, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        return this.call(context, caller2, self2, klazz, name2, args2, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyModule klazz, String name2, IRubyObject[] args2, Block block) {
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, this.cache.cache.sourceModule, name2, args2, block);
        }
        return this.cacheAndCall(caller2, selfType, block, args2, context, self2, name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject[] args2, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller2, self2, args2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyModule klazz, String name2, IRubyObject[] args2, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller2, self2, klazz, name2, args2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    @Override
    public IRubyObject callVarargs(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject ... args2) {
        switch (args2.length) {
            case 0: {
                return this.call(context, caller2, self2);
            }
            case 1: {
                return this.call(context, caller2, self2, args2[0]);
            }
            case 2: {
                return this.call(context, caller2, self2, args2[0], args2[1]);
            }
            case 3: {
                return this.call(context, caller2, self2, args2[0], args2[1], args2[2]);
            }
        }
        return this.call(context, caller2, self2, args2);
    }

    public IRubyObject callVarargs(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyModule klazz, String name2, IRubyObject ... args2) {
        switch (args2.length) {
            case 0: {
                return this.call(context, caller2, self2, klazz, name2);
            }
            case 1: {
                return this.call(context, caller2, self2, klazz, name2, args2[0]);
            }
            case 2: {
                return this.call(context, caller2, self2, klazz, name2, args2[0], args2[1]);
            }
            case 3: {
                return this.call(context, caller2, self2, klazz, name2, args2[0], args2[1], args2[2]);
            }
        }
        return this.call(context, caller2, self2, klazz, name2, args2);
    }

    @Override
    public IRubyObject callVarargs(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.call(context, caller2, self2, block);
            }
            case 1: {
                return this.call(context, caller2, self2, args2[0], block);
            }
            case 2: {
                return this.call(context, caller2, self2, args2[0], args2[1], block);
            }
            case 3: {
                return this.call(context, caller2, self2, args2[0], args2[1], args2[2], block);
            }
        }
        return this.call(context, caller2, self2, args2, block);
    }

    public IRubyObject callVarargs(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyModule klazz, String name2, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.call(context, caller2, self2, klazz, name2, block);
            }
            case 1: {
                return this.call(context, caller2, self2, klazz, name2, args2[0], block);
            }
            case 2: {
                return this.call(context, caller2, self2, klazz, name2, args2[0], args2[1], block);
            }
            case 3: {
                return this.call(context, caller2, self2, klazz, name2, args2[0], args2[1], args2[2], block);
            }
        }
        return this.call(context, caller2, self2, klazz, name2, args2, block);
    }

    @Override
    public IRubyObject callVarargsIter(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.callIter(context, caller2, self2, block);
            }
            case 1: {
                return this.callIter(context, caller2, self2, args2[0], block);
            }
            case 2: {
                return this.callIter(context, caller2, self2, args2[0], args2[1], block);
            }
            case 3: {
                return this.callIter(context, caller2, self2, args2[0], args2[1], args2[2], block);
            }
        }
        return this.callIter(context, caller2, self2, args2, block);
    }

    public IRubyObject callVarargsIter(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyModule klazz, String name2, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.callIter(context, caller2, self2, klazz, name2, block);
            }
            case 1: {
                return this.callIter(context, caller2, self2, klazz, name2, args2[0], block);
            }
            case 2: {
                return this.callIter(context, caller2, self2, klazz, name2, args2[0], args2[1], block);
            }
            case 3: {
                return this.callIter(context, caller2, self2, klazz, name2, args2[0], args2[1], args2[2], block);
            }
        }
        return this.callIter(context, caller2, self2, klazz, name2, args2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        return this.call(context, caller2, self2, klazz, name2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyModule klazz, String name2) {
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, this.cache.cache.sourceModule, name2);
        }
        return this.cacheAndCall(caller2, selfType, context, self2, name2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        return this.call(context, caller2, self2, klazz, name2, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyModule klazz, String name2, Block block) {
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, this.cache.cache.sourceModule, name2, block);
        }
        return this.cacheAndCall(caller2, selfType, block, context, self2, name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self2, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller2, self2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyModule klazz, String name2, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller2, self2, klazz, name2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        return this.call(context, caller2, self2, klazz, name2, arg1);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg1) {
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, this.cache.cache.sourceModule, name2, arg1);
        }
        return this.cacheAndCall(caller2, selfType, context, self2, name2, arg1);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        return this.call(context, caller2, self2, klazz, name2, arg1, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg1, Block block) {
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, this.cache.cache.sourceModule, name2, arg1, block);
        }
        return this.cacheAndCall(caller2, selfType, block, context, self2, name2, arg1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller2, self2, arg1, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg1, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller2, self2, klazz, name2, arg1, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, IRubyObject arg2) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        return this.call(context, caller2, self2, klazz, name2, arg1, arg2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2) {
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, this.cache.cache.sourceModule, name2, arg1, arg2);
        }
        return this.cacheAndCall(caller2, selfType, context, self2, name2, arg1, arg2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        return this.call(context, caller2, self2, klazz, name2, arg1, arg2, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2, Block block) {
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, this.cache.cache.sourceModule, name2, arg1, arg2, block);
        }
        return this.cacheAndCall(caller2, selfType, block, context, self2, name2, arg1, arg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller2, self2, arg1, arg2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller2, self2, klazz, name2, arg1, arg2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        return this.call(context, caller2, self2, klazz, name2, arg1, arg2, arg3);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, this.cache.cache.sourceModule, name2, arg1, arg2, arg3);
        }
        return this.cacheAndCall(caller2, selfType, context, self2, name2, arg1, arg2, arg3);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        return this.call(context, caller2, self2, klazz, name2, arg1, arg2, arg3, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, this.cache.cache.sourceModule, name2, arg1, arg2, arg3, block);
        }
        return this.cacheAndCall(caller2, selfType, block, context, self2, name2, arg1, arg2, arg3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller2, self2, arg1, arg2, arg3, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller2, self2, klazz, name2, arg1, arg2, arg3, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, IRubyObject[] args2, ThreadContext context, IRubyObject self2, String name2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, name2, method2, args2, block);
        }
        this.cache = new SuperTuple(name2, entry);
        return method2.call(context, self2, entry.sourceModule, name2, args2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, IRubyObject[] args2, ThreadContext context, IRubyObject self2, String name2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, name2, method2, args2);
        }
        this.cache = new SuperTuple(name2, entry);
        return method2.call(context, self2, entry.sourceModule, name2, args2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self2, String name2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, name2, method2);
        }
        this.cache = new SuperTuple(name2, entry);
        return method2.call(context, self2, entry.sourceModule, name2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2, String name2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, name2, method2, block);
        }
        this.cache = new SuperTuple(name2, entry);
        return method2.call(context, self2, entry.sourceModule, name2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, name2, method2, arg2);
        }
        this.cache = new SuperTuple(name2, entry);
        return method2.call(context, self2, entry.sourceModule, name2, arg2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, name2, method2, arg2, block);
        }
        this.cache = new SuperTuple(name2, entry);
        return method2.call(context, self2, entry.sourceModule, name2, arg2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self2, String name2, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, name2, method2, arg1, arg2);
        }
        this.cache = new SuperTuple(name2, entry);
        return method2.call(context, self2, entry.sourceModule, name2, arg1, arg2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2, String name2, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, name2, method2, arg1, arg2, block);
        }
        this.cache = new SuperTuple(name2, entry);
        return method2.call(context, self2, entry.sourceModule, name2, arg1, arg2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self2, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, name2, method2, arg1, arg2, arg3);
        }
        this.cache = new SuperTuple(name2, entry);
        return method2.call(context, self2, entry.sourceModule, name2, arg1, arg2, arg3);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, name2, method2, arg1, arg2, arg3, block);
        }
        this.cache = new SuperTuple(name2, entry);
        return method2.call(context, self2, entry.sourceModule, name2, arg1, arg2, arg3, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, String name2, DynamicMethod method2, IRubyObject[] args2) {
        return Helpers.callMethodMissing(context, self2, selfType, method2.getVisibility(), name2, this.callType, args2, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, String name2, DynamicMethod method2) {
        return Helpers.callMethodMissing(context, self2, selfType, method2.getVisibility(), name2, this.callType, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, String name2, DynamicMethod method2, Block block) {
        return Helpers.callMethodMissing(context, self2, selfType, method2.getVisibility(), name2, this.callType, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, String name2, DynamicMethod method2, IRubyObject arg2) {
        return Helpers.callMethodMissing(context, self2, selfType, method2.getVisibility(), name2, this.callType, arg2, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, String name2, DynamicMethod method2, IRubyObject[] args2, Block block) {
        return Helpers.callMethodMissing(context, self2, selfType, method2.getVisibility(), name2, this.callType, args2, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, String name2, DynamicMethod method2, IRubyObject arg0, Block block) {
        return Helpers.callMethodMissing(context, self2, selfType, method2.getVisibility(), name2, this.callType, arg0, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, String name2, DynamicMethod method2, IRubyObject arg0, IRubyObject arg1) {
        return Helpers.callMethodMissing(context, self2, selfType, method2.getVisibility(), name2, this.callType, arg0, arg1, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, String name2, DynamicMethod method2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return Helpers.callMethodMissing(context, self2, selfType, method2.getVisibility(), name2, this.callType, arg0, arg1, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, String name2, DynamicMethod method2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg3) {
        return Helpers.callMethodMissing(context, self2, selfType, method2.getVisibility(), name2, this.callType, arg0, arg1, arg3, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, String name2, DynamicMethod method2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return Helpers.callMethodMissing(context, self2, selfType, method2.getVisibility(), name2, this.callType, arg0, arg1, arg2, block);
    }

    protected boolean methodMissing(DynamicMethod method2, IRubyObject caller2) {
        return method2.isUndefined();
    }

    protected static RubyClass pollAndGetClass(ThreadContext context, IRubyObject self2, RubyModule frameClass, String frameName) {
        Helpers.checkSuperDisabledOrOutOfMethod(context, frameClass, frameName);
        return frameClass.getSuperClass();
    }

    private static class SuperTuple {
        static final SuperTuple NULL_CACHE = new SuperTuple("", CacheEntry.NULL_CACHE);
        public final String name;
        public final CacheEntry cache;

        public SuperTuple(String name2, CacheEntry cache) {
            this.name = name2;
            this.cache = cache;
        }

        public boolean cacheOk(String name2, RubyClass klass) {
            return this.name.equals(name2) && this.cache.typeOk(klass);
        }
    }
}

