/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.ext;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.NoMethodError;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.util.ClassUtils;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ext.JavaExtensions;
import org.jruby.javasupport.ext.JavaLangReflect;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaInternalBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Inspector;
import org.jruby.util.RubyStringBuilder;

public abstract class JavaLang {
    public static void define(Ruby runtime2) {
        JavaExtensions.put(runtime2, java.lang.Iterable.class, proxyClass -> Iterable.define(runtime2, proxyClass));
        JavaExtensions.put(runtime2, java.lang.Comparable.class, proxyClass -> Comparable.define(runtime2, proxyClass));
        JavaExtensions.put(runtime2, java.lang.Throwable.class, proxyClass -> Throwable.define(runtime2, (RubyClass)proxyClass));
        JavaExtensions.put(runtime2, java.lang.Runnable.class, proxyClass -> Runnable.define(runtime2, proxyClass));
        JavaExtensions.put(runtime2, java.lang.Character.class, proxyClass -> Character.define(runtime2, (RubyClass)proxyClass));
        JavaExtensions.put(runtime2, java.lang.Number.class, proxyClass -> Number.define(runtime2, (RubyClass)proxyClass));
        JavaExtensions.put(runtime2, java.lang.Class.class, proxyClass -> Class.define(runtime2, (RubyClass)proxyClass));
        JavaExtensions.put(runtime2, java.lang.ClassLoader.class, proxyClass -> ClassLoader.define(runtime2, (RubyClass)proxyClass));
        JavaExtensions.put(runtime2, new byte[0].getClass(), byteArray -> {
            byteArray.addMethod("ubyte_get", new UByteGet((RubyModule)byteArray));
            byteArray.addMethod("ubyte_set", new UByteSet((RubyModule)byteArray));
        });
        JavaExtensions.put(runtime2, java.lang.CharSequence.class, proxyClass -> CharSequence.define(runtime2, proxyClass));
        JavaExtensions.put(runtime2, java.lang.String.class, proxyClass -> String.define(runtime2, (RubyClass)proxyClass));
        JavaExtensions.put(runtime2, Enum.class, proxyClass -> proxyClass.defineAlias("inspect", "to_s"));
        JavaExtensions.put(runtime2, Boolean.class, proxyClass -> proxyClass.defineAlias("inspect", "to_s"));
        JavaExtensions.put(runtime2, Thread.class, proxyClass -> proxyClass.addMethod("inspect", new InspectThread((RubyModule)proxyClass)));
    }

    static RubyString inspectValueWithTypePrefix(ThreadContext context, IRubyObject self2) {
        Object obj = JavaUtil.unwrapIfJavaObject(self2);
        RubyString buf = Inspector.inspectPrefix(context, self2.getMetaClass());
        RubyStringBuilder.cat(context.runtime, buf, Inspector.SPACE);
        RubyStringBuilder.cat(context.runtime, buf, obj.toString());
        RubyStringBuilder.cat(context.runtime, buf, Inspector.GT);
        return buf;
    }

    private static final class UByteSet
    extends JavaMethod.JavaMethodTwo {
        UByteSet(RubyModule implClass) {
            super(implClass, Visibility.PUBLIC, "ubyte_set");
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, java.lang.String name2, IRubyObject idx, IRubyObject val) {
            int byte_val = ((RubyInteger)val).getIntValue();
            if (byte_val > 127) {
                val = RubyFixnum.newFixnum(context.runtime, byte_val - 256);
            }
            return self2.callMethod(context, "[]=", new IRubyObject[]{idx, val});
        }
    }

    private static final class UByteGet
    extends JavaMethod.JavaMethodOne {
        UByteGet(RubyModule implClass) {
            super(implClass, Visibility.PUBLIC, "ubyte_get");
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, java.lang.String name2, IRubyObject idx) {
            RubyInteger val = (RubyInteger)self2.callMethod(context, "[]", idx);
            int byte_val = val.getIntValue();
            if (byte_val >= 0) {
                return val;
            }
            return RubyFixnum.newFixnum(context.runtime, byte_val + 256);
        }
    }

    static final class InspectValueWithTypePrefix
    extends JavaMethod.JavaMethodZero {
        InspectValueWithTypePrefix(RubyModule implClass) {
            super(implClass, Visibility.PUBLIC, "inspect");
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, java.lang.String name2) {
            return JavaLang.inspectValueWithTypePrefix(context, self2);
        }
    }

    static final class InspectRawValue
    extends JavaMethod.JavaMethodZero {
        InspectRawValue(RubyModule implClass) {
            super(implClass, Visibility.PUBLIC, "inspect");
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, java.lang.String name2) {
            Object val = JavaUtil.unwrapIfJavaObject(self2);
            return context.runtime.newString(val.toString());
        }
    }

    static final class InspectThread
    extends JavaMethod.JavaMethodZero {
        InspectThread(RubyModule implClass) {
            super(implClass, Visibility.PUBLIC, "inspect");
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, java.lang.String name2) {
            Thread thread2 = (Thread)JavaUtil.unwrapIfJavaObject(self2);
            RubyString buf = Inspector.inspectPrefix(context, self2.getMetaClass());
            RubyStringBuilder.cat(context.runtime, buf, Long.toString(thread2.getId()));
            RubyStringBuilder.cat(context.runtime, buf, 32);
            RubyStringBuilder.cat(context.runtime, buf, thread2.getName());
            RubyStringBuilder.cat(context.runtime, buf, 32);
            RubyStringBuilder.cat(context.runtime, buf, thread2.getState().toString());
            RubyStringBuilder.cat(context.runtime, buf, Inspector.GT);
            return buf;
        }
    }

    @JRubyClass(name={"Java::JavaLang::String"})
    public static class String {
        static RubyClass define(Ruby runtime2, RubyClass proxy2) {
            proxy2.defineAnnotatedMethods(String.class);
            return proxy2;
        }

        @JRubyMethod(name={"to_s"}, alias={"to_str"})
        public static IRubyObject to_s(ThreadContext context, IRubyObject self2) {
            java.lang.String str = self2.toJava(java.lang.String.class);
            return RubyString.newString(context.runtime, str);
        }

        @JRubyMethod(name={"inspect"})
        public static IRubyObject inspect(ThreadContext context, IRubyObject self2) {
            java.lang.String str = self2.toJava(java.lang.String.class);
            return RubyString.newString(context.runtime, str).inspect();
        }
    }

    @JRubyClass(name={"Java::JavaLang::CharSequence"})
    public static class CharSequence {
        static RubyModule define(Ruby runtime2, RubyModule proxy2) {
            proxy2.defineAnnotatedMethods(CharSequence.class);
            return proxy2;
        }

        @JRubyMethod(name={"inspect"})
        public static IRubyObject inspect(ThreadContext context, IRubyObject self2) {
            java.lang.CharSequence str = (java.lang.CharSequence)JavaUtil.unwrapIfJavaObject(self2);
            RubyString buf = Inspector.inspectPrefix(context, self2.getMetaClass());
            RubyStringBuilder.cat(context.runtime, buf, Inspector.SPACE);
            buf.cat19(RubyString.newString(context.runtime, str).inspect());
            RubyStringBuilder.cat(context.runtime, buf, Inspector.GT);
            return buf;
        }
    }

    @JRubyClass(name={"Java::JavaLang::ClassLoader"})
    public static class ClassLoader {
        static RubyModule define(Ruby runtime2, RubyClass proxy2) {
            proxy2.defineAnnotatedMethods(ClassLoader.class);
            return proxy2;
        }

        @JRubyMethod
        public static IRubyObject resource_as_url(ThreadContext context, IRubyObject self2, IRubyObject name2) {
            java.lang.ClassLoader loader = (java.lang.ClassLoader)JavaUtil.unwrapIfJavaObject(self2);
            java.lang.String resName = name2.convertToString().toString();
            return JavaUtil.convertJavaToUsableRubyObject(context.runtime, loader.getResource(resName));
        }

        @JRubyMethod
        public static IRubyObject resource_as_stream(ThreadContext context, IRubyObject self2, IRubyObject name2) {
            java.lang.ClassLoader loader = (java.lang.ClassLoader)JavaUtil.unwrapIfJavaObject(self2);
            java.lang.String resName = name2.convertToString().toString();
            return JavaUtil.convertJavaToUsableRubyObject(context.runtime, loader.getResourceAsStream(resName));
        }

        @JRubyMethod
        public static IRubyObject resource_as_string(ThreadContext context, IRubyObject self2, IRubyObject name2) {
            java.lang.ClassLoader loader = (java.lang.ClassLoader)JavaUtil.unwrapIfJavaObject(self2);
            java.lang.String resName = name2.convertToString().toString();
            return new RubyIO(context.runtime, loader.getResourceAsStream(resName)).read(context);
        }
    }

    @JRubyClass(name={"Java::JavaLang::Class"})
    public static class Class {
        static RubyClass define(Ruby runtime2, RubyClass proxy2) {
            proxy2.includeModule(runtime2.getComparable());
            proxy2.defineAnnotatedMethods(Class.class);
            proxy2.defineAlias("resource", "get_resource");
            proxy2.defineAlias("declared_field", "get_declared_field");
            proxy2.defineAlias("field", "get_field");
            return proxy2;
        }

        @JRubyMethod(name={"ruby_class"})
        public static IRubyObject proxy_class(ThreadContext context, IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return Java.getProxyClass(context.runtime, klass);
        }

        @JRubyMethod
        public static IRubyObject resource_as_stream(ThreadContext context, IRubyObject self2, IRubyObject name2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            java.lang.String resName = name2.convertToString().toString();
            return JavaUtil.convertJavaToUsableRubyObject(context.runtime, klass.getResourceAsStream(resName));
        }

        @JRubyMethod
        public static IRubyObject resource_as_string(ThreadContext context, IRubyObject self2, IRubyObject name2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            java.lang.String resName = name2.convertToString().toString();
            return new RubyIO(context.runtime, klass.getResourceAsStream(resName)).read(context);
        }

        @JRubyMethod
        public static IRubyObject to_s(ThreadContext context, IRubyObject self2) {
            return RubyString.newString(context.runtime, Class.getClassName(self2));
        }

        @JRubyMethod
        public static IRubyObject inspect(ThreadContext context, IRubyObject self2) {
            RubyString buf = Inspector.inspectPrefix(context, self2.getMetaClass());
            RubyStringBuilder.cat(context.runtime, buf, Inspector.SPACE);
            buf.catString(Class.getClassName(self2));
            RubyStringBuilder.cat(context.runtime, buf, Inspector.GT);
            return buf;
        }

        private static java.lang.String getClassName(IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            java.lang.String name2 = klass.getCanonicalName();
            return name2 == null ? klass.getName() : name2;
        }

        @JRubyMethod(name={"annotations?"})
        public static IRubyObject annotations_p(ThreadContext context, IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return RubyBoolean.newBoolean(context, klass.getAnnotations().length > 0);
        }

        @JRubyMethod(name={"declared_annotations?"})
        public static IRubyObject declared_annotations_p(ThreadContext context, IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return RubyBoolean.newBoolean(context, klass.getDeclaredAnnotations().length > 0);
        }

        @JRubyMethod
        public static IRubyObject java_instance_methods(ThreadContext context, IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            RubyArray methods2 = RubyArray.newArray(context.runtime);
            for (Method method2 : klass.getMethods()) {
                if (Modifier.isStatic(method2.getModifiers())) continue;
                methods2.add(method2);
            }
            return methods2;
        }

        @JRubyMethod
        public static IRubyObject declared_instance_methods(ThreadContext context, IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            RubyArray methods2 = RubyArray.newArray(context.runtime);
            for (Method method2 : klass.getDeclaredMethods()) {
                if (Modifier.isStatic(method2.getModifiers())) continue;
                methods2.add(method2);
            }
            return methods2;
        }

        @JRubyMethod
        public static IRubyObject java_class_methods(ThreadContext context, IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            RubyArray methods2 = RubyArray.newArray(context.runtime);
            for (Method method2 : klass.getMethods()) {
                if (!Modifier.isStatic(method2.getModifiers())) continue;
                methods2.add(method2);
            }
            return methods2;
        }

        @JRubyMethod
        public static IRubyObject declared_class_methods(ThreadContext context, IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            RubyArray methods2 = RubyArray.newArray(context.runtime);
            for (Method method2 : klass.getDeclaredMethods()) {
                if (!Modifier.isStatic(method2.getModifiers())) continue;
                methods2.add(method2);
            }
            return methods2;
        }

        @JRubyMethod(name={"<=>"})
        public static IRubyObject cmp(ThreadContext context, IRubyObject self2, IRubyObject other) {
            if (!JavaUtil.isJavaObject(other)) {
                return context.nil;
            }
            java.lang.Class that = (java.lang.Class)JavaUtil.unwrapJavaObject(other);
            java.lang.Class thiz = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            if (thiz == that) {
                return context.runtime.newFixnum(0);
            }
            if (thiz.isAssignableFrom(that)) {
                return context.runtime.newFixnum(1);
            }
            if (that.isAssignableFrom(thiz)) {
                return context.runtime.newFixnum(-1);
            }
            return context.nil;
        }

        @JRubyMethod(name={"anonymous?"})
        public static IRubyObject anonymous_p(IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return self2.getRuntime().newBoolean(klass.isAnonymousClass());
        }

        @JRubyMethod(name={"abstract?"})
        public static IRubyObject abstract_p(IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isAbstract(self2, klass.getModifiers());
        }

        @JRubyMethod(name={"public?"})
        public static IRubyObject public_p(IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isPublic(self2, klass.getModifiers());
        }

        @JRubyMethod(name={"protected?"})
        public static IRubyObject protected_p(IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isProtected(self2, klass.getModifiers());
        }

        @JRubyMethod(name={"private?"})
        public static IRubyObject private_p(IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isPrivate(self2, klass.getModifiers());
        }

        @JRubyMethod(name={"final?"})
        public static IRubyObject final_p(IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isFinal(self2, klass.getModifiers());
        }

        @JRubyMethod(name={"static?"})
        public static IRubyObject static_p(IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isStatic(self2, klass.getModifiers());
        }

        @JRubyMethod(required=1)
        public static IRubyObject extend_proxy(ThreadContext context, IRubyObject self2, IRubyObject extender) {
            java.lang.Class<?> klass = Java.unwrapClassProxy(self2);
            RubyModule proxy2 = Java.getProxyClass(context.runtime, klass);
            try {
                return extender.callMethod(context, "extend_proxy", proxy2);
            }
            catch (NoMethodError ex) {
                throw context.runtime.newTypeError("proxy extender must have an extend_proxy method");
            }
        }

        @JRubyMethod(required=1, rest=true)
        public static IRubyObject java_method(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            Arity.checkArgumentCount(context, args2, 1, -1);
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            java.lang.String methodName = args2[0].asJavaString();
            try {
                java.lang.Class<?>[] argumentTypes = ClassUtils.getArgumentTypes(context, args2, 1);
                Method method2 = klass.getMethod(methodName, argumentTypes);
                return Java.getInstance(context.runtime, method2);
            }
            catch (NoSuchMethodException e) {
                Ruby runtime2 = context.runtime;
                throw runtime2.newNameError(RubyModule.undefinedMethodMessage(runtime2, RubyStringBuilder.ids(runtime2, methodName), RubyStringBuilder.ids(runtime2, klass.getName()), false), methodName);
            }
        }

        @JRubyMethod(required=1, rest=true)
        public static IRubyObject declared_method(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            Arity.checkArgumentCount(context, args2, 1, -1);
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            java.lang.String methodName = args2[0].asJavaString();
            try {
                java.lang.Class<?>[] argumentTypes = ClassUtils.getArgumentTypes(context, args2, 1);
                Method method2 = klass.getDeclaredMethod(methodName, argumentTypes);
                return Java.getInstance(context.runtime, method2);
            }
            catch (NoSuchMethodException e) {
                Helpers.throwException(e);
                return null;
            }
        }

        @JRubyMethod(required=1, rest=true)
        public static IRubyObject declared_method_smart(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            Arity.checkArgumentCount(context, args2, 1, -1);
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            java.lang.String methodName = args2[0].asJavaString();
            java.lang.Class<?>[] argumentTypes = ClassUtils.getArgumentTypes(context, args2, 1);
            AccessibleObject callable = ClassUtils.getMatchingCallable(klass, methodName, argumentTypes);
            if (callable != null) {
                return Java.getInstance(context.runtime, callable);
            }
            Ruby runtime2 = context.runtime;
            throw runtime2.newNameError(RubyModule.undefinedMethodMessage(runtime2, RubyStringBuilder.ids(runtime2, methodName), RubyStringBuilder.ids(runtime2, klass.getName()), false), methodName);
        }

        @JRubyMethod(rest=true)
        public static IRubyObject constructor(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            try {
                java.lang.Class<?>[] parameterTypes = ClassUtils.getArgumentTypes(context, args2, 0);
                Constructor constructor2 = klass.getConstructor(parameterTypes);
                return Java.getInstance(context.runtime, constructor2);
            }
            catch (NoSuchMethodException e) {
                Helpers.throwException(e);
                return null;
            }
        }

        @JRubyMethod(rest=true)
        public static IRubyObject declared_constructor(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            try {
                java.lang.Class<?>[] parameterTypes = ClassUtils.getArgumentTypes(context, args2, 0);
                Constructor constructor2 = klass.getDeclaredConstructor(parameterTypes);
                return Java.getInstance(context.runtime, constructor2);
            }
            catch (NoSuchMethodException e) {
                Helpers.throwException(e);
                return null;
            }
        }

        @JRubyMethod
        public static IRubyObject array_class(ThreadContext context, IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            java.lang.Class<?> arrayClass = Array.newInstance(klass, 0).getClass();
            return Java.getInstance(context.runtime, arrayClass);
        }

        @JRubyMethod(required=1)
        public static IRubyObject new_array(ThreadContext context, IRubyObject self2, IRubyObject length2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            if (length2 instanceof RubyInteger) {
                int len = ((RubyInteger)length2).getIntValue();
                return ArrayJavaProxy.newArray(context.runtime, klass, len);
            }
            if (length2 instanceof RubyArray) {
                IRubyObject[] aryLengths = ((RubyArray)length2).toJavaArrayMaybeUnsafe();
                int len = aryLengths.length;
                if (len == 0) {
                    throw context.runtime.newArgumentError("empty dimensions specifier for java array");
                }
                int[] dimensions2 = new int[len];
                int i2 = len;
                while (--i2 >= 0) {
                    IRubyObject dimLength = aryLengths[i2];
                    if (!(dimLength instanceof RubyInteger)) {
                        throw context.runtime.newTypeError(dimLength, context.runtime.getInteger());
                    }
                    dimensions2[i2] = ((RubyInteger)dimLength).getIntValue();
                }
                return ArrayJavaProxy.newArray(context.runtime, klass, dimensions2);
            }
            throw context.runtime.newArgumentError("invalid length or dimensions specifier for java array - must be Integer or Array of Integer");
        }
    }

    @JRubyClass(name={"Java::JavaLang::Character"})
    public static class Character {
        static RubyClass define(Ruby runtime2, RubyClass proxy2) {
            proxy2.defineAnnotatedMethods(Character.class);
            return proxy2;
        }

        @JRubyMethod(name={"java_identifier_start?"}, meta=true)
        public static IRubyObject java_identifier_start_p(ThreadContext context, IRubyObject self2, IRubyObject num) {
            return RubyBoolean.newBoolean(context, java.lang.Character.isJavaIdentifierStart(Character.int_char(num)));
        }

        @JRubyMethod(name={"java_identifier_part?"}, meta=true)
        public static IRubyObject java_identifier_part_p(ThreadContext context, IRubyObject self2, IRubyObject num) {
            return RubyBoolean.newBoolean(context, java.lang.Character.isJavaIdentifierPart(Character.int_char(num)));
        }

        private static int int_char(IRubyObject num) {
            return num.toJava(java.lang.Character.TYPE).charValue();
        }

        @JRubyMethod(name={"to_i"})
        public static IRubyObject to_i(ThreadContext context, IRubyObject self2) {
            java.lang.Character c = self2.toJava(java.lang.Character.class);
            return context.runtime.newFixnum(c.charValue());
        }

        @JRubyMethod(name={"inspect"})
        public static IRubyObject inspect(ThreadContext context, IRubyObject self2) {
            java.lang.Character c = self2.toJava(java.lang.Character.class);
            return RubyString.newString(context.runtime, Character.inspectCharValue(new StringBuilder(3), c.charValue()));
        }

        public static StringBuilder inspectCharValue(StringBuilder buf, char c) {
            return buf.append('\'').append(c).append('\'');
        }
    }

    @JRubyClass(name={"Java::JavaLang::Number"})
    public static class Number {
        static RubyClass define(Ruby runtime2, RubyClass proxy2) {
            proxy2.defineAnnotatedMethods(Number.class);
            proxy2.defineAlias("to_int", "longValue");
            proxy2.defineAlias("to_f", "doubleValue");
            return proxy2;
        }

        @JRubyMethod(name={"to_f"})
        public static IRubyObject to_f(ThreadContext context, IRubyObject self2) {
            java.lang.Number val = self2.toJava(java.lang.Number.class);
            return context.runtime.newFloat(val.doubleValue());
        }

        @JRubyMethod(name={"real?"})
        public static IRubyObject real_p(ThreadContext context, IRubyObject self2) {
            java.lang.Number val = self2.toJava(java.lang.Number.class);
            return RubyBoolean.newBoolean(context, val instanceof Integer || val instanceof Long || val instanceof Short || val instanceof Byte || val instanceof Float || val instanceof Double || val instanceof BigInteger || val instanceof BigDecimal);
        }

        @JRubyMethod(name={"to_i", "to_int"})
        public static IRubyObject to_i(ThreadContext context, IRubyObject self2) {
            java.lang.Number val = self2.toJava(java.lang.Number.class);
            if (val instanceof BigInteger) {
                return RubyBignum.newBignum(context.runtime, (BigInteger)val);
            }
            return context.runtime.newFixnum(val.longValue());
        }

        @JRubyMethod(name={"integer?"})
        public static IRubyObject integer_p(ThreadContext context, IRubyObject self2) {
            java.lang.Number val = self2.toJava(java.lang.Number.class);
            return RubyBoolean.newBoolean(context, val instanceof Integer || val instanceof Long || val instanceof Short || val instanceof Byte || val instanceof BigInteger);
        }

        @JRubyMethod(name={"zero?"})
        public static IRubyObject zero_p(ThreadContext context, IRubyObject self2) {
            return RubyBoolean.newBoolean(context, Number.isZero(self2));
        }

        private static boolean isZero(IRubyObject self2) {
            java.lang.Number val = self2.toJava(java.lang.Number.class);
            return Double.compare(val.doubleValue(), 0.0) == 0;
        }

        @JRubyMethod(name={"nonzero?"})
        public static IRubyObject nonzero_p(ThreadContext context, IRubyObject self2) {
            return Number.isZero(self2) ? context.nil : self2;
        }

        @JRubyMethod(name={"coerce"})
        public static IRubyObject coerce(ThreadContext context, IRubyObject self2, IRubyObject type2) {
            java.lang.Number val = self2.toJava(java.lang.Number.class);
            IRubyObject value2 = JavaUtil.convertJavaToUsableRubyObject(context.runtime, val);
            return context.runtime.newArray(type2, value2);
        }

        @JRubyMethod(name={"inspect"})
        public static IRubyObject inspect(ThreadContext context, IRubyObject self2) {
            java.lang.Number val = self2.toJava(java.lang.Number.class);
            return context.runtime.newString(val.toString());
        }
    }

    @JRubyModule(name={"Java::JavaLang::Runnable"})
    public static class Runnable {
        static RubyModule define(Ruby runtime2, RubyModule proxy2) {
            proxy2.defineAnnotatedMethods(Runnable.class);
            return proxy2;
        }

        @JRubyMethod
        public static IRubyObject to_proc(ThreadContext context, IRubyObject self2) {
            Ruby runtime2 = context.runtime;
            java.lang.Runnable runnable = (java.lang.Runnable)JavaUtil.unwrapIfJavaObject(self2);
            Block block = new Block(new RunBody(runtime2, runnable));
            return new RubyProc(runtime2, runtime2.getProc(), block, null, -1);
        }

        private static final class RunBody
        extends JavaInternalBlockBody {
            private final java.lang.Runnable runnable;

            RunBody(Ruby runtime2, java.lang.Runnable runnable) {
                super(runtime2, Signature.NO_ARGUMENTS);
                this.runnable = runnable;
            }

            @Override
            public IRubyObject yield(ThreadContext context, IRubyObject[] args2) {
                return this.yieldImpl(context);
            }

            final IRubyObject yieldImpl(ThreadContext context) {
                this.runnable.run();
                return context.nil;
            }

            @Override
            protected final IRubyObject doYield(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
                return this.yieldImpl(context);
            }

            @Override
            protected final IRubyObject doYield(ThreadContext context, Block block, IRubyObject value2) {
                return this.yieldImpl(context);
            }
        }
    }

    @JRubyClass(name={"Java::JavaLang::Throwable"})
    public static class Throwable {
        static RubyModule define(Ruby runtime2, RubyClass proxy2) {
            proxy2.defineAnnotatedMethods(Throwable.class);
            return proxy2;
        }

        @JRubyMethod
        public static IRubyObject backtrace(ThreadContext context, IRubyObject self2) {
            Ruby runtime2 = context.runtime;
            java.lang.Throwable throwable = (java.lang.Throwable)JavaUtil.unwrapIfJavaObject(self2);
            StackTraceElement[] stackTrace = throwable.getStackTrace();
            if (stackTrace == null) {
                return context.nil;
            }
            int len = stackTrace.length;
            if (len == 0) {
                return RubyArray.newEmptyArray(runtime2);
            }
            IRubyObject[] backtrace2 = new IRubyObject[len];
            for (int i2 = 0; i2 < len; ++i2) {
                backtrace2[i2] = RubyString.newString(runtime2, stackTrace[i2].toString());
            }
            return RubyArray.newArrayMayCopy(runtime2, backtrace2);
        }

        @JRubyMethod
        public static IRubyObject set_backtrace(IRubyObject self2, IRubyObject backtrace2) {
            return self2.getRuntime().getNil();
        }

        @JRubyMethod
        public static IRubyObject message(ThreadContext context, IRubyObject self2) {
            java.lang.Throwable throwable = (java.lang.Throwable)JavaUtil.unwrapIfJavaObject(self2);
            java.lang.String msg = throwable.getLocalizedMessage();
            return msg == null ? RubyString.newEmptyString(context.runtime) : RubyString.newString(context.runtime, msg);
        }

        @JRubyMethod
        public static IRubyObject full_message(ThreadContext context, IRubyObject self2) {
            return Throwable.full_message(context, self2, null);
        }

        @JRubyMethod
        public static IRubyObject full_message(ThreadContext context, IRubyObject self2, IRubyObject opts) {
            return RubyString.newString(context.runtime, TraceType.printFullMessage(context, self2, opts));
        }

        @JRubyMethod
        public static IRubyObject to_s(ThreadContext context, IRubyObject self2) {
            return Throwable.message(context, self2);
        }

        @JRubyMethod(name={"inspect"})
        public static IRubyObject inspect(ThreadContext context, IRubyObject self2) {
            java.lang.Throwable throwable = (java.lang.Throwable)JavaUtil.unwrapIfJavaObject(self2);
            RubyString buf = Inspector.inspectPrefix(context, self2.getMetaClass());
            RubyStringBuilder.cat(context.runtime, buf, Inspector.SPACE);
            java.lang.String message2 = throwable.getMessage();
            buf.catString(message2 == null ? "" : message2);
            RubyStringBuilder.cat(context.runtime, buf, Inspector.GT);
            return buf;
        }

        @JRubyMethod(name={"==="}, meta=true)
        public static IRubyObject eqq(ThreadContext context, IRubyObject self2, IRubyObject other) {
            if (Throwable.checkNativeException(self2, other)) {
                return context.tru;
            }
            return self2.op_eqq(context, other);
        }

        private static boolean checkNativeException(IRubyObject self2, IRubyObject other) {
            java.lang.Class java_class2;
            return other instanceof NativeException && (java_class2 = (java.lang.Class)self2.dataGetStruct()).isAssignableFrom(((NativeException)other).getCause().getClass());
        }
    }

    @JRubyClass(name={"Java::JavaLang::Comparable"}, include={"Comparable"})
    public static class Comparable {
        static RubyModule define(Ruby runtime2, RubyModule proxy2) {
            proxy2.includeModule(runtime2.getComparable());
            proxy2.defineAnnotatedMethods(Comparable.class);
            return proxy2;
        }

        @JRubyMethod(name={"<=>"})
        public static IRubyObject cmp(ThreadContext context, IRubyObject self2, IRubyObject other) {
            int cmp2;
            java.lang.Comparable comparable = (java.lang.Comparable)JavaUtil.unwrapIfJavaObject(self2);
            if (other.isNil()) {
                return context.nil;
            }
            Object otherComp = JavaUtil.unwrapIfJavaObject(other);
            try {
                cmp2 = comparable.compareTo(otherComp);
            }
            catch (ClassCastException ex) {
                throw context.runtime.newTypeError(ex.getMessage());
            }
            return RubyFixnum.newFixnum(context.runtime, cmp2);
        }
    }

    @JRubyModule(name={"Java::JavaLang::Iterable"}, include={"Enumerable"})
    public static class Iterable {
        static RubyModule define(Ruby runtime2, RubyModule proxy2) {
            proxy2.includeModule(runtime2.getEnumerable());
            proxy2.defineAnnotatedMethods(Iterable.class);
            return proxy2;
        }

        @JRubyMethod
        public static IRubyObject each(ThreadContext context, IRubyObject self2, Block block) {
            Ruby runtime2 = context.runtime;
            if (!block.isGiven()) {
                return RubyEnumerator.enumeratorize(context.runtime, self2, "each");
            }
            java.lang.Iterable iterable = (java.lang.Iterable)JavaUtil.unwrapIfJavaObject(self2);
            for (Object value2 : iterable) {
                block.yield(context, JavaUtil.convertJavaToUsableRubyObject(runtime2, value2));
            }
            return self2;
        }

        @JRubyMethod
        public static IRubyObject each_with_index(ThreadContext context, IRubyObject self2, Block block) {
            Ruby runtime2 = context.runtime;
            if (!block.isGiven()) {
                return RubyEnumerator.enumeratorize(context.runtime, self2, "each_with_index");
            }
            java.lang.Iterable iterable = (java.lang.Iterable)JavaUtil.unwrapIfJavaObject(self2);
            Iterator iterator = iterable.iterator();
            boolean twoArguments = block.getSignature().isTwoArguments();
            int i2 = 0;
            while (iterator.hasNext()) {
                RubyFixnum index2 = RubyFixnum.newFixnum(runtime2, i2++);
                Object value2 = iterator.next();
                IRubyObject rValue = JavaUtil.convertJavaToUsableRubyObject(runtime2, value2);
                if (twoArguments) {
                    block.yieldSpecific(context, rValue, index2);
                    continue;
                }
                block.yield(context, RubyArray.newArray(runtime2, rValue, index2));
            }
            return self2;
        }

        @JRubyMethod(name={"to_a", "entries"})
        public static IRubyObject to_a(ThreadContext context, IRubyObject self2, Block block) {
            Ruby runtime2 = context.runtime;
            RubyArray ary = runtime2.newArray();
            java.lang.Iterable iterable = (java.lang.Iterable)JavaUtil.unwrapIfJavaObject(self2);
            for (Object value2 : iterable) {
                ary.append(JavaUtil.convertJavaToUsableRubyObject(runtime2, value2));
            }
            return ary;
        }

        @JRubyMethod(name={"count"})
        public static IRubyObject count(ThreadContext context, IRubyObject self2, Block block) {
            Ruby runtime2 = context.runtime;
            java.lang.Iterable iterable = (java.lang.Iterable)JavaUtil.unwrapIfJavaObject(self2);
            if (block.isGiven()) {
                return Iterable.countBlock(context, iterable.iterator(), block);
            }
            if (iterable instanceof Collection) {
                return RubyFixnum.newFixnum(runtime2, ((Collection)iterable).size());
            }
            int count2 = 0;
            Iterator it = iterable.iterator();
            while (it.hasNext()) {
                it.next();
                ++count2;
            }
            return RubyFixnum.newFixnum(runtime2, count2);
        }

        static RubyFixnum countBlock(ThreadContext context, Iterator it, Block block) {
            Ruby runtime2 = context.runtime;
            int count2 = 0;
            while (it.hasNext()) {
                IRubyObject next2 = JavaUtil.convertJavaToUsableRubyObject(runtime2, it.next());
                if (!block.yield(context, next2).isTrue()) continue;
                ++count2;
            }
            return RubyFixnum.newFixnum(runtime2, count2);
        }

        @JRubyMethod(name={"count"})
        public static IRubyObject count(ThreadContext context, IRubyObject self2, IRubyObject obj, Block unused2) {
            Ruby runtime2 = context.runtime;
            java.lang.Iterable iterable = (java.lang.Iterable)JavaUtil.unwrapIfJavaObject(self2);
            int count2 = 0;
            Iterator it = iterable.iterator();
            while (it.hasNext()) {
                IRubyObject next2 = JavaUtil.convertJavaToUsableRubyObject(runtime2, it.next());
                if (!RubyObject.equalInternal(context, next2, obj)) continue;
                ++count2;
            }
            return RubyFixnum.newFixnum(runtime2, count2);
        }
    }
}

