/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.codegen;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class MultiClassLoader
extends ClassLoader {
    private final List<ClassLoader> classLoaders = new LinkedList<ClassLoader>();

    public MultiClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void addClassLoader(ClassLoader loader) {
        this.classLoaders.add(loader);
    }

    @Override
    protected Class<?> findClass(String name2) throws ClassNotFoundException {
        String path2 = name2.replace('.', '/') + ".class";
        for (ClassLoader classLoader : this.classLoaders) {
            URL resource2 = classLoader.getResource(path2);
            if (resource2 == null) continue;
            return classLoader.loadClass(name2);
        }
        return super.findClass(name2);
    }

    @Override
    protected URL findResource(String name2) {
        for (ClassLoader classLoader : this.classLoaders) {
            URL resource2 = classLoader.getResource(name2);
            if (resource2 == null) continue;
            return resource2;
        }
        return super.findResource(name2);
    }

    @Override
    protected Enumeration<URL> findResources(String name2) throws IOException {
        Vector<URL> vector = new Vector<URL>();
        for (ClassLoader classLoader : this.classLoaders) {
            Enumeration<URL> enumeration = classLoader.getResources(name2);
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
        }
        Enumeration<URL> enumeration = super.findResources(name2);
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector.elements();
    }
}

