/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.log;

import java.io.PrintStream;
import org.joda.time.DateTime;
import org.jruby.util.log.Logger;

public class OutputStreamLogger
implements Logger {
    private final String loggerName;
    private boolean debug = false;
    protected PrintStream stream;

    public OutputStreamLogger(String loggerName) {
        this.loggerName = loggerName;
    }

    public OutputStreamLogger(String loggerName, PrintStream stream) {
        this.loggerName = loggerName;
        this.stream = stream;
    }

    @Override
    public String getName() {
        return this.loggerName;
    }

    public PrintStream getStream() {
        return this.stream;
    }

    public void setStream(PrintStream stream) {
        this.stream = stream;
    }

    @Override
    public void warn(String message2, Object ... args2) {
        this.write(message2, "WARN", args2);
    }

    @Override
    public void warn(Throwable throwable) {
        this.write("", "WARN", throwable);
    }

    @Override
    public void warn(String message2, Throwable throwable) {
        this.write(message2, "WARN", throwable);
    }

    @Override
    public void error(String message2, Object ... args2) {
        this.write(message2, "ERROR", args2);
    }

    @Override
    public void error(Throwable throwable) {
        this.write("", "ERROR", throwable);
    }

    @Override
    public void error(String message2, Throwable throwable) {
        this.write(message2, "ERROR", throwable);
    }

    @Override
    public void info(String message2, Object ... args2) {
        this.write(message2, "INFO", args2);
    }

    @Override
    public void info(Throwable throwable) {
        this.write("", "INFO", throwable);
    }

    @Override
    public void info(String message2, Throwable throwable) {
        this.write(message2, "INFO", throwable);
    }

    @Override
    public void debug(String message2, Object ... args2) {
        if (this.debug) {
            this.write(message2, "DEBUG", args2);
        }
    }

    @Override
    public void debug(Throwable throwable) {
        if (this.debug) {
            this.write("", "DEBUG", throwable);
        }
    }

    @Override
    public void debug(String message2, Throwable throwable) {
        if (this.debug) {
            this.write(message2, "DEBUG", throwable);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debug;
    }

    @Override
    public void setDebugEnable(boolean debug) {
        this.debug = debug;
    }

    protected void write(String message2, String level2, Object[] args2) {
        CharSequence suble = OutputStreamLogger.substitute(message2, args2);
        this.stream.println(this.formatMessage(suble, level2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(String message2, String level2, Throwable throwable) {
        PrintStream printStream = this.stream;
        synchronized (printStream) {
            this.stream.println(this.formatMessage(message2, level2));
            OutputStreamLogger.writeStackTrace(this.stream, throwable);
        }
    }

    protected static void writeStackTrace(PrintStream stream, Throwable throwable) {
        if (throwable == null) {
            throw new IllegalArgumentException("null throwable");
        }
        throwable.printStackTrace(stream);
    }

    protected String formatMessage(CharSequence message2, String level2) {
        return new StringBuilder(64).append(new DateTime(System.currentTimeMillis())).append(' ').append('[').append(Thread.currentThread().getName()).append(']').append(' ').append(level2).append(' ').append(this.loggerName).append(" : ").append(message2).toString();
    }

    static CharSequence substitute(String messagePattern, Object ... args2) {
        if (messagePattern == null) {
            StringBuilder msg = new StringBuilder();
            for (int i2 = 0; i2 < args2.length; ++i2) {
                msg.append(args2[i2]);
            }
            return msg;
        }
        StringBuilder msg = null;
        int len = messagePattern.length();
        int s2 = 0;
        int a = 0;
        for (int i3 = 0; i3 < len; ++i3) {
            if (messagePattern.charAt(i3) != '{' || i3 != 0 && (i3 <= 0 || messagePattern.charAt(i3 - 1) == '\\') || i3 >= len - 1 || messagePattern.charAt(i3 + 1) != '}') continue;
            if (msg == null) {
                msg = new StringBuilder(len + 48);
            }
            msg.append(messagePattern, s2, i3);
            s2 = i3 + 2;
            if (a < args2.length) {
                msg.append(args2[a++]);
                continue;
            }
            msg.append("{!abs-arg!}");
        }
        if (msg != null) {
            if (s2 < len) {
                msg.append(messagePattern, s2, len);
            }
            return msg;
        }
        return messagePattern;
    }
}

