/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaAccessibleObject;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaConstructor
extends JavaCallable {
    private final Constructor<?> constructor;

    public final Constructor getValue() {
        return this.constructor;
    }

    public static RubyClass createJavaConstructorClass(Ruby runtime2, RubyModule javaModule) {
        RubyClass result2 = javaModule.defineClassUnder("JavaConstructor", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaAccessibleObject.registerRubyMethods(runtime2, result2);
        JavaCallable.registerRubyMethods(runtime2, result2);
        result2.defineAnnotatedMethods(JavaConstructor.class);
        return result2;
    }

    public JavaConstructor(Ruby runtime2, Constructor<?> constructor2) {
        super(runtime2, null, constructor2.getParameterTypes());
        this.constructor = constructor2;
    }

    public static JavaConstructor create(Ruby runtime2, Constructor<?> constructor2) {
        return new JavaConstructor(runtime2, constructor2);
    }

    public static JavaConstructor getMatchingConstructor(Ruby runtime2, Class<?> javaClass, Class<?>[] argumentTypes) {
        try {
            return JavaConstructor.create(runtime2, javaClass.getConstructor(argumentTypes));
        }
        catch (NoSuchMethodException e) {
            int argLength = argumentTypes.length;
            block2: for (Constructor<?> ctor : javaClass.getConstructors()) {
                Class<?>[] ctorTypes = ctor.getParameterTypes();
                int ctorLength = ctorTypes.length;
                if (ctorLength != argLength) continue;
                if (ctorLength == 0 && argLength == 0) {
                    return JavaConstructor.create(runtime2, ctor);
                }
                boolean found = true;
                for (int i2 = 0; i2 < argLength; ++i2) {
                    if (!ctorTypes[i2].isAssignableFrom(argumentTypes[i2])) continue block2;
                    found = true;
                }
                if (!found) continue;
                return JavaConstructor.create(runtime2, ctor);
            }
            return null;
        }
    }

    @Override
    public final boolean equals(Object other) {
        return other instanceof JavaConstructor && this.constructor.equals(((JavaConstructor)other).constructor);
    }

    @Override
    public final int hashCode() {
        return this.constructor.hashCode();
    }

    @Override
    public final Class<?>[] getExceptionTypes() {
        return this.constructor.getExceptionTypes();
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return this.constructor.getGenericParameterTypes();
    }

    @Override
    public Type[] getGenericExceptionTypes() {
        return this.constructor.getGenericExceptionTypes();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        return this.constructor.getParameterAnnotations();
    }

    @Override
    public final boolean isVarArgs() {
        return this.constructor.isVarArgs();
    }

    @Override
    public final int getModifiers() {
        return this.constructor.getModifiers();
    }

    @Override
    public String toGenericString() {
        return this.constructor.toGenericString();
    }

    public Class<?> getDeclaringClass() {
        return this.constructor.getDeclaringClass();
    }

    @Override
    public AccessibleObject accessibleObject() {
        return this.constructor;
    }

    @JRubyMethod
    public IRubyObject type_parameters(ThreadContext context) {
        return Java.getInstance(context.runtime, this.constructor.getTypeParameters());
    }

    @JRubyMethod
    public IRubyObject return_type(ThreadContext context) {
        return context.runtime.getNil();
    }

    @Override
    @JRubyMethod
    public IRubyObject declaring_class(ThreadContext context) {
        return Java.getProxyClass(context.runtime, this.getDeclaringClass());
    }

    @JRubyMethod(rest=true)
    public final IRubyObject new_instance(ThreadContext context, IRubyObject[] args2) {
        this.checkArity(context, args2.length);
        return this.newInstanceExactArity(context, this.convertArguments(args2));
    }

    public final IRubyObject new_instance(ThreadContext context, Object[] arguments) {
        this.checkArity(context, arguments.length);
        return this.newInstanceExactArity(context, arguments);
    }

    private IRubyObject newInstanceExactArity(ThreadContext context, Object[] arguments) {
        try {
            Object result2 = this.constructor.newInstance(arguments);
            return JavaObject.wrap(context.runtime, result2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, this.constructor, false, arguments);
        }
        catch (IllegalAccessException iae) {
            throw context.runtime.newTypeError("illegal access");
        }
        catch (InvocationTargetException ite) {
            context.runtime.getJavaSupport().handleNativeException(ite.getTargetException(), this.constructor);
            assert (false);
            return null;
        }
        catch (InstantiationException ie) {
            throw context.runtime.newTypeError("can't make instance of " + this.constructor.getDeclaringClass().getName());
        }
    }

    public Object newInstanceDirect(ThreadContext context, Object ... arguments) {
        this.checkArity(context, arguments.length);
        try {
            return this.constructor.newInstance(arguments);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, this.constructor, arguments);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, this.constructor);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    public Object newInstanceDirect(ThreadContext context) {
        this.checkArity(context, 0);
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, this.constructor, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, this.constructor);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    public Object newInstanceDirect(ThreadContext context, Object arg0) {
        this.checkArity(context, 1);
        try {
            return this.constructor.newInstance(arg0);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, this.constructor, arg0);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, this.constructor);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    public Object newInstanceDirect(ThreadContext context, Object arg0, Object arg1) {
        this.checkArity(context, 2);
        try {
            return this.constructor.newInstance(arg0, arg1);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, this.constructor, arg0, arg1);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, this.constructor);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    public Object newInstanceDirect(ThreadContext context, Object arg0, Object arg1, Object arg2) {
        this.checkArity(context, 3);
        try {
            return this.constructor.newInstance(arg0, arg1, arg2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, this.constructor, arg0, arg1, arg2);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, this.constructor);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    public Object newInstanceDirect(ThreadContext context, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.checkArity(context, 4);
        try {
            return this.constructor.newInstance(arg0, arg1, arg2, arg3);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, this.constructor, arg0, arg1, arg2, arg3);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, this.constructor);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    boolean isConstructor() {
        return true;
    }
}

