/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jruby.RubyThread;
import org.jruby.internal.runtime.ThreadLike;

public class NativeThread
implements ThreadLike {
    private final Reference<Thread> nativeThread;
    public final RubyThread rubyThread;
    public String rubyName;
    private static final String RUBY_THREAD_PREFIX = "Ruby-";

    public NativeThread(RubyThread rubyThread, Thread nativeThread) {
        this.rubyThread = rubyThread;
        this.nativeThread = new WeakReference<Thread>(nativeThread);
        this.rubyName = null;
    }

    @Override
    public void start() {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            thread2.start();
        }
    }

    @Override
    public void interrupt() {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            thread2.interrupt();
        }
    }

    @Override
    public boolean isAlive() {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            return thread2.isAlive();
        }
        return false;
    }

    @Override
    public void join() throws InterruptedException {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            thread2.join();
        }
    }

    @Override
    public void join(long timeoutMillis) throws InterruptedException {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            thread2.join(timeoutMillis);
        }
    }

    @Override
    public int getPriority() {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            return thread2.getPriority();
        }
        return 0;
    }

    @Override
    public void setPriority(int priority2) {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            thread2.setPriority(priority2);
        }
    }

    @Override
    public boolean isCurrent() {
        return this.getThread() == Thread.currentThread();
    }

    @Override
    public boolean isInterrupted() {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            return thread2.isInterrupted();
        }
        return false;
    }

    public final Thread getThread() {
        return this.nativeThread.get();
    }

    public String toString() {
        return String.valueOf(this.getThread());
    }

    @Override
    public Thread nativeThread() {
        return this.nativeThread.get();
    }

    @Override
    public void setRubyName(String id2) {
        this.rubyName = id2;
        this.updateName();
    }

    @Override
    @Deprecated
    public String getRubyName() {
        return this.rubyName;
    }

    @Override
    public String getReportName() {
        String nativeName = "";
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            nativeName = thread2.getName();
        }
        if (this.rubyName == null || this.rubyName.length() == 0) {
            return nativeName.equals("") ? "(unnamed)" : nativeName;
        }
        return nativeName.equals("") ? this.rubyName : this.rubyName + " (" + nativeName + ")";
    }

    void updateName() {
        String newName;
        String setName2 = this.rubyName;
        Thread thread2 = this.getThread();
        if (thread2 == null) {
            return;
        }
        String currentName = thread2.getName();
        if (currentName != null && currentName.startsWith(RUBY_THREAD_PREFIX)) {
            int i2 = currentName.indexOf(64);
            if (i2 == -1) {
                int end2 = currentName.indexOf(58);
                if (end2 == -1) {
                    end2 = currentName.length();
                }
                String prefix = currentName.substring(0, end2);
                newName = currentName.replace(prefix, prefix + '@' + setName2);
            } else {
                String prefix = currentName.substring(0, i2);
                int end3 = currentName.indexOf(58, i2);
                if (end3 == -1) {
                    end3 = currentName.length();
                }
                String prefixWithName = currentName.substring(0, end3);
                newName = currentName.replace(prefixWithName, setName2 == null ? prefix : prefix + '@' + setName2);
            }
        } else {
            return;
        }
        try {
            thread2.setName(newName);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

