/*
 ***** BEGIN LICENSE BLOCK *****
 * Version: EPL 2.0/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Eclipse Public
 * License Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.eclipse.org/legal/epl-v20.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * Copyright (C) 2013-2017 The JRuby Team (jruby@jruby.org)
 * 
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the EPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the EPL, the GPL or the LGPL.
 ***** END LICENSE BLOCK *****/
package org.jruby.parser;

public class YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

          292,  479,  295,   88,   88,  402,  288,  687,  405,  361, 
          228,  228,  228,  294,  205,  262,  228,  228,  702,  701, 
          192,  681,  701,  341,  498,  635,  111,  412,  518,  238, 
          289,  207,  520,  455,  205,  563,  648,  636,  648,  637, 
          226,  226,  226,  747,  749,  649,   88,  339,  277,  283, 
          337,  207,  228,  819,  584,  276,  276,  702,  637,    8, 
          261,  938,  191,  191,  280,  280,  347,  828,  359,    8, 
          648,  415,  279,  279,  648,  553,  754,  866,  393,  311, 
          232,  235,  416,  191,   83,  648,  313,  648,  584,   83, 
           83,  234,  417,  617,  291,  261,  318,  322,  386,  839, 
          576,  337,  359,  584,  317, 1013,  284,  864,  191,  228, 
          434,  434,  534,   74,  537,  649,  418,  506,    8,  659, 
          859,  961,  439,  238,  553,   93,   93,  393,  607,  287, 
          440,  379,  568, 1064,  576,   83,  583,  263,  301,  594, 
          233,  420,  677,  287,  234,  451,  261,   86,  276,  576, 
          360,   61,   62,   63,   64,  261,  261,  280,  691,  568, 
          613,   97,  621,   73,   72,  279,  627,  291,   93,   86, 
          583,  607,  338,  594,  302,  909,  399,  607,  414,  467, 
          628,  275,  628,  277,  360,  583,   72,  628,  594,  632, 
          860, 1064,  545,  233,  346,  414,  651,  546,   53,  572, 
         1022,  456,  568,  276,   75,  515,  316,  320,  479,  613, 
          582,  621,   88, 1013,   71,  938,  501,  723,  367,  368, 
          607,  384,  643,  338,  462,  399,   88,  694,  563,  288, 
          551,  552,  435,  435,  602,  534,  387,  382,  296,  514, 
          228,  228,  385,  346,  582,  568,  702,  648,  380,  701, 
          701,  297,  417,  238,  526,   75,  383,  637,  657,  582, 
          633,  694,  658,  522,  381,  352,  553,  652,  602,  592, 
          226,  226,  648,  508,  637,  971,  866,  643,  515,  316, 
          353,  568,  648,  602,  509,  228,  694,  228,  228,  814, 
          811,  228,  306,  228,  568,  643,  648,   88,   88,   96, 
           96,  730,  864,  592,   88,  633,   88,  652,   81,  460, 
          461,  264,  517,  316,  846,   88,  356,  480,  592,  483, 
           79,  489,  637,  491,  276,  238,  276,  276,  316,  234, 
          568,  648,  357,  280,   93,  280,  730,  337,  942,  311, 
          576,  279,   96,  279,  946,  948,   76,  950,   93,  951, 
          798,  885,  872,   83,  463,  799,  714,  892,  637,   81, 
          316,  396,  684,  228,  228,  228,  228,   88,  228,  228, 
          553,   79,  807,  409,  576,  930,  952,  649,  233,  629, 
          649,  629,  261,   83,  864,  647,  629,  623,  635,  576, 
          504,  648,  572,  226,  226,  226,  226,   76,  584,  585, 
          636,  512,  228,  584,   72,  648,  648,  553,  631,  645, 
          631,   88,  337,  648,  228,  631,   83,   88,  313,   93, 
           93,  832,    8,  607,  694,  290,   93,  393,   93,  837, 
          386,  228,  579,  580,  581,  582,  623,   93,  228,  653, 
          553,  276,  864,  835,  311,   74,  485, 1093,   88,  576, 
          407,  228,  623,  583,  522,   97,   88,  261,  622,  338, 
          607,  656,  622,  379, 1026,  107,  642,  228,  666, 1030, 
          642,  702,  306,   75,  408,  701,  899,  413,  686,  686, 
          291,  709,  563,  825,  563,  583,  623,  442,  594,   93, 
          276,  568, 1001,  607,  847,   73,  414,  228, 1050, 1052, 
         1053, 1054,  205,   83,  732,  582,  276,  622,   96,  733, 
           88,  623,  316,  275,  682,  277,  275,  445,  277,  207, 
          607,  847,   96,  622,  700,  399,  228,  710,  337,  602, 
          634,  457,  634,   93,  338,  276,   75,  634,  276,   93, 
          628,  628,  582,  613,  499,  621,  628,  628,  785,  881, 
          883,  191,  306,  384,  832,  888,  890,  622,  452,  628, 
          485,  874, 1095,  719,  592,  276,  602, 1087,  387,  382, 
           93,  522,  726,  261,  385,  582,  453,   81,   93,  648, 
          380,  765,  622,  602,  551,  552,  446,   84,  383,   79, 
          572,  772,  572,   96,   96,  875,  381,  316,  769,  602, 
           96,  592,   96,  759,  316,  316,  775,  812,  760,  485, 
          623,   96,  775,  568,  454,   76,  822,  459,  592,  490, 
          882,  884,  770,  740,  290,  485,  889,  891,  316,  468, 
          776,  648,   93,  291,  592,  576,  779,   77,   84,  475, 
           81,  510,  511,  103,  103,  337,  572,  838,  572,  623, 
          338,  772,   79,  528,  529,  806,  401,  306,   82,  628, 
          531,  648,  648,   96,  228,  772,   88, 1048,  970,  492, 
          882,  884,  576,  889,  891,  769,  205,  464,   76,  775, 
          648,  811,  805,  457,  485,   80,  103,  474,   77,  790, 
          261,  528,  529,  207,  673,  450,  228,  772,  531,  648, 
          126,  736,  680,  276,  635,  576,  635,   96,  478,   82, 
          369,  635,   78,   96,  855,  894,   88,  996,  522,  965, 
          622,  337,  502,  998,  191,  191,  226,  642,  503,  507, 
          454,   97, 1071,  513,  648,  116,   80,  493,  494,  629, 
          629,  374,  375,   96,   96,  629,  629,  519,  648,  316, 
          521,  648,   96,  527,  833,  646,  316,  316,  629,  234, 
          367,  368,  623,   78,  288,  829,  261,  338,  631,  631, 
          623,  648,  654,  772,  631,  631,  390,  391,  522,  454, 
          778,  660,   88,  648,  116,  228,  778,  631,   93,  670, 
          521,  572,  337,  824,  672,  228,   88,  683,  319,  674, 
          648,  694,   83,  496,   88,  711,   96,  704,  233,  703, 
          705,  906,   88,  453,  453,  228,  522,  707,  708,  453, 
          648,  706,  485,  712,  276,  226,   88,   88,   88,  810, 
          813,  715,  813,  720,  741,  716,  904,  261,   93,  813, 
          742,  622,  743,  338,  746,  226,  748,  686,  862,  855, 
          865,  845,  103,  778,  750,  752,   84,  753,  629,  648, 
           88,   88,  756,  999,  907,  761,  103,  965,  895,  763, 
          850,  965,  766,  772,   97,  398,   35,  911,   88,  913, 
           88,  767,  399,  404,  922,  648,   35,  631,  736,  851, 
          634,  634,  768,  398,  773,  774,  634,  634,  935,  781, 
          399,  400,  786,  788,   93,  791,   77,   88,  648,  634, 
         1041,  802,  811,  817,  338, 1008,  993,  818,   93,   84, 
           88,  878,  820,  878,  821,  974,   93,   82,  855,  965, 
          823,  978,  398,  848,   93,   35,  852,  103,  103,  399, 
          449,  873,  268,  485,  103,  880,  103,  886,   93,   93, 
           93,  887,  268,  648,   80,  103,  905,  910,  648,  915, 
          648,  261,   96,  528,  529, 1034,  116,  919,  917,   77, 
          531,  921,  789,  924,  923,  536,  925,  953,  115,  931, 
           88,   78,   93,   93, 1007, 1049,  263,  454,  856,  932, 
           82,  648,  116,  867,  648,  801,  936,   88,  939,   88, 
           93,  268,   93,  648,  736,   88,  736,  103,  648,  634, 
          261,  941,   96,  940,  945,  522,  446,   80,  254,  469, 
          470,  471,  522,  522,  473,  648,  623,  521,  254,   93, 
          648,  947,  949,  115,  521,  521, 1067,  975,  994,  834, 
          977,  228,   93,  648,   78,  772,   88,  836,  103, 1017, 
          103,  103,  648,  522, 1002,  103, 1046,  103,  918,  454, 
          522,  522,  254,  648,  635,  635,  869, 1003,  853,  869, 
          635,  635,  927,  928,  929, 1006,  254,  254,   96, 1014, 
          276,  261,  115,  635, 1015, 1020,  813,  435,  103, 1023, 
          736, 1009,   96, 1025, 1027, 1078,  103,  622, 1029, 1035, 
           96, 1036,   93, 1038, 1047,  117,  943,  944,   96, 1051, 
         1057,  648,  648,  648,  521, 1065,  275,  275,  648,   93, 
          955,   93,   96,   96,   96, 1058,  967,   93,  800, 1062, 
         1068, 1076,  540,  107,  541,  542,  543,  544,   35,   35, 
           35,   98,  298,  300,   35,   35, 1081,   35,  275,  275, 
          103,  340,  342, 1083,  117, 1085,   96,   96,  435,  641, 
          736,  369,  736,  650, 1088, 1094,  997,  107,   93,   35, 
           35,   35,   35,   35,   96, 1101,   96,  540,  934,  541, 
          542,  543,  544,  635,  107,  635,  523, 1097,  523,  636, 
         1016,  960, 1018,  384, 1019,  648,  648,  386,  387,  485, 
          637,  736,  813,   96,  268,  268,  268,  641,  641,  275, 
          268,  268,  995,  268,  316,  637,   96,  466,   35,  528, 
          529,  530,  643,  369,  697,  699,  531,  641,  319,  637, 
          637,  358,  268,  268,  472,  268,  268,  268,  268,   35, 
          976,  350,  648, 1042,  758, 1043,  436,  717,  648, 1075, 
          194, 1044,  648,  648,  879,  384,  648,  648,  908,  386, 
          387,  388,  389,   35,  699, 1055,  912,  319,   53,  780, 
          979,  863, 1063,  103,  956, 1060,   96,  893,   53,  868, 
          254,  254,  254,  792,  268,  254,  254,  254, 1059,  254, 
          115,  609, 1077,   96,  265,   96, 1080, 1074,  103,  254, 
          254,   96,  849,  403, 1079,  268,  103,  103,  254,  254, 
            0,  254,  254,  254,  254,  254,    0,    0,  528,  529, 
          533,  755,    0,  254,  103,  531,    0,   53, 1096,  268, 
         1098,    0,    0, 1099,   16,  696,  960,    0,    0,  960, 
          966,  869,   96,  960,    0,  440, 1105,    0,  528,  529, 
          533,  521,    0,    0,  440,  531,  103,  254,  521,  521, 
          254,    0,  117,  254,  110,  254,    0,    0,    0,  973, 
          275,  275,  275,  342,    0,  275,  117,  528,  529,  535, 
          242,  254,    0,   16,  531,  275,  787,  275,  275,    0, 
          242,  450,    0,  254,    0,    0,  497,  960,    0,  960, 
            0,  960,  107,    0,  960,  254,    0,    0,  103,  103, 
            0,    0,    0,  110,  103,  103,    0,  960,    0,    0, 
          808,    0,  103,  523,  242,  523,    0,  103,    0,    0, 
          523,  523,  523,  523,    0,    0,  103,    0,  242,  242, 
            0,    0, 1037,  242,  103,  516,  830,    0,  831,  546, 
            0,  316,  103,    0,  398,  699,  319,    0,  316,  316, 
          113,  399,  465,    0,  623,  107,  103,  103,  103,    0, 
          586,  587,  588,  589,  590,    0,    0,  591,  592,  593, 
          594,  595,  596,  597,  598,  599,  600,  601,  602,  603, 
          604,    0,    0,  605,  606,  607,  608,    0,  546,    0, 
          103,  103,  275,    0,  624,    0,  871,    0,  630,  113, 
          637,    0,    0,    0,  275,  630,  525,    0,  103,    0, 
          103,  663,    0,   15,    0,    0,    0,  103,    0,    0, 
           53,   53,   53,  122,  440,   53,   53,   53,  903,   53, 
            0,  519,  103,  440,    0,    0,   91,  103,    0,   53, 
            0,  275,    0,  630,  630,  630,    0,    0,  275,    0, 
          103,   53,   53,   53,   53,   53, 1010,  275,  541,  542, 
          543,  544,   15,  267,  926,  275,  275,    0,    0,  275, 
           91,    0,  440,  126,    0,    0,   16,   16,   16,  440, 
          440,  440,   16,   16,    0,   16,    0,   91,  440,  440, 
          267,  267,    0,  713,  630,  103,  267,  267,  267,  267, 
           53,    0,    0,    0,  784,  275,  440,    0,  275,    0, 
          103,  110,  528,  529,  729,  440,  275,  516,  398,  531, 
            0,   53,  126,    0,  619,  399,  500,  103,    0,  103, 
            0,    0,  242,  242,  242,  103,    0,  242,  242,  242, 
            0,  242,  972,    0,    0,   53,    0,   94,    0,  267, 
            0,  242,  242,    0,  316,    0,   16, 1040,  267,  267, 
          242,  242,  275,  242,  242,  242,  242,  242,    0,  663, 
            0,  319,  516,    0,    0,  242,  103,   16,    0,  516, 
          516,   94,    0,    0,    0,  619,    0,  242,  242,  242, 
          242,  242,    0,    0,  242,  242,  242,  242,   94,  242, 
          242,   16,    0,  242,  242,    0,  619,  113,    0,  242, 
            0,  118,  242,    0,    0,  242,   99,  242,    0,  242, 
          620,  242,    0,  242,  242,  242,  242,  275,  519,  242, 
            0,  242,    0,  242,    0,  546,    0,  546,  546,  546, 
          546,  546,    0,  398,    0,  242,  546,    0,  398,  241, 
          399,  524,    0,    0,  275,  399,  662,  242,    0,  241, 
          118,  275,    0,  524,    0,   15,   15,   15,  519,  546, 
            0,   15,   15,    0,   15,  519,  519,  546,  546,  546, 
          546,  620,  841,  842,    0,  843,    0,  275,    0,  275, 
            0,  122,  524,  241,    0,    0,  275,  275,    0,    0, 
          268,    0,  620,    0,    0,   91,  619,  241,  241,  528, 
          529,  757,  241,    0,    0,  546,  531,    0,  267,  267, 
          267,  267,    0,  267,  487,  487,  487,  268,  268,    0, 
          126,  487,    0,  268,  268,  268,  268,    0,    0,    0, 
          122,  398,  101,    0,  267,   15,    0,  275,  399,  783, 
           59,   60,    0,    0,  516,    0,    0,    0,  630,  630, 
            0,  516,  516,    0,  630,  630,   15,  619,   91,    0, 
            0,    0,  440,  896,    0,  275,    0,  630,    0,  275, 
          362,  363,  364,  365,  366,  267,  268,    0,  619,  526, 
           15,  316,    0,    0,  398,  268,  268,    0,  316,  316, 
            0,  399, 1039,  100,  623,    0,  398,    0,  630,  630, 
            0,  630,  630,  399, 1066,  275,   94,  620,  267,  267, 
          267,  267,  267,    0,    0,  267,  267,  267,  267,  267, 
          267,  267,  267,  267,  267,  267,  267,  267,  267,  269, 
            0,  267,  267,  267,  267,    0,    0,    0,    0,  269, 
          525,  118,  267,  540,    0,  541,  542,  543,  544,    0, 
          267,    0,    0,    0,    0,  519,    0,    0,  118,    0, 
            0,  968,  519,  519,    0,    0,    0,  969,  620,   94, 
            0,    0,    0,  269,    0,    0,    0,  734,    0,    0, 
            0,  102,    0,  275,    0,  735,    0,  269,  269,  620, 
          524,  267,  267,  267,    0,    0,  267,  524,  524,    0, 
            0,  241,  241,  241,    0,  969,  241,  241,  241,    0, 
          241,  291,  275,  267,  267,    0,    0,  267,    0,  524, 
          241,  241,    0,    0,    0,    0,  524,  524,  527,  241, 
          241,    0,  241,  241,  241,  241,  241,    0,  122,    0, 
           93,  267,  267,    0,  241,  268,  268,  268,  268,    0, 
          268,  440,    0,  267,    0,    0,  267,    0,    0,    0, 
          120,    0,    0,  241,  241,    0,  267,  120,  241,  241, 
            0,  268,    0,    0,    0,  440,    0,    0,  241,    0, 
            0,  241,    0,    0,  241,  440,  241,  518,  540,    0, 
          541,  542,  543,  544,    0,    0,    0,    0,    0,  440, 
            0,    0,  241,    0,    0,    0,  440,  440,    0,  120, 
          267,    0,  268,    0,  241,    0,  526,    0,    0,  103, 
            0,  275,  734,  526,  526,    0,  241,    0,  119,    0, 
          937,  119,    0,  440,  440,    0,  122,    0,  440,    0, 
            0,  526,    0,    0,    0,  268,  268,  268,  268,  268, 
          121,    0,  268,  268,  268,  268,  268,  268,  268,  268, 
          268,  268,  268,  268,  268,  268,  440,    0,  268,  268, 
          268,  268,    0,    0,    0,  267,    0,  525,    0,  268, 
          119,  105,    0,  267,  525,  525,    0,  268,    0,    0, 
            0,  269,  269,  269,    0,    0,  269,  269,  269,  121, 
          269,    0,   97,    0,   96,    0,    0,    0,    0,  267, 
          269,  269,  525,   92,    0,  105,  121,    0,    0,  269, 
          269,    0,  269,  269,  269,  269,  269,    0,  268,  268, 
          268,  527,  105,  268,  269,  267,   97,  267,   96,    0, 
            0,    0,    0,    0,  267,  267,    0,    0,    0,    0, 
          268,  268,    0,   97,  268,   96,    0,    0,    0,  267, 
          517,    0,  626,    0,    0,  527,    0,    0,  269,    0, 
            0,  269,  527,  527,  269,  112,  269,    0,  268,  268, 
            0,   95,    0,  522,    0,  521,   24,    0,    0,    0, 
          268,    0,  269,  268,    0,  267,   24,    0,    0,  516, 
            0,    0,    0,  268,  269,  206,    0,  540,    0,  541, 
          542,  543,  544,  545,    0,    0,  269,  120,  546,    0, 
            0,  267,    0,    0,  518,    0,    0,  267,  520,    0, 
          267,  518,  518,  516,    0,  109,    0,  440,  440,  440, 
          519,  547,  112,  440,  440,   24,  440,  268,  516,  549, 
          550,  551,  552,    0,  206,  440,  267,  267,    0,  267, 
          267,    0,    0,  267,    0,  440,  440,    0,  440,  440, 
          440,  440,  440,    0,  519,    0,    0,    0,  526,    0, 
          516,    0,  306,    0,  870,  526,  526,  553,  119,  519, 
            0,  112,  440,  440,  440,  440,  440,  440,  440,  440, 
          440,  440,  440,  440,  440,  440,   91,  121,  440,  440, 
          440,  440,  268,    0,    0,    0,    0,  440,    0,  267, 
          268,  519,    0,  518,  440,    0,  440,    0,  440,  440, 
          440,  440,  440,  440,  440,    0,  440,  440,  440,    0, 
            0,  267,  108,    0,    0,    0,  268,    0,  111,  525, 
          105,  626,    0,  516,  267,    0,  525,  525,    0,    0, 
            0,    0,  440,  267,    0,    0,    0,    0,  527,    0, 
          267,   97,  268,   96,  268,  527,  527,    0,    0,    0, 
          516,  268,  268,  540,    0,  541,  542,  543,  544,  317, 
          516,    0,    0,    0,    0,    0,  268,  517,    0,  626, 
            0,    0,    0,  267,  517,  517,  626,  626,    0,  963, 
            0,    0,  622,  105,    0,    0,  114,  734,    0,    0, 
          522,    0,  521,    0,  516,    0,    0,  522,  522,  521, 
          521,    0,  268,  626,   97,    0,   96,    0,  516,  516, 
            0,  110,    0,  516,    0,    0,    0,    0,   24,   24, 
           24,    0,    0,    0,   24,   24,    0,   24,  268,    0, 
            0,    0,    0,    0,  268,  520,    0,  268,    0,  619, 
          128,  516,  520,  520,  267,    0,    0,    0,    0,   24, 
           24,   24,   24,   24,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  268,  268,    0,  268,  268,    0,  112, 
          268,  206,    0,  206,  206,  206,  206,  206,    0,    0, 
          620,  519,  206,    0,    0,    0,    0,  516,    0,  306, 
            0,  519,    0,  522,  516,  516,  306,  306,   24,    0, 
          619,  522,    0,    0,    0,  206,  206,    0,    0,    0, 
            0,  110,  619,  206,  206,  206,  206,    0,  516,   24, 
            0,  619,    0,    0,  963,  519,  268,  963,  519, 1061, 
          518,  963,    0,    0,    0,  519,  519,  518,  518,  519, 
          519,  620,  113,   24,  519,    0,    0,  127,  268,    0, 
            0,  206,    0,    0,    0,    0,    0,    0,    0,  519, 
          516,  268,  620,    0,    0,    0,    0,  516,  516,    0, 
          268,    0,  519,  619,    0,    0,    0,  268,    0,    0, 
            0,    0,    0,    0,    0,  963,    0,  963,    0,  963, 
            0,    0,  963,    0,  619,    0,  317,    0,    0,    0, 
            0,  199,    0,  317,  317,  963,    0,  619,  619,  619, 
          268,  619,  516,  516,  516,  619,  619,  516,  516,  516, 
          619,  516,  619,  619,  619,  619,  619,  619,  619,    0, 
          619,  516,  516,  619,  619,  619,  619,  619,  619,  619, 
          516,  516,  619,  516,  516,  516,  516,  516,    0,  619, 
          199,    0,  619,  619,  619,  516,  619,  619,  619,  619, 
          619,  619,  619,  619,  619,  619,  619,  516,  516,  516, 
          516,  516,  516,  516,  516,  516,  516,  516,  516,  516, 
          516,  268,    0,  516,  516,  516,  516,  619,  528,  516, 
          619,  619,  516,  619,  619,  516,  619,  516,  619,  516, 
          619,  516,  619,  516,  516,  516,  516,  516,  516,  516, 
          619,  516,  619,  516,    0,  619,  619,  619,  619,  619, 
          619,    0,    0,    0,  619,  516,  619,  619,    0,  619, 
          619,  619,  619,    0,  619,  619,  619,  516,  620,  620, 
          620,    0,  620,  519,  519,  519,  620,  620,  519,  519, 
          519,  620,  519,  620,  620,  620,  620,  620,  620,  620, 
            0,  620,  519,  519,  620,  620,  620,  620,  620,  620, 
          620,  519,  519,  620,  519,  519,  519,  519,  519,    0, 
          620,    0,    0,  620,  620,  620,  519,  620,  620,  620, 
          620,  620,  620,  620,  620,  620,  620,  620,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  964,    0,  519,  519,  519,  519,  620,  531, 
          519,  620,  620,  519,  620,  620,  519,  620,  519,  620, 
          519,  620,  519,  620,  519,  519,  519,  519,  519,  519, 
          519,  620,  519,  620,  519,    0,  620,  620,  620,  620, 
          620,  620,    0,    0,  626,  620,  519,  620,  620,    0, 
          620,  620,  620,  620,  626,  620,  620,  620,  519,    0, 
            0, 1024,  635,  635,  635, 1028,    0,    0,  635,  635, 
            0,  635,    0,  636,  636,  636,    0,    0,    0,  636, 
          636,    0,  636,    0,    0,    0,    0,  199,  626,  199, 
          199,  199,  199,  199,    0,    0,    0,    0,  199,    0, 
            0,    0,  626,  626,    0,  124,    0,  626,    0,  521, 
            0,    0,    0,    0,    0,    0,    0,  521,    0,    0, 
            0,  199,  199,    0,    0,    0,    0,    0,    0,  199, 
          199,  199,  199,    0,    0,  626,    0,    0,    0,    0, 
            0,    0,  635,    0,    0,    0,    0,  964,    0,    0, 
          964,    0,  964,  636,  964,    0,  369,    0,    0,    0, 
            0, 1082,    0,  635, 1084, 1086,    0,  199, 1089, 1090, 
            0,    0,  382,  383,  636,  622,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  622,    0,  635,  384,    0, 
          385,    0,  386,  387,  388,  389,    0,    0,  636,    0, 
            0,    0, 1100, 1102, 1103, 1104,    0,    0,  964,    0, 
          964, 1106,  964,    0,    0,  964,    0,    0,  540,  622, 
          541,  542,  543,  544,  545,    0,    0,    0,  964,  546, 
            0,    0,    0,  622,  622,    0,  123,    0,  622,    0, 
            0,    0,  369,  540,    0,  541,  542,  543,  544,  545, 
            0,    0,  547,  548,  546,    0,    0,    0,  382,  383, 
          549,  550,  551,  552,    0,    0,  622,    0,    0,    0, 
            0,    0,    0,    0,  384,    0,    0,  547,  386,  387, 
          388,  389,    0,    0,    0,  549,  550,  551,  552,    0, 
            0,    0,    0,    0,    0,  209,    0,    0,  553,    0, 
            0,  622,  622,  622,    0,  622,  626,  626,  626,  622, 
          622,  626,  626,  626,  622,  626,  622,  622,  622,  622, 
          622,  622,  622,  553,  626,  626,  626,  622,  622,  622, 
          622,  622,  622,  622,  626,  626,  622,  626,  626,  626, 
          626,  626,    0,  622,  209,    0,  622,  622,  622,  626, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  626,  626,  626,  626,  626,  626,  626,  626,  626, 
          626,  626,  626,  626,  626,    0,    0,  626,  626,  626, 
          626,  622,    0,  626,  622,  622,  626,  622,  622,  626, 
          622,  626,  622,  626,  622,  626,  622,  626,  626,  626, 
          626,  626,  626,  626,  622,  626,  626,  626,    0,  622, 
          622,  622,  622,  622,  622,    0,    0,    0,  622,  626, 
          622,  622,    0,  622,  622,  622,  622,    0,  622,  622, 
          622,  626,  622,  622,  622,    0,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,    0,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,    0,  622,    0,    0,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,    0,    0,  622,  622, 
          622,  622,  622,    0,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,    0, 
          622,  622,  622,  622,  622,  622,    0,    0,  623,  622, 
          622,  622,  622,    0,  622,  622,  622,  622,  623,  622, 
          622,  622,  622,    0,    0,    0,    0,    0,    0,    0, 
          540,    0,  541,  542,  543,  544,  545,    0,    0,    0, 
            0,  546,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  209,  623,  209,  209,  209,  209,  209,    0,    0, 
            0,    0,  209,    0,  547,    0,  623,  623,    0,  125, 
            0,  623,    0,  523,  551,  552,    0,    0,    0,    0, 
            0,  523,    0,    0,    0,  209,  209,    0,    0,    0, 
            0,    0,    0,  209,  209,  209,  209,    0,    0,  623, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          553,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,  209,    0,    9,   10,    0,    0,    0,   11,  307, 
           12,   13,   14,  241,  242,   17,   18,    0,    0,  307, 
            0,   19,  243,  244,  245,  246,  247,  248,    0,    0, 
          249,    0,    0,    0,    0,    0,    0,  250,    0,    0, 
          251,  252,  253,    0,  254,   35,  255,  256,  257,  258, 
            0,   40,    0,  307,  259,    0,    0,  369,    0,    0, 
            0,    0,  374,  375,    0,    0,    0,  307,  307,    0, 
            0,    0,  307,  382,  383,  260,    0,    0,   45,    0, 
            0,   46,   47,    0,   48,    0,   49,    0,    0,  384, 
            0,  385,    0,  386,  387,  388,  389,  390,  391,  392, 
          307,  393,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,    0,    0,    0,    0,    0,  194, 
            0,    0,    0,    0,    0,  623,  623,  623,    0,  623, 
          623,  623,  623,  623,  623,  623,  623,  623,  623,  623, 
          623,  623,  623,  623,  623,  623,  623,    0,  623,  623, 
          623,  623,  623,  623,  623,  623,  623,  623,  623,  623, 
          623,  623,  623,  623,  623,  623,    0,  623,  194,    0, 
          623,  623,  623,  623,  623,  623,  623,  623,  623,  623, 
          623,  623,  623,  623,  623,  623,  623,  623,  623,  623, 
          623,  623,  623,  623,  623,  623,  623,  623,  623,    0, 
            0,  623,  623,  623,  623,  623,    0,  623,  623,  623, 
          623,  623,  623,  623,  623,  623,  623,  623,  623,  623, 
          623,  623,  623,  623,  623,  623,  623,  623,  623,  623, 
          623,  623,    0,  623,  623,  623,  623,  623,  623,    0, 
            0,    0,  623,  623,  623,  623,    0,  623,  623,  623, 
          623,    0,  623,  623,  623,  623,  621,  621,  621,    0, 
          621,  307,  307,  307,  621,  621,  307,  307,  307,  621, 
          307,  621,  621,  621,  621,  621,  621,  621,    0,  621, 
          307,  307,  621,  621,  621,  621,  621,  621,  621,  307, 
          307,  621,  307,  307,  307,  307,  307,    0,  621,    0, 
            0,  621,  621,  621,  307,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  307,  307,  307,  307, 
          307,  307,  307,  307,  307,  307,  307,  307,  307,  307, 
            0,    0,  307,  307,  307,  307,  621,    0,  307,  621, 
          621,  307,  621,  621,  307,  621,  307,  621,  307,  621, 
          307,  621,  307,  307,  307,  307,  307,  307,  307,  621, 
          307,  621,  307,    0,  621,  621,  621,  621,  621,  621, 
            0,    0,  627,  621,  307,  621,  621,    0,  621,  621, 
          621,  621,  627,  621,  621,  621,  307,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  194,  627,  194,  194,  194, 
          194,  194,    0,    0,    0,    0,  194,    0,    0,    0, 
          627,  627,    0,    0,    0,  627,    0,  524,  369,  370, 
          371,  372,  373,  374,  375,  524,    0,  378,  379,  194, 
          194,    0,    0,    0,  382,  383,    0,  194,  194,  194, 
          194,    0,    0,  627,    0,    0,    0,    0,    0,    0, 
          384,    0,  385,    0,  386,  387,  388,  389,  390,  391, 
          392,    0,  393,    0,    0,    0,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,  194,    0,    9,   10,    0, 
            0,    0,   11,  628,   12,   13,   14,  241,  242,   17, 
           18,    0,    0,  628,    0,   19,  243,  244,  323,  324, 
          325,  326,    0,    0,  249,    0,    0,    0,    0,    0, 
            0,  250,    0,    0,  327,  328,  329,    0,  330,   35, 
          331,  332,  333,  334,    0,   40,    0,  628,  259,    0, 
            0,  369,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  628,  628,    0,    0,    0,  628,  382,  383,  335, 
            0,    0,  410,    0,    0,   46,   47,    0,   48,    0, 
          411,    0,    0,  384,    0,  385,    0,  386,  387,  388, 
          389,    0,    0,  392,  628,  393,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,    0,    0, 
            0,    0,    0,  176,    0,    0,    0,    0,    0,  624, 
          624,  624,    0,  624,  627,  627,  627,  624,  624,  627, 
          627,  627,  624,  627,  624,  624,  624,  624,  624,  624, 
          624,    0,  627,  627,  627,  624,  624,  624,  624,  624, 
          624,  624,  627,  627,  624,  627,  627,  627,  627,  627, 
            0,  624,  176,    0,  624,  624,  624,  627,  624,  624, 
          624,  624,  624,  624,  624,  624,  624,  624,  624,  627, 
          627,  627,  627,  627,  627,  627,  627,  627,  627,  627, 
          627,  627,  627,    0,    0,  627,  627,  627,  627,  624, 
            0,  627,  624,  624,  627,  624,  624,  627,  624,  627, 
          624,  627,  624,  627,  624,  627,  627,  627,  627,  627, 
          627,  627,  624,  627,  627,  627,    0,  624,  624,  624, 
          624,  624,  624,    0,    0,    0,  624,  627,  624,  624, 
            0,  624,  624,  624,  624,    0,  624,  624,  624,  627, 
          625,  625,  625,    0,  625,  628,  628,  628,  625,  625, 
          628,  628,  628,  625,  628,  625,  625,  625,  625,  625, 
          625,  625,    0,  628,  628,  628,  625,  625,  625,  625, 
          625,  625,  625,  628,  628,  625,  628,  628,  628,  628, 
          628,  394,  625,    0,    0,  625,  625,  625,  628,  625, 
          625,  625,  625,  625,  625,  625,  625,  625,  625,  625, 
          628,  628,  628,  628,  628,  628,  628,  628,  628,  628, 
          628,  628,  628,  628,    0,    0,  628,  628,  628,  628, 
          625,    0,  628,  625,  625,  628,  625,  625,  628,  625, 
          628,  625,  628,  625,  628,  625,  628,  628,  628,  628, 
          628,  628,  628,  625,  628,  628,  628,    0,  625,  625, 
          625,  625,  625,  625,    0,    0,  316,  625,  628,  625, 
          625,    0,  625,  625,  625,  625,  316,  625,  625,  625, 
          628,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  176, 
          316,  176,  176,  176,  176,  176,    0,    0,    0,    0, 
          176,    0,    0,    0,  316,  316,    0,  126,    0,  316, 
            0,  526,    0,    0,    0,    0,    0,    0,    0,  526, 
            0,    0,    0,  176,  176,    0,    0,    0,    0,    0, 
            0,  176,  176,  176,  176,    0,    0,  316,    0,    0, 
            0,    0,  369,  370,  371,  372,  373,  374,  375,  376, 
          377,  378,  379,    0,    0,    0,    0,    0,  382,  383, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  176, 
            0,    0,    0,    0,  384,    0,  385,  439,  386,  387, 
          388,  389,  390,  391,  392,    0,  393,  439,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  782,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  439,    0,    0,    0,  369,  370,  371,  372,  373, 
          374,  375,  376,  377,  378,  379,  439,  380,  381,    0, 
          439,  382,  383,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  384,    0,  385, 
            0,  386,  387,  388,  389,  390,  391,  392,  439,  393, 
            0,    0,    0,    0,    0,    0,  177,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  623,  623,  623,    0,  623,  316,  316, 
          316,  623,  623,  316,  316,  316,  623,  316,  623,  623, 
          623,  623,  623,  623,  623,  177,    0,  316,  316,  623, 
          623,  623,  623,  623,  623,  623,  316,  316,  623,  316, 
          316,  316,  316,  316,    0,  623,    0,    0,  623,  623, 
          623,  316,  623,  623,  623,  623,  623,  623,  623,  623, 
          623,  623,  623,  316,  316,  316,  316,  316,  316,  316, 
          316,  316,  316,  316,  316,  316,  316,   94,    0,  316, 
          316,  316,  316,  623,    0,  316,  623,  623,  316,  623, 
          623,  316,  623,  316,  623,  316,  623,  316,  623,  316, 
          316,  316,  316,  316,  316,  316,  623,  316,    0,  316, 
            0,  623,  623,  623,  623,  623,  623,    0,    0,    0, 
          623,  316,  623,  623,  519,  623,  623,  623,  623,    0, 
          623,  623,  623,  316,  283,  283,  283,    0,  283,  439, 
          439,  439,  283,  283,  439,  439,  439,  283,  439,  283, 
          283,  283,  283,  283,  283,  283,  394,  439,  439,  439, 
          283,  283,  283,  283,  283,  283,  283,  439,  439,  283, 
          439,  439,  439,  439,  439,    0,  283,    0,    0,  283, 
          283,  283,    0,  283,  283,  283,  283,  283,  283,  283, 
          283,  283,  283,  283,  439,  439,  439,  439,  439,  439, 
          439,  439,  439,  439,  439,  439,  439,  439,  648,    0, 
          439,  439,  439,  439,  283,    0,  439,  283,  648,  439, 
          283,  283,  439,  283,  439,  283,  439,  283,  439,  283, 
          439,  439,  439,  439,  439,  439,  439,  283,  439,  439, 
          439,    0,  283,  283,  283,  283,  283,  283,    0,    0, 
            0,  283,  648,  283,  283,    0,  283,  283,  283,  283, 
            0,  283,  283,  283,  439,    0,    0,  648,    0,    0, 
            0,  648,  177,    0,  177,  177,  177,  177,  177,    0, 
            0,    0,    0,  177,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  525,    0,    0,    0,    0,  648, 
            0,    0,  525,    0,    0,    0,  177,  177,    0,    0, 
            0,    0,  113,  620,  177,  177,  177,  177,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  323, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  323, 
            0,    0,  177,    0,    0,    0,    0,    0,    0,    0, 
            0,  519,    0,    0,    0,    0,    0,    0,  519,  519, 
            0,    0,    0,    0,  620,    0,    0,    0,    0,    0, 
            0,    0,    0,  323,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  620,    0,    0,  323,    0, 
            0,    0,  323,    0,    0,    0,    0,    0,    0,    0, 
          369,  370,  371,  372,  373,  374,  375,  376,  377,  378, 
          379,    0,  380,  381,    0,    0,  382,  383,    0,    0, 
          323,    0,    0,    0,    0,    0,    0,    0,  178,    0, 
            0,    0,  384,    0,  385,    0,  386,  387,  388,  389, 
          390,  391,  392,    0,  393,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  283,  283,  283,    0,  283, 
          648,  648,  648,  283,  283,  648,  648,  648,  283,  648, 
          283,  283,  283,  283,  283,  283,  283,  178,  648,  648, 
          648,  283,  283,  283,  283,  283,  283,  283,  648,  648, 
          283,  648,  648,  648,  648,  648,    0,  283,    0,    0, 
          283,  283,  283,    0,  283,  283,  283,  283,  283,  283, 
          283,  283,  283,  283,  283,  648,  648,  648,  648,  648, 
          648,  648,  648,  648,  648,  648,  648,  648,  648,  105, 
            0,  648,  648,  648,  648,  283,    0,  648,  283,    0, 
          648,  283,  283,  648,  283,  648,  283,  648,  283,  648, 
          283,  648,  648,  648,  648,  648,  648,  648,  283,  648, 
          648,  648,    0,  283,  283,  283,  283,  283,  283,    0, 
            0,    0,  283,    0,  283,  283,  626,  283,  283,  283, 
          283,    0,  283,  283,  283,  648,  283,  283,  283,    0, 
          283,  323,  323,  323,  283,  283,  323,  323,  323,  283, 
          323,  283,  283,  283,  283,  283,  283,  283,    0,    0, 
          323,  323,  283,  283,  283,  283,  283,  283,  283,  323, 
          323,  283,  323,  323,  323,  323,  323,    0,  283,    0, 
            0,  283,  283,  283,    0,  283,  283,  283,  283,  283, 
          283,  283,  283,  283,  283,  283,  323,  323,  323,  323, 
          323,  323,  323,  323,  323,  323,  323,  323,  323,  323, 
          516,    0,  323,  323,  323,  323,  283,    0,  323,  283, 
          516,  323,  283,  283,  323,  283,  323,  283,  323,  283, 
          323,  283,  323,  323,  323,  323,  323,  323,  323,  283, 
          323,    0,  323,    0,  283,  283,  283,  283,  283,  283, 
            0,    0,    0,  283,   91,  283,  283,    0,  283,  283, 
          283,  283,    0,  283,  283,  283,  323,    0,    0,  516, 
            0,  110,    0,  516,  178,    0,  178,  178,  178,  178, 
          178,    0,    0,    0,    0,  178,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  527,    0,    0,    0, 
            0,  516,    0,    0,  527,    0,    0,    0,  178,  178, 
            0,    0,    0,    0,  124,  626,  178,  178,  178,  178, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  519,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  519,    0,    0,  178,    0,    0,    0,    0,    0, 
            0,    0,    0,  626,    0,    0,    0,    0,    0,    0, 
          626,  626,    0,    0,    0,    0,  622,    0,    0,    0, 
            0,    0,    0,    0,    0,   94,    0,    0,    0,  369, 
          370,  371,  372,  373,  374,  375,  376,  626,  378,  379, 
          519,    0,  113,    0,  519,  382,  383,    0,    0,    0, 
            0,   98,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  384,    0,  385,    0,  386,  387,  388,  389,  390, 
          391,  392,  519,  393,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   98,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  134,   98,    0,    0,    0,    0,  619,  619,  619, 
            0,  619,  516,  516,  516,  619,  619,    0,  516,  516, 
          619,  516,  619,  619,  619,  619,  619,  619,  619,    0, 
          619,    0,  523,  619,  619,  619,  619,  619,  619,  619, 
          516,  516,  619,  516,  516,  516,  516,  516,  135,  619, 
          134,    0,  619,  619,  619,    0,  619,  619,  619,  619, 
          619,  619,  619,  619,  619,  619,  619,  516,  516,  516, 
          516,  516,  516,  516,  516,  516,  516,  516,  516,  516, 
          516,    0,    0,  516,  516,  516,  516,  619,  528,    0, 
          619,  619,  516,  619,  619,    0,  619,  135,  619,  516, 
          619,  516,  619,  516,  516,  516,  516,  516,  516,  516, 
          619,  516,  619,  516,    0,  619,  619,  619,  619,  619, 
          619,    0,    0,    0,  619,    0,  619,  619,    0,  619, 
          619,  619,  619,    0,  619,  619,  619,  516,  620,  620, 
          620,    0,  620,  519,  519,  519,  620,  620,    0,  519, 
          519,  620,  519,  620,  620,  620,  620,  620,  620,  620, 
            0,  620,    0,    0,  620,  620,  620,  620,  620,  620, 
          620,  519,  519,  620,  519,  519,  519,  519,  519,    0, 
          620,  104,    0,  620,  620,  620,    0,  620,  620,  620, 
          620,  620,  620,  620,  620,  620,  620,  620,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,    0,    0,  519,  519,  519,  519,  620,  531, 
           98,  620,  620,  519,  620,  620,    0,  620,  622,  620, 
          519,  620,  519,  620,  519,  519,  519,  519,  519,  519, 
          519,  620,  519,  620,  519,    0,  620,  620,  620,  620, 
          620,  620,    0,    0,  626,  620,    0,  620,  620,    0, 
          620,  620,  620,  620,  626,  620,  620,  620,  519,  523, 
            0,    0,    0,    0,    0,    0,  523,  523,    0,    0, 
            0,    0,    0,   98,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  134,  105,  134, 
          134,  134,  134,  134,    0,    0,    0,    0,  134,    0, 
            0,    0,    0,  626,    0,  124,    0,  626,    0,  516, 
            0,    0,    0,    0,    0,    0,    0,  516,    0,    0, 
            0,  134,  134,    0,    0,    0,    0,    0,    0,  134, 
          134,  134,  134,    0,  135,  626,  135,  135,  135,  135, 
          135,    0,    0,    0,    0,  135,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  519,    0,    0,    0, 
            0,    0,    0,    0,  519,    0,    0,  134,  135,  135, 
            0,    0,    0,    0, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

            0,  622,  135,  135,  135,  135,    0,    0,    0,    0, 
            0,  622,    0,    0,   99,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  123,  622,    0,    0,    0,    0,    0,    0, 
          135,    0,    0,    0,    0,  104,    0,    0,   99,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          622,    0,  123,    0,  622,   99,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  622,    0,    0,    0,    0,    0,    0,  622,  622, 
            0,    0,  622,    0,  622,  524,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  622,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  622,  622,  622, 
            0,  622,  626,  626,  626,  622,  622,    0,  626,  626, 
          622,  626,  622,  622,  622,  622,  622,  622,  622,    0, 
          626,    0,    0,  622,  622,  622,  622,  622,  622,  622, 
          626,  626,  622,  626,  626,  626,  626,  626,    0,  622, 
          106,    0,  622,  622,  622,    0,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  626,  626,  626, 
          626,  626,  626,  626,  626,  626,  626,  626,  626,  626, 
          626,    0,    0,  626,  626,  626,  626,  622,    0,    0, 
          622,  622,  626,  622,  622,    0,  622,  623,  622,  626, 
          622,  626,  622,  626,  626,  626,  626,  626,  626,  626, 
          622,  626,  626,  626,    0,  622,  622,  622,  622,  622, 
          622,    0,    0,    0,  622,    0,  622,  622,    0,  622, 
          622,  622,  622,    0,  622,  622,  622,  626,  622,  622, 
          622,    0,  622,  622,  622,  622,  622,  622,    0,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
            0,  622,    0,   99,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,    0, 
          622,    0,    0,  622,  622,  622,    0,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  524,    0,  622,  622,  622,  622,  622,  524, 
          524,  622,  622,  622,  622,  622,   99,  622,    0,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,    0,  622,  622,  622,  622, 
          622,  622,    0,    0,  623,  622,    0,  622,  622,    0, 
          622,  622,  622,  622,  623,  622,  622,  622,  622,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  125,  623,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  106,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  623,    0,  125,    0,  623,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  623,    0,    0,    0,    0,    0, 
            0,  623,  623,    0,    0,  623,    0,  623,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  610,  611,    0,    0,  612,    0,    0,  623,  160, 
          161,    0,  162,  163,  164,  165,  166,  167,  168,    0, 
            0,  169,  170,    0,    0,  626,  171,  172,  173,  174, 
            0,    0,    0,    0,    0,  626,  287,    0,  101,    0, 
            0,    0,    0,  176,  177,    0,  178,  179,  180,  181, 
          182,  183,  184,  185,  186,  187,  188,    0,    0,  189, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  626, 
            0,    0,  101,    0,    0,    0,    0,    0,    0,    0, 
            0,  190,    0,    0,  626,    0,  124,    0,  626,  101, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  626,    0,    0,  526, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  623,  623,  623,    0,  623,  623,  623,  623,  623, 
          623,    0,  623,  623,  623,  623,  623,  623,  623,  623, 
          623,  623,  623,    0,  623,    0,    0,  623,  623,  623, 
          623,  623,  623,  623,  623,  623,  623,  623,  623,  623, 
          623,  623,    0,  623,    0,    0,  623,  623,  623,    0, 
          623,  623,  623,  623,  623,  623,  623,  623,  623,  623, 
          623,  623,  623,  623,  623,  623,  623,  623,  623,  623, 
          623,  623,  623,  623,  623,    0,    0,  623,  623,  623, 
          623,  623,    0,    0,  623,  623,  623,  623,  623,    0, 
          623,    0,  623,  623,  623,  623,  623,  623,  623,  623, 
          623,  623,  623,  623,  623,  623,  623,  623,    0,  623, 
          623,  623,  623,  623,  623,    0,    0,    0,  623,    0, 
          623,  623,    0,  623,  623,  623,  623,    0,  623,  623, 
          623,  623,  622,  622,  622,    0,  622,  626,  626,  626, 
          622,  622,    0,  626,  626,  622,  626,  622,  622,  622, 
          622,  622,  622,  622,    0,  626,    0,  101,  622,  622, 
          622,  622,  622,  622,  622,  626,  626,  622,  626,  626, 
          626,  626,  626,    0,  622,    0,    0,  622,  622,  622, 
            0,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  626,  626,  626,  626,  626,  626,  626,  626, 
          626,  626,  626,  626,  626,  626,  526,    0,  626,  626, 
          626,  626,  622,  526,  526,  622,  622,  626,  622,  622, 
          101,  622,    0,  622,  626,  622,  626,  622,  626,  626, 
          626,  626,  626,  626,  626,  622,  626,  626,  626,    0, 
          622,  622,  622,  622,  622,  622,    0,    0,  622,  622, 
            0,  622,  622,    0,  622,  622,  622,  622,  622,  622, 
          622,  622,  626,    0,    0,    0,    0,    0,    0,    0, 
          618,  619,    0,    0,  620,    0,    0,    0,  160,  161, 
            0,  162,  163,  164,  165,  166,  167,  168,    0,    0, 
          169,  170,  622,    0,    0,  171,  172,  173,  174,    0, 
            0,    0,    0,    0,    0,  287,    0,  622,    0,  123, 
            0,  622,  176,  177,    0,  178,  179,  180,  181,  182, 
          183,  184,  185,  186,  187,  188,    0,    0,  189,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  622, 
            0,    0,    0,    0,    0,    0,    0,    0,  675,  611, 
          190,    0,  676,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,  166,  167,  168,    0,    0,  169,  170, 
            0,    0,    0,  171,  172,  173,  174,    0,    0,  623, 
            0,    0,    0,  287,    0,    0,    0,    0,    0,  623, 
          176,  177,  100,  178,  179,  180,  181,  182,  183,  184, 
          185,  186,  187,  188,  678,  619,  189,    0,  679,    0, 
            0,    0,  160,  161,    0,  162,  163,  164,  165,  166, 
          167,  168,    0,  623,  169,  170,  100,    0,  190,  171, 
          172,  173,  174,    0,    0,    0,    0,    0,  623,  287, 
          125,    0,  623,  100,    0,    0,  176,  177,    0,  178, 
          179,  180,  181,  182,  183,  184,  185,  186,  187,  188, 
            0,    0,  189,    0,    0,    0,    0,    0,    0,    0, 
          623,    0,    0,  525,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  190,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  622,  622,  622,    0,  622, 
          622,  622,  622,  622,  622,    0,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,    0,  622,    0, 
            0,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,    0,  622,    0,    0, 
          622,  622,  622,    0,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,    0, 
            0,  622,  622,  622,  622,  622,    0,    0,  622,  622, 
          622,  622,  622,    0,  622,    0,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,    0,  622,  622,  622,  622,  622,  622,    0, 
            0,    0,  622,    0,  622,  622,    0,  622,  622,  622, 
          622,    0,  622,  622,  622,  622,  623,  623,  623,    0, 
          623,  623,  623,  623,  623,  623,    0,  623,  623,  623, 
          623,  623,  623,  623,  623,  623,  623,  623,    0,  623, 
            0,  100,  623,  623,  623,  623,  623,  623,  623,  623, 
          623,  623,  623,  623,  623,  623,  623,    0,  623,    0, 
            0,  623,  623,  623,    0,  623,  623,  623,  623,  623, 
          623,  623,  623,  623,  623,  623,  623,  623,  623,  623, 
          623,  623,  623,  623,  623,  623,  623,  623,  623,  623, 
          525,    0,  623,  623,  623,  623,  623,  525,  525,  623, 
          623,  623,  623,  623,  100,  623,    0,  623,  623,  623, 
          623,  623,  623,  623,  623,  623,  623,  623,  623,  623, 
          623,  623,  623,    0,  623,  623,  623,  623,  623,  623, 
            0,    0,  316,  623,    0,  623,  623,    0,  623,  623, 
          623,  623,  316,  623,  623,  623,  623,    0,    0,    0, 
            0,    0,    0,    0,  688,  611,    0,    0,  689,    0, 
            0,    0,  160,  161,    0,  162,  163,  164,  165,  166, 
          167,  168,    0,    0,  169,  170,  107,    0,    0,  171, 
          172,  173,  174,    0,    0,    0,    0,    0,    0,  287, 
            0,  316,    0,  126,    0,  316,  176,  177,    0,  178, 
          179,  180,  181,  182,  183,  184,  185,  186,  187,  188, 
            0,    0,  189,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  316,    0,    0,    0,    0,    0,    0, 
            0,    0,  692,  619,  190,    0,  693,    0,    0,    0, 
          160,  161,    0,  162,  163,  164,  165,  166,  167,  168, 
            0,    0,  169,  170,    0,    0,    0,  171,  172,  173, 
          174,    0,    0,  316,    0,    0,    0,  287,    0,    0, 
            0,    0,    0,  316,  176,  177,  102,  178,  179,  180, 
          181,  182,  183,  184,  185,  186,  187,  188,  721,  611, 
          189,    0,  722,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,  166,  167,  168,    0,  316,  169,  170, 
          102,    0,  190,  171,  172,  173,  174,    0,    0,    0, 
            0,    0,  316,  287,  126,    0,  316,  102,    0,    0, 
          176,  177,    0,  178,  179,  180,  181,  182,  183,  184, 
          185,  186,  187,  188,    0,    0,  189,    0,    0,    0, 
            0,    0,    0,    0,  316,    0,    0,  527,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  190,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  623, 
          623,  623,    0,  623,  316,  316,  316,  623,  623,    0, 
          316,  316,  623,  316,  623,  623,  623,  623,  623,  623, 
          623,    0,    0,    0,    0,  623,  623,  623,  623,  623, 
          623,  623,  316,  316,  623,  316,  316,  316,  316,  316, 
            0,  623,    0,    0,  623,  623,  623,    0,  623,  623, 
          623,  623,  623,  623,  623,  623,  623,  623,  623,  316, 
          316,  316,  316,  316,  316,  316,  316,  316,  316,  316, 
          316,  316,  316,    0,    0,  316,  316,  316,  316,  623, 
            0,    0,  623,  623,  316,  623,  623,    0,  623,    0, 
          623,  316,  623,  316,  623,  316,  316,  316,  316,  316, 
          316,  316,  623,  316,    0,  316,    0,  623,  623,  623, 
          623,  623,  623,    0,    0,  648,  623,    0,  623,  623, 
            0,  623,  623,  623,  623,  648,  623,  623,  623,  316, 
          623,  623,  623,    0,  623,  316,  316,  316,  623,  623, 
            0,  316,  316,  623,  316,  623,  623,  623,  623,  623, 
          623,  623,    0,    0,    0,  102,  623,  623,  623,  623, 
          623,  623,  623,  316,  316,  623,  316,  316,  316,  316, 
          316,    0,  623,    0,  648,  623,  623,  623,    0,  623, 
          623,  623,  623,  623,  623,  623,  623,  623,  623,  623, 
          316,  316,  316,  316,  316,  316,  316,  316,  316,  316, 
          316,  316,  316,  316,  527,    0,  316,  316,  316,  316, 
          623,  527,  527,  623,  623,  316,  623,  623,  102,  623, 
            0,  623,  316,  623,  316,  623,  316,  316,  316,  316, 
          316,  316,  316,  623,  316,    0,  316,    0,  623,  623, 
          623,  623,  623,  623,    0,    0,  440,  623,    0,  623, 
          623,    0,  623,  623,  623,  623,  440,  623,  623,  623, 
          316,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  104,    0, 
          440,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  440,  440,    0,  122,    0,  440, 
            0,    0,    0,  626,    0,    0,    0,    0,    0,    0, 
            0,    0,  104,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  440,    0,  104, 
            0,    0,    0,    0,    0,    0,    0,  626,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  626,    0,    0,    0,    0,    0,    0,  622, 
            0,    0,  283,  283,  283,    0,  283,  648,  648,  648, 
          283,  283,  648,  648,  648,  283,  648,  283,  283,  283, 
          283,  283,  283,  283,  626,  648,  648,    0,  283,  283, 
          283,  283,  283,  283,  283,  648,  648,  283,  648,  648, 
          648,  648,  648,    0,  283,    0,    0,  283,  283,  283, 
            0,  283,  283,  283,  283,  283,  283,  283,  283,  283, 
          283,  283,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  648,    0,    0,    0,    0,    0,    0, 
          648,  648,  283,    0,    0,  283,    0,  648,  283,  283, 
            0,  283,  522,  283,    0,  283,    0,  283,    0,    0, 
            0,    0,  522,    0,    0,  283,    0,  648,  648,    0, 
          283,  283,  283,  283,  283,  283,    0,    0,    0,  283, 
            0,  283,  283,    0,  283,  283,  283,  283,    0,  283, 
          283,  283,  648,    0,    0,    0,  522,    0,  440,  440, 
          440,    0,    0,  440,  440,  440,    0,  440,    0,    0, 
          522,  522,    0,  116,    0,  522,  440,  440,  440,    0, 
            0,    0,    0,    0,    0,    0,  440,  440,    0,  440, 
          440,  440,  440,  440,    0,    0,    0,    0,    0,    0, 
            0,  440,    0,  522,    0,    0,    0,  104,  622,    0, 
            0,    0,    0,  440,  440,  440,  440,  440,  440,  440, 
          440,  440,  440,  440,  440,  440,  440,    0,    0,  440, 
          440,  440,  440,  626,  521,  440,    0,    0,  440,    0, 
            0,  440,    0,  440,  521,  440,    0,  440,    0,  440, 
          440,  440,  440,  440,  440,  440,  622,  440,  440,  440, 
            0,    0,    0,  622,  622,    0,    0,    0,    0,  622, 
          104,  440,    0,    0,    0,    0,    0,    0,  521,    0, 
            0,  626,    0,  440,    0,    0,    0,    0,  626,  626, 
          622,    0,  521,  521,  622,  115,    0,  521,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  626,    0,    0,  626,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  521,    0,    0,    0,  111, 
            0,    0,    0,    0,    0,    0,    0,    0,  106,    0, 
            0,    0,  293,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  293,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  106,    0,  522,  522,  522,  114,  111,  522, 
          522,  522,    0,  522,    0,    0,  288,    0,    0,  106, 
            0,    0,    0,  522,  522,    0,    0,    0,    0,    0, 
            0,  293,  522,  522,    0,  522,  522,  522,  522,  522, 
          517,    0,    0,    0,    0,    0,    0,  522,  523,  623, 
            0,    0,    0,    0,    0,    0,  114,    0,  523,  522, 
          522,  522,  522,  522,  522,  522,  522,  522,  522,  522, 
          522,  522,  522,    0,    0,  522,  522,  522,  522,    0, 
          534,  522,    0,    0,  522,    0,    0,  522,  520,  522, 
            0,  522,  523,  522,    0,  522,  522,  522,  522,  522, 
          522,  522,    0,  522,    0,  522,  523,  523,    0,  117, 
            0,  523,    0,    0,    0,    0,    0,  522,    0,    0, 
            0,    0,    0,    0,    0,    0,  521,  521,  521,  522, 
            0,  521,  521,  521,    0,  521,    0,    0,    0,  523, 
            0,    0,    0,    0,    0,  521,  521,    0,    0,    0, 
            0,    0,    0,    0,  521,  521,    0,  521,  521,  521, 
          521,  521,    0,    0,    0,    0,    0,    0,    0,  521, 
          524,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          524,  521,  521,  521,  521,  521,  521,  521,  521,  521, 
          521,  521,  521,  521,  521,    0,    0,  521,  521,  521, 
          521,    0,  533,  521,    0,    0,  521,    0,    0,  521, 
            0,  521,    0,  521,  524,  521,  111,  521,  521,  521, 
          521,  521,  521,  521,    0,  521,    0,  521,  524,  524, 
            0,  118,    0,  524,  293,  293,  293,  106,  623,  521, 
          293,  293,    0,  293,    0,    0,    0,    0,    0,    0, 
            0,  521,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  524,    0,    0,  114,  293,  293,  293,  293,  293, 
            0,    0,    0,    0,    0,   93,    0,  517,   44,  128, 
            0,    0,    0,    0,  517,  517,  623,    0,   44,    0, 
            0,    0,    0,  623,  623,    0,    0,    0,    0,  623, 
          106,    0,    0,    0,    0,    0,    0,    0,    0,   93, 
          523,  523,  523,    0,  293,  523,  523,  523,    0,  523, 
          623,    0,    0,    0,    0,  520,   93,    0,  128,  523, 
          523,    0,  520,  520,    0,  293,    0,   44,  523,  523, 
            0,  523,  523,  523,  523,  523,    0,    0,    0,    0, 
            0,    0,    0,  523,  526,    0,  518,    0,    0,  293, 
          306,    0,    0,    0,  526,  523,  523,  523,  523,  523, 
          523,  523,  523,  523,  523,  523,  523,  523,  523,    0, 
            0,  523,  523,  523,  523,    0,  535,  523,    0,    0, 
          523,    0,    0,  523,    0,  523,    0,  523,  526,  523, 
            0,  523,  523,  523,  523,  523,  523,  523,    0,  523, 
            0,  523,  526,  526,    0,  120,    0,  526,    0,    0, 
            0,    0,    0,  523,    0,    0,    0,    0,    0,    0, 
            0,    0,  524,  524,  524,  523,    0,  524,  524,  524, 
            0,  524,    0,    0,    0,  526,    0,    0,    0,    0, 
            0,  524,  524,    0,    0,    0,    0,    0,    0,    0, 
          524,  524,    0,  524,  524,  524,  524,  524,    0,    0, 
            0,    0,    0,    0,    0,  524,  525,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  525,  524,  524,  524, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,  524, 
          524,    0,    0,  524,  524,  524,  524,    0,  536,  524, 
            0,    0,  524,    0,    0,  524,    0,  524,    0,  524, 
          525,  524,    0,  524,  524,  524,  524,  524,  524,  524, 
            0,  524,  127,  524,  525,  525,  128,  119,    0,  525, 
           44,   44,   44,    0,   93,  524,   44,   44,    0,   44, 
          124,    0,    0,    0,    0,    0,    0,  524,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  525,    0,    0, 
            0,   44,   44,   44,   44,   92,    0,    0,    0,    0, 
            0,  127,    0,    0,    0,  123,    0,    0,    0,    0, 
            0,    0,    0,  518,    0,    0,    0,  306,    0,  124, 
          518,  518,    0,    0,  306,  306,    0,   93,    0,   92, 
            0,    0,    0,  317,    0,    0,  526,  526,  526,    0, 
           44,  526,  526,  526,    0,  526,   92,    0,    0,    0, 
            0,  626,    0,    0,  123,  526,  526,    0,    0,    0, 
            0,   44,    0,    0,  526,  526,    0,  526,  526,  526, 
          526,  526,    0,    0,    0,    0,  517,    0,    0,  526, 
          527,    0,    0,    0,    0,   44,  622,    0,    0,    0, 
          527,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,    0,    0,  526,  526,  526, 
          526,    0,  538,  526,    0,    0,  526,    0,    0,  526, 
            0,  526,    0,  526,  527,  526,    0,  526,  526,  526, 
          526,  526,  526,  526,    0,  526,    0,  526,  527,  527, 
            0,  121,    0,  527,    0,    0,    0,    0,    0,  526, 
            0,    0,    0,    0,    0,    0,    0,    0,  525,  525, 
          525,  526,    0,  525,  525,  525,    0,  525,    0,    0, 
            0,  527,    0,    0,    0,    0,    0,  525,  525,    0, 
            0,    0,    0,    0,    0,    0,  525,  525,    0,  525, 
          525,  525,  525,  525,    0,    0,    0,    0,    0,    0, 
            0,  525,  518,    0,    0,    0,    0,    0,    0,  127, 
            0,    0,  518,  525,  525,  525,  525,  525,  525,  525, 
          525,  525,  525,  525,  525,  525,  525,  124,    0,  525, 
          525,  525,  525,    0,  537,  525,    0,    0,  525,    0, 
          626,  525,    0,  525,    0,  525,  518,  525,    0,  525, 
          525,  525,  525,  525,  525,  525,    0,  525,    0,  525, 
          518,  518,  123,  112,   92,  518,    0,    0,    0,    0, 
          317,  525,    0,    0,    0,  622,    0,  317,  317,    0, 
            0,    0,    0,  525,    0,    0,    0,    0,  626,    0, 
            0,    0,    0,  518,    0,  626,  626,    0,    0,    0, 
            0,  622,    0,    0,    0,    0,    0,   95,    0,    0, 
            0,  125,    0,  517,    0,    0,    0,    0,    0,    0, 
          517,  517,  626,  622,    0,    0,    0,   92,    0,    0, 
          622,  622,    0,    0,    0,    0,  622,    0,    0,    0, 
            0,   95,  527,  527,  527,    0,    0,  527,  527,  527, 
            0,  527,    0,    0,    0,    0,    0,  622,   95,    0, 
          125,  527,  527,    0,    0,    0,    0,    0,    0,    0, 
          527,  527,    0,  527,  527,  527,  527,  527,    0,    0, 
            0,    0,    0,    0,    0,  527,  517,    0,  520,    0, 
            0,    0,  623,    0,    0,    0,  517,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,    0,    0,  527,  527,  527,  527,    0,  539,  527, 
            0,    0,  527,    0,    0,  527,    0,  527,  109,  527, 
          517,  527,    0,  527,  527,  527,  527,  527,  527,  527, 
            0,  527,    0,  527,  517,  517,    0,  111,    0,  517, 
            0,    0,    0,    0,    0,  527,    0,    0,    0,    0, 
            0,    0,  109,    0,  518,  518,  518,  527,    0,  518, 
          518,  518,    0,  518,    0,    0,    0,  517,    0,  109, 
            0,    0,    0,  518,  518,    0,    0,    0,    0,    0, 
            0,    0,  518,  518,    0,  518,  518,  518,  518,  518, 
            0,    0,    0,    0,    0,    0,    0,  518,  520,  306, 
            0,    0,    0,    0,    0,    0,    0,    0,  520,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,    0,    0,  518,  518,  518,  518,    0, 
          530,  518,    0,    0,  518,    0,    0,  518,    0,  518, 
          108,  518,  520,  518,    0,  518,  518,  518,  518,  518, 
          518,  518,    0,  518,    0,  518,  520,  520,  125,  114, 
            0,  520,    0,    0,    0,    0,   95,  518,    0,    0, 
            0,  623,    0,    0,  108,    0,    0,    0,    0,  518, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  520, 
            0,  108,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  520,    0,    0,    0,  623, 
            0,  317,  520,  520,    0,    0,  623,  623,    0,   95, 
            0,    0,  623,    0,    0,    0,    0,    0,  517,  517, 
          517,    0,    0,  517,  517,  517,    0,  517,    0,    0, 
            0,    0,    0,  623,    0,    0,    0,  517,  517,    0, 
            0,    0,    0,    0,    0,    0,  517,  517,    0,  517, 
          517,  517,  517,  517,    0,    0,    0,    0,    0,    0, 
            0,  517,  439,    0,    0,    0,    0,  109,    0,    0, 
            0,    0,  439,  517,  517,  517,  517,  517,  517,  517, 
          517,  517,  517,  517,  517,  517,  517,    0,    0,  517, 
          517,  517,  517,    0,  529,  517,    0,    0,  517,    0, 
            0,  517,    0,  517,    0,  517,  439,  517,    0,  517, 
          517,  517,  517,  517,  517,  517,  306,  517,    0,  517, 
          439,  439,    0,  306,  306,  439,    0,    0,    0,    0, 
          109,  517,    0,    0,    0,    0,    0,    0,    0,    0, 
          520,  520,  520,  517,    0,  520,  520,  520,    0,  520, 
            0,    0,    0,  439,    0,    0,    0,    0,    0,  520, 
          520,    0,    0,    0,    0,    0,    0,    0,  520,  520, 
            0,  520,  520,  520,  520,  520,    0,    0,    0,    0, 
            0,    0,    0,  520,  648,    0,    0,    0,    0,  108, 
            0,    0,    0,    0,  648,  520,  520,  520,  520,  520, 
          520,  520,  520,  520,  520,  520,  520,  520,  520,    0, 
            0,  520,  520,  520,  520,    0,  532,  520,    0,    0, 
          520,    0,    0,  520,    0,  520,    0,  520,  648,  520, 
            0,  520,  520,  520,  520,  520,  520,  520,  317,  520, 
            0,  520,  648,  648,    0,  317,  317,  648,    0,    0, 
            0,    0,  108,  520,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  520,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  648,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  439,  439,  439,    0,    0,  439, 
          439,  439,    0,  439,    0,    0,    0,    0,    0,    0, 
            0,    0,  439,  439,  439,    0,    0,    0,    0,    0, 
            0,    0,  439,  439,    0,  439,  439,  439,  439,  439, 
            0,    0,    0,    0,    0,    0,    0,  439,  306,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  306,  439, 
          439,  439,  439,  439,  439,  439,  439,  439,  439,  439, 
          439,  439,  439,    0,    0,  439,  439,  439,  439,    0, 
            0,  439,    0,    0,  439,    0,    0,  439,    0,  439, 
            0,  439,  306,  439,    0,  439,  439,  439,  439,  439, 
          439,  439,    0,  439,  439,  439,  306,  306,    0,  128, 
            0,  306,    0,    0,    0,    0,    0,  439,    0,    0, 
            0,    0,    0,    0,    0,    0,  648,  648,  648,  439, 
            0,  648,  648,  648,    0,  648,    0,    0,    0,  306, 
            0,    0,    0,    0,  648,  648,  648,    0,    0,    0, 
            0,    0,    0,    0,  648,  648,    0,  648,  648,  648, 
          648,  648,    0,    0,    0,    0,    0,    0,    0,  648, 
          317,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          317,  648,  648,  648,  648,  648,  648,  648,  648,  648, 
          648,  648,  648,  648,  648,    0,    0,  648,  648,  648, 
          648,    0,    0,  648,    0,    0,  648,    0,    0,  648, 
            0,  648,    0,  648,  317,  648,    0,  648,  648,  648, 
          648,  648,  648,  648,    0,  648,  648,  648,  317,  317, 
            0,  127,    0,  317,    0,    0,    0,    0,    0,  648, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  648,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  317,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          306,  306,  306,    0,    0,  306,  306,  306,    0,  306, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  306, 
          306,    0,    0,    0,    0,    0,    0,    0,  306,  306, 
            0,  306,  306,  306,  306,  306,    0,    0,    0,    0, 
            0,    0,    0,  306,  464,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  464,  306,  306,  306,  306,  306, 
          306,  306,  306,  306,  306,  306,  306,  306,  306,    0, 
            0,  306,  306,  306,  306,    0,    0,  306,    0,    0, 
          306,    0,    0,  306,    0,  306,    0,  306,  464,  306, 
            0,  306,  306,  306,  306,  306,  306,  306,    0,  306, 
            0,  306,  464,  464,    0,    0,    0,  464,    0,    0, 
            0,    0,    0,  306,    0,    0,    0,    0,    0,    0, 
            0,    0,  317,  317,  317,  306,    0,  317,  317,  317, 
            0,  317,    0,    0,    0,  464,    0,    0,    0,    0, 
            0,  317,  317,    0,    0,    0,    0,    0,    0,    0, 
          317,  317,    0,  317,  317,  317,  317,  317,    0,    0, 
            0,    0,    0,    0,    0,  317,  328,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  328,  317,  317,  317, 
          317,  317,  317,  317,  317,  317,  317,  317,  317,  317, 
          317,    0,    0,  317,  317,  317,  317,    0,    0,  317, 
            0,    0,  317,    0,    0,  317,    0,  317,    0,  317, 
          328,  317,    0,  317,  317,  317,  317,  317,  317,  317, 
            0,  317,    0,  317,  328,  328,    0,    0,    0,  328, 
            0,    0,    0,    0,    0,  317,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  317,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  328,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  464,  464,  464,    0, 
            0,  464,  464,  464,    0,  464,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  464,  464,    0,    0,    0, 
            0,    0,    0,    0,  464,  464,    0,  464,  464,  464, 
          464,  464,    0,    0,    0,    0,    0,    0,    0,  464, 
          256,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          256,  464,  464,  464,  464,  464,  464,  464,  464,  464, 
          464,  464,  464,  464,  464,    0,    0,  464,  464,  464, 
          464,    0,    0,  464,    0,    0,  464,    0,    0,  464, 
            0,  464,    0,  464,  256,  464,    0,  464,  464,  464, 
          464,  464,  464,  464,    0,  464,    0,  464,  256,  256, 
            0,    0,    0,  256,    0,    0,    0,    0,    0,  464, 
            0,    0,    0,    0,    0,    0,    0,    0,  328,  328, 
          328,  464,    0,  328,  328,  328,    0,  328,    0,    0, 
            0,  360,    0,    0,    0,    0,    0,  328,  328,    0, 
            0,    0,    0,    0,    0,    0,  328,  328,    0,  328, 
          328,  328,  328,  328,    0,    0,    0,    0,    0,    0, 
            0,  328,  323,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  323,  328,  328,  328,  328,  328,  328,  328, 
          328,  328,  328,  328,  328,  328,  328,    0,    0,  328, 
          328,  328,  328,    0,    0,  328,    0,    0,  328,    0, 
            0,  328,    0,  328,    0,  328,  323,  328,    0,  328, 
          328,  328,  328,  328,  328,  328,    0,  328,    0,  328, 
          323,  323,    0,    0,    0,  323,    0,    0,    0,    0, 
            0,  328,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  328,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  323,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  256,  256,  256,    0,    0,  256,  256,  256, 
            0,  256,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  256,  256,    0,    0,    0,    0,    0,    0,    0, 
          256,  256,    0,  256,  256,  256,  256,  256,    0,    0, 
            0,    0,    0,    0,    0,  256,  511,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  511,  256,  256,  256, 
          256,  256,  256,  256,  256,  256,  256,  256,  360,  256, 
          256,    0,    0,  256,  256,  360,  360,    0,    0,  256, 
            0,    0,  256,    0,    0,  256,    0,  256,    0,  256, 
          511,  256,    0,  256,  256,  256,  256,  256,  256,  256, 
            0,  256,    0,  256,  511,  511,    0,    0,    0,  511, 
            0,    0,    0,    0,    0,  256,    0,    0,    0,    0, 
            0,    0,    0,    0,  323,  323,  323,  256,    0,  323, 
          323,  323,    0,  323,    0,    0,    0,  511,    0,    0, 
            0,    0,    0,  323,  323,    0,    0,    0,    0,    0, 
            0,    0,  323,  323,    0,  323,  323,  323,  323,  323, 
            0,    0,    0,    0,    0,    0,    0,  323,  356,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  356,  323, 
          323,  323,  323,  323,  323,  323,  323,  323,  323,  323, 
          323,  323,  323,    0,    0,  323,  323,  323,  323,    0, 
            0,  323,    0,    0,  323,    0,    0,  323,    0,  323, 
            0,  323,  356,  323,    0,  323,  323,  323,  323,  323, 
          323,  323,    0,  323,    0,  323,    0,  356,    0,    0, 
            0,  356,    0,    0,    0,    0,    0,  323,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  323, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  356, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  357,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  357,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  511,  511, 
          511,    0,    0,  511,  511,  511,  357,  511,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  511,  511,    0, 
            0,  357,    0,    0,    0,  357,  511,  511,    0,  511, 
          511,  511,  511,  511,    0,    0,    0,    0,    0,    0, 
            0,  511,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  357,  511,  511,  511,  511,  511,  511, 
          511,  511,  511,  511,  511,  511,  511,    0,    0,  511, 
          511,  511,  511,    0,  320,  511,    0,    0,  511,    0, 
            0,  511,    0,  511,  320,  511,    0,  511,    0,  511, 
          511,  511,  511,  511,  511,  511,    0,  511,    0,  511, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  511,    0,    0,    0,    0,    0,    0,  320,    0, 
          356,  356,  356,  511,    0,  356,  356,  356,    0,  356, 
            0,    0,    0,  320,    0,    0,    0,  320,    0,  356, 
          356,    0,    0,    0,    0,    0,    0,    0,  356,  356, 
            0,  356,  356,  356,  356,  356,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  320,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  356,  356,  356,  356,  356, 
          356,  356,  356,  356,  356,  356,  356,  356,  356,    0, 
            0,  356,  356,  356,  356,    0,    0,  356,    0,    0, 
          356,    0,    0,  356,    0,  356,    0,  356,    0,  356, 
          237,  356,  356,  356,  356,  356,  356,  356,    0,  356, 
          237,  356,    0,    0,  357,  357,  357,    0,    0,  357, 
          357,  357,    0,  357,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  357,  357,  356,    0,    0,    0,    0, 
            0,    0,  357,  357,  237,  357,  357,  357,  357,  357, 
            0,    0,    0,    0,    0,    0,    0,    0,  237,  237, 
            0,    0,    0,  237,    0,    0,    0,    0,    0,  357, 
          357,  357,  357,  357,  357,  357,  357,  357,  357,  357, 
          357,  357,  357,    0,    0,  357,  357,  357,  357,    0, 
            0,  357,    0,    0,  357,    0,    0,  357,    0,  357, 
            0,  357,    0,  357,    0,  357,  357,  357,  357,  357, 
          357,  357,    0,  357,    0,  357,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  320,  320,  320,    0, 
            0,  320,  320,  320,    0,  320,    0,    0,    0,  357, 
            0,    0,    0,    0,    0,  320,  320,    0,    0,    0, 
            0,    0,    0,    0,  320,  320,    0,  320,  320,  320, 
          320,  320,    0,    0,    0,    0,    0,    0,    0,    0, 
          234,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          234,  320,  320,  320,  320,  320,  320,  320,  320,  320, 
          320,  320,  320,  320,  320,    0,    0,  320,  320,  320, 
          320,    0,    0,  320,    0,    0,  320,    0,    0,  320, 
            0,  320,    0,  320,  234,  320,    0,  320,  320,  320, 
          320,  320,  320,  320,    0,  320,    0,  320,  234,  234, 
            0,    0,    0,  234,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  320,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  237,  237,  237,    0,    0,  237,  237,  237, 
            0,  237,    0,  231,    0,    0,    0,    0,    0,    0, 
            0,  237,  237,  231,    0,    0,    0,    0,    0,    0, 
          237,  237,    0,  237,  237,  237,  237,  237,    0,    0, 
            0,    0,    0,    0,    0,  237,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  231,  237,  237, 
          237,  237,  237,  237,  237,  237,  237,  237,    0,  237, 
          237,  231,  231,  237,  237,    0,  231,    0,    0,  237, 
            0,    0,  237,    0,    0,  237,    0,  237,    0,  237, 
            0,  237,    0,  237,  237,  237,  237,  237,  237,  237, 
            0,  237,    0,  237,    0,  724,  619,    0,    0,  725, 
            0,    0,    0,  160,  161,  237,  162,  163,  164,  165, 
          166,  167,  168,    0,    0,  169,  170,  237,    0,    0, 
          171,  172,  173,  174,    0,    0,    0,    0,    0,  233, 
          287,    0,    0,    0,    0,    0,    0,  176,  177,  233, 
          178,  179,  180,  181,  182,  183,  184,  185,  186,  187, 
          188,    0,    0,  189,    0,    0,    0,    0,    0,    0, 
            0,    0,  234,  234,  234,    0,    0,  234,  234,  234, 
            0,  234,    0,  233,    0,  190,    0,    0,    0,    0, 
            0,  234,  234,    0,    0,    0,    0,  233,  233,    0, 
          234,  234,  233,  234,  234,  234,  234,  234,    0,    0, 
            0,    0,    0,    0,    0,  234,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  234,  234, 
          234,  234,  234,  234,  234,  234,  234,  234,    0,  234, 
          234,    0,    0,  234,  234,    0,    0,    0,    0,  234, 
            0,    0,  234,    0,    0,  234,    0,  234,    0,  234, 
            0,  234,    0,  234,  234,  234,  234,  234,  234,  234, 
            0,  234,    0,  234,    0,  231,  231,  231,    0,    0, 
          231,  231,  231,    0,  231,  234,  232,    0,    0,    0, 
            0,    0,    0,    0,  231,  231,  232,  234,    0,    0, 
            0,    0,    0,  231,  231,    0,  231,  231,  231,  231, 
          231,    0,    0,    0,    0,    0,    0,    0,  231,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          232,  231,  231,  231,  231,  231,  231,  231,  231,  231, 
          231,    0,  231,  231,  232,  232,  231,  231,    0,  232, 
            0,    0,  231,    0,    0,  231,    0,    0,  231,    0, 
          231,    0,  231,    0,  231,    0,  231,  231,  231,  231, 
          231,  231,  231,    0,  231,    0,  231,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  231,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          231,  233,  233,  233,    0,    0,  233,  233,  233,    0, 
          233,    0,  235,    0,    0,    0,    0,    0,    0,    0, 
          233,  233,  235,    0,    0,    0,    0,    0,    0,  233, 
          233,    0,  233,  233,  233,  233,  233,    0,    0,    0, 
            0,    0,    0,    0,  233,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  235,  233,  233,  233, 
          233,  233,  233,  233,  233,  233,  233,    0,  233,  233, 
          235,  235,  233,  233,    0,  235,    0,    0,  233,    0, 
            0,  233,    0,    0,  233, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

            0,  233,    0,  233,    0,  233,    0,  233,  233,  233, 
          233,  233,  233,  233,    0,  233,    0,  233,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  233, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  233,  440,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  440,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  232,  232,  232,    0,    0,  232,  232, 
          232,    0,  232,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  232,  232,    0,    0,  440,    0,    0,    0, 
            0,  232,  232,    0,  232,  232,  232,  232,  232,    0, 
            0,  440,    0,  122,    0,  440,  232,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  232, 
          232,  232,  232,  232,  232,  232,  232,  232,  232,    0, 
          232,  232,    0,  440,  232,  232,    0,    0,    0,    0, 
          232,    0,    0,  232,    0,    0,  232,    0,  232,    0, 
          232,    0,  232,  522,  232,  232,  232,  232,  232,  232, 
          232,    0,  232,  522,  232,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  232,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  232,  235, 
          235,  235,    0,    0,  235,  235,  235,   97,  235,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  235,  235, 
            0,    0,  522,    0,  116,    0,  522,  235,  235,    0, 
          235,  235,  235,  235,  235,    0,    0,    0,    0,    0, 
            0,    0,  235,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  522,  235,  235,  235,  235,  235, 
          235,  235,  235,  235,  235,    0,  235,  235,    0,    0, 
          235,  235,    0,    0,    0,  521,  235,    0,    0,  235, 
            0,    0,  235,    0,  235,  521,  235,    0,  235,    0, 
          235,  235,  235,  235,  235,  235,  235,    0,  235,    0, 
          235,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  235,    0,  440,  440,  440,    0,    0,   96, 
          440,  440,    0,  440,  235,    0,    0,    0,    0,    0, 
            0,    0,  440,    0,  521,    0,  115,    0,  521,    0, 
            0,    0,  440,  440,    0,  440,  440,  440,  440,  440, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  521,    0,    0,  440, 
          440,  440,  440,  440,  440,  440,  440,  440,  440,  440, 
          440,  440,  440,  429,    0,  440,  440,  440,  440,    0, 
            0,    0,    0,  429,  440,    0,    0,    0,    0,    0, 
            0,  440,    0,  440,    0,  440,  440,  440,  440,  440, 
          440,  440,    0,  440,  440,  440,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  522,  522,  522,    0,    0, 
            0,  522,  522,    0,  522,    0,    0,    0,    0,  440, 
            0,    0,  429,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  522,  522,    0,  522,  522,  522,  522, 
          522,    0,    0,    0,  523,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  523,    0,    0,    0,    0,    0, 
          522,  522,  522,  522,  522,  522,  522,  522,  522,  522, 
          522,  522,  522,  522,    0,    0,  522,  522,  522,  522, 
            0,  534,    0,    0,    0,  522,    0,    0,   98,    0, 
            0,    0,  522,    0,  522,    0,  522,  522,  522,  522, 
          522,  522,  522,  523,  522,  117,  522,  523,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  521,  521,  521, 
            0,    0,    0,  521,  521,    0,  521,    0,    0,    0, 
          522,    0,    0,    0,    0,  523,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  521,  521,    0,  521,  521, 
          521,  521,  521,    0,    0,    0,  524,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  524,    0,    0,    0, 
            0,    0,  521,  521,  521,  521,  521,  521,  521,  521, 
          521,  521,  521,  521,  521,  521,    0,    0,  521,  521, 
          521,  521,    0,  533,    0,    0,    0,  521,    0,    0, 
           99,    0,    0,    0,  521,    0,  521,    0,  521,  521, 
          521,  521,  521,  521,  521,  524,  521,  118,  521,  524, 
            0,    0,    0,    0,    0,  429,  429,  429,    0,    0, 
          429,  429,  429,  526,  429,    0,    0,    0,    0,    0, 
            0,    0,  521,  526,  429,    0,    0,  524,    0,    0, 
            0,    0,    0,  429,  429,    0,  429,  429,  429,  429, 
          429,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  101,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  429,  526,    0,  120,    0,  526,    0,  429,  429, 
            0,    0,    0,    0,    0,  429,  523,  523,  523,    0, 
            0,    0,  523,  523,    0,  523,    0,    0,    0,    0, 
            0,    0,    0,    0,  526,    0,  429,    0,    0,    0, 
            0,    0,    0,    0,  523,  523,    0,  523,  523,  523, 
          523,  523,    0,    0,    0,  525,    0,    0,    0,    0, 
          429,    0,    0,    0,    0,  525,    0,    0,    0,    0, 
            0,  523,  523,  523,  523,  523,  523,  523,  523,  523, 
          523,  523,  523,  523,  523,    0,    0,  523,  523,  523, 
          523,    0,  535,    0,    0,    0,  523,    0,    0,  100, 
            0,    0,    0,  523,    0,  523,    0,  523,  523,  523, 
          523,  523,  523,  523,  525,  523,  119,  523,  525,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  524,  524, 
          524,    0,    0,    0,  524,  524,    0,  524,    0,    0, 
            0,  523,    0,    0,    0,    0,  525,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  524,  524,    0,  524, 
          524,  524,  524,  524,    0,    0,    0,   52,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   52,    0,    0, 
            0,    0,    0,  524,  524,  524,  524,  524,  524,  524, 
          524,  524,  524,  524,  524,  524,  524,    0,    0,  524, 
          524,  524,  524,    0,  536,  526,  526,  526,  524,    0, 
            0,  526,  526,    0,  526,  524,    0,  524,    0,  524, 
          524,  524,  524,  524,  524,  524,   52,  524,    0,  524, 
            0,    0,    0,  526,  526,    0,  526,  526,  526,  526, 
          526,    0,    0,    0,  527,    0,    0,    0,    0,    0, 
            0,    0,    0,  524,  527,    0,    0,    0,    0,    0, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,    0,    0,  526,  526,  526,  526, 
            0,  538,    0,    0,    0,  526,    0,    0,  102,    0, 
            0,    0,  526,    0,  526,    0,  526,  526,  526,  526, 
          526,  526,  526,  527,  526,  121,  526,  527,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  525,  525,  525, 
            0,    0,    0,  525,  525,    0,  525,    0,    0,    0, 
          526,    0,    0,    0,    0,  527,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  525,  525,    0,  525,  525, 
          525,  525,  525,    0,    0,    0,  518,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  518,    0,    0,    0, 
            0,    0,  525,  525,  525,  525,  525,  525,  525,  525, 
          525,  525,  525,  525,  525,  525,    0,    0,  525,  525, 
          525,  525,    0,  537,    0,    0,    0,  525,    0,    0, 
           93,    0,    0,    0,  525,    0,  525,    0,  525,  525, 
          525,  525,  525,  525,  525,  518,  525,  112,  525,  518, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   52, 
           52,   52,    0,  517,   52,   52,   52,    0,   52,    0, 
            0,    0,  525,  517,    0,    0,    0,  518,   52,    0, 
            0,    0,    0,    0,    0,    0,    0,   52,   52,    0, 
           52,   52,   52,   52,   52,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   92,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  517,    0,  111,    0,  517,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  527,  527,  527,   52, 
            0,    0,  527,  527,    0,  527,    0,    0,    0,    0, 
            0,    0,    0,    0,  517,    0,    0,    0,    0,    0, 
           52,    0,    0,    0,  527,  527,    0,  527,  527,  527, 
          527,  527,    0,    0,    0,  520,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,  520,    0,    0,    0,    0, 
            0,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,    0,    0,  527,  527,  527, 
          527,    0,  539,    0,    0,    0,  527,    0,    0,   95, 
            0,    0,    0,  527,    0,  527,    0,  527,  527,  527, 
          527,  527,  527,  527,  520,  527,  114,  527,  520,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  518,  518, 
          518,    0,    0,    0,  518,  518,    0,  518,    0,    0, 
            0,  527,    0,    0,    0,    0,  520,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  518,  518,    0,  518, 
          518,  518,  518,  518,    0,    0,    0,    0,    0,   60, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   60, 
            0,    0,    0,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,    0,    0,  518, 
          518,  518,  518,    0,  530,  517,  517,  517,  518,    0, 
            0,  517,  517,    0,  517,  518,    0,  518,    0,  518, 
          518,  518,  518,  518,  518,  518,    0,  518,   60,  518, 
            0,    0,    0,  517,  517,    0,  517,  517,  517,  517, 
          517,    0,    0,    0,  306,    0,    0,    0,    0,    0, 
            0,    0,    0,  518,  306,    0,    0,    0,    0,    0, 
          517,  517,  517,  517,  517,  517,  517,  517,  517,  517, 
          517,  517,  517,  517,    0,    0,  517,  517,  517,  517, 
            0,  529,    0,    0,    0,  517,    0,    0,  109,    0, 
            0,    0,  517,    0,  517,    0,  517,  517,  517,  517, 
          517,  517,  517,  306,  517,  128,  517,  306,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  520,  520,  520, 
            0,    0,    0,  520,  520,    0,  520,    0,    0,    0, 
          517,    0,    0,    0,    0,  306,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  520,  520,    0,  520,  520, 
          520,  520,  520,    0,    0,    0,  317,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  317,    0,    0,    0, 
            0,    0,  520,  520,  520,  520,  520,  520,  520,  520, 
          520,  520,  520,  520,  520,  520,    0,    0,  520,  520, 
          520,  520,    0,  532,    0,    0,    0,  520,    0,    0, 
          108,    0,    0,    0,  520,    0,  520,    0,  520,  520, 
          520,  520,  520,  520,  520,  317,  520,  127,  520,  317, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   60,   60,   60,    0,    0,   60,   60,   60,    0, 
           60,    0,  520,    0,    0,    0,    0,  317,    0,    0, 
           60,   60,    0,    0,    0,    0,    0,    0,  229,   60, 
           60,    0,   60,   60,   60,   60,   60,    0,  229,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  229,    0,    0,    0,  306,  306,  306,    0, 
            0,   60,  306,  306,   60,  306,  229,  229,    0,    0, 
            0,  229,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   60,    0,  306,  306,    0,  306,  306,  306, 
          306,  306,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   60,    0,    0,    0, 
            0,  306,  306,  306,  306,  306,  306,  306,  306,  306, 
          306,  306,  306,  306,  306,    0,    0,  306,  306,  306, 
          306,    0,    0,    0,    0,    0,  306,    0,    0,    0, 
            0,    0,    0,  306,    0,  306,  230,  306,  306,  306, 
          306,  306,  306,  306,    0,  306,  230,  306,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  317,  317, 
          317,    0,    0,    0,  317,  317,    0,  317,    0,    0, 
            0,  306,    0,    0,    0,    0,    0,    0,    0,    0, 
          230,    0,    0,    0,    0,    0,  317,  317,    0,  317, 
          317,  317,  317,  317,  230,  230,    0,    0,    0,  230, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  317,  317,  317,  317,  317,  317,  317, 
          317,  317,  317,  317,  317,  317,  317,    0,    0,  317, 
          317,  317,  317,    0,    0,    0,    0,    0,  317,    0, 
            0,    0,    0,    0,    0,  317,    0,  317,    0,  317, 
          317,  317,  317,  317,  317,  317,    0,  317,    0,  317, 
          229,  229,  229,    0,    0,  229,  229,  229,    0,  229, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  229, 
          229,    0,    0,  317,    0,    0,    0,    0,  229,  229, 
            0,  229,  229,  229,  229,  229,    0,    0,    0,    0, 
            0,    0,    0,  229,  306,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  306,    0,  229,  229,  229,  229, 
          229,  229,  229,  229,  229,  229,    0,  229,  229,    0, 
            0,  229,  229,    0,    0,    0,    0,  229,    0,    0, 
          229,    0,    0,  229,    0,  229,    0,    0,  306,  229, 
            0,    0,    0,  229,  229,  229,  229,  229,    0,  229, 
            0,  229,    0,  306,    0,  128,    0,  306,    0,    0, 
            0,    0,    0,  229,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  229,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  306,    0,    0,  230,  230, 
          230,    0,    0,  230,  230,  230,    0,  230,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  230,  230,    0, 
            0,    0,    0,    0,    0,    0,  230,  230,    0,  230, 
          230,  230,  230,  230,    0,    0,    0,    0,    0,    0, 
            0,  230,  250,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  250,    0,  230,  230,  230,  230,  230,  230, 
          230,  230,  230,  230,    0,  230,  230,    0,    0,  230, 
          230,    0,    0,    0,    0,  230,    0,    0,  230,    0, 
            0,  230,    0,  230,    0,    0,  250,  230,    0,    0, 
            0,  230,  230,  230,  230,  230,    0,  230,    0,  230, 
          250,  250,    0,    0,    0,  250,    0,    0,    0,    0, 
            0,  230,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  230,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  251,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  251,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  306,  306,  306,    0, 
            0,    0,  306,  306,    0,  306,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  251,    0, 
            0,    0,    0,    0,  306,  306,    0,  306,  306,  306, 
          306,  306,  251,  251,    0,    0,    0,  251,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  306,  306,  306,  306,  306,  306,  306,  306,  306, 
          306,  306,  306,  306,  306,    0,    0,  306,  306,  306, 
          306,    0,    0,    0,    0,    0,  306,    0,    0,    0, 
            0,    0,    0,  306,    0,  306,    0,  306,  306,  306, 
          306,  306,  306,  306,    0,  306,    0,  306,    0,    0, 
            0,  240,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  240,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  306,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  250,  250,  250,    0,    0,  250, 
          250,  250,    0,  250,    0,  240,    0,    0,    0,    0, 
            0,    0,    0,  250,  250,    0,    0,    0,    0,  240, 
          240,    0,  250,  250,  240,  250,  250,  250,  250,  250, 
            0,    0,    0,    0,    0,    0,    0,  250,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          250,  250,  250,  250,  250,  250,  250,  250,  250,  250, 
            0,  250,  250,    0,    0,  250,  250,    0,    0,    0, 
            0,  250,    0,    0,  250,    0,    0,  250,  238,  250, 
            0,    0,    0,  250,    0,    0,    0,    0,  238,  250, 
          250,  250,    0,  250,    0,  250,  251,  251,  251,    0, 
            0,  251,  251,  251,    0,  251,    0,  250,    0,    0, 
            0,    0,    0,    0,    0,  251,  251,    0,    0,  250, 
            0,    0,  238,    0,  251,  251,    0,  251,  251,  251, 
          251,  251,    0,    0,    0,    0,  238,  238,    0,  251, 
            0,  238,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  251,  251,  251,  251,  251,  251,  251,  251, 
          251,  251,    0,  251,  251,    0,    0,  251,  251,    0, 
            0,    0,    0,  251,    0,    0,  251,    0,    0,  251, 
            0,  251,    0,    0,    0,  251,    0,    0,    0,    0, 
            0,  251,  251,  251,    0,  251,    0,  251,    0,    0, 
            0,    0,    0,    0,  239,    0,    0,    0,    0,  251, 
            0,    0,    0,    0,  239,    0,    0,    0,    0,    0, 
            0,  251,    0,  240,  240,  240,    0,    0,  240,  240, 
          240,    0,  240,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  240,  240,    0,    0,    0,    0,  239,    0, 
            0,  240,  240,    0,  240,  240,  240,  240,  240,    0, 
            0,    0,  239,  239,    0,    0,  240,  239,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  240, 
          240,  240,  240,  240,  240,  240,  240,  240,  240,    0, 
          240,  240,    0,    0,    0,    0,    0,    0,    0,    0, 
          240,    0,    0,  240,    0,    0,  240,  261,  240,    0, 
            0,    0,  240,    0,    0,    0,    0,  261,  240,  240, 
          240,    0,  240,    0,  240,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  240,    0,    0,    0, 
          238,  238,  238,    0,    0,  238,  238,  238,  240,  238, 
            0,  261,    0,    0,    0,    0,    0,    0,    0,  238, 
          238,    0,    0,    0,    0,  261,  261,    0,  238,  238, 
          261,  238,  238,  238,  238,  238,    0,    0,    0,    0, 
            0,    0,    0,  238,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  238,  238,  238,  238, 
          238,  238,  238,  238,  238,  238,    0,  238,  238,    0, 
            0,    0,    0,    0,    0,    0,    0,  238,    0,    0, 
          238,    0,    0,  238,    0,  238,    0,    0,    0,    0, 
            0,    0,    0,  262,    0,  238,  238,  238,    0,  238, 
            0,  238,    0,  262,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  238,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  238,  239,  239,  239,    0, 
            0,  239,  239,  239,    0,  239,    0,  262,    0,    0, 
            0,    0,    0,    0,    0,  239,  239,    0,    0,    0, 
            0,  262,  262,    0,  239,  239,  262,  239,  239,  239, 
          239,  239,    0,    0,    0,    0,    0,    0,    0,  239, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  239,  239,  239,  239,  239,  239,  239,  239, 
          239,  239,    0,  239,  239,    0,    0,    0,    0,    0, 
            0,    0,    0,  239,    0,    0,  239,    0,  243,  239, 
            0,  239,    0,    0,    0,    0,    0,    0,  243,    0, 
            0,  239,  239,  239,    0,  239,    0,  239,    0,  261, 
          261,  261,    0,    0,  261,  261,  261,    0,  261,  239, 
            0,    0,    0,    0,    0,    0,    0,    0,  261,  261, 
            0,  239,  243,    0,    0,    0,    0,  261,  261,    0, 
          261,  261,  261,  261,  261,    0,  243,  243,    0,    0, 
            0,  243,  261,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  261,  261,  261,  261,  261, 
          261,  261,  261,  261,  261,    0,  261,  261,    0,    0, 
            0,    0,    0,    0,    0,    0,  261,    0,    0,  261, 
            0,    0,  261,    0,  261,    0,    0,    0,    0,    0, 
            0,    0,  244,    0,  261,  261,    0,    0,    0,    0, 
          261,    0,  244,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  261,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  261,  262,  262,  262,    0,    0, 
          262,  262,  262,    0,  262,    0,  244,    0,    0,    0, 
            0,    0,    0,    0,  262,  262,    0,    0,    0,    0, 
          244,  244,    0,  262,  262,  244,  262,  262,  262,  262, 
          262,    0,    0,    0,    0,    0,    0,    0,  262,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  262,  262,  262,  262,  262,  262,  262,  262,  262, 
          262,    0,  262,  262,    0,    0,    0,    0,    0,    0, 
            0,    0,  262,    0,    0,  262,    0,  245,  262,    0, 
          262,    0,    0,    0,    0,    0,    0,  245,    0,    0, 
          262,  262,    0,    0,    0,    0,  262,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  262,    0, 
          243,  243,  243,    0,    0,  243,  243,  243,    0,  243, 
          262,  245,    0,    0,    0,    0,    0,    0,    0,  243, 
          243,    0,    0,    0,    0,  245,  245,    0,  243,  243, 
          245,  243,  243,  243,  243,  243,    0,    0,    0,    0, 
            0,    0,    0,  243,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  243,  243,    0,    0,    0,  243,  243,    0, 
            0,    0,    0,    0,    0,    0,    0,  243,    0,    0, 
          243,    0,    0,  243,    0,  243,    0,    0,    0,    0, 
            0,    0,    0,  252,    0,    0,    0,    0,    0,    0, 
            0,  243,    0,  252,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  243,  244,  244,  244,    0,    0,  244, 
          244,  244,    0,  244,    0,  243,    0,    0,    0,    0, 
            0,    0,    0,  244,  244,    0,    0,  252,    0,    0, 
            0,    0,  244,  244,    0,  244,  244,  244,  244,  244, 
            0,  252,  252,    0,    0,    0,  252,  244,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  244,  244,    0,    0, 
            0,  244,  244,    0,    0,    0,    0,    0,    0,    0, 
            0,  244,    0,    0,  244,    0,  246,  244,    0,  244, 
            0,    0,    0,    0,    0,    0,  246,    0,    0,    0, 
            0,    0,    0,    0,    0,  244,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  244,    0,  245, 
          245,  245,    0,    0,  245,  245,  245,    0,  245,  244, 
          246,    0,    0,    0,    0,    0,    0,    0,  245,  245, 
            0,    0,    0,    0,  246,  246,    0,  245,  245,  246, 
          245,  245,  245,  245,  245,    0,    0,    0,    0,    0, 
            0,    0,  245,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  247,    0,    0,    0,    0, 
            0,  245,  245,    0,    0,  247,  245,  245,    0,    0, 
            0,    0,    0,    0,    0,    0,  245,    0,    0,  245, 
            0,    0,  245,    0,  245,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  247, 
          245,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  245,  247,  247,    0,    0,    0,  247,    0, 
            0,    0,    0,    0,  245,  252,  252,  252,    0,    0, 
          252,  252,  252,    0,  252,    0,    0,    0,    0,    0, 
            0,  253,    0,    0,  252,  252,    0,    0,    0,    0, 
            0,  253,    0,  252,  252,    0,  252,  252,  252,  252, 
          252,    0,    0,    0,    0,    0,    0,    0,  252,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  253,    0,  252,  252,    0, 
            0,    0,  252,  252,    0,    0,    0,    0,    0,  253, 
          253,    0,  252,    0,  253,  252,    0,    0,  252,    0, 
          252,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  252,    0,  246,  246, 
          246,    0,    0,  246,  246,  246,    0,  246,  252,  227, 
            0,    0,    0,    0,    0,    0,    0,  246,  246,  227, 
          252,    0,    0,    0,    0,    0,  246,  246,    0,  246, 
          246,  246,  246,  246,    0,    0,    0,    0,    0,    0, 
            0,  246,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  227,    0,    0,    0,    0,    0,    0, 
          246,  246,    0,    0,    0,  246,  246,  227,  227,    0, 
            0,    0,  227,    0,    0,  246,    0,    0,  246,    0, 
            0,  246,    0,  246,    0,    0,    0,  247,  247,  247, 
            0,    0,  247,  247,  247,    0,  247,    0,  228,  246, 
            0,    0,    0,    0,    0,    0,  247,  247,  228,    0, 
            0,  246,    0,    0,    0,  247,  247,    0,  247,  247, 
          247,  247,  247,  246,    0,    0,    0,    0,    0,    0, 
          247,    0,    0,    0,    0,    0,    0,  255,    0,    0, 
            0,    0,  228,    0,    0,    0,    0,  255,    0,  247, 
          247,    0,    0,    0,  247,  247,  228,  228,    0,    0, 
            0,  228,    0,    0,  247,    0,    0,  247,    0,    0, 
          247,    0,  247,  253,  253,  253,    0,    0,  253,  253, 
          253,  255,  253,    0,    0,    0,    0,    0,  247,    0, 
            0,    0,  253,  253,    0,  255,  255,    0,    0,    0, 
          247,  253,  253,    0,  253,  253,  253,  253,  253,    0, 
            0,    0,  247,    0,    0,    0,  253,    0,    0,    0, 
            0,    0,    0,    0,  220,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  220,    0,  253,    0,    0,    0, 
          253,  253,    0,    0,    0,    0,    0,    0,    0,    0, 
          253,    0,    0,  253,    0,    0,  253,    0,  253,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  220,    0, 
            0,  227,  227,  227,  253,    0,  227,  227,  227,    0, 
          227,    0,  220,  220,    0,    0,  253,    0,    0,    0, 
          227,  227,    0,    0,    0,    0,    0,    0,  253,  227, 
          227,    0,  227,  227,  227,  227,  227,    0,    0,    0, 
            0,  263,    0,    0,  227,    0,    0,    0,    0,    0, 
            0,  263,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  227,    0, 
            0,  227,    0,    0,  227,  263,  227,    0,    0,    0, 
          228,  228,  228,    0,    0,  228,  228,  228,    0,  228, 
          263,    0,  227,    0,    0,    0,    0,    0,    0,  228, 
          228,    0,    0,    0,  227,    0,    0,    0,  228,  228, 
            0,  228,  228,  228,  228,  228,  227,  268,    0,  255, 
          255,  255,    0,  228,  255,  255,  255,  268,  255,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  255,  255, 
            0,    0,    0,    0,    0,    0,    0,  255,  255,    0, 
          255,  255,  255,  255,  255,    0,    0,  228,    0,    0, 
          228,  268,  255,  228,    0,  228,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  268,  268,    0,    0,    0, 
            0,  228,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  228,    0,    0,  255,    0,    0,  255, 
            0,    0,  255,    0,  255,  228,  220,  220,  220,    0, 
            0,  220,  220,  220,    0,  220,    0,    0,    0,  288, 
          255,    0,    0,    0,    0,  220,  220,    0,    0,  288, 
            0,    0,  255,    0,  220,  220,    0,  220,  220,  220, 
          220,  220,    0,    0,  255,    0,    0,    0,    0,  220, 
            0,    0,    0,    0,    0,    0,    0,  290,    0,    0, 
            0,    0,    0,  288,    0,    0,    0,  290,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  288,    0, 
            0,    0,    0,  220,    0,    0,  220,    0,    0,  220, 
            0,  220,    0,  263,  263,  263,    0,    0,  263,  263, 
          263,  290,  263,    0,    0,    0,    0,  220,    0,    0, 
            0,    0,  263,  263,    0,    0,  290,    0,    0,  220, 
            0,  263,  263,    0,  263,  263,  263,  263,  263,    0, 
            0,  220,    0,    0,    0,    0,  263,    0,    0,    0, 
            0,    0,    0,    0,    0,  649,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  649,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          263,    0,    0,  263,    0,    0,  263,    0,  263,  268, 
          268,  268,    0,   64,  268,  268,  268,    0,  268,    0, 
            0,    0,    0,   64,  263,    0,    0,    0,  268,  268, 
            0,    0,    0,    0,  649,    0,  263,  268,  268,    0, 
          268,  268,  268,  268,    0,    0,    0,    0,  263,    0, 
            0,    0,  268,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   64,    0,    0,    0,    0,    0,   62,    0, 
            0,    0,    0,    0,    0,    0,  268,    0,   62,  268, 
            0,    0,  268,    0,  268,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          268,  288,  288,  288,    0,   54,  288,  288,  288,    0, 
          288,    0,  268,    0,    0,   54,    0,    0,    0,    0, 
          288,  288,    0,    0,  268,    0,    0,   62,    0,  288, 
          288,    0,  288,  288,  288,  288,  288,    0,    0,  290, 
          290,  290,    0,    0,  290,  290,  290,    0,  290,    0, 
            0,    0,    0,    0,    0,   56,    0,    0,  290,  290, 
            0,    0,    0,    0,   54,   56,    0,  290,  290,    0, 
          290,  290,  290,  290,  290,    0,    0,    0,    0,    0, 
            0,  288,    0,    0,  288,    0,  288,    0,    0,    0, 
            0,    0,    0,    0,   57,    0,    0,    0,    0,    0, 
            0,    0,  288,    0,   57,    0,    0,    0,    0,    0, 
          296,    0,    0,    0,   56,  291,    0,    0,    0,  290, 
          296,    0,  290,    0,  290,    0,  288,  649,  649,  649, 
            0,    0,  649,  649,  649,    0,  649,    0,    0,    0, 
          290,    0,    0,    0,    0,    0,  649,  649,    0,    0, 
            0,    0,    0,   57,  289,  649,  649,    0,  649,  649, 
          649,  649,  649,    0,  290,   64,   64,   64,  394,  296, 
           64,   64,   64,    0,   64,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   64,   64,    0,    0,    0,    0, 
            0,    0,    0,   64,   64,    0,   64,   64,   64,   64, 
           64,    0,    0,    0,    0,    0,    0,  649,    0,    0, 
          649,    0,  649,    0,    0,    0,  294,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  294,    0,  649,    0, 
           62,   62,   62,    0,    0,   62,   62,   62,    0,   62, 
            0,    0,    0,    0,    0,   64,    0,    0,   64,   62, 
           62,    0,  649,    0,    0,    0,    0,    0,   62,   62, 
          290,   62,   62,   62,   62,   62,   64,   54,   54,   54, 
          295,    0,   54,   54,   54,  294,   54,    0,    0,    0, 
          295,    0,    0,    0,    0,    0,   54,    0,    0,    0, 
           64,    0,    0,    0,    0,   54,   54,    0,   54,   54, 
           54,   54,   54,    0,    0,    0,    0,    0,    0,    0, 
           62,    0,    0,   62,  291,    0,    0,   56,   56,   56, 
            0,    0,   56,   56,   56,    0,   56,    0,    0,  295, 
            0,   62,    0,    0,    0,    0,   56,    0,    0,    0, 
            0,    0,    0,    0,    0,   56,   56,   54,   56,   56, 
           56,   56,   56,    0,    0,   62,   57,   57,   57,    0, 
            0,   57,   57,   57,    0,   57,    0,    0,   54,    0, 
            0,    0,  296,  296,  296,   57,  291,  296,  296,  296, 
            0,  296,    0,    0,   57,   57,    0,   57,   57,   57, 
           57,   57,   54,    0,    0,    0,    0,   56,    0,    0, 
            0,    0,    0,  296,  296,  296,  296,  296,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   56,    0, 
            0,    0,  369,  370,  371,  372,  373,  374,  375,  376, 
          377,  378,  379,    0,  380,  381,   57,    0,  382,  383, 
            0,    0,   56,    0,    0,    0,    0,    0,    0,  296, 
            0,    0,  296,    0,  384,    0,  385,   57,  386,  387, 
          388,  389,  390,  391,  392,    0,  393,    0,    0,    0, 
            0,    0,    0,  296,    0,    0,    0,    0,  294,  294, 
          294,   57,    0,  294,  294,  294,    0,  294,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  296,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  129,    0,  294, 
          294,  294,  294,  294,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  295,  295,  295,    0,    0,  295,  295,  295, 
            0,  295,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  294,  129,    0,  294,    0, 
            0,    0,    0,  295,  295,  295,  295,  295,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  294, 
            0,    0,    0,    0,    0,    0,    0,    0,  516,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  294,    0,    0,    0,    0,    0,  295, 
            0,    0,  295,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,  295,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,  130,    0,    0,   19, 
           20,   21,  212,  213,  214,  215,    0,  295,  249,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  216,  217, 
          218,    0,  219,   35,  220,  221,  222,  223,  269,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  130,    0,    0,    0,    0, 
            0,    0,    0,  224,    0,    0,  225,    0,    0,   46, 
           47,    0,   48,    0,  270,    0,  271,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  272,  519,    0,    0, 
            0,   52,  273,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
           65,   66,  274,  129,  129,  129,  129,  129,  129,  129, 
          129,  129,  129,  129,    0,    0,  129,  129,    0,  129, 
          129,  129,  129,  129,  129,  129,    0,  619,    0,  129, 
          129,  129,  129,  129,  129,  129,  129,    0,    0,  129, 
            0,    0,    0,    0,    0,  129,  129,    0,  129,  129, 
          129,  129,    0,  129,  129,  129,  129,  129,  129,    0, 
          129,  129,  129,  129,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  516,    0,    0,  129,    0, 
            0,    0,  516,  516,  129,    0,    0,  129,  619,    0, 
          129,  129,    0,  129,    0,  129,    0,    0,    0,  129, 
            0,    0,    0,    0,  129,    0,    0,  129,    0,  619, 
          626,    0,  129,  129,  129,  129,  129,  129,    0,    0, 
            0,  129,    0,  129,  129,    0,  129,  129,  129,  129, 
            0,  129,  129,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  130,  130,  130,  130,  130,  130,  130,  130, 
          130,  130,  130,    0,    0,  130,  130,    0,  130,  130, 
          130,  130,  130,  130,  130,    0,  620,    0,  130,  130, 
          130,  130,  130,  130,  130,  130,    0,    0,  130,    0, 
            0,    0,    0,    0,  130,  130,    0,  130,  130,  130, 
          130,    0,  130,  130,  130,  130,  130,  130,    0,  130, 
          130,  130,  130,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  519,    0,    0,  130,    0,    0, 
            0,  519,  519,  130,    0,    0,  130,  620,    0,  130, 
          130,    0,  130,    0,  130,    0,    0,    0,  130,    0, 
            0,    0,    0,  130,    0,    0,  130,    0,  620,  316, 
            0,  130,  130,  130,  130,  130,  130,    0,    0,    0, 
          130,    0,  130,  130,    0,  130,  130,  130,  130,    0, 
          130,  130,    0,    0,    0,  129,  129,  129,  129,  129, 
          129,  129,  129,  129,  129,  129,    0,    0,  129,  129, 
            0,  129,  129,  129,  129,  129,  129,  129,    0,  626, 
            0,  130,  129,  129,  129,  129,  129,  129,  129,    0, 
            0,  129,    0,    0,    0,    0,    0,  129,  129,    0, 
          129,  129,  129,  129,    0,  129,  129,  129,  129,  129, 
          129,    0,  129,  129,  129,  129,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  626,    0,    0, 
          130,    0,    0,    0,  626,  626,  129,    0,    0,  129, 
          622,    0,  129,  129,    0,  129,    0,  129,    0,    0, 
            0,  129,    0,    0,    0,    0,  129,    0,    0,  129, 
            0,  626,  317,    0,  129,  129,  129,  129,  129,  129, 
            0,    0,    0,  129,    0,  129,  129,    0,  129,  129, 
          129,  129,    0,  129,  129,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  130,  130,  130,  130,  130,  130, 
          130,  130,  130,  130,  130,    0,    0,  130,  130,    0, 
          130,  130,  130,  130,  130,  130,  130,    0,  364,    0, 
            0,  130,  130,  130,  130,  130,  130,  130,    0,    0, 
          130,    0,    0,    0,    0,    0,  130,  130,    0,  130, 
          130,  130,  130,    0,  130,  130,  130,  130,  130,  130, 
            0,  130,  130,  130,  130,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  316,  364,    0,    0, 
            0,    0,    0,  316,  316,  130,    0,    0,  130,  623, 
            0,  130,  130,    0,  130,    0,  130,    0,    0,    0, 
          130,    0,    0,    0,    0,  130,    0,    0,  130,    0, 
            0,    0,    0,  130,  130,  130,  130,  130,  130,    0, 
            0,    0,  130,    0,  130,  130,    0,  130,  130,  130, 
          130,    0,  130,  130,    0,    0,    0,  130,  130,  130, 
          130,  130,  130,  130,  130,  130,  130,  130,    0,    0, 
          130,  130,    0,  130,  130,  130,  130,  130,  130,  130, 
            0,  308,    0,    0,  130,  130,  130,  130,  130,  130, 
          130,    0,    0,  130,    0,    0,    0,    0,    0,  130, 
          130,    0,  130,  130,  130,  130,    0,  130,  130,  130, 
          130,  130,  130,    0,  130,  130,  130,  130,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  317, 
          308,    0,    0,    0,    0,    0,  317,  317,  130,    0, 
            0,  130,    0,    0,  130,  130,    0,  130,    0,  130, 
            0,    0,    0,  130,    0,    0,    0,    0,  130,    0, 
            0,  130,    0,    0,    0,    0,  130,  130,  130,  130, 
          130,  130,    0,    0,    0,  130,    0,  130,  130,    0, 
          130,  130,  130,  130,    0,  130,  130,    0,    0,    0, 
            0,    0,    0,    0,  364,  364,  364,  364,  364,  364, 
          364,  364,  364,  364,  364,    0,  364,  364,  364,  364, 
          364,  364,  364,  364,  364,  364,  364,  544,    0,    0, 
            0,  364,  364,  364,  364,  364,  364,  364,    0,    0, 
          364,    0,    0,    0,    0,    0,  364,  364,    0,  364, 
          364,  364,  364,    0,  364,  364,  364,  364,  364,  364, 
            0,  364,  364,  364,  364,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  544,    0,    0,    0, 
            0,    0,    0,    0,    0,  364,    0,    0,  364,    0, 
            0,  364,  364,    0,  364,    0,  364,    0,    0,    0, 
          364,    0,    0,    0,    0,    0,    0,    0,  364,    0, 
            0,    0,    0,  364,  364,  364,  364,  364,  364,    0, 
            0,    0,  364,    0,  364,  364,    0,  364,  364,  364, 
          364,    0,  364,  364,    0,    0,    0,  308,  308,  308, 
          308,  308,  308,  308,  308,  308,  308,  308,    0,    0, 
          308,  308,    0,  308,  308,  308,  308,  308,  308,  308, 
          648,    0,    0,    0,  308,  308,  308,  308,  308,  308, 
          308,    0,    0,  308,    0,    0,    0,    0,    0,  308, 
          308,    0,  308,  308,  308,  308,    0,  308,  308,  308, 
          308,  308,  308,    0,  308,  308,  308,  308,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  648, 
            0,    0,    0,    0,    0,    0,    0,    0,  308,    0, 
            0,  308,    0,    0,  308,  308,    0,  308,    0,  308, 
            0,    0,    0,  308,    0,    0,    0,    0,    0,    0, 
            0,  308,    0,   17,    0,    0,  308,  308,  308,  308, 
          308,  308,    0,    0, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

            0,  308,    0,  308,  308,    0,  308,  308,  308,  308, 
            0,  308,  308,    0,    0,    0,    0,    0,    0,  544, 
          544,  544,  544,  544,  544,  544,  544,  544,  544,  544, 
            0,    0,  544,  544,    0,  544,  544,  544,  544,  544, 
          544,  544,  648,    0,    0,    0,  544,  544,  544,  544, 
          544,  544,  544,    0,    0,  544,    0,    0,    0,    0, 
            0,  544,  544,    0,  544,  544,  544,  544,    0,  544, 
          544,  544,  544,  544,  544,    0,  544,  544,  544,  544, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  648,    0,    0,    0,    0,    0,    0,    0,    0, 
          544,    0,    0,  544,    0,    0,  544,  544,    0,  544, 
            0,  544,    0,    0,    0,  544,    0,    0,    0,    0, 
            0,    0,    0,  544,    0,    0,    0,    0,  544,  544, 
          544,  544,  544,  544,    0,    0,    0,  544,    0,  544, 
          544,    0,  544,  544,  544,  544,    0,  544,  544,    0, 
            0,    0,  648,  648,  648,  648,  648,  648,  648,  648, 
          648,  648,  648,    0,    0,  648,  648,    0,  648,  648, 
          648,  648,  648,  648,  648,  310,    0,    0,    0,  648, 
          648,  648,  648,  648,  648,  648,    0,    0,  648,    0, 
            0,    0,    0,    0,  648,  648,    0,  648,  648,  648, 
          648,    0,  648,  648,  648,  648,  648,  648,    0,  648, 
          648,  648,  648,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  648,    0,    0,  648,    0,    0,  648, 
          648,    0,  648,    0,  648,    0,    0,    0,  648,    0, 
            0,    0,    0,    0,    0,    0,  648,    0,    0,    0, 
            0,  648,  648,  648,  648,  648,  648,    0,    0,    0, 
          648,    0,  648,  648,    0,  648,  648,  648,  648,    0, 
          648,  648,    0,    0,    0,    0,    0,    0,  648,  648, 
          648,  648,  648,  648,    0,    0,    0,  648,  648,    0, 
            0,    0,  648,    0,  648,  648,  648,  648,  648,  648, 
          648,  234,    0,    0,    0,  648,  648,  648,  648,  648, 
          648,  648,    0,    0,  648,    0,    0,    0,    0,    0, 
          648,  648,    0,  648,  648,  648,  648,    0,  648,  648, 
          648,  648,  648,  648,    0,  648,  648,  648,  648,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          233,    0,    0,    0,    0,    0,    0,    0,    0,  648, 
            0,    0,  648,    0,    0,  648,  648,    0,  648,    0, 
          648,    0,    0,    0,  648,    0,    0,    0,    0,    0, 
            0,    0,  648,    0,    0,  648,    0,  648,  648,  648, 
          648,  648,  648,    0,    0,    0,  648,    0,  648,  648, 
            0,  648,  648,  648,  648,    0,  648,  648,    0,    0, 
            0,    0,  312,  312,  312,  312,  312,    0,    0,    0, 
          312,  312,    0,    0,    0,  312,    0,  312,  312,  312, 
          312,  312,  312,  312,  291,    0,    0,    0,  312,  312, 
          312,  312,  312,  312,  312,    0,    0,  312,    0,    0, 
            0,    0,    0,  312,  312,    0,  312,  312,  312,  312, 
            0,  312,  312,  312,  312,  312,  312,    0,  312,  312, 
          312,  312,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  312,    0,    0,  312,    0,  310,  312,  312, 
            0,  312,    0,  312,    0,    0,    0,  312,    0,    0, 
            0,    0,    0,    0,    0,  312,    0,    0,    0,    0, 
          312,  312,  312,  312,  312,  312,    0,    0,    0,  312, 
            0,  312,  312,    0,  312,  312,  312,  312,    0,  312, 
          312,    0,    0,    0,    0,    0,    0,    0,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,  212,  213,  214, 
          215,    0,    0,   26,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  216,  217,  218,    0,  219,   35,  220, 
          221,  222,  223,  336,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  224,    0, 
            0,  225,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,    0,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
          212,  213,  214,  215,    0,    0,   26,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  216,  217,  218,    0, 
          219,   35,  220,  221,  222,  223,  644,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  224,    0,    0,  225,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
            0,    0,    0,    0,    0,    0,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  241,  242,   17,   18,    0,    0, 
            0,    0,   19,  243,  244,  323,  324,  325,  326,    0, 
            0,  249,    0,    0,    0,    0,    0,    0,  250,    0, 
            0,  327,  328,  329,    0,  330,   35,  331,  332,  333, 
          334,    0,   40,    0,    0,  259,    0,    0,    0,    0, 
          459,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  335,    0,    0,  225, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,    0,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  241,  242,   17, 
           18,    0,    0,    0,    0,   19,  243,  244,  323,  324, 
          325,  326,    0,    0,  249,    0,    0,    0,    0,    0, 
            0,  250,    0,    0,  327,  328,  329,    0,  330,   35, 
          331,  332,  333,  334,    0,   40,    0,    0,  259,  459, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  335, 
            0,    0,  225,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,    4,    5, 
            6,    7,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,   27, 
           28,   29,   30,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   44,    0, 
            0,   45,    0,    0,   46,   47,    0,   48,    0,   49, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,    4,    5,    6, 
            7,  304,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,   22,   23,   24,   25, 
            0,    0,   26,    0,    0,    0,    0,    0,   27,   28, 
            0,   30,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   44,    0,    0, 
           45,    0,    0,   46,   47,    0,   48,    0,   49,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
           51,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,  112,  113,  114,  115, 
          116,  117,  118,  119,  120,  121,  122,  123,  124,  125, 
          126,  127,  128,  129,  130,  131,  132,  133,  134,  135, 
            0,    0,  136,  137,  138,  139,  140,  141,  142,  143, 
          144,  145,    0,    0,    0,    0,  146,  147,  148,  149, 
          150,  151,  152,  153,    0,  154,  155,  156,  157,  158, 
          159,    0,    0,  160,  161,    0,  162,  163,  164,  165, 
          166,  167,  168,    0,    0,  169,  170,    0,    0,    0, 
          171,  172,  173,  174,    0,    0,    0,    0,    0,    0, 
          175,    0,    0,    0,    0,    0,    0,  176,  177,    0, 
          178,  179,  180,  181,  182,  183,  184,  185,  186,  187, 
          188,    0,    0,  189,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  190,  112,  113,  114,  115, 
          116,  117,  118,  119,  120,  121,  122,  123,  124,  125, 
          126,  127,  128,  129,  130,  131,  132,  133,  134,  135, 
            0,    0,  136,  137,  138,  196,  197,  198,  199,  143, 
          144,  145,    0,    0,    0,    0,  146,  147,  148,  149, 
          150,  200,  201,  202,    0,  203,  155,  343,  344,  204, 
          345,    0,    0,  160,  161,    0,  162,  163,  164,  165, 
          166,  167,  168,    0,    0,  169,  170,    0,    0,    0, 
          171,  172,  173,  174,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  176,  177,    0, 
          178,  179,  180,  181,  182,  183,  184,  185,  186,  187, 
          188,    0,    0,  189,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  190,  112,  113,  114,  115, 
          116,  117,  118,  119,  120,  121,  122,  123,  124,  125, 
          126,  127,  128,  129,  130,  131,  132,  133,  134,  135, 
            0,    0,  136,  137,  138,  196,  197,  198,  199,  143, 
          144,  145,    0,    0,    0,    0,  146,  147,  148,  149, 
          150,  200,  201,  202,    0,  203,  155,  293,    0,  204, 
            0,    0,    0,  160,  161,    0,  162,  163,  164,  165, 
          166,  167,  168,    0,    0,  169,  170,    0,    0,    0, 
          171,  172,  173,  174,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  176,  177,    0, 
          178,  179,  180,  181,  182,  183,  184,  185,  186,  187, 
          188,    0,    0,  189,   52,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  190,  112,  113,  114,  115, 
          116,  117,  118,  119,  120,  121,  122,  123,  124,  125, 
          126,  127,  128,  129,  130,  131,  132,  133,  134,  135, 
            0,    0,  136,  137,  138,  196,  197,  198,  199,  143, 
          144,  145,    0,    0,    0,    0,  146,  147,  148,  149, 
          150,  200,  201,  202,    0,  203,  155,    0,    0,  204, 
            0,    0,    0,  160,  161,    0,  162,  163,  164,  165, 
          166,  167,  168,    0,    0,  169,  170,    0,    0,    0, 
          171,  172,  173,  174,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  176,  177,    0, 
          178,  179,  180,  181,  182,  183,  184,  185,  186,  187, 
          188,    0,    0,  189,   52,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  190,  112,  113,  114,  115, 
          116,  117,  118,  119,  120,  121,  122,  123,  124,  125, 
          126,  127,  128,  129,  130,  131,  132,  133,  134,  135, 
            0,    0,  136,  137,  138,  196,  197,  198,  199,  143, 
          144,  145,    0,    0,    0,    0,  146,  147,  148,  149, 
          150,  200,  201,  202,    0,  203,  155,    0,    0,  204, 
            0,    0,    0,  160,  161,    0,  162,  163,  164,  165, 
          166,  167,  168,    0,    0,  169,  170,    0,    0,    0, 
          171,  172,  173,  174,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  176,  177,    0, 
          178,  179,  180,  181,  182,  183,  184,  185,  186,  187, 
          188,    0,    0,  189,    0,    0,    0,    0,    0,    0, 
            3,    4,    5,    6,    7,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,  190,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,   29,   30,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   44,    0,    0,   45,    0,    0,   46,   47,    0, 
           48,    0,   49,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
          303,    4,    5,    6,    7,  304,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,    0,   30,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   44,    0,    0,  305,    0,    0,   46,   47,    0, 
           48,    0,   49,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
          303,    4,    5,    6,    7,  304,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,    0,   30,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   44,    0,    0,   45,    0,    0,   46,   47,    0, 
           48,    0,   49,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,  212, 
          213,  214,  215,    0,    0,  249,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  216,  217,  218,    0,  219, 
           35,  220,  221,  222,  223,  269,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          224,    0,    0,  225,    0,    0,   46,   47,    0,   48, 
            0,  270,    0,  271,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  272,    0,    0,    0,    0,   52,  273, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  274, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  241,  242, 
           17,   18,    0,    0,    0,    0,   19,  243,  244,  212, 
          213,  214,  215,    0,    0,  249,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  216,  217,  218,    0,  219, 
           35,  220,  221,  222,  223,  269,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          224,    0,    0,  225,    0,    0,   46,   47,    0,   48, 
            0,  698,    0,  271,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  272,    0,    0,    0,    0,   52,  273, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  274, 
          283,  283,  283,    0,  283,    0,    0,    0,  283,  283, 
            0,    0,    0,  283,    0,  283,  283,  283,  283,  283, 
          283,  283,    0,    0,    0,    0,  283,  283,  283,  283, 
          283,  283,  283,    0,    0,  283,    0,    0,    0,    0, 
            0,    0,  283,    0,    0,  283,  283,  283,    0,  283, 
          283,  283,  283,  283,  283,  283,  283,  283,  283,  283, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          283,    0,    0,  283,    0,    0,  283,  283,    0,  283, 
            0,  283,    0,  283,    0,  283,    0,    0,    0,    0, 
            0,    0,    0,  283,    0,    0,    0,    0,  283,  283, 
          283,  283,  283,  283,    0,    0,    0,  283,    0,  283, 
          283,    0,  283,  283,  283,  283,    0,  283,  283,  283, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  241,  242, 
           17,   18,    0,    0,    0,    0,   19,  243,  244,  212, 
          213,  214,  215,    0,    0,  249,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  216,  217,  218,    0,  219, 
           35,  220,  221,  222,  223,  269,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          224,    0,    0,  225,    0,    0,   46,   47,    0,   48, 
            0,  270,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  272,    0,    0,    0,    0,   52,  273, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  274, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  241,  242, 
           17,   18,    0,    0,    0,    0,   19,  243,  244,  212, 
          213,  214,  215,    0,    0,  249,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  216,  217,  218,    0,  219, 
           35,  220,  221,  222,  223,  269,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          224,    0,    0,  225,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,  271,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  272,    0,    0,    0,    0,   52,  273, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  274, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  241,  242, 
           17,   18,    0,    0,    0,    0,   19,  243,  244,  212, 
          213,  214,  215,    0,    0,  249,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  216,  217,  218,    0,  219, 
           35,  220,  221,  222,  223,  269,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          224,    0,    0,  225,    0,    0,   46,   47,    0,   48, 
            0,  698,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  272,    0,    0,    0,    0,   52,  273, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  274, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  241,  242, 
           17,   18,    0,    0,    0,    0,   19,  243,  244,  212, 
          213,  214,  215,    0,    0,  249,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  216,  217,  218,    0,  219, 
           35,  220,  221,  222,  223,  269,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          224,    0,    0,  225,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  272,    0,    0,    0,    0,   52,  273, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  274, 
            4,    5,    6,    7,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,    0, 
            0,   27,   28,   29,   30,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           44,    0,    0,   45,    0,    0,   46,   47,    0,   48, 
            0,   49,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,    4, 
            5,    6,    7,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
           27,   28,    0,   30,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   44, 
            0,    0,   45,    0,    0,   46,   47,    0,   48,    0, 
           49,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  241,  242,   17,   18, 
            0,    0,    0,    0,   19,  243,  244,  212,  213,  214, 
          215,    0,    0,  249,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  216,  217,  218,    0,  219,   35,  220, 
          221,  222,  223,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  224,    0, 
            0,  225,  496,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  272,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,  212,  213,  214,  215, 
            0,    0,  249,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  216,  217,  218,    0,  219,   35,  220,  221, 
          222,  223,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  224,    0,    0, 
          225,    0,    0,   46,   47,    0,   48,    0,  636,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          272,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  241,  242,   17,   18,    0,    0, 
            0,    0,   19,  243,  244,  212,  213,  214,  215,    0, 
            0,  249,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,  216,  217,  218,    0,  219,   35,  220,  221,  222, 
          223,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  224,    0,    0,  225, 
            0,    0,   46,   47,    0,   48,    0,  270,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  272, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  241,  242,   17,   18,    0,    0,    0, 
            0,   19,  243,  244,  212,  213,  214,  215,    0,    0, 
          249,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
          216,  217,  218,    0,  219,   35,  220,  221,  222,  223, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  224,    0,    0,  225,    0, 
            0,   46,   47,    0,   48,    0,  636,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  272,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  241,  242,   17,   18,    0,    0,    0,    0, 
           19,  243,  244,  212,  213,  214,  215,    0,    0,  249, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  216, 
          217,  218,    0,  219,   35,  220,  221,  222,  223,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  224,    0,    0,  225,    0,    0, 
           46,   47,    0,   48,    0,  902,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  272,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  241,  242,   17,   18,    0,    0,    0,    0,   19, 
          243,  244,  212,  213,  214,  215,    0,    0,  249,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  216,  217, 
          218,    0,  219,   35,  220,  221,  222,  223,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  224,    0,    0,  225,    0,    0,   46, 
           47,    0,   48,    0,  698,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  272,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
           65,   66,  637,  637,  637,    0,  637,    0,    0,    0, 
          637,  637,    0,    0,    0,  637,    0,  637,  637,  637, 
          637,  637,  637,  637,    0,    0,    0,    0,  637,  637, 
          637,  637,  637,  637,  637,    0,    0,  637,    0,    0, 
            0,    0,    0,    0,  637,    0,    0,  637,  637,  637, 
            0,  637,  637,  637,  637,  637,  637,    0,  637,  637, 
          637,  637,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  637,    0,    0,  637,  637,    0,  637,  637, 
            0,  637,    0,    0,    0,    0,    0,  637,    0,    0, 
            0,    0,    0,    0,    0,  637,    0,    0,    0,    0, 
          637,  637,  637,  637,  637,  637,    0,    0,    0,  637, 
            0,  637,  637,    0,  637,  637,  637,  637,    0,  637, 
          637,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
          212,  213,  214,  215,    0,    0,   26,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  216,  217,  218,    0, 
          219,   35,  220,  221,  222,  223,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  224,    0,    0,  225,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  241,  242, 
           17,   18,    0,    0,    0,    0,   19,  243,  244,  212, 
          213,  214,  215,    0,    0,  249,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  216,  217,  218,    0,  219, 
           35,  220,  221,  222,  223,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          224,    0,    0,  225,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  272,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,  212,  213, 
          214,  215,    0,    0,  249,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,  216,  217,  218,    0,  219,   35, 
          220,  221,  222,  223,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  224, 
            0,    0,  225,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  272,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,  637,  637, 
          637,    0,  637,    0,    0,    0,  637,  637,    0,    0, 
            0,  637,    0,  637,  637,  637,  637,  637,  637,  637, 
            0,    0,    0,    0,  637,  637,  637,  637,  637,  637, 
          637,    0,    0,  637,    0,    0,    0,    0,    0,    0, 
          637,    0,    0,  637,  637,  637,    0,  637,  637,  637, 
          637,  637,  637,    0,  637,  637,  637,  637,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  637,    0, 
            0,  637,    0,    0,  637,  637,    0,  637,    0,    0, 
            0,    0,    0,  637,    0,    0,    0,    0,    0,    0, 
            0,  637,    0,    0,    0,    0,  637,  637,  637,  637, 
          637,  637,    0,    0,    0,  637,    0,  637,  637,    0, 
          637,  637,  637,  637,    0,  637,  637,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  241,  242,   17,   18,    0, 
            0,    0,    0,   19,  243,  244,  421,  422,  423,  424, 
            0,    0,  249,    0,    0,    0,    0,    0,    0,  250, 
            0,    0,  425,  426,  427,    0,  428,   35,  156,  157, 
          429,  159,    0,   40,    0,    0,  259,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  430,    0,    0,    0,  431,    0,    0, 
          225,    0,    0,   46,   47,    0,   48,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  241,  242,   17,   18,    0,    0, 
            0,    0,   19,  243,  244,  421,  422,  423,  424,    0, 
            0,  249,    0,    0,    0,    0,    0,    0,  250,    0, 
            0,  425,  426,  427,    0,  428,   35,  156,  157,  429, 
          159,    0,   40,    0,    0,  259,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  431,    0,    0,  225, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  241,  242,   17,   18,    0,    0,    0, 
            0,   19,  243,  244,  323,  324,  325,  326,    0,    0, 
          249,    0,    0,    0,    0,    0,    0,  250,    0,    0, 
          327,  328,  329,    0,  330,   35,  331,  332,  333,  334, 
            0,   40,    0,    0,  259,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  335,    0,    0,  410,    0, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  241,  242,   17,   18,    0,    0,    0,    0, 
           19,  243,  244,  980,  981,  982,  983,    0,    0,  249, 
            0,    0,    0,    0,    0,    0,  250,    0,    0,  984, 
          985,  986,    0,  987,   35,  988,  989,  990,  991,    0, 
           40,    0,    0,  259,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  992,    0,    0,  225,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  241,  242,   17,   18,    0,    0,    0,    0,   19, 
          243,  244,  421,  422,  423,  424,    0,    0,  249,    0, 
            0,    0,    0,    0,    0,  250,    0,    0,  425,  426, 
          427,    0, 1031,   35,  156,  157, 1032,  159,    0,   40, 
            0,    0,  259,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0, 1033,    0,    0,  225,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
           65,   66,  796,  611,    0,    0,  797,    0,    0,    0, 
          160,  161,    0,  162,  163,  164,  165,  166,  167,  168, 
            0,    0,  169,  170,    0,    0,    0,  171,  172,  173, 
          174,    0,    0,    0,    0,    0,    0,  287,    0,    0, 
            0,    0,    0,    0,  176,  177,    0,  178,  179,  180, 
          181,  182,  183,  184,  185,  186,  187,  188,  625,  619, 
          189,    0,  626,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,  166,  167,  168,    0,    0,  169,  170, 
            0,    0,  190,  171,  172,  173,  174,    0,    0,    0, 
            0,    0,    0,  287,    0,    0,    0,    0,    0,    0, 
          176,  177,    0,  178,  179,  180,  181,  182,  183,  184, 
          185,  186,  187,  188,  897,  611,  189,    0,  898,    0, 
            0,    0,  160,  161,    0,  162,  163,  164,  165,  166, 
          167,  168,    0,    0,  169,  170,    0,    0,  190,  171, 
          172,  173,  174,    0,    0,    0,    0,    0,    0,  287, 
            0,    0,    0,    0,    0,    0,  176,  177,    0,  178, 
          179,  180,  181,  182,  183,  184,  185,  186,  187,  188, 
          900,  619,  189,    0,  901,    0,    0,    0,  160,  161, 
            0,  162,  163,  164,  165,  166,  167,  168,    0,    0, 
          169,  170,    0,    0,  190,  171,  172,  173,  174,    0, 
            0,    0,    0,    0,    0,  287,    0,    0,    0,    0, 
            0,    0,  176,  177,    0,  178,  179,  180,  181,  182, 
          183,  184,  185,  186,  187,  188, 1069,  611,  189,    0, 
         1070,    0,    0,    0,  160,  161,    0,  162,  163,  164, 
          165,  166,  167,  168,    0,    0,  169,  170,    0,    0, 
          190,  171,  172,  173,  174,    0,    0,    0,    0,    0, 
            0,  287,    0,    0,    0,    0,    0,    0,  176,  177, 
            0,  178,  179,  180,  181,  182,  183,  184,  185,  186, 
          187,  188, 1072,  619,  189,    0, 1073,    0,    0,    0, 
          160,  161,    0,  162,  163,  164,  165,  166,  167,  168, 
            0,    0,  169,  170,    0,    0,  190,  171,  172,  173, 
          174,    0,    0,    0,    0,    0,    0,  287,    0,    0, 
            0,    0,    0,    0,  176,  177,    0,  178,  179,  180, 
          181,  182,  183,  184,  185,  186,  187,  188, 1091,  611, 
          189,    0, 1092,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,  166,  167,  168,    0,    0,  169,  170, 
            0,    0,  190,  171,  172,  173,  174,    0,    0,    0, 
            0,    0,    0,  287,    0,    0,    0,    0,    0,    0, 
          176,  177,    0,  178,  179,  180,  181,  182,  183,  184, 
          185,  186,  187,  188,  625,  619,  189,    0,  626,    0, 
            0,    0,  160,  161,    0,  162,  163,  164,  165,  166, 
          167,  168,    0,    0,  169,  170,    0,    0,  190,  171, 
          172,  173,  174,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  176,  177,    0,  178, 
          179,  180,  181,  182,  183,  184,  185,  186,  187,  188, 
            0,    0,  189,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  190, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

           26,  280,   28,    2,    3,   88,   21,  461,   91,   74, 
            9,   10,   11,   27,    7,   14,   15,   16,  478,  475, 
            6,  456,  478,   51,  296,    0,    3,  100,  318,   11, 
           21,    7,  322,  232,   27,  355,   10,    0,   10,   59, 
            9,   10,   11,  561,  562,   10,   45,   49,   15,   16, 
           49,   27,   51,  677,   10,   15,   16,  517,   59,    0, 
           14,  852,    6,    7,   15,   16,   52,  691,  280,   10, 
           10,  105,   15,   16,   10,   10,  570,  748,   10,   45, 
           10,   11,  105,   27,   10,   59,   10,   59,   44,    2, 
            3,   10,  107,  401,   10,   49,   47,   48,   10,  723, 
           10,  100,  280,   59,   47,  940,  341,  746,   52,  108, 
          109,  110,  349,   10,  351,  413,  107,  305,   59,  431, 
          305,  875,  328,  105,   59,    2,    3,   59,   10,  341, 
          336,   10,  305, 1027,   44,   61,   10,   14,   43,   10, 
           59,  108,  450,  341,   10,  228,  100,   44,  108,   59, 
          362,  379,  380,  381,  382,  109,  110,  108,  466,   10, 
          400,    2,  402,   10,   61,  108,  406,   10,   45,   44, 
           44,   10,   49,   44,  310,  799,   10,   59,  342,  262, 
          407,   10,  409,   10,  362,   59,   61,  414,   59,  407, 
          375, 1085,  312,   59,   10,  359,  414,  317,  366,  355, 
          954,  235,  375,   10,   10,   10,   47,   48,  487,  449, 
           10,  451,  211, 1048,   61, 1006,  299,  525,  290,  291, 
           59,   10,  410,  100,  250,   59,  225,  467,  548,  244, 
          350,  351,  109,  110,   10,  472,   10,   10,  362,   44, 
          239,  240,   10,   59,   44,   10,  706,   10,   10,  705, 
          706,  362,  267,  235,  337,   61,   10,  342,  306,   59, 
          407,  501,  310,  336,   10,   32,  386,  414,   44,   10, 
          239,  240,    0,  307,  359,  899,  947,  345,   10,   10, 
           32,   10,   10,   59,  307,  284,  526,  286,  287,  268, 
          269,  290,   45,  292,   59,  363,   59,  296,  297,    2, 
            3,  538,  941,   44,  303,  452,  305,  454,   10,  239, 
          240,   14,   44,   44,   32,  314,   32,  284,   59,  286, 
           10,  290,  342,  292,  284,  307,  286,  287,   59,   10, 
           59,   59,   32,  284,  211,  286,  573,  336,  856,  305, 
           10,  284,   45,  286,  862,  863,   10,  865,  225,  867, 
          662,  770,   32,  279,  259,  663,  503,  776,  359,   61, 
           91,  282,  281,  362,  363,  364,  365,  366,  367,  368, 
          305,   61,  670,   61,   44,  829,  870,  342,   59,  407, 
          345,  409,  336,  296, 1023,  413,  414,  402,  363,   59, 
          303,  363,  548,  362,  363,  364,  365,   61,  367,  368, 
          363,  314,  401,  359,  279,  345,  342,  342,  407,  411, 
          409,  410,  411,  387,  413,  414,  342,  416,  342,  296, 
          297,  700,  363,  305,  664,  341,  303,  359,  305,  719, 
          342,  430,  362,  363,  364,  365,  451,  314,  437,  416, 
          375,  401, 1081,  715,  410,  342,  287, 1071,  447,  359, 
          338,  450,  467,  366,  527,  296,  455,  411,  402,  336, 
          342,  430,  406,  342,  958,   44,  409,  466,  437,  963, 
          413,  931,  225,  279,   44,  931,  784,   61,  460,  461, 
           10,  495,  802,  682,  804,  359,  501,   44,  359,  366, 
          450,  342,  927,  375,  731,  342,  338,  496, 1016, 1017, 
         1018, 1019,  495,  416,  373,  305,  466,  451,  211,  378, 
          509,  526,   91,  342,  457,  342,  345,  310,  345,  495, 
          359,  758,  225,  467,  475,  359,  525,  496,  527,  305, 
          407,  271,  409,  410,  411,  342,  342,  414,  345,  416, 
          767,  768,  342,  783,  297,  785,  773,  774,  631,  767, 
          768,  495,  305,  342,  833,  773,  774,  501,  338,  786, 
          401,  325, 1080,  514,  305,  525,  342, 1061,  342,  342, 
          447,  644,  527,  527,  342,  375,   61,  279,  455,  342, 
          342,  607,  526,  359,  350,  351,  267,   10,  342,  279, 
          746,  617,  748,  296,  297,  359,  342,  328,  613,  375, 
          303,  342,  305,  373,  335,  336,  621,  671,  378,  450, 
          341,  314,  627,  342,  338,  279,  680,   59,  359,  290, 
          767,  768,  613,  548,  341,  466,  773,  774,  359,  279, 
          621,   10,  509,   10,  375,  305,  627,   10,   61,   44, 
          342,  312,  313,    2,    3,  644,  802,  720,  804,  664, 
          527,  677,  342,  371,  372,  669,   91,  410,   10,  886, 
          378,  263,  264,  366,  663,  691,  665,   44,  886,  308, 
          817,  818,  342,  820,  821,  690,  669,  310,  342,  694, 
           59,  269,  668,  271,  525,   10,   45,  339,   61,  644, 
          644,  371,  372,  669,  447,   91,  695,  723,  378,   10, 
          279,  547,  455,  663,  407,  375,  409,  410,   44,   61, 
          317,  414,   10,  416,  740,  780,  715,  916,  791,  875, 
          664,  720,  317,  922,  668,  669,  695,  670,  338,  342, 
           10,   44, 1040,  345,   10,   10,   61,  376,  377,  767, 
          768,  322,  323,   44,  447,  773,  774,  363,   59,  328, 
          310,   10,  455,   44,  705,   44,  335,  336,  786,   10, 
          290,  291,  341,   61,   44,  695,  720,  644,  767,  768, 
          785,   10,  347,  799,  773,  774,  357,  358,   91,   59, 
          621,  357,  781,   59,   59,  784,  627,  786,  665,  262, 
           91,  947,  791,   44,  264,  794,  795,  264,   48,  267, 
           59, 1041,  715,  341,  803,  363,  509,  342,   59,  480, 
           44,  793,  811,  263,  264,  814,   91,  488,  489,  269, 
           59,   44,  663,  363,  784,  794,  825,  826,  827,  670, 
          671,  362,  673,   44,  306,  506,  791,  791,  715,  680, 
          306,  785,   44,  720,   44,  814,   44,  829,  746,  875, 
          748,  728,  211,  694,   44,  306,  279,   44,  886,   10, 
          859,  860,   61,  927,  794,  264,  225, 1023,  781,  363, 
           44, 1027,  264,  899,  715,  328,    0,  802,  877,  804, 
          879,  338,  335,  336,  814,  264,   10,  886,  734,  735, 
          767,  768,  338,  328,  338,  338,  773,  774,  850,  297, 
          335,  336,   61,   44,  781,   44,  279,  906,   59,  786, 
          993,  341,  269,  338,  791,   44,  915,  338,  795,  342, 
          919,  762,  338,  764,  338,  907,  803,  279,  954, 1085, 
          264,  913,  328,   32,  811,   59,   44,  296,  297,  335, 
          336,   32,    0,  784,  303,   58,  305,  338,  825,  826, 
          827,  345,   10,  264,  279,  314,  363,  264,  269,  339, 
          271,  915,  665,  371,  372,  964,  279,  263,  809,  342, 
          378,  812,  643,  338,  264,  383,  264,  875,  279,   44, 
          979,  279,  859,  860,  936, 1011,   44,  267,  743,  363, 
          342,  267,  267,  748,   10,  666,   44,  996,  342,  998, 
          877,   59,  879,   10,  850, 1004,  852,  366,  267,  886, 
          964,   44,  715,   59,   44,  328,  267,  342,    0,  269, 
          270,  271,  335,  336,  274,  264, 1041,  328,   10,  906, 
          269,   44,   44,   10,  335,  336, 1035,  264,  915,  710, 
          264, 1040,  919,   59,  342, 1071, 1045,  718,  407,  947, 
          409,  410,   59,  328,  264,  414, 1008,  416,  811,  339, 
          335,  336,   44,  339,  767,  768,  750,  264,  739,  753, 
          773,  774,  825,  826,  827,   44,   58,   59,  781,  264, 
         1040, 1035,   59,  786,  363,   44,  927,  964,  447,   44, 
          936,  937,  795,   44,   44, 1047,  455, 1041,  359,   61, 
          803,  264,  979,  310,   44,   10,  859,  860,  811,   44, 
          359,  262,  263,  264,   91,  310,   15,   16,  269,  996, 
          875,  998,  825,  826,  827, 1023,  879, 1004,  665, 1027, 
          264,  264,  306,   10,  308,  309,  310,  311,  262,  263, 
          264,   44,   41,   42,  268,  269,   44,  271,   47,   48, 
          509,   50,   51,   44,   59,   44,  859,  860, 1035,  409, 
         1006,  317, 1008,  413,   44,  387,  919,   44, 1045,  293, 
          294,  295,  296,  297,  877,   44,  879,  306,  849,  308, 
          309,  310,  311,  886,   61,  271,   91, 1085,   91,  271, 
          945,  875,  947,  349,  949,  345,  363,  353,  354, 1040, 
          342, 1047, 1043,  906,  262,  263,  264,  457,  345,  108, 
          268,  269,  915,  271,   91,  341,  919,   91,  342,  371, 
          372,  373,  345,  317,  474,  475,  378,  363,  478,   58, 
          345,   70,  290,  291,  273,  293,  294,  295,  296,  363, 
          911,   54,  264,  996,  573,  998,  110,  509,  264, 1043, 
            6, 1004,  268,  269,  764,  349,  263,  264,  795,  353, 
          354,  355,  356,  387,  514, 1020,  803,  517,    0,  627, 
          914,  746, 1027,   10,  875, 1025,  979,  779,   10,  750, 
          262,  263,  264,  654,  342,  267,  268,  269, 1023,  271, 
          267,  396, 1045,  996,   14,  998, 1051, 1042,   44,  281, 
          282, 1004,  734,   89, 1048,  363,  665,   44,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,  371,  372, 
          373,  571,   -1,  305,   61,  378,   -1,   59, 1083,  387, 
         1085,   -1,   -1, 1088,   10,  388, 1020,   -1,   -1, 1023, 
          877, 1025, 1045, 1027,   -1,   91, 1101,   -1,  371,  372, 
          373,  328,   -1,   -1,   91,  378,  715,  339,  335,  336, 
          342,   -1,  267,  345,   10,  347,   -1,   -1,   -1,  906, 
          269,  270,  271,  272,   -1,  274,  279,  371,  372,  373, 
            0,  363,   -1,   59,  378,  284,  636,  286,  287,   -1, 
           10,   91,   -1,  375,   -1,   -1,  295, 1081,   -1, 1083, 
           -1, 1085,  279,   -1, 1088,  387,   -1,   -1,  767,  768, 
           -1,   -1,   -1,   59,  773,  774,   -1, 1101,   -1,   -1, 
          670,   -1,  781,  328,   44,  328,   -1,  786,   -1,   -1, 
          335,  336,  335,  336,   -1,   -1,  795,   -1,   58,   59, 
           -1,   -1,  979,   63,  803,   91,  696,   -1,  698,   10, 
           -1,  328,  811,   -1,  328,  705,  706,   -1,  335,  336, 
           10,  335,  336,   -1,  341,  342,  825,  826,  827,   -1, 
          369,  370,  371,  372,  373,   -1,   -1,  376,  377,  378, 
          379,  380,  381,  382,  383,  384,  385,  386,  387,  388, 
          389,   -1,   -1,  392,  393,  394,  395,   -1,   59,   -1, 
          859,  860,  401,   -1,  403,   -1,  756,   -1,  407,   59, 
          409,   -1,   -1,   -1,  413,  414,   91,   -1,  877,   -1, 
          879,   91,   -1,   10,   -1,   -1,   -1,  886,   -1,   -1, 
          262,  263,  264,  279,  280,  267,  268,  269,  788,  271, 
           -1,   91,  279,  280,   -1,   -1,   10,  906,   -1,  281, 
           -1,  450,   -1,  452,  453,  454,   -1,   -1,  457,   -1, 
          919,  293,  294,  295,  296,  297,  306,  466,  308,  309, 
          310,  311,   59,   14,  824,  474,  475,   -1,   -1,  478, 
           44,   -1,  328,   10,   -1,   -1,  262,  263,  264,  335, 
          336,  328,  268,  269,   -1,  271,   -1,   61,  335,  336, 
           41,   42,   -1,  502,  503,  342,   47,   48,   49,   50, 
          342,   -1,   -1,   -1,   91,  514,  362,   -1,  517,   -1, 
          979,  267,  371,  372,  373,  362,  525,   91,  328,  378, 
           -1,  363,   59,   -1,  280,  335,  336,  996,   -1,  998, 
           -1,   -1,  262,  263,  264, 1004,   -1,  267,  268,  269, 
           -1,  271,  902,   -1,   -1,  387,   -1,   10,   -1,  100, 
           -1,  281,  282,   -1,   91,   -1,  342,   91,  109,  110, 
          290,  291,  571,  293,  294,  295,  296,  297,   -1,   91, 
           -1,  931,  328,   -1,   -1,  305, 1045,  363,   -1,  335, 
          336,   44,   -1,   -1,   -1,  341,   -1,  317,  318,  319, 
          320,  321,   -1,   -1,  324,  325,  326,  327,   61,  329, 
          330,  387,   -1,  333,  334,   -1,  362,  267,   -1,  339, 
           -1,   10,  342,   -1,   -1,  345,   44,  347,   -1,  349, 
          280,  351,   -1,  353,  354,  355,  356,  636,   91,  359, 
           -1,  361,   -1,  363,   -1,  306,   -1,  308,  309,  310, 
          311,  312,   -1,  328,   -1,  375,  317,   -1,  328,    0, 
          335,  336,   -1,   -1,  663,  335,  336,  387,   -1,   10, 
           59,  670,   -1,   91,   -1,  262,  263,  264,  328,  340, 
           -1,  268,  269,   -1,  271,  335,  336,  348,  349,  350, 
          351,  341,  308,  309,   -1,  311,   -1,  696,   -1,  698, 
           -1,   10,   91,   44,   -1,   -1,  705,  706,   -1,   -1, 
           14,   -1,  362,   -1,   -1,  279,  280,   58,   59,  371, 
          372,  373,   63,   -1,   -1,  386,  378,   -1,  269,  270, 
          271,  272,   -1,  274,  371,  372,  373,   41,   42,   -1, 
          267,  378,   -1,   47,   48,   49,   50,   -1,   -1,   -1, 
           59,  328,   44,   -1,  295,  342,   -1,  756,  335,  336, 
          376,  377,   -1,   -1,  328,   -1,   -1,   -1,  767,  768, 
           -1,  335,  336,   -1,  773,  774,  363,  341,  342,   -1, 
           -1,   -1,   91,  782,   -1,  784,   -1,  786,   -1,  788, 
          293,  294,  295,  296,  297,  336,  100,   -1,  362,   91, 
          387,  328,   -1,   -1,  328,  109,  110,   -1,  335,  336, 
           -1,  335,  336,   44,  341,   -1,  328,   -1,  817,  818, 
           -1,  820,  821,  335,  336,  824,  279,  280,  369,  370, 
          371,  372,  373,   -1,   -1,  376,  377,  378,  379,  380, 
          381,  382,  383,  384,  385,  386,  387,  388,  389,    0, 
           -1,  392,  393,  394,  395,   -1,   -1,   -1,   -1,   10, 
           91,  279,  403,  306,   -1,  308,  309,  310,  311,   -1, 
          411,   -1,   -1,   -1,   -1,  328,   -1,   -1,  267,   -1, 
           -1,  880,  335,  336,   -1,   -1,   -1,  886,  341,  342, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,  340,   -1,   -1, 
           -1,   44,   -1,  902,   -1,  348,   -1,   58,   59,  362, 
          328,  452,  453,  454,   -1,   -1,  457,  335,  336,   -1, 
           -1,  262,  263,  264,   -1,  924,  267,  268,  269,   -1, 
          271,   10,  931,  474,  475,   -1,   -1,  478,   -1,  328, 
          281,  282,   -1,   -1,   -1,   -1,  335,  336,   91,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  267,   -1, 
           44,  502,  503,   -1,  305,  269,  270,  271,  272,   -1, 
          274,  280,   -1,  514,   -1,   -1,  517,   -1,   -1,   -1, 
           10,   -1,   -1,  324,  325,   -1,  527,  279,  329,  330, 
           -1,  295,   -1,   -1,   -1,    0,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   10,  347,   91,  306,   -1, 
          308,  309,  310,  311,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,  363,   -1,   -1,   -1,  335,  336,   -1,   59, 
          571,   -1,  336,   -1,  375,   -1,  328,   -1,   -1,   44, 
           -1, 1040,  340,  335,  336,   -1,  387,   -1,  279,   -1, 
          348,   10,   -1,  362,   59,   -1,   61,   -1,   63,   -1, 
           -1,   91,   -1,   -1,   -1,  369,  370,  371,  372,  373, 
           10,   -1,  376,  377,  378,  379,  380,  381,  382,  383, 
          384,  385,  386,  387,  388,  389,   91,   -1,  392,  393, 
          394,  395,   -1,   -1,   -1,  636,   -1,  328,   -1,  403, 
           59,   10,   -1,  644,  335,  336,   -1,  411,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   59, 
          271,   -1,   10,   -1,   10,   -1,   -1,   -1,   -1,  670, 
          281,  282,   91,   44,   -1,   44,  279,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  452,  453, 
          454,   91,   61,  457,  305,  696,   44,  698,   44,   -1, 
           -1,   -1,   -1,   -1,  705,  706,   -1,   -1,   -1,   -1, 
          474,  475,   -1,   61,  478,   61,   -1,   -1,   -1,  720, 
           91,   -1,   91,   -1,   -1,  328,   -1,   -1,  339,   -1, 
           -1,  342,  335,  336,  345,  279,  347,   -1,  502,  503, 
           -1,   44,   -1,   91,   -1,   91,    0,   -1,   -1,   -1, 
          514,   -1,  363,  517,   -1,  756,   10,   -1,   -1,   10, 
           -1,   -1,   -1,  527,  375,   10,   -1,  306,   -1,  308, 
          309,  310,  311,  312,   -1,   -1,  387,  267,  317,   -1, 
           -1,  782,   -1,   -1,  328,   -1,   -1,  788,   91,   -1, 
          791,  335,  336,   44,   -1,   44,   -1,  262,  263,  264, 
           10,  340,   10,  268,  269,   59,  271,  571,   59,  348, 
          349,  350,  351,   -1,   59,  280,  817,  818,   -1,  820, 
          821,   -1,   -1,  824,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   44,   -1,   -1,   -1,  328,   -1, 
           91,   -1,   91,   -1,  750,  335,  336,  386,  267,   59, 
           -1,   59,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   44,  267,  333,  334, 
          335,  336,  636,   -1,   -1,   -1,   -1,  342,   -1,  880, 
          644,   91,   -1,   91,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,  362,  363,   -1, 
           -1,  902,   44,   -1,   -1,   -1,  670,   -1,  279,  328, 
          279,  280,   -1,   91,  915,   -1,  335,  336,   -1,   -1, 
           -1,   -1,  387,  924,   -1,   -1,   -1,   -1,  328,   -1, 
          931,  279,  696,  279,  698,  335,  336,   -1,   -1,   -1, 
            0,  705,  706,  306,   -1,  308,  309,  310,  311,   91, 
           10,   -1,   -1,   -1,   -1,   -1,  720,  328,   -1,  328, 
           -1,   -1,   -1,  964,  335,  336,  335,  336,   -1,  875, 
           -1,   -1,  341,  342,   -1,   -1,  279,  340,   -1,   -1, 
          328,   -1,  328,   -1,   44,   -1,   -1,  335,  336,  335, 
          336,   -1,  756,  362,  342,   -1,  342,   -1,   58,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,  782,   -1, 
           -1,   -1,   -1,   -1,  788,  328,   -1,  791,   -1,  280, 
          279,   91,  335,  336, 1035,   -1,   -1,   -1,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  817,  818,   -1,  820,  821,   -1,  267, 
          824,  306,   -1,  308,  309,  310,  311,  312,   -1,   -1, 
          280,    0,  317,   -1,   -1,   -1,   -1,  328,   -1,  328, 
           -1,   10,   -1,  328,  335,  336,  335,  336,  342,   -1, 
          341,  336,   -1,   -1,   -1,  340,  341,   -1,   -1,   -1, 
           -1,  279,  280,  348,  349,  350,  351,   -1,  359,  363, 
           -1,  362,   -1,   -1, 1020,   44,  880, 1023,  328, 1025, 
          328, 1027,   -1,   -1,   -1,  335,  336,  335,  336,   58, 
           59,  341,   61,  387,   63,   -1,   -1,  279,  902,   -1, 
           -1,  386,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
          328,  915,  362,   -1,   -1,   -1,   -1,  335,  336,   -1, 
          924,   -1,   91,  341,   -1,   -1,   -1,  931,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1, 1081,   -1, 1083,   -1, 1085, 
           -1,   -1, 1088,   -1,  362,   -1,  328,   -1,   -1,   -1, 
           -1,   10,   -1,  335,  336, 1101,   -1,  257,  258,  259, 
          964,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           59,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330, 1035,   -1,  333,  334,  335,  336,  337,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,  375,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  386,  387,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,  875,   -1,  333,  334,  335,  336,  337,  338, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,    0,  374,  375,  376,  377,   -1, 
          379,  380,  381,  382,   10,  384,  385,  386,  387,   -1, 
           -1,  955,  262,  263,  264,  959,   -1,   -1,  268,  269, 
           -1,  271,   -1,  262,  263,  264,   -1,   -1,   -1,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,  306,   44,  308, 
          309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1, 
           -1,   -1,   58,   59,   -1,   61,   -1,   63,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
           -1,  340,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,  350,  351,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,  342,   -1,   -1,   -1,   -1, 1020,   -1,   -1, 
         1023,   -1, 1025,  342, 1027,   -1,  317,   -1,   -1,   -1, 
           -1, 1055,   -1,  363, 1058, 1059,   -1,  386, 1062, 1063, 
           -1,   -1,  333,  334,  363,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,  387,  349,   -1, 
          351,   -1,  353,  354,  355,  356,   -1,   -1,  387,   -1, 
           -1,   -1, 1096, 1097, 1098, 1099,   -1,   -1, 1081,   -1, 
         1083, 1105, 1085,   -1,   -1, 1088,   -1,   -1,  306,   44, 
          308,  309,  310,  311,  312,   -1,   -1,   -1, 1101,  317, 
           -1,   -1,   -1,   58,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,  317,  306,   -1,  308,  309,  310,  311,  312, 
           -1,   -1,  340,  341,  317,   -1,   -1,   -1,  333,  334, 
          348,  349,  350,  351,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  349,   -1,   -1,  340,  353,  354, 
          355,  356,   -1,   -1,   -1,  348,  349,  350,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  386,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,  386,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   59,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,  337,   -1,  339,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,  375, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          386,  387,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,  337,   -1,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,    0,  374, 
          375,  376,  377,   -1,  379,  380,  381,  382,   10,  384, 
          385,  386,  387,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          306,   -1,  308,  309,  310,  311,  312,   -1,   -1,   -1, 
           -1,  317,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  306,   44,  308,  309,  310,  311,  312,   -1,   -1, 
           -1,   -1,  317,   -1,  340,   -1,   58,   59,   -1,   61, 
           -1,   63,   -1,  328,  350,  351,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,   -1,  340,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,  350,  351,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          386,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,  386,   -1,  265,  266,   -1,   -1,   -1,  270,    0, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   10, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   44,  316,   -1,   -1,  317,   -1,   -1, 
           -1,   -1,  322,  323,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,  333,  334,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,  349, 
           -1,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           91,  361,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   59,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,  337,   -1,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,  375,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,  386,  387,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,  337,   -1,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,    0,  374,  375,  376,  377,   -1,  379,  380, 
          381,  382,   10,  384,  385,  386,  387,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  306,   44,  308,  309,  310, 
          311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,   -1,  328,  317,  318, 
          319,  320,  321,  322,  323,  336,   -1,  326,  327,  340, 
          341,   -1,   -1,   -1,  333,  334,   -1,  348,  349,  350, 
          351,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,  386,   -1,  265,  266,   -1, 
           -1,   -1,  270,    0,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   10,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,   -1,   44,  316,   -1, 
           -1,  317,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,  333,  334,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
          348,   -1,   -1,  349,   -1,  351,   -1,  353,  354,  355, 
          356,   -1,   -1,  359,   91,  361,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   59,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,  337, 
           -1,  339,  340,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,  375,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,  386,  387, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   63,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
          337,   -1,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,  363,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,    0,  374,  375,  376, 
          377,   -1,  379,  380,  381,  382,   10,  384,  385,  386, 
          387,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306, 
           44,  308,  309,  310,  311,  312,   -1,   -1,   -1,   -1, 
          317,   -1,   -1,   -1,   58,   59,   -1,   61,   -1,   63, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,   -1,  340,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,  349,  350,  351,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,   -1,   -1,   -1,   -1,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  386, 
           -1,   -1,   -1,   -1,  349,   -1,  351,    0,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   59,  329,  330,   -1, 
           63,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   91,  361, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   59,   -1,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   44,   -1,  333, 
          334,  335,  336,  337,   -1,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,   -1,  363, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,  375,  376,  377,   91,  379,  380,  381,  382,   -1, 
          384,  385,  386,  387,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   63,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,    0,   -1, 
          333,  334,  335,  336,  337,   -1,  339,  340,   10,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
          363,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   44,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,  386,  387,   -1,   -1,   59,   -1,   -1, 
           -1,   63,  306,   -1,  308,  309,  310,  311,  312,   -1, 
           -1,   -1,   -1,  317,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,  336,   -1,   -1,   -1,  340,  341,   -1,   -1, 
           -1,   -1,  279,  280,  348,  349,  350,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,  386,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   59,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   44, 
           -1,  333,  334,  335,  336,  337,   -1,  339,  340,   -1, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   91,  379,  380,  381, 
          382,   -1,  384,  385,  386,  387,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
            0,   -1,  333,  334,  335,  336,  337,   -1,  339,  340, 
           10,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,  363,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   44,  376,  377,   -1,  379,  380, 
          381,  382,   -1,  384,  385,  386,  387,   -1,   -1,   59, 
           -1,   61,   -1,   63,  306,   -1,  308,  309,  310,  311, 
          312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,  336,   -1,   -1,   -1,  340,  341, 
           -1,   -1,   -1,   -1,  279,  280,  348,  349,  350,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,  386,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,  336,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  362,  326,  327, 
           59,   -1,   61,   -1,   63,  333,  334,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  349,   -1,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   91,  361,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   61,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,   -1,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,   -1,   91,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   10,  299, 
           59,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,  337,  338,   -1, 
          340,  341,  342,  343,  344,   -1,  346,   59,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  386,  387,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,   -1,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   44,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,  337,  338, 
          279,  340,  341,  342,  343,  344,   -1,  346,   91,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,    0,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   10,  384,  385,  386,  387,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1, 
           -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,   44,  308, 
          309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1, 
           -1,   -1,   -1,   59,   -1,   61,   -1,   63,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
           -1,  340,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,  350,  351,   -1,  306,   91,  308,  309,  310,  311, 
          312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  386,  340,  341, 
           -1,   -1,   -1,   -1, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

           -1,    0,  348,  349,  350,  351,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  279,  280,   -1,   -1,   -1,   -1,   -1,   -1, 
          386,   -1,   -1,   -1,   -1,   44,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   61,   -1,   63,   61,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336, 
           -1,   -1,   91,   -1,  341,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,   -1,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           44,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,  337,   -1,   -1, 
          340,  341,  342,  343,  344,   -1,  346,   91,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  386,  387,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,   -1,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,   -1,  279,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,  328,   -1,  333,  334,  335,  336,  337,  335, 
          336,  340,  341,  342,  343,  344,  342,  346,   -1,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,    0,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   10,  384,  385,  386,  387,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  279,  280,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,   -1,   -1,   91,   -1,  341,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  306,  307,   -1,   -1,  310,   -1,   -1,  362,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,    0,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   10,  341,   -1,   10,   -1, 
           -1,   -1,   -1,  348,  349,   -1,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,   -1,   -1,  364, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  386,   -1,   -1,   59,   -1,   61,   -1,   63,   61, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,   -1,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,  337,   -1,   -1,  340,  341,  342,  343,  344,   -1, 
          346,   -1,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          386,  387,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,   -1,  279,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,  328,   -1,  333,  334, 
          335,  336,  337,  335,  336,  340,  341,  342,  343,  344, 
          342,  346,   -1,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,    0,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   10,  384, 
          385,  386,  387,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   44,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,  341,   -1,   59,   -1,   61, 
           -1,   63,  348,  349,   -1,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,   -1,   -1,  364,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,  307, 
          386,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,    0, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   10, 
          348,  349,   10,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  306,  307,  364,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   44,  326,  327,   44,   -1,  386,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,   59,  341, 
           61,   -1,   63,   61,   -1,   -1,  348,  349,   -1,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
           -1,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  386,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,  337,   -1,   -1,  340,  341, 
          342,  343,  344,   -1,  346,   -1,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,  386,  387,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,   -1,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
           -1,  279,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          328,   -1,  333,  334,  335,  336,  337,  335,  336,  340, 
          341,  342,  343,  344,  342,  346,   -1,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,    0,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   10,  384,  385,  386,  387,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  306,  307,   -1,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   44,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
           -1,   59,   -1,   61,   -1,   63,  348,  349,   -1,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
           -1,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  306,  307,  386,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,    0,   -1,   -1,   -1,  341,   -1,   -1, 
           -1,   -1,   -1,   10,  348,  349,   10,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  306,  307, 
          364,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   44,  326,  327, 
           44,   -1,  386,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   59,  341,   61,   -1,   63,   61,   -1,   -1, 
          348,  349,   -1,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,   -1,   -1,  364,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  386,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,  337, 
           -1,   -1,  340,  341,  342,  343,  344,   -1,  346,   -1, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,   -1,  363,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,    0,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   10,  384,  385,  386,  387, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
           -1,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,  279,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   59,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,  328,   -1,  333,  334,  335,  336, 
          337,  335,  336,  340,  341,  342,  343,  344,  342,  346, 
           -1,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,   -1,  363,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,    0,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   10,  384,  385,  386, 
          387,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   61, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   91,  280,  281,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,  336,  337,   -1,   -1,  340,   -1,  342,  343,  344, 
           -1,  346,    0,  348,   -1,  350,   -1,  352,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,  360,   -1,  362,  363,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,  384, 
          385,  386,  387,   -1,   -1,   -1,   44,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           58,   59,   -1,   61,   -1,   63,  280,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   91,   -1,   -1,   -1,  279,  280,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,  280,    0,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   10,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,  328,  361,  362,  363, 
           -1,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1,  341, 
          342,  375,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,  328,   -1,  387,   -1,   -1,   -1,   -1,  335,  336, 
          362,   -1,   58,   59,  341,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,  262,  263,  264,   10,   59,  267, 
          268,  269,   -1,  271,   -1,   -1,   44,   -1,   -1,   61, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,  290,  291,   -1,  293,  294,  295,  296,  297, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   10,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,   -1,   -1,  342,   -1,   -1,  345,   91,  347, 
           -1,  349,   44,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   58,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,  387, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   44,  351,  267,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   58,   59, 
           -1,   61,   -1,   63,  262,  263,  264,  279,  280,  375, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  387,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,  267,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,  328,    0,   10, 
           -1,   -1,   -1,   -1,  335,  336,  328,   -1,   10,   -1, 
           -1,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1,  341, 
          342,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          262,  263,  264,   -1,  342,  267,  268,  269,   -1,  271, 
          362,   -1,   -1,   -1,   -1,  328,   61,   -1,   59,  281, 
          282,   -1,  335,  336,   -1,  363,   -1,   59,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,    0,   -1,   91,   -1,   -1,  387, 
           91,   -1,   -1,   -1,   10,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   44,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,   58,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,  387,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           44,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   10,  363,   58,   59,  267,   61,   -1,   63, 
          262,  263,  264,   -1,  279,  375,  268,  269,   -1,  271, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,  293,  294,  295,  296,   10,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   -1,  328,   -1,   59, 
          335,  336,   -1,   -1,  335,  336,   -1,  342,   -1,   44, 
           -1,   -1,   -1,   91,   -1,   -1,  262,  263,  264,   -1, 
          342,  267,  268,  269,   -1,  271,   61,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   59,  281,  282,   -1,   -1,   -1, 
           -1,  363,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   91,   -1,   -1,  305, 
            0,   -1,   -1,   -1,   -1,  387,   91,   -1,   -1,   -1, 
           10,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   44,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   58,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,  375, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  387,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,    0,   -1,   -1,   -1,   -1,   -1,   -1,  267, 
           -1,   -1,   10,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,  267,   -1,  333, 
          334,  335,  336,   -1,  338,  339,   -1,   -1,  342,   -1, 
          280,  345,   -1,  347,   -1,  349,   44,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           58,   59,  267,   61,  279,   63,   -1,   -1,   -1,   -1, 
          328,  375,   -1,   -1,   -1,  280,   -1,  335,  336,   -1, 
           -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,  328,   -1, 
           -1,   -1,   -1,   91,   -1,  335,  336,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   10,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,  336,  362,  328,   -1,   -1,   -1,  342,   -1,   -1, 
          335,  336,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   44,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,  362,   61,   -1, 
           59,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   91,   -1, 
           -1,   -1,   91,   -1,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   10,  349, 
           44,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   58,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,  262,  263,  264,  387,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   91,   -1,   61, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           10,  349,   44,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   58,   59,  267,   61, 
           -1,   63,   -1,   -1,   -1,   -1,  279,  375,   -1,   -1, 
           -1,  280,   -1,   -1,   44,   -1,   -1,   -1,   -1,  387, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   61,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,  328, 
           -1,   91,  335,  336,   -1,   -1,  335,  336,   -1,  342, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,    0,   -1,   -1,   -1,   -1,  279,   -1,   -1, 
           -1,   -1,   10,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,   44,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,  328,  361,   -1,  363, 
           58,   59,   -1,  335,  336,   63,   -1,   -1,   -1,   -1, 
          342,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  387,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,    0,   -1,   -1,   -1,   -1,  279, 
           -1,   -1,   -1,   -1,   10,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   44,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,  328,  361, 
           -1,  363,   58,   59,   -1,  335,  336,   63,   -1,   -1, 
           -1,   -1,  342,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  280,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,  349,   44,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,  362,  363,   58,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,  387, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,  280,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   44,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,  362,  363,   58,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,  375, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  387,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   44,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,  387,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           44,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   44,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,  375, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  387,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,   44,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           44,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,  387,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,  349,   44,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   -1,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  387, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   44,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   59,   -1,   -1,   -1,   63,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,    0,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   10,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
          262,  263,  264,  387,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,   63,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   -1,  351, 
            0,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           10,  363,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,  387,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   44,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,  349,   -1,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,  387, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   44,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  387,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   58,   59,  333,  334,   -1,   63,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           -1,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   -1,  306,  307,   -1,   -1,  310, 
           -1,   -1,   -1,  314,  315,  375,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,  387,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,    0, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   10, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   44,   -1,  386,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   58,   59,   -1, 
          290,  291,   63,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           -1,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,  375,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   10,  387,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   58,   59,  333,  334,   -1,   63, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          387,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   10,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           58,   59,  333,  334,   -1,   63,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

           -1,  347,   -1,  349,   -1,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  375, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  387,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   59,   -1,   61,   -1,   63,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   91,  333,  334,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,    0,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   10,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  387,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   44,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   59,   -1,   61,   -1,   63,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,   -1,    0,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   10,  349,   -1,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  375,   -1,  262,  263,  264,   -1,   -1,   44, 
          268,  269,   -1,  271,  387,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  280,   -1,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,    0,   -1,  333,  334,  335,  336,   -1, 
           -1,   -1,   -1,   10,  342,   -1,   -1,   -1,   -1,   -1, 
           -1,  349,   -1,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,  362,  363,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,  387, 
           -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   44,   -1, 
           -1,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   59,  361,   61,  363,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
          387,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1, 
           44,   -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   59,  361,   61,  363,   63, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,    0,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  387,   10,  281,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   59,   -1,   61,   -1,   63,   -1,  335,  336, 
           -1,   -1,   -1,   -1,   -1,  342,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
          387,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   44, 
           -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   59,  361,   61,  363,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,  387,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  262,  263,  264,  342,   -1, 
           -1,  268,  269,   -1,  271,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   59,  361,   -1,  363, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  387,   10,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   44,   -1, 
           -1,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   59,  361,   61,  363,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
          387,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1, 
           44,   -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   59,  361,   61,  363,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,    0,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,  387,   10,   -1,   -1,   -1,   91,  281,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,  342, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
          363,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  387,   10,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   44, 
           -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   59,  361,   61,  363,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,  387,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  262,  263,  264,  342,   -1, 
           -1,  268,  269,   -1,  271,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   59,  363, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  387,   10,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   44,   -1, 
           -1,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   59,  361,   61,  363,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
          387,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1, 
           44,   -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   59,  361,   61,  363,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,  387,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,    0,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  342,  268,  269,  345,  271,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  363,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,  351,    0,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   10,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,  387,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,   -1,   -1,   -1,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,  387,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,   -1,   44,  351, 
           -1,   -1,   -1,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,   -1,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,   44,  351,   -1,   -1, 
           -1,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  387,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   58, 
           59,   -1,  290,  291,   63,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,    0,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   10,  357, 
          358,  359,   -1,  361,   -1,  363,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,  387, 
           -1,   -1,   44,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   58,   59,   -1,  305, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,  357,  358,  359,   -1,  361,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,  375, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,  387,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   58,   59,   -1,   -1,  305,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,    0,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   10,  357,  358, 
          359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,  387,  271, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   58,   59,   -1,  290,  291, 
           63,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,  357,  358,  359,   -1,  361, 
           -1,  363,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  387,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   58,   59,   -1,  290,  291,   63,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  339,   -1,   -1,  342,   -1,    0,  345, 
           -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,  357,  358,  359,   -1,  361,   -1,  363,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,  375, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,  387,   44,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   58,   59,   -1,   -1, 
           -1,   63,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,  357,  358,   -1,   -1,   -1,   -1, 
          363,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  387,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           58,   59,   -1,  290,  291,   63,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,    0,  345,   -1, 
          347,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
          357,  358,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
          387,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   58,   59,   -1,  290,  291, 
           63,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  363,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  375,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,  387,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   58,   59,   -1,   -1,   -1,   63,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  339,   -1,   -1,  342,   -1,    0,  345,   -1,  347, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,  387, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   58,   59,   -1,  290,  291,   63, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,  324,  325,   -1,   -1,   10,  329,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  375,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,  387,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,  324,  325,   -1, 
           -1,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,  339,   -1,   63,  342,   -1,   -1,  345,   -1, 
          347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  363,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,  375,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   10, 
          387,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
          324,  325,   -1,   -1,   -1,  329,  330,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,    0,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   10,   -1, 
           -1,  375,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,  387,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   10,   -1,  324, 
          325,   -1,   -1,   -1,  329,  330,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   44,  271,   -1,   -1,   -1,   -1,   -1,  363,   -1, 
           -1,   -1,  281,  282,   -1,   58,   59,   -1,   -1,   -1, 
          375,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,  387,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,  325,   -1,   -1,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,  262,  263,  264,  363,   -1,  267,  268,  269,   -1, 
          271,   -1,   58,   59,   -1,   -1,  375,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,  387,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   44,  347,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           59,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,  375,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,  387,    0,   -1,  262, 
          263,  264,   -1,  305,  267,  268,  269,   10,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,  339,   -1,   -1, 
          342,   44,  305,  345,   -1,  347,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,  387,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,    0, 
          363,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   10, 
           -1,   -1,  375,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,  387,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   44,  271,   -1,   -1,   -1,   -1,  363,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   59,   -1,   -1,  375, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,  387,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,  262, 
          263,  264,   -1,    0,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   10,  363,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   59,   -1,  375,  290,  291,   -1, 
          293,  294,  295,  296,   -1,   -1,   -1,   -1,  387,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   10,  342, 
           -1,   -1,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          363,  262,  263,  264,   -1,    0,  267,  268,  269,   -1, 
          271,   -1,  375,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,  387,   -1,   -1,   59,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   59,   10,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  363,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   59,   10,   -1,   -1,   -1,  342, 
           10,   -1,  345,   -1,  347,   -1,  387,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   59,   44,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,  387,  262,  263,  264,   63,   59, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,  363,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,  345,  281, 
          282,   -1,  387,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           44,  293,  294,  295,  296,  297,  363,  262,  263,  264, 
            0,   -1,  267,  268,  269,   59,  271,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,  281,   -1,   -1,   -1, 
          387,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          342,   -1,   -1,  345,   44,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   59, 
           -1,  363,   -1,   -1,   -1,   -1,  281,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,  342,  293,  294, 
          295,  296,  297,   -1,   -1,  387,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,  363,   -1, 
           -1,   -1,  262,  263,  264,  281,   10,  267,  268,  269, 
           -1,  271,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,  387,   -1,   -1,   -1,   -1,  342,   -1,   -1, 
           -1,   -1,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  363,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,  342,   -1,  333,  334, 
           -1,   -1,  387,   -1,   -1,   -1,   -1,   -1,   -1,  339, 
           -1,   -1,  342,   -1,  349,   -1,  351,  363,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,   -1,   -1, 
           -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,  262,  263, 
          264,  387,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  339,   59,   -1,  342,   -1, 
           -1,   -1,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,  363,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   10,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,  387,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,  350,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   91,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,  386,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   -1,   10, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   59,   -1, 
           -1,   -1,  335,  336,  337,   -1,   -1,  340,  341,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,  357,   -1,   -1,  360,   -1,  362, 
           91,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   10,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   59,   -1,   -1, 
           -1,  335,  336,  337,   -1,   -1,  340,  341,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,  357,   -1,   -1,  360,   -1,  362,   91, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,   -1,   -1,   -1,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,   -1,   -1,  269,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
           -1,   10,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           59,   -1,   -1,   -1,  335,  336,  337,   -1,   -1,  340, 
          341,   -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1, 
           -1,  352,   -1,   -1,   -1,   -1,  357,   -1,   -1,  360, 
           -1,  362,   91,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,  384,  385,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  256,  257,  258,  259,  260,  261, 
          262,  263,  264,  265,  266,   -1,   -1,  269,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   10,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   59,   -1,   -1, 
           -1,   -1,   -1,  335,  336,  337,   -1,   -1,  340,  341, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,  357,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,   -1,   -1,   -1,  256,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,   -1,   -1, 
          269,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   10,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           59,   -1,   -1,   -1,   -1,   -1,  335,  336,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,  357,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  256,  257,  258,  259,  260,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   10,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,   -1,   -1,   -1,  256,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,   -1,   -1, 
          269,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           10,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,  362,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,   -1,   -1,   -1,   -1,   -1,   -1,  256, 
          257,  258,  259,  260,  261,  262,  263,  264,  265,  266, 
           -1,   -1,  269,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   10,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,   -1,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   10,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   10,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
          348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,  363,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,   -1,   -1, 
           -1,   -1,  257,  258,  259,  260,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   10,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,  342,  343,  344, 
           -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,  384, 
          385,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   44,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   44,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
           -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,  384,  385,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,   -1,   -1,  316,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,  257,  258, 
          259,  260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,  300,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,  257,  258,  259, 
          260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
           -1,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,   -1,   -1,   -1,   -1,  297,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  386,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,   -1,   -1,   -1,   -1,  297,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  386,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,   -1,   -1,   -1,   -1,  297,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,  308,   -1,  310, 
           -1,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,   -1,  364,  365,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  386,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,   -1,   -1,   -1,   -1,  297,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,   -1,   -1,  310, 
           -1,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,   -1,  364,  365,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  386,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,   -1,   -1,   -1,   -1,  297,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,   -1,   -1,  310, 
           -1,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
          256,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,  386,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          256,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,   -1,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          256,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,   -1,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  386, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  386, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  386, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  386, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  386, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  386, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  386, 
          257,  258,  259,  260,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,  300,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
          348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,  341,   -1,  343,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1, 
           -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,  384,  385,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,  341,   -1,  343,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,  384, 
          385,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  333,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,  384,  385,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
           -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1, 
           -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  306,  307, 
          364,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,  386,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,  349,   -1,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  306,  307,  364,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,  386,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          306,  307,  364,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,  386,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,  349,   -1,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  306,  307,  364,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
          386,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349, 
           -1,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  306,  307,  364,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,  386,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1, 
           -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  306,  307, 
          364,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,  386,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,  349,   -1,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  306,  307,  364,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,  386,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
           -1,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  386, 
      };
   }

}
