/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyYielder;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;

public class RubyGenerator
extends RubyObject {
    private IRubyObject proc;

    public static void createGeneratorClass(Ruby runtime2) {
        RubyClass genc = runtime2.defineClassUnder("Generator", runtime2.getObject(), new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                return new RubyGenerator(runtime2, klazz);
            }
        }, runtime2.getEnumerator());
        genc.includeModule(runtime2.getEnumerable());
        genc.defineAnnotatedMethods(RubyGenerator.class);
        runtime2.setGenerator(genc);
    }

    public RubyGenerator(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE, optional=1)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject proc2;
        Ruby runtime2 = context.runtime;
        if (args2.length == 0) {
            proc2 = RubyProc.newProc(runtime2, block, Block.Type.PROC);
        } else {
            if (!(args2[0] instanceof RubyProc)) {
                throw runtime2.newTypeError(args2[0], runtime2.getProc());
            }
            proc2 = args2[0];
            if (block.isGiven()) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
            }
        }
        this.proc = proc2;
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject other) {
        if (!(other instanceof RubyGenerator)) {
            throw context.runtime.newTypeError(other, context.runtime.getGenerator());
        }
        this.checkFrozen();
        this.proc = ((RubyGenerator)other).proc;
        return this;
    }

    @JRubyMethod(rest=true)
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        return ((RubyProc)this.proc).call(context, ArraySupport.newCopy(RubyYielder.newYielder(context, block), args2), Block.NULL_BLOCK);
    }
}

