/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.ClosureManager;
import com.kenai.jffi.ClosurePool;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.MappedType;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.StructByValue;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.jffi.FFIUtil;
import org.jruby.ext.ffi.jffi.NativeCallbackPointer;
import org.jruby.ext.ffi.jffi.NativeClosureProxy;
import org.jruby.ext.ffi.jffi.NativeFunctionInfo;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.util.WeakIdentityHashMap;

public class NativeCallbackFactory {
    private final WeakIdentityHashMap closures = new WeakIdentityHashMap();
    private final Ruby runtime;
    private final ClosurePool closurePool;
    private final NativeFunctionInfo closureInfo;
    private final CallbackInfo callbackInfo;
    private final RubyClass callbackClass;
    private final CachingCallSite callSite = new FunctionalCachingCallSite("call");

    public NativeCallbackFactory(Ruby runtime2, CallbackInfo cbInfo) {
        this.runtime = runtime2;
        this.closureInfo = this.newFunctionInfo(runtime2, cbInfo);
        this.closurePool = ClosureManager.getInstance().getClosurePool(this.closureInfo.callContext);
        this.callbackInfo = cbInfo;
        this.callbackClass = runtime2.getModule("FFI").getClass("Callback");
    }

    public final Pointer getCallback(RubyObject callable) {
        return this.getCallback(callable, this.callSite);
    }

    public final Pointer getCallback(IRubyObject callable, CachingCallSite callSite) {
        if (callable instanceof Pointer) {
            return (Pointer)callable;
        }
        Object ffiHandle = callable.getMetaClass().getRealClass().getFFIHandleAccessorField().getVariableAccessorForRead().get(callable);
        if (ffiHandle instanceof NativeCallbackPointer) {
            NativeCallbackPointer cbptr = (NativeCallbackPointer)ffiHandle;
            if (cbptr.cbInfo == this.callbackInfo) {
                return cbptr;
            }
        }
        return this.getCallbackPointer(callable, callSite);
    }

    private synchronized Pointer getCallbackPointer(IRubyObject callable, CachingCallSite callSite) {
        NativeCallbackPointer cbptr = (NativeCallbackPointer)this.closures.get(callable);
        if (cbptr != null) {
            return cbptr;
        }
        cbptr = this.newCallback(callable, callSite);
        this.closures.put(callable, cbptr);
        if (callable.getMetaClass().getFFIHandleAccessorForRead().get(callable) == null) {
            callable.getMetaClass().getFFIHandleAccessorForWrite().set(callable, cbptr);
        }
        return cbptr;
    }

    NativeCallbackPointer newCallback(IRubyObject callable, CachingCallSite callSite) {
        if (callSite.retrieveCache((IRubyObject)callable).method.isUndefined()) {
            throw this.runtime.newArgumentError("callback does not respond to :" + callSite.getMethodName());
        }
        return new NativeCallbackPointer(this.runtime, this.callbackClass, this.closurePool.newClosureHandle(new NativeClosureProxy(this.runtime, this.closureInfo, callable, callSite)), this.callbackInfo, this.closureInfo);
    }

    NativeCallbackPointer newCallback(Object callable) {
        return new NativeCallbackPointer(this.runtime, this.callbackClass, this.closurePool.newClosureHandle(new NativeClosureProxy(this.runtime, this.closureInfo, callable, this.callSite)), this.callbackInfo, this.closureInfo);
    }

    private final NativeFunctionInfo newFunctionInfo(Ruby runtime2, CallbackInfo cbInfo) {
        Type[] paramTypes = cbInfo.getParameterTypes();
        for (int i2 = 0; i2 < paramTypes.length; ++i2) {
            if (NativeCallbackFactory.isParameterTypeValid(paramTypes[i2]) && FFIUtil.getFFIType(paramTypes[i2]) != null) continue;
            throw runtime2.newTypeError("invalid callback parameter type: " + paramTypes[i2]);
        }
        if (!NativeCallbackFactory.isReturnTypeValid(cbInfo.getReturnType()) || FFIUtil.getFFIType(cbInfo.getReturnType()) == null) {
            throw runtime2.newTypeError("invalid callback return type: " + cbInfo.getReturnType());
        }
        return new NativeFunctionInfo(runtime2, cbInfo.getReturnType(), cbInfo.getParameterTypes(), cbInfo.isStdcall() ? CallingConvention.STDCALL : CallingConvention.DEFAULT);
    }

    private static final boolean isReturnTypeValid(Type type2) {
        if (type2 instanceof Type.Builtin) {
            switch (type2.getNativeType()) {
                case CHAR: 
                case UCHAR: 
                case SHORT: 
                case USHORT: 
                case INT: 
                case UINT: 
                case LONG: 
                case ULONG: 
                case LONG_LONG: 
                case ULONG_LONG: 
                case FLOAT: 
                case DOUBLE: 
                case POINTER: 
                case VOID: 
                case BOOL: {
                    return true;
                }
            }
        } else {
            if (type2 instanceof CallbackInfo) {
                return true;
            }
            if (type2 instanceof StructByValue) {
                return true;
            }
        }
        return false;
    }

    private static final boolean isParameterTypeValid(Type type2) {
        if (type2 instanceof Type.Builtin) {
            switch (type2.getNativeType()) {
                case CHAR: 
                case UCHAR: 
                case SHORT: 
                case USHORT: 
                case INT: 
                case UINT: 
                case LONG: 
                case ULONG: 
                case LONG_LONG: 
                case ULONG_LONG: 
                case FLOAT: 
                case DOUBLE: 
                case POINTER: 
                case BOOL: 
                case STRING: 
                case TRANSIENT_STRING: {
                    return true;
                }
            }
        } else {
            if (type2 instanceof CallbackInfo) {
                return true;
            }
            if (type2 instanceof StructByValue) {
                return true;
            }
            if (type2 instanceof MappedType) {
                return NativeCallbackFactory.isParameterTypeValid(((MappedType)type2).getRealType());
            }
        }
        return false;
    }
}

