/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.tempfile;

import java.io.File;
import java.io.IOException;
import jnr.constants.platform.Errno;
import jnr.constants.platform.OpenFlags;
import jnr.posix.POSIX;
import org.jruby.Finalizable;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFileStat;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubySystemCallError;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.platform.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock19;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Tempfile"}, parent="File")
public class Tempfile
extends RubyFile
implements Finalizable {
    private static ObjectAllocator TEMPFILE_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            Tempfile instance = new Tempfile(runtime, klass);
            return instance;
        }
    };
    private File tmpFile = null;
    private IRubyObject tmpname;
    private IRubyObject opts;
    private IRubyObject mode;

    public static RubyClass createTempfileClass(Ruby runtime) {
        RubyClass tempfileClass = runtime.defineClass("Tempfile", runtime.getFile(), TEMPFILE_ALLOCATOR);
        tempfileClass.defineAnnotatedMethods(Tempfile.class);
        return tempfileClass;
    }

    public Tempfile(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @Override
    @JRubyMethod(optional=3, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        if (args2.length == 0) {
            args2 = new IRubyObject[]{RubyString.newEmptyString(context.runtime)};
        }
        return this.initializeCommon(context, args2);
    }

    private IRubyObject initializeCommon(ThreadContext context, IRubyObject[] args2) {
        TempfileCallback body = new TempfileCallback();
        this.callMethod(context, "create", args2, CallBlock19.newCallClosure((IRubyObject)this, (RubyModule)this.getMetaClass(), Signature.OPTIONAL, (BlockCallback)body, context));
        context.runtime.addInternalFinalizer(this);
        return context.nil;
    }

    @JRubyMethod(visibility=Visibility.PUBLIC)
    public IRubyObject open(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (!this.isClosed()) {
            this.rbIoClose(runtime);
        }
        this.openFile = null;
        Tempfile.super.initialize(context, new IRubyObject[]{this.tmpname, this.mode, this.opts}, Block.NULL_BLOCK);
        return this;
    }

    @JRubyMethod(visibility=Visibility.PROTECTED)
    public IRubyObject _close(ThreadContext context) {
        return !this.isClosed() ? super.close() : context.nil;
    }

    @JRubyMethod(optional=1, visibility=Visibility.PUBLIC)
    public IRubyObject close(ThreadContext context, IRubyObject[] args2, Block block) {
        boolean unlink2 = args2.length == 1 ? args2[0].isTrue() : false;
        return unlink2 ? this.close_bang(context) : this._close(context);
    }

    @JRubyMethod(name={"close!"}, visibility=Visibility.PUBLIC)
    public IRubyObject close_bang(ThreadContext context) {
        this._close(context);
        this.unlink(context);
        return context.nil;
    }

    @JRubyMethod(name={"unlink", "delete"})
    public IRubyObject unlink(ThreadContext context) {
        if (this.openFile.getPath() == null) {
            return context.nil;
        }
        Ruby runtime = context.runtime;
        POSIX posix = runtime.getPosix();
        if (posix.isNative() && !Platform.IS_WINDOWS) {
            IRubyObject oldExc = context.runtime.getGlobalVariables().get("$!");
            try {
                RubyFile.unlink(context, this);
            }
            catch (RaiseException re) {
                RubyException excp = re.getException();
                if (!(excp instanceof RubySystemCallError)) {
                    throw re;
                }
                int errno2 = (int)((RubySystemCallError)excp).errno().convertToInteger().getLongValue();
                if (errno2 != Errno.ENOENT.intValue() && errno2 != Errno.EACCES.intValue()) {
                    throw re;
                }
                context.runtime.getGlobalVariables().set("$!", oldExc);
            }
            this.openFile.setPath(null);
            this.tmpname = context.nil;
        } else if (this.isClosed()) {
            if (!this.tmpFile.exists() || this.tmpFile.delete()) {
                this.openFile.setPath(null);
                this.tmpname = context.nil;
            }
        } else {
            context.runtime.getWarnings().warn("Tempfile#unlink or delete called on open file; ignoring");
        }
        return context.nil;
    }

    @Override
    @JRubyMethod(name={"size", "length"})
    public IRubyObject size(ThreadContext context) {
        if (!this.isClosed()) {
            this.flush(context);
            RubyFileStat stat2 = (RubyFileStat)this.stat(context);
            return stat2.size();
        }
        if (this.tmpname != null && !this.tmpname.isNil()) {
            RubyFileStat stat3 = (RubyFileStat)Tempfile.stat(context, this.getMetaClass(), this.tmpname);
            return stat3.size();
        }
        return RubyFixnum.zero(context.runtime);
    }

    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return Tempfile.open19(context, recv2, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject open19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyClass klass = (RubyClass)recv2;
        Tempfile tempfile2 = (Tempfile)klass.newInstance(context, args2, block);
        if (block.isGiven()) {
            try {
                IRubyObject iRubyObject = block.yield(context, tempfile2);
                return iRubyObject;
            }
            finally {
                if (!tempfile2.isClosed()) {
                    tempfile2.close();
                }
            }
        }
        return tempfile2;
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect() {
        StringBuilder val = new StringBuilder();
        val.append("#<Tempfile:").append(this.openFile.getPath());
        if (!this.openFile.isOpen()) {
            val.append(" (closed)");
        }
        val.append(">");
        return this.getRuntime().newString(val.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.tmpFile.delete();
        }
    }

    @Override
    @Deprecated
    public IRubyObject initialize19(IRubyObject[] args2, Block block) {
        return this.initialize(this.getRuntime().getCurrentContext(), args2, block);
    }

    @Deprecated
    public IRubyObject size19(ThreadContext context) {
        return this.size(context);
    }

    private class TempfileCallback
    implements BlockCallback {
        private TempfileCallback() {
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
            Ruby runtime = context.runtime;
            IRubyObject tmpname = args2[0];
            IRubyObject opts = args2.length > 2 ? args2[2] : context.nil;
            int mode2 = OpenFlags.O_RDWR.intValue() | OpenFlags.O_EXCL.intValue();
            RubyFixnum perm = runtime.newFixnum(384);
            if (!opts.isNil()) {
                RubyHash options2 = (RubyHash)opts;
                IRubyObject optsMode = options2.delete(context, runtime.newSymbol("mode"), Block.NULL_BLOCK);
                if (!optsMode.isNil()) {
                    mode2 |= optsMode.convertToInteger().getIntValue();
                }
                options2.op_aset(context, runtime.newSymbol("perm"), perm);
            } else {
                opts = perm;
            }
            try {
                File tmp = new File(tmpname.convertToString().toString());
                if (!tmp.createNewFile()) {
                    throw context.runtime.newErrnoEEXISTError(Tempfile.this.getPath());
                }
                runtime.getPosix().chmod(tmp.getAbsolutePath(), 384);
                Tempfile.this.tmpFile = tmp;
            }
            catch (IOException e) {
                throw context.runtime.newIOErrorFromException(e);
            }
            Tempfile.super.initialize(context, new IRubyObject[]{tmpname, runtime.newFixnum(mode2), opts}, Block.NULL_BLOCK);
            Tempfile.this.tmpname = tmpname;
            Tempfile.this.mode = runtime.newFixnum(mode2 & ~(OpenFlags.O_CREAT.intValue() | OpenFlags.O_EXCL.intValue()));
            Tempfile.this.opts = opts;
            return opts;
        }
    }
}

