/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.interpreter;

import java.util.List;
import java.util.concurrent.Callable;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.interpreter.InterpreterEngine;
import org.jruby.ir.interpreter.StartupInterpreterEngine;
import org.jruby.ir.representations.CFG;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;

public class InterpreterContext {
    protected int temporaryVariablecount;
    protected Instr[] instructions;
    private boolean hasExplicitCallProtocol;
    private boolean pushNewDynScope;
    private boolean reuseParentDynScope;
    private boolean popDynScope;
    private boolean receivesKeywordArguments;
    private boolean metaClassBodyScope;
    private static final InterpreterEngine DEFAULT_INTERPRETER = new InterpreterEngine();
    private static final InterpreterEngine STARTUP_INTERPRETER = new StartupInterpreterEngine();
    private static final InterpreterEngine SIMPLE_METHOD_INTERPRETER = new InterpreterEngine();
    private InterpreterEngine engine;
    public Callable<List<Instr>> instructionsCallback;
    private IRScope scope;

    public InterpreterEngine getEngine() {
        if (this.engine == null) {
            try {
                List<Instr> instrs = this.instructionsCallback.call();
                this.instructions = instrs != null ? this.prepareBuildInstructions(instrs) : null;
            }
            catch (Exception e) {
                Helpers.throwException(e);
            }
            this.setEngine(this.instructions == null ? DEFAULT_INTERPRETER : STARTUP_INTERPRETER);
        }
        return this.engine;
    }

    public InterpreterContext(IRScope scope, List<Instr> instructions) {
        this.scope = scope;
        this.setEngine(instructions == null ? DEFAULT_INTERPRETER : STARTUP_INTERPRETER);
        this.metaClassBodyScope = scope instanceof IRMetaClassBody;
        this.instructions = instructions != null ? this.prepareBuildInstructions(instructions) : null;
    }

    public InterpreterContext(IRScope scope, Callable<List<Instr>> instructions) throws Exception {
        this.instructionsCallback = instructions;
        this.scope = scope;
        this.metaClassBodyScope = scope instanceof IRMetaClassBody;
    }

    private void retrieveFlags() {
        this.temporaryVariablecount = this.scope.getTemporaryVariablesCount();
        this.hasExplicitCallProtocol = this.scope.getFlags().contains((Object)IRFlags.HAS_EXPLICIT_CALL_PROTOCOL);
        this.reuseParentDynScope = this.scope.getFlags().contains((Object)IRFlags.REUSE_PARENT_DYNSCOPE);
        this.pushNewDynScope = !this.scope.getFlags().contains((Object)IRFlags.DYNSCOPE_ELIMINATED) && !this.reuseParentDynScope;
        this.popDynScope = this.pushNewDynScope || this.reuseParentDynScope;
        this.receivesKeywordArguments = this.scope.getFlags().contains((Object)IRFlags.RECEIVES_KEYWORD_ARGS);
    }

    private Instr[] prepareBuildInstructions(List<Instr> instructions) {
        int length2 = instructions.size();
        Instr[] linearizedInstrArray = instructions.toArray(new Instr[length2]);
        for (int ipc = 0; ipc < length2; ++ipc) {
            Instr i2 = linearizedInstrArray[ipc];
            if (!(i2 instanceof LabelInstr)) continue;
            ((LabelInstr)i2).getLabel().setTargetPC(ipc + 1);
        }
        return linearizedInstrArray;
    }

    public int getRequiredArgsCount() {
        return this.getStaticScope().getSignature().required();
    }

    public IRScope getScope() {
        return this.scope;
    }

    public boolean buildComplete() {
        return true;
    }

    public CFG getCFG() {
        return null;
    }

    public Object[] allocateTemporaryVariables() {
        return this.temporaryVariablecount > 0 ? new Object[this.temporaryVariablecount] : null;
    }

    public boolean[] allocateTemporaryBooleanVariables() {
        return null;
    }

    public long[] allocateTemporaryFixnumVariables() {
        return null;
    }

    public double[] allocateTemporaryFloatVariables() {
        return null;
    }

    public StaticScope getStaticScope() {
        return this.scope.getStaticScope();
    }

    public String getFileName() {
        return this.scope.getFileName();
    }

    public String getName() {
        return this.scope.getName();
    }

    public Instr[] getInstructions() {
        if (this.instructions == null) {
            this.getEngine();
        }
        return this.instructions;
    }

    public void computeScopeFlagsFromInstructions() {
        for (Instr instr : this.getInstructions()) {
            instr.computeScopeFlags(this.scope);
        }
    }

    public DynamicScope newDynamicScope(ThreadContext context) {
        if (this.metaClassBodyScope) {
            return DynamicScope.newDynamicScope(this.getStaticScope(), context.getCurrentScope());
        }
        return DynamicScope.newDynamicScope(this.getStaticScope());
    }

    public boolean hasExplicitCallProtocol() {
        return this.hasExplicitCallProtocol;
    }

    public boolean pushNewDynScope() {
        return this.pushNewDynScope;
    }

    public boolean reuseParentDynScope() {
        return this.reuseParentDynScope;
    }

    public boolean popDynScope() {
        return this.popDynScope;
    }

    public boolean receivesKeywordArguments() {
        return this.receivesKeywordArguments;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getFileName()).append(':').append(this.scope.getLineNumber());
        if (this.getName() != null) {
            buf.append(' ').append(this.getName()).append("\n");
        }
        if (this.instructions == null) {
            buf.append("  No Instructions.  Full Build before linearizeInstr?");
        } else {
            buf.append(this.toStringInstrs()).append("\n");
        }
        return buf.toString();
    }

    public String toStringInstrs() {
        StringBuilder b2 = new StringBuilder();
        int length2 = this.instructions.length;
        for (int i2 = 0; i2 < length2; ++i2) {
            if (i2 > 0) {
                b2.append("\n");
            }
            b2.append("  ").append(i2).append('\t').append(this.instructions[i2]);
        }
        return b2.toString();
    }

    public void setEngine(InterpreterEngine engine) {
        this.engine = engine;
        this.retrieveFlags();
    }
}

