/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.util;

import java.lang.reflect.Method;
import org.jruby.BasicObjectStub;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.org.objectweb.asm.ClassVisitor;
import org.jruby.util.CodegenUtils;

public class BasicObjectStubGenerator {
    private static final Method[] BASIC_OBJECT_STUB_METHODS = BasicObjectStub.class.getDeclaredMethods();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addBasicObjectStubsToClass(ClassVisitor cv) {
        for (Method stub : BASIC_OBJECT_STUB_METHODS) {
            if (stub.getName().equals("getRuntime") || stub.getName().equals("getMetaClass")) continue;
            Class[] signature = new Class[stub.getParameterTypes().length - 1];
            for (int i2 = 0; i2 < signature.length; ++i2) {
                signature[i2] = stub.getParameterTypes()[i2 + 1];
            }
            SkinnyMethodAdapter method = new SkinnyMethodAdapter(cv, 65, stub.getName(), CodegenUtils.sig(stub.getReturnType(), signature), null, null);
            method.start();
            method.aload(0);
            int nextIndex = 1;
            for (Class argType : signature) {
                if (argType.isPrimitive()) {
                    if (argType == Boolean.TYPE || argType == Byte.TYPE || argType == Character.TYPE || argType == Short.TYPE || argType == Integer.TYPE) {
                        method.iload(nextIndex);
                        ++nextIndex;
                        continue;
                    }
                    if (argType == Long.TYPE) {
                        method.lload(nextIndex);
                        nextIndex += 2;
                        continue;
                    }
                    if (argType == Float.TYPE) {
                        method.fload(nextIndex);
                        ++nextIndex;
                        continue;
                    }
                    if (argType != Double.TYPE) throw new RuntimeException("unknown primitive type: " + argType);
                    method.dload(nextIndex);
                    nextIndex += 2;
                    continue;
                }
                method.aload(nextIndex);
                ++nextIndex;
            }
            method.invokestatic(CodegenUtils.p(BasicObjectStub.class), stub.getName(), CodegenUtils.sig(stub.getReturnType(), stub.getParameterTypes()));
            Class<?> retType = stub.getReturnType();
            if (retType == Void.TYPE) {
                method.voidreturn();
            } else if (retType.isPrimitive()) {
                if (retType == Boolean.TYPE || retType == Byte.TYPE || retType == Character.TYPE || retType == Short.TYPE || retType == Integer.TYPE) {
                    method.ireturn();
                } else if (retType == Long.TYPE) {
                    method.lreturn();
                } else if (retType == Float.TYPE) {
                    method.freturn();
                } else {
                    if (retType != Double.TYPE) throw new RuntimeException("unknown primitive type: " + retType);
                    method.dreturn();
                }
            } else {
                method.areturn();
            }
            method.end();
        }
    }
}

