/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.marshal;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.IncludedModuleWrapper;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.encoding.MarshalEncoding;
import org.jruby.runtime.marshal.CoreObjectType;
import org.jruby.runtime.marshal.DataType;
import org.jruby.runtime.marshal.MarshalCache;
import org.jruby.util.ByteList;

public class MarshalStream
extends FilterOutputStream {
    private final Ruby runtime;
    private final MarshalCache cache;
    private final int depthLimit;
    private boolean tainted = false;
    private int depth = 0;
    private static final char TYPE_IVAR = 'I';
    private static final char TYPE_USRMARSHAL = 'U';
    private static final char TYPE_USERDEF = 'u';
    private static final char TYPE_UCLASS = 'C';
    public static final String SYMBOL_ENCODING_SPECIAL = "E";
    private static final String SYMBOL_ENCODING = "encoding";

    public MarshalStream(Ruby runtime, OutputStream out, int depthLimit) throws IOException {
        super(out);
        this.runtime = runtime;
        this.depthLimit = depthLimit >= 0 ? depthLimit : Integer.MAX_VALUE;
        this.cache = new MarshalCache();
        out.write(4);
        out.write(8);
    }

    public void dumpObject(IRubyObject value2) throws IOException {
        ++this.depth;
        if (this.depth > this.depthLimit) {
            throw this.runtime.newArgumentError("exceed depth limit");
        }
        this.tainted |= value2.isTaint();
        this.writeAndRegister(value2);
        --this.depth;
        if (this.depth == 0) {
            this.out.flush();
        }
    }

    public void registerLinkTarget(IRubyObject newObject2) {
        if (MarshalStream.shouldBeRegistered(newObject2)) {
            this.cache.register(newObject2);
        }
    }

    public void registerSymbol(String sym) {
        this.cache.registerSymbol(sym);
    }

    static boolean shouldBeRegistered(IRubyObject value2) {
        if (value2.isNil()) {
            return false;
        }
        if (value2 instanceof RubyBoolean) {
            return false;
        }
        if (value2 instanceof RubyFixnum) {
            return !MarshalStream.isMarshalFixnum((RubyFixnum)value2);
        }
        return true;
    }

    private static boolean isMarshalFixnum(RubyFixnum fixnum) {
        return fixnum.getLongValue() <= 0x3FFFFFFFL && fixnum.getLongValue() >= -1073741824L;
    }

    private void writeAndRegisterSymbol(String sym) throws IOException {
        if (this.cache.isSymbolRegistered(sym)) {
            this.cache.writeSymbolLink(this, sym);
        } else {
            this.registerSymbol(sym);
            this.dumpSymbol(sym);
        }
    }

    private void writeAndRegister(IRubyObject value2) throws IOException {
        if (this.cache.isRegistered(value2)) {
            this.cache.writeLink(this, value2);
        } else {
            value2.getMetaClass().smartDump(this, value2);
        }
    }

    private List<Variable<Object>> getVariables(IRubyObject value2) throws IOException {
        ClassIndex nativeClassIndex;
        List<Variable<Object>> variables = null;
        if (value2 instanceof CoreObjectType && (nativeClassIndex = ((CoreObjectType)((Object)value2)).getNativeClassIndex()) != ClassIndex.OBJECT && nativeClassIndex != ClassIndex.BASICOBJECT) {
            if (MarshalStream.shouldMarshalEncoding(value2) || !value2.isImmediate() && value2.hasVariables() && nativeClassIndex != ClassIndex.CLASS && nativeClassIndex != ClassIndex.MODULE) {
                variables = value2.getVariableList();
                this.write(73);
            }
            RubyClass type2 = value2.getMetaClass();
            switch (nativeClassIndex) {
                case STRING: 
                case REGEXP: 
                case ARRAY: 
                case HASH: {
                    type2 = this.dumpExtended(type2);
                }
            }
            if (nativeClassIndex != value2.getMetaClass().getClassIndex() && nativeClassIndex != ClassIndex.STRUCT) {
                this.writeUserClass(value2, type2);
            }
        }
        return variables;
    }

    private static boolean shouldMarshalEncoding(IRubyObject value2) {
        if (!(value2 instanceof MarshalEncoding)) {
            return false;
        }
        return ((MarshalEncoding)((Object)value2)).shouldMarshalEncoding();
    }

    public void writeDirectly(IRubyObject value2) throws IOException {
        List<Variable<Object>> variables = this.getVariables(value2);
        this.writeObjectData(value2);
        if (variables != null) {
            this.dumpVariablesWithEncoding(variables, value2);
        }
    }

    public static String getPathFromClass(RubyModule clazz) {
        RubyModule real2;
        String path2 = clazz.getName();
        if (path2.charAt(0) == '#') {
            String classOrModule = clazz.isClass() ? "class" : "module";
            throw clazz.getRuntime().newTypeError("can't dump anonymous " + classOrModule + " " + path2);
        }
        RubyModule rubyModule = real2 = clazz.isModule() ? clazz : ((RubyClass)clazz).getRealClass();
        if (clazz.getRuntime().getClassFromPath(path2) != real2) {
            throw clazz.getRuntime().newTypeError(path2 + " can't be referred");
        }
        return path2;
    }

    private void writeObjectData(IRubyObject value2) throws IOException {
        if (value2 instanceof CoreObjectType) {
            if (value2 instanceof DataType) {
                throw value2.getRuntime().newTypeError("no marshal_dump is defined for class " + value2.getMetaClass().getName());
            }
            ClassIndex nativeClassIndex = ((CoreObjectType)((Object)value2)).getNativeClassIndex();
            switch (nativeClassIndex) {
                case ARRAY: {
                    this.write(91);
                    RubyArray.marshalTo((RubyArray)value2, this);
                    return;
                }
                case FALSE: {
                    this.write(70);
                    return;
                }
                case FIXNUM: {
                    RubyFixnum fixnum = (RubyFixnum)value2;
                    if (MarshalStream.isMarshalFixnum(fixnum)) {
                        this.write(105);
                        this.writeInt((int)fixnum.getLongValue());
                        return;
                    }
                    value2 = RubyBignum.newBignum(value2.getRuntime(), fixnum.getLongValue());
                }
                case BIGNUM: {
                    this.write(108);
                    RubyBignum.marshalTo((RubyBignum)value2, this);
                    return;
                }
                case CLASS: {
                    if (((RubyClass)value2).isSingleton()) {
                        throw this.runtime.newTypeError("singleton class can't be dumped");
                    }
                    this.write(99);
                    RubyClass.marshalTo((RubyClass)value2, this);
                    return;
                }
                case FLOAT: {
                    this.write(102);
                    RubyFloat.marshalTo((RubyFloat)value2, this);
                    return;
                }
                case HASH: {
                    RubyHash hash2 = (RubyHash)value2;
                    if (hash2.getIfNone() == RubyBasicObject.UNDEF) {
                        this.write(123);
                    } else {
                        if (hash2.hasDefaultProc()) {
                            throw hash2.getRuntime().newTypeError("can't dump hash with default proc");
                        }
                        this.write(125);
                    }
                    RubyHash.marshalTo(hash2, this);
                    return;
                }
                case MODULE: {
                    this.write(109);
                    RubyModule.marshalTo((RubyModule)value2, this);
                    return;
                }
                case NIL: {
                    this.write(48);
                    return;
                }
                case OBJECT: 
                case BASICOBJECT: {
                    this.dumpDefaultObjectHeader(value2.getMetaClass());
                    value2.getMetaClass().getRealClass().marshal(value2, this);
                    return;
                }
                case REGEXP: {
                    this.write(47);
                    RubyRegexp.marshalTo((RubyRegexp)value2, this);
                    return;
                }
                case STRING: {
                    this.registerLinkTarget(value2);
                    this.write(34);
                    this.writeString(value2.convertToString().getByteList());
                    return;
                }
                case STRUCT: {
                    RubyStruct.marshalTo((RubyStruct)value2, this);
                    return;
                }
                case SYMBOL: {
                    this.writeAndRegisterSymbol(((RubySymbol)value2).asJavaString());
                    return;
                }
                case TRUE: {
                    this.write(84);
                    return;
                }
            }
            throw this.runtime.newTypeError("can't dump " + value2.getMetaClass().getName());
        }
        this.dumpDefaultObjectHeader(value2.getMetaClass());
        value2.getMetaClass().getRealClass().marshal(value2, this);
    }

    public void userNewMarshal(IRubyObject value2, DynamicMethod method) throws IOException {
        this.userNewCommon(value2, method);
    }

    public void userNewMarshal(IRubyObject value2) throws IOException {
        this.userNewCommon(value2, null);
    }

    private void userNewCommon(IRubyObject value2, DynamicMethod method) throws IOException {
        this.registerLinkTarget(value2);
        this.write(85);
        RubyClass metaclass = value2.getMetaClass().getRealClass();
        this.writeAndRegisterSymbol(metaclass.getName());
        IRubyObject marshaled = method != null ? method.call(this.runtime.getCurrentContext(), value2, value2.getMetaClass(), "marshal_dump") : value2.callMethod(this.runtime.getCurrentContext(), "marshal_dump");
        this.dumpObject(marshaled);
    }

    public void userMarshal(IRubyObject value2, DynamicMethod method) throws IOException {
        this.userCommon(value2, method);
    }

    public void userMarshal(IRubyObject value2) throws IOException {
        this.userCommon(value2, null);
    }

    private void userCommon(IRubyObject value2, DynamicMethod method) throws IOException {
        RubyFixnum depthLimitFixnum = this.runtime.newFixnum(this.depthLimit);
        IRubyObject dumpResult = method != null ? method.call(this.runtime.getCurrentContext(), value2, (RubyModule)value2.getMetaClass(), "_dump", depthLimitFixnum) : value2.callMethod(this.runtime.getCurrentContext(), "_dump", depthLimitFixnum);
        if (!(dumpResult instanceof RubyString)) {
            throw this.runtime.newTypeError(dumpResult, this.runtime.getString());
        }
        RubyString marshaled = (RubyString)dumpResult;
        boolean hasVars = marshaled.hasVariables();
        if (hasVars) {
            this.write(73);
        }
        this.write(117);
        RubyClass metaclass = value2.getMetaClass().getRealClass();
        this.writeAndRegisterSymbol(metaclass.getName());
        this.writeString(marshaled.getByteList());
        if (hasVars) {
            this.dumpVariables(marshaled.getVariableList());
        }
        this.registerLinkTarget(value2);
    }

    public void writeUserClass(IRubyObject obj, RubyClass type2) throws IOException {
        this.write(67);
        if (type2.getName().charAt(0) == '#') {
            throw obj.getRuntime().newTypeError("can't dump anonymous class " + type2.getName());
        }
        this.writeAndRegisterSymbol(type2.getName());
    }

    public void dumpVariablesWithEncoding(List<Variable<Object>> vars, IRubyObject obj) throws IOException {
        if (MarshalStream.shouldMarshalEncoding(obj)) {
            this.writeInt(vars.size() + 1);
            this.writeEncoding(((MarshalEncoding)((Object)obj)).getMarshalEncoding());
        } else {
            this.writeInt(vars.size());
        }
        this.dumpVariablesShared(vars);
    }

    public void dumpVariables(List<Variable<Object>> vars) throws IOException {
        this.writeInt(vars.size());
        this.dumpVariablesShared(vars);
    }

    private void dumpVariablesShared(List<Variable<Object>> vars) throws IOException {
        for (Variable<Object> var : vars) {
            if (!(var.getValue() instanceof IRubyObject)) continue;
            this.writeAndRegisterSymbol(var.getName());
            this.dumpObject((IRubyObject)var.getValue());
        }
    }

    public void writeEncoding(Encoding encoding2) throws IOException {
        if (encoding2 == null || encoding2 == USASCIIEncoding.INSTANCE) {
            this.writeAndRegisterSymbol(SYMBOL_ENCODING_SPECIAL);
            this.writeObjectData(this.runtime.getFalse());
        } else if (encoding2 == UTF8Encoding.INSTANCE) {
            this.writeAndRegisterSymbol(SYMBOL_ENCODING_SPECIAL);
            this.writeObjectData(this.runtime.getTrue());
        } else {
            this.writeAndRegisterSymbol(SYMBOL_ENCODING);
            RubyString encodingString = new RubyString(this.runtime, this.runtime.getString(), encoding2.getName());
            this.writeObjectData(encodingString);
        }
    }

    private boolean hasSingletonMethods(RubyClass type2) {
        for (DynamicMethod method : type2.getMethods().values()) {
            if (!method.isImplementedBy(type2)) continue;
            return true;
        }
        return false;
    }

    private RubyClass dumpExtended(RubyClass type2) throws IOException {
        if (type2.isSingleton()) {
            if (this.hasSingletonMethods(type2) || type2.hasVariables()) {
                throw type2.getRuntime().newTypeError("singleton can't be dumped");
            }
            type2 = type2.getSuperClass();
        }
        while (type2.isIncluded()) {
            this.write(101);
            this.writeAndRegisterSymbol(((IncludedModuleWrapper)type2).getNonIncludedClass().getName());
            type2 = type2.getSuperClass();
        }
        return type2;
    }

    public void dumpDefaultObjectHeader(RubyClass type2) throws IOException {
        this.dumpDefaultObjectHeader('o', type2);
    }

    public void dumpDefaultObjectHeader(char tp, RubyClass type2) throws IOException {
        this.dumpExtended(type2);
        this.write(tp);
        this.writeAndRegisterSymbol(MarshalStream.getPathFromClass(type2.getRealClass()));
    }

    public void writeString(String value2) throws IOException {
        this.writeInt(value2.length());
        this.out.write(RubyString.stringToBytes(value2));
    }

    public void writeString(ByteList value2) throws IOException {
        int len = value2.length();
        this.writeInt(len);
        this.out.write(value2.getUnsafeBytes(), value2.begin(), len);
    }

    public void dumpSymbol(String value2) throws IOException {
        this.write(58);
        this.writeString(value2);
    }

    public void writeInt(int value2) throws IOException {
        if (value2 == 0) {
            this.out.write(0);
        } else if (0 < value2 && value2 < 123) {
            this.out.write(value2 + 5);
        } else if (-124 < value2 && value2 < 0) {
            this.out.write(value2 - 5 & 0xFF);
        } else {
            int i2;
            byte[] buf = new byte[4];
            for (i2 = 0; i2 < buf.length; ++i2) {
                buf[i2] = (byte)(value2 & 0xFF);
                if ((value2 >>= 8) == 0 || value2 == -1) break;
            }
            int len = i2 + 1;
            this.out.write(value2 < 0 ? -len : len);
            this.out.write(buf, 0, i2 + 1);
        }
    }

    public void writeByte(int value2) throws IOException {
        this.out.write(value2);
    }

    public boolean isTainted() {
        return this.tainted;
    }

    @Deprecated
    public boolean isUntrusted() {
        return this.tainted;
    }
}

