/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jnr.constants.platform.Signal;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.platform.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.NoFunctionalitySignalFacade;
import org.jruby.util.SignalFacade;

@JRubyModule(name={"Signal"})
public class RubySignal {
    private static final SignalFacade SIGNALS = RubySignal.getSignalFacade();
    private static final Set<String> RUBY_18_SIGNALS = new HashSet<String>();

    private static final SignalFacade getSignalFacade() {
        try {
            Class<?> realFacadeClass = Class.forName("org.jruby.util.SunSignalFacade");
            return (SignalFacade)realFacadeClass.newInstance();
        }
        catch (Throwable e) {
            return new NoFunctionalitySignalFacade();
        }
    }

    public static void createSignal(Ruby runtime) {
        if (!Platform.IS_WINDOWS) {
            try {
                Class.forName("java.lang.Process");
                Class.forName("java.lang.UNIXProcess");
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        RubyModule mSignal = runtime.defineModule("Signal");
        mSignal.defineAnnotatedMethods(RubySignal.class);
    }

    public static Map<String, Integer> list() {
        HashMap<String, Integer> signals = new HashMap<String, Integer>();
        for (Signal s2 : Signal.values()) {
            if (!s2.description().startsWith("SIG") || !RUBY_18_SIGNALS.contains(s2.description().substring(3))) continue;
            int signo = s2.intValue();
            if (s2 == Signal.SIGCLD) {
                signo = Signal.SIGCHLD.intValue();
            }
            if (signo >= 20000) continue;
            signals.put(s2.description().substring("SIG".length()), signo);
        }
        return signals;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject list(ThreadContext context, IRubyObject recv2) {
        Ruby runtime = recv2.getRuntime();
        RubyHash names2 = RubyHash.newHash(runtime);
        for (Map.Entry<String, Integer> sig : RubySignal.list().entrySet()) {
            names2.op_aset(context, runtime.newString(sig.getKey()), runtime.newFixnum(sig.getValue()));
        }
        names2.op_aset(context, runtime.newString("EXIT"), runtime.newFixnum(0));
        return names2;
    }

    @JRubyMethod(required=2, meta=true)
    public static IRubyObject __jtrap_kernel(IRubyObject recv2, IRubyObject block, IRubyObject sig) {
        return SIGNALS.trap(recv2, block, sig);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject __jtrap_platform_kernel(IRubyObject recv2, IRubyObject sig) {
        return SIGNALS.restorePlatformDefault(recv2, sig);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject __jtrap_osdefault_kernel(IRubyObject recv2, IRubyObject sig) {
        return SIGNALS.restoreOSDefault(recv2, sig);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject __jtrap_restore_kernel(IRubyObject recv2, IRubyObject sig) {
        return SIGNALS.ignore(recv2, sig);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject signame(ThreadContext context, IRubyObject recv2, IRubyObject rubySig) {
        long sig = rubySig.convertToInteger().getLongValue();
        String signame2 = RubySignal.signo2signm(sig);
        if (signame2 == null) {
            if (sig == 0L) {
                return RubyString.newString(context.runtime, "EXIT");
            }
            throw context.runtime.newArgumentError("invalid signal number: " + rubySig);
        }
        return context.runtime.newString(signame2);
    }

    public static String signo2signm(long no) {
        for (Signal s2 : Signal.values()) {
            if ((long)s2.intValue() != no) continue;
            return s2.name().substring(3);
        }
        return null;
    }

    static {
        for (String name2 : new String[]{"EXIT", "HUP", "INT", "QUIT", "ILL", "TRAP", "IOT", "ABRT", "EMT", "FPE", "KILL", "BUS", "SEGV", "SYS", "PIPE", "ALRM", "TERM", "URG", "STOP", "TSTP", "CONT", "CHLD", "CLD", "TTIN", "TTOU", "IO", "XCPU", "XFSZ", "VTALRM", "PROF", "WINCH", "USR1", "USR2", "LOST", "MSG", "PWR", "POLL", "DANGER", "MIGRATE", "PRE", "GRANT", "RETRACT", "SOUND", "INFO"}) {
            RUBY_18_SIGNALS.add(name2);
        }
    }
}

