/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;

public class OpAsgnNode
extends Node {
    private final Node receiverNode;
    private final Node valueNode;
    private final String variableName;
    private final String operatorName;
    private final String variableNameAsgn;

    public OpAsgnNode(ISourcePosition position, Node receiverNode, Node valueNode, String variableName, String operatorName) {
        super(position, receiverNode.containsVariableAssignment());
        assert (receiverNode != null) : "receiverNode is not null";
        assert (valueNode != null) : "valueNode is not null";
        this.receiverNode = receiverNode;
        this.valueNode = valueNode;
        this.variableName = variableName;
        this.operatorName = operatorName;
        this.variableNameAsgn = (variableName + "=").intern();
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.OPASGNNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitOpAsgnNode(this);
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableNameAsgn() {
        return this.variableNameAsgn;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.valueNode);
    }

    @Override
    public boolean needsDefinitionCheck() {
        return false;
    }
}

