/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Signature;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyRange;
import org.jruby.RubyRational;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.AliasInstr;
import org.jruby.ir.instructions.ArgScopeDepthInstr;
import org.jruby.ir.instructions.AttrAssignInstr;
import org.jruby.ir.instructions.BEQInstr;
import org.jruby.ir.instructions.BFalseInstr;
import org.jruby.ir.instructions.BNEInstr;
import org.jruby.ir.instructions.BNilInstr;
import org.jruby.ir.instructions.BTrueInstr;
import org.jruby.ir.instructions.BUndefInstr;
import org.jruby.ir.instructions.BacktickInstr;
import org.jruby.ir.instructions.BlockGivenInstr;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.BuildCompoundArrayInstr;
import org.jruby.ir.instructions.BuildCompoundStringInstr;
import org.jruby.ir.instructions.BuildDynRegExpInstr;
import org.jruby.ir.instructions.BuildLambdaInstr;
import org.jruby.ir.instructions.BuildRangeInstr;
import org.jruby.ir.instructions.BuildSplatInstr;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.CheckArgsArrayArityInstr;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.CheckForLJEInstr;
import org.jruby.ir.instructions.ClassSuperInstr;
import org.jruby.ir.instructions.ConstMissingInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.DefineClassInstr;
import org.jruby.ir.instructions.DefineClassMethodInstr;
import org.jruby.ir.instructions.DefineInstanceMethodInstr;
import org.jruby.ir.instructions.DefineMetaClassInstr;
import org.jruby.ir.instructions.DefineModuleInstr;
import org.jruby.ir.instructions.EQQInstr;
import org.jruby.ir.instructions.ExceptionRegionEndMarkerInstr;
import org.jruby.ir.instructions.ExceptionRegionStartMarkerInstr;
import org.jruby.ir.instructions.GVarAliasInstr;
import org.jruby.ir.instructions.GetClassVarContainerModuleInstr;
import org.jruby.ir.instructions.GetClassVariableInstr;
import org.jruby.ir.instructions.GetEncodingInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.GetGlobalVariableInstr;
import org.jruby.ir.instructions.InheritanceSearchConstInstr;
import org.jruby.ir.instructions.InstanceSuperInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.LexicalSearchConstInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.LoadFrameClosureInstr;
import org.jruby.ir.instructions.LoadImplicitClosureInstr;
import org.jruby.ir.instructions.LoadLocalVarInstr;
import org.jruby.ir.instructions.MatchInstr;
import org.jruby.ir.instructions.ModuleVersionGuardInstr;
import org.jruby.ir.instructions.NoResultCallInstr;
import org.jruby.ir.instructions.NonlocalReturnInstr;
import org.jruby.ir.instructions.NopInstr;
import org.jruby.ir.instructions.OptArgMultipleAsgnInstr;
import org.jruby.ir.instructions.PopBindingInstr;
import org.jruby.ir.instructions.PopFrameInstr;
import org.jruby.ir.instructions.ProcessModuleBodyInstr;
import org.jruby.ir.instructions.PushBindingInstr;
import org.jruby.ir.instructions.PushFrameInstr;
import org.jruby.ir.instructions.PutClassVariableInstr;
import org.jruby.ir.instructions.PutConstInstr;
import org.jruby.ir.instructions.PutFieldInstr;
import org.jruby.ir.instructions.PutGlobalVarInstr;
import org.jruby.ir.instructions.RaiseRequiredKeywordArgumentError;
import org.jruby.ir.instructions.ReceiveJRubyExceptionInstr;
import org.jruby.ir.instructions.ReceiveKeywordArgInstr;
import org.jruby.ir.instructions.ReceiveKeywordRestArgInstr;
import org.jruby.ir.instructions.ReceiveOptArgInstr;
import org.jruby.ir.instructions.ReceivePostReqdArgInstr;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ReceiveRestArgInstr;
import org.jruby.ir.instructions.ReceiveRubyExceptionInstr;
import org.jruby.ir.instructions.ReceiveSelfInstr;
import org.jruby.ir.instructions.RecordEndBlockInstr;
import org.jruby.ir.instructions.ReifyClosureInstr;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.instructions.RescueEQQInstr;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.SearchConstInstr;
import org.jruby.ir.instructions.SetCapturedVarInstr;
import org.jruby.ir.instructions.StoreLocalVarInstr;
import org.jruby.ir.instructions.ThreadPollInstr;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.instructions.ToAryInstr;
import org.jruby.ir.instructions.ToggleBacktraceInstr;
import org.jruby.ir.instructions.UndefMethodInstr;
import org.jruby.ir.instructions.UnresolvedSuperInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.instructions.ZSuperInstr;
import org.jruby.ir.instructions.boxing.AluInstr;
import org.jruby.ir.instructions.boxing.BoxBooleanInstr;
import org.jruby.ir.instructions.boxing.BoxFixnumInstr;
import org.jruby.ir.instructions.boxing.BoxFloatInstr;
import org.jruby.ir.instructions.boxing.UnboxBooleanInstr;
import org.jruby.ir.instructions.boxing.UnboxFixnumInstr;
import org.jruby.ir.instructions.boxing.UnboxFloatInstr;
import org.jruby.ir.instructions.defined.GetErrorInfoInstr;
import org.jruby.ir.instructions.defined.RestoreErrorInfoInstr;
import org.jruby.ir.instructions.specialized.OneFixnumArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneFloatArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneOperandArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.ZeroOperandArgNoBlockCallInstr;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.AsString;
import org.jruby.ir.operands.Backref;
import org.jruby.ir.operands.Bignum;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.Complex;
import org.jruby.ir.operands.CurrentScope;
import org.jruby.ir.operands.DynamicSymbol;
import org.jruby.ir.operands.Filename;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.FrozenString;
import org.jruby.ir.operands.Hash;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.NthRef;
import org.jruby.ir.operands.NullBlock;
import org.jruby.ir.operands.ObjectClass;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Rational;
import org.jruby.ir.operands.Regexp;
import org.jruby.ir.operands.SValue;
import org.jruby.ir.operands.ScopeModule;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.StandardError;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.TemporaryBooleanVariable;
import org.jruby.ir.operands.TemporaryFixnumVariable;
import org.jruby.ir.operands.TemporaryFloatVariable;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.UnboxedBoolean;
import org.jruby.ir.operands.UnboxedFixnum;
import org.jruby.ir.operands.UnboxedFloat;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.UnexecutableNil;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.JVM;
import org.jruby.ir.targets.JVM6;
import org.jruby.ir.targets.JVM7;
import org.jruby.ir.targets.JVMVisitorMethodContext;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.commons.Method;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.RefinedCachingCallSite;
import org.jruby.util.ByteList;
import org.jruby.util.ClassDefiningClassLoader;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.KeyValuePair;
import org.jruby.util.RegexpOptions;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class JVMVisitor
extends IRVisitor {
    private static final Logger LOG = LoggerFactory.getLogger("JVMVisitor");
    public static final String DYNAMIC_SCOPE = "$dynamicScope";
    private static final boolean DEBUG = false;
    private static final Signature METHOD_SIGNATURE_BASE = Signature.returning(IRubyObject.class).appendArgs(new String[]{"context", "scope", "self", "block", "class", "callName"}, ThreadContext.class, StaticScope.class, IRubyObject.class, Block.class, RubyModule.class, String.class);
    public static final Signature CLOSURE_SIGNATURE = Signature.returning(IRubyObject.class).appendArgs(new String[]{"context", "scope", "self", "args", "block", "superName", "type"}, ThreadContext.class, StaticScope.class, IRubyObject.class, IRubyObject[].class, Block.class, String.class, Block.Type.class);
    private JVM jvm = Options.COMPILE_INVOKEDYNAMIC.load() != false ? new JVM7() : new JVM6();
    private int methodIndex = 0;
    private Map<String, IRScope> scopeMap = new HashMap<String, IRScope>();

    public Class compile(IRScope scope, ClassDefiningClassLoader jrubyClassLoader) {
        JVMVisitorMethodContext context = new JVMVisitorMethodContext();
        return this.defineFromBytecode(scope, this.compileToBytecode(scope, context), jrubyClassLoader);
    }

    public byte[] compileToBytecode(IRScope scope, JVMVisitorMethodContext context) {
        this.codegenScope(scope, context);
        return this.code();
    }

    public Class defineFromBytecode(IRScope scope, byte[] code, ClassDefiningClassLoader jrubyClassLoader) {
        Class<?> result2 = jrubyClassLoader.defineClass(CodegenUtils.c(JVM.scriptToClass(scope.getFileName())), code);
        for (Map.Entry<String, IRScope> entry : this.scopeMap.entrySet()) {
            try {
                result2.getField(entry.getKey()).set(null, entry.getValue());
            }
            catch (Exception e) {
                throw new NotCompilableException(e);
            }
        }
        return result2;
    }

    public byte[] code() {
        return this.jvm.code();
    }

    public void codegenScope(IRScope scope, JVMVisitorMethodContext context) {
        if (scope instanceof IRScriptBody) {
            this.codegenScriptBody((IRScriptBody)scope);
        } else if (scope instanceof IRMethod) {
            this.emitMethodJIT((IRMethod)scope, context);
        } else if (scope instanceof IRClosure) {
            this.emitBlockJIT((IRClosure)scope, context);
        } else if (scope instanceof IRModuleBody) {
            this.emitModuleBodyJIT((IRModuleBody)scope);
        } else {
            throw new NotCompilableException("don't know how to JIT: " + scope);
        }
    }

    public void codegenScriptBody(IRScriptBody script) {
        this.emitScriptBody(script);
    }

    private void logScope(IRScope scope) {
        LOG.info("Starting JVM compilation on scope " + scope, new Object[0]);
        LOG.info("\n\nLinearized instructions for JIT:\n" + scope.toStringInstrs(), new Object[0]);
    }

    public void emitScope(IRScope scope, String name2, Signature signature, boolean specificArity) {
        BasicBlock[] bbs = scope.prepareForInitialCompilation();
        Map<BasicBlock, org.jruby.ir.operands.Label> exceptionTable = scope.buildJVMExceptionTable();
        if (Options.IR_COMPILER_DEBUG.load().booleanValue()) {
            this.logScope(scope);
        }
        this.emitClosures(scope);
        this.jvm.pushmethod(name2, scope, signature, specificArity);
        String scopeField = name2 + "_IRScope";
        if (this.scopeMap.get(scopeField) == null) {
            this.scopeMap.put(scopeField, scope);
            this.jvm.cls().visitField(73, scopeField, CodegenUtils.ci(IRScope.class), null, null).visitEnd();
        }
        if (!scope.hasExplicitCallProtocol()) {
            this.jvmMethod().loadContext();
            this.jvmMethod().invokeVirtual(Type.getType(ThreadContext.class), Method.getMethod("org.jruby.runtime.DynamicScope getCurrentScope()"));
            this.jvmStoreLocal(DYNAMIC_SCOPE);
        }
        IRBytecodeAdapter m = this.jvmMethod();
        int numberOfBasicBlocks = bbs.length;
        boolean ipc = false;
        for (int i2 = 0; i2 < numberOfBasicBlocks; ++i2) {
            BasicBlock bb = bbs[i2];
            Label start2 = this.jvm.methodData().getLabel(bb.getLabel());
            org.jruby.ir.operands.Label rescueLabel = exceptionTable.get(bb);
            Label end2 = null;
            m.mark(start2);
            boolean newEnd = false;
            if (rescueLabel != null) {
                if (i2 + 1 < numberOfBasicBlocks) {
                    end2 = this.jvm.methodData().getLabel(bbs[i2 + 1].getLabel());
                } else {
                    newEnd = true;
                    end2 = new Label();
                }
                Label rescue = this.jvm.methodData().getLabel(rescueLabel);
                this.jvmAdapter().trycatch(start2, end2, rescue, CodegenUtils.p(Throwable.class));
            }
            m.adapter.nop();
            for (Instr instr : bb.getInstrs()) {
                this.visit(instr);
            }
            if (!newEnd) continue;
            m.mark(end2);
        }
        this.jvm.popmethod();
    }

    public static final Signature signatureFor(IRScope method, boolean aritySplit) {
        if (aritySplit) {
            StaticScope argScope = method.getStaticScope();
            if (argScope.isArgumentScope() && argScope.getSignature().isFixed() && !argScope.getSignature().hasKwargs()) {
                String[] args2 = new String[argScope.getSignature().required()];
                Class[] types = Helpers.arrayOf(Class.class, args2.length, IRubyObject.class);
                for (int i2 = 0; i2 < args2.length; ++i2) {
                    args2[i2] = "arg" + i2;
                }
                return METHOD_SIGNATURE_BASE.insertArgs(3, args2, types);
            }
            return null;
        }
        return METHOD_SIGNATURE_BASE.insertArgs(3, new String[]{"args"}, IRubyObject[].class);
    }

    public void emitScriptBody(IRScriptBody script) {
        String name2 = JavaNameMangler.encodeScopeForBacktrace(script);
        String clsName = JVM.scriptToClass(script.getFileName());
        this.jvm.pushscript(clsName, script.getFileName());
        this.emitScope(script, name2, JVMVisitor.signatureFor(script, false), false);
        this.jvm.cls().visitEnd();
        this.jvm.popclass();
    }

    public void emitMethod(IRMethod method, JVMVisitorMethodContext context) {
        String name2 = JavaNameMangler.encodeScopeForBacktrace(method) + "$" + this.methodIndex++;
        this.emitWithSignatures(method, context, name2);
    }

    public void emitMethodJIT(IRMethod method, JVMVisitorMethodContext context) {
        String clsName = JVM.scriptToClass(method.getFileName());
        String name2 = JavaNameMangler.encodeScopeForBacktrace(method) + "$" + this.methodIndex++;
        this.jvm.pushscript(clsName, method.getFileName());
        this.emitWithSignatures(method, context, name2);
        this.jvm.cls().visitEnd();
        this.jvm.popclass();
    }

    public void emitBlockJIT(IRClosure closure, JVMVisitorMethodContext context) {
        String clsName = JVM.scriptToClass(closure.getFileName());
        String name2 = JavaNameMangler.encodeScopeForBacktrace(closure) + "$" + this.methodIndex++;
        this.jvm.pushscript(clsName, closure.getFileName());
        this.emitScope(closure, name2, CLOSURE_SIGNATURE, false);
        context.setJittedName(name2);
        this.jvm.cls().visitEnd();
        this.jvm.popclass();
    }

    private void emitWithSignatures(IRMethod method, JVMVisitorMethodContext context, String name2) {
        context.setJittedName(name2);
        Signature signature = JVMVisitor.signatureFor(method, false);
        this.emitScope(method, name2, signature, false);
        context.addNativeSignature(-1, signature.type());
        Signature specificSig = JVMVisitor.signatureFor(method, true);
        if (specificSig != null) {
            this.emitScope(method, name2, specificSig, true);
            context.addNativeSignature(method.getStaticScope().getSignature().required(), specificSig.type());
        }
    }

    public Handle emitModuleBodyJIT(IRModuleBody method) {
        String name2 = JavaNameMangler.encodeScopeForBacktrace(method) + "$" + this.methodIndex++;
        String clsName = JVM.scriptToClass(method.getFileName());
        this.jvm.pushscript(clsName, method.getFileName());
        Signature signature = JVMVisitor.signatureFor(method, false);
        this.emitScope(method, name2, signature, false);
        Handle handle = new Handle(6, this.jvm.clsData().clsName, name2, CodegenUtils.sig((Class)signature.type().returnType(), signature.type().parameterArray()));
        this.jvm.cls().visitEnd();
        this.jvm.popclass();
        return handle;
    }

    private void emitClosures(IRScope s2) {
        for (IRClosure c : s2.getClosures()) {
            c.setHandle(this.emitClosure(c));
        }
    }

    public Handle emitClosure(IRClosure closure) {
        String name2 = JavaNameMangler.encodeScopeForBacktrace(closure) + "$" + this.methodIndex++;
        this.emitScope(closure, name2, CLOSURE_SIGNATURE, false);
        return new Handle(6, this.jvm.clsData().clsName, name2, CodegenUtils.sig((Class)CLOSURE_SIGNATURE.type().returnType(), CLOSURE_SIGNATURE.type().parameterArray()));
    }

    public Handle emitModuleBody(IRModuleBody method) {
        String name2 = JavaNameMangler.encodeScopeForBacktrace(method) + "$" + this.methodIndex++;
        Signature signature = JVMVisitor.signatureFor(method, false);
        this.emitScope(method, name2, signature, false);
        return new Handle(6, this.jvm.clsData().clsName, name2, CodegenUtils.sig((Class)signature.type().returnType(), signature.type().parameterArray()));
    }

    @Override
    public void visit(Instr instr) {
        instr.visit(this);
    }

    @Override
    public void visit(Operand operand) {
        operand.visit(this);
    }

    private int getJVMLocalVarIndex(Variable variable) {
        if (variable instanceof TemporaryLocalVariable) {
            switch (((TemporaryLocalVariable)variable).getType()) {
                case FLOAT: {
                    return this.jvm.methodData().local(variable, JVM.DOUBLE_TYPE);
                }
                case FIXNUM: {
                    return this.jvm.methodData().local(variable, JVM.LONG_TYPE);
                }
                case BOOLEAN: {
                    return this.jvm.methodData().local(variable, JVM.BOOLEAN_TYPE);
                }
            }
            return this.jvm.methodData().local(variable);
        }
        return this.jvm.methodData().local(variable);
    }

    private int getJVMLocalVarIndex(String specialVar) {
        return this.jvm.methodData().local(specialVar);
    }

    private Label getJVMLabel(org.jruby.ir.operands.Label label2) {
        return this.jvm.methodData().getLabel(label2);
    }

    private void jvmStoreLocal(Variable variable) {
        if (variable instanceof TemporaryLocalVariable) {
            switch (((TemporaryLocalVariable)variable).getType()) {
                case FLOAT: {
                    this.jvmAdapter().dstore(this.getJVMLocalVarIndex(variable));
                    break;
                }
                case FIXNUM: {
                    this.jvmAdapter().lstore(this.getJVMLocalVarIndex(variable));
                    break;
                }
                case BOOLEAN: {
                    this.jvmAdapter().istore(this.getJVMLocalVarIndex(variable));
                    break;
                }
                default: {
                    this.jvmMethod().storeLocal(this.getJVMLocalVarIndex(variable));
                    break;
                }
            }
        } else {
            this.jvmMethod().storeLocal(this.getJVMLocalVarIndex(variable));
        }
    }

    private void jvmStoreLocal(String specialVar) {
        this.jvmMethod().storeLocal(this.getJVMLocalVarIndex(specialVar));
    }

    private void jvmLoadLocal(Variable variable) {
        if (variable instanceof TemporaryLocalVariable) {
            switch (((TemporaryLocalVariable)variable).getType()) {
                case FLOAT: {
                    this.jvmAdapter().dload(this.getJVMLocalVarIndex(variable));
                    break;
                }
                case FIXNUM: {
                    this.jvmAdapter().lload(this.getJVMLocalVarIndex(variable));
                    break;
                }
                case BOOLEAN: {
                    this.jvmAdapter().iload(this.getJVMLocalVarIndex(variable));
                    break;
                }
                default: {
                    this.jvmMethod().loadLocal(this.getJVMLocalVarIndex(variable));
                    break;
                }
            }
        } else {
            this.jvmMethod().loadLocal(this.getJVMLocalVarIndex(variable));
        }
    }

    private void jvmLoadLocal(String specialVar) {
        this.jvmMethod().loadLocal(this.getJVMLocalVarIndex(specialVar));
    }

    @Override
    public void AliasInstr(AliasInstr aliasInstr) {
        IRBytecodeAdapter m = this.jvm.method();
        m.loadContext();
        m.loadSelf();
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.visit(aliasInstr.getNewName());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Object.class), "toString", CodegenUtils.sig(String.class, new Class[0]));
        this.visit(aliasInstr.getOldName());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Object.class), "toString", CodegenUtils.sig(String.class, new Class[0]));
        m.invokeIRHelper("defineAlias", CodegenUtils.sig(Void.TYPE, ThreadContext.class, IRubyObject.class, DynamicScope.class, String.class, String.class));
    }

    @Override
    public void ArgScopeDepthInstr(ArgScopeDepthInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadStaticScope();
        this.jvmMethod().invokeIRHelper("getArgScopeDepth", CodegenUtils.sig(RubyFixnum.class, ThreadContext.class, StaticScope.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void AttrAssignInstr(AttrAssignInstr attrAssignInstr) {
        Operand[] callArgs = attrAssignInstr.getCallArgs();
        this.compileCallCommon(this.jvmMethod(), attrAssignInstr.getName(), callArgs, attrAssignInstr.getReceiver(), callArgs.length, null, false, attrAssignInstr.getReceiver() instanceof Self ? CallType.FUNCTIONAL : CallType.NORMAL, null, attrAssignInstr.isPotentiallyRefined());
    }

    @Override
    public void BEQInstr(BEQInstr beqInstr) {
        this.jvmMethod().loadContext();
        this.visit(beqInstr.getArg1());
        this.visit(beqInstr.getArg2());
        this.jvmMethod().invokeHelper("BEQ", java.lang.Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        this.jvmAdapter().iftrue(this.getJVMLabel(beqInstr.getJumpTarget()));
    }

    @Override
    public void BFalseInstr(BFalseInstr bFalseInstr) {
        Operand arg1 = bFalseInstr.getArg1();
        this.visit(arg1);
        if (!(arg1 instanceof TemporaryBooleanVariable) && !(arg1 instanceof UnboxedBoolean)) {
            this.jvmAdapter().invokeinterface(CodegenUtils.p(IRubyObject.class), "isTrue", CodegenUtils.sig(java.lang.Boolean.TYPE, new Class[0]));
        }
        this.jvmMethod().bfalse(this.getJVMLabel(bFalseInstr.getJumpTarget()));
    }

    @Override
    public void BlockGivenInstr(BlockGivenInstr blockGivenInstr) {
        this.jvmMethod().loadContext();
        this.visit(blockGivenInstr.getBlockArg());
        this.jvmMethod().invokeIRHelper("isBlockGiven", CodegenUtils.sig(RubyBoolean.class, ThreadContext.class, Object.class));
        this.jvmStoreLocal(blockGivenInstr.getResult());
    }

    private void loadFloatArg(Operand arg2) {
        if (arg2 instanceof Variable) {
            this.visit(arg2);
        } else {
            double val;
            if (arg2 instanceof Float) {
                val = ((Float)arg2).value;
            } else if (arg2 instanceof Fixnum) {
                val = ((Fixnum)arg2).value;
            } else {
                throw new NotCompilableException("Non-float/fixnum in loadFloatArg!" + arg2);
            }
            this.jvmAdapter().ldc(val);
        }
    }

    private void loadFixnumArg(Operand arg2) {
        if (arg2 instanceof Variable) {
            this.visit(arg2);
        } else {
            long val;
            if (arg2 instanceof Float) {
                val = (long)((Float)arg2).value;
            } else if (arg2 instanceof Fixnum) {
                val = ((Fixnum)arg2).value;
            } else {
                throw new NotCompilableException("Non-float/fixnum in loadFixnumArg!" + arg2);
            }
            this.jvmAdapter().ldc(val);
        }
    }

    private void loadBooleanArg(Operand arg2) {
        if (arg2 instanceof Variable) {
            this.visit(arg2);
        } else {
            if (!(arg2 instanceof UnboxedBoolean)) {
                throw new NotCompilableException("Non-float/fixnum in loadFixnumArg!" + arg2);
            }
            boolean val = ((UnboxedBoolean)arg2).isTrue();
            this.jvmAdapter().ldc(val);
        }
    }

    @Override
    public void BoxFloatInstr(BoxFloatInstr instr) {
        IRBytecodeAdapter m = this.jvmMethod();
        SkinnyMethodAdapter a = m.adapter;
        m.loadContext();
        a.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
        this.loadFloatArg(instr.getValue());
        a.invokevirtual(CodegenUtils.p(Ruby.class), "newFloat", CodegenUtils.sig(RubyFloat.class, Double.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BoxFixnumInstr(BoxFixnumInstr instr) {
        IRBytecodeAdapter m = this.jvmMethod();
        SkinnyMethodAdapter a = m.adapter;
        m.loadContext();
        a.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
        this.loadFixnumArg(instr.getValue());
        a.invokevirtual(CodegenUtils.p(Ruby.class), "newFixnum", CodegenUtils.sig(RubyFixnum.class, Long.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BoxBooleanInstr(BoxBooleanInstr instr) {
        IRBytecodeAdapter m = this.jvmMethod();
        SkinnyMethodAdapter a = m.adapter;
        m.loadContext();
        a.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
        this.loadBooleanArg(instr.getValue());
        a.invokevirtual(CodegenUtils.p(Ruby.class), "newBoolean", CodegenUtils.sig(RubyBoolean.class, java.lang.Boolean.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void UnboxFloatInstr(UnboxFloatInstr instr) {
        this.visit(instr.getValue());
        this.jvmMethod().invokeIRHelper("unboxFloat", CodegenUtils.sig(Double.TYPE, IRubyObject.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void UnboxFixnumInstr(UnboxFixnumInstr instr) {
        this.visit(instr.getValue());
        this.jvmMethod().invokeIRHelper("unboxFixnum", CodegenUtils.sig(Long.TYPE, IRubyObject.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void UnboxBooleanInstr(UnboxBooleanInstr instr) {
        this.visit(instr.getValue());
        this.jvmMethod().invokeIRHelper("unboxBoolean", CodegenUtils.sig(java.lang.Boolean.TYPE, IRubyObject.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void AluInstr(AluInstr instr) {
        IRBytecodeAdapter m = this.jvmMethod();
        SkinnyMethodAdapter a = m.adapter;
        this.visit(instr.getArg1());
        this.visit(instr.getArg2());
        switch (instr.getOperation()) {
            case FADD: {
                a.dadd();
                break;
            }
            case FSUB: {
                a.dsub();
                break;
            }
            case FMUL: {
                a.dmul();
                break;
            }
            case FDIV: {
                a.ddiv();
                break;
            }
            case FLT: {
                m.invokeIRHelper("flt", CodegenUtils.sig(java.lang.Boolean.TYPE, Double.TYPE, Double.TYPE));
                break;
            }
            case FGT: {
                m.invokeIRHelper("fgt", CodegenUtils.sig(java.lang.Boolean.TYPE, Double.TYPE, Double.TYPE));
                break;
            }
            case FEQ: {
                m.invokeIRHelper("feq", CodegenUtils.sig(java.lang.Boolean.TYPE, Double.TYPE, Double.TYPE));
                break;
            }
            case IADD: {
                a.ladd();
                break;
            }
            case ISUB: {
                a.lsub();
                break;
            }
            case IMUL: {
                a.lmul();
                break;
            }
            case IDIV: {
                a.ldiv();
                break;
            }
            case ILT: {
                m.invokeIRHelper("ilt", CodegenUtils.sig(java.lang.Boolean.TYPE, Long.TYPE, Long.TYPE));
                break;
            }
            case IGT: {
                m.invokeIRHelper("igt", CodegenUtils.sig(java.lang.Boolean.TYPE, Long.TYPE, Long.TYPE));
                break;
            }
            case IOR: {
                a.lor();
                break;
            }
            case IAND: {
                a.land();
                break;
            }
            case IXOR: {
                a.lxor();
                break;
            }
            case ISHL: {
                a.lshl();
                break;
            }
            case ISHR: {
                a.lshr();
                break;
            }
            case IEQ: {
                m.invokeIRHelper("ilt", CodegenUtils.sig(java.lang.Boolean.TYPE, Long.TYPE, Long.TYPE));
                break;
            }
            default: {
                throw new NotCompilableException("UNHANDLED!");
            }
        }
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BacktickInstr(BacktickInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadSelf();
        this.jvmMethod().loadSelf();
        ByteList csByteList = new ByteList();
        this.jvmMethod().pushString(csByteList, 48);
        for (Operand p2 : instr.getOperands()) {
            this.visit(p2);
            this.jvmAdapter().dup();
            Label after = new Label();
            this.jvmAdapter().instance_of(CodegenUtils.p(RubyString.class));
            this.jvmAdapter().iftrue(after);
            this.jvmAdapter().invokevirtual(CodegenUtils.p(IRubyObject.class), "anyToString", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            this.jvmAdapter().label(after);
            this.jvmAdapter().invokevirtual(CodegenUtils.p(RubyString.class), "append19", CodegenUtils.sig(RubyString.class, IRubyObject.class));
        }
        this.jvmAdapter().dup();
        this.jvmAdapter().ldc(true);
        this.jvmAdapter().invokeinterface(CodegenUtils.p(IRubyObject.class), "setFrozen", CodegenUtils.sig(Void.TYPE, java.lang.Boolean.TYPE));
        this.jvmMethod().invokeSelf("`", 1, false, CallType.FUNCTIONAL, false);
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BNEInstr(BNEInstr bneinstr) {
        this.jvmMethod().loadContext();
        this.visit(bneinstr.getArg1());
        this.visit(bneinstr.getArg2());
        this.jvmMethod().invokeHelper("BNE", java.lang.Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        this.jvmAdapter().iftrue(this.getJVMLabel(bneinstr.getJumpTarget()));
    }

    @Override
    public void BNilInstr(BNilInstr bnilinstr) {
        this.visit(bnilinstr.getArg1());
        this.jvmMethod().isNil();
        this.jvmMethod().btrue(this.getJVMLabel(bnilinstr.getJumpTarget()));
    }

    @Override
    public void BreakInstr(BreakInstr breakInstr) {
        this.jvmMethod().loadContext();
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.visit(breakInstr.getReturnValue());
        this.jvmMethod().loadBlockType();
        this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "initiateBreak", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, DynamicScope.class, IRubyObject.class, Block.Type.class));
        this.jvmMethod().returnValue();
    }

    @Override
    public void BTrueInstr(BTrueInstr btrueinstr) {
        Operand arg1 = btrueinstr.getArg1();
        this.visit(arg1);
        if (!(arg1 instanceof TemporaryBooleanVariable) && !(arg1 instanceof UnboxedBoolean)) {
            this.jvmMethod().isTrue();
        }
        this.jvmMethod().btrue(this.getJVMLabel(btrueinstr.getJumpTarget()));
    }

    @Override
    public void BUndefInstr(BUndefInstr bundefinstr) {
        this.visit(bundefinstr.getArg1());
        this.jvmMethod().pushUndefined();
        this.jvmAdapter().if_acmpeq(this.getJVMLabel(bundefinstr.getJumpTarget()));
    }

    @Override
    public void BuildCompoundArrayInstr(BuildCompoundArrayInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getAppendingArg());
        if (instr.isArgsPush()) {
            this.jvmAdapter().checkcast("org/jruby/RubyArray");
        }
        this.visit(instr.getAppendedArg());
        if (instr.isArgsPush()) {
            this.jvmMethod().invokeHelper("argsPush", RubyArray.class, ThreadContext.class, RubyArray.class, IRubyObject.class);
        } else {
            this.jvmMethod().invokeHelper("argsCat", RubyArray.class, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        }
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BuildCompoundStringInstr(BuildCompoundStringInstr compoundstring) {
        ByteList csByteList = new ByteList();
        csByteList.setEncoding(compoundstring.getEncoding());
        this.jvmMethod().pushString(csByteList, 0);
        for (Operand p2 : compoundstring.getPieces()) {
            this.visit(p2);
            this.jvmAdapter().invokevirtual(CodegenUtils.p(RubyString.class), "append19", CodegenUtils.sig(RubyString.class, IRubyObject.class));
        }
        this.jvmStoreLocal(compoundstring.getResult());
    }

    @Override
    public void BuildDynRegExpInstr(BuildDynRegExpInstr instr) {
        final IRBytecodeAdapter m = this.jvmMethod();
        SkinnyMethodAdapter a = m.adapter;
        RegexpOptions options2 = instr.getOptions();
        final Operand[] operands = instr.getPieces();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                m.loadContext();
                for (int i2 = 0; i2 < operands.length; ++i2) {
                    Operand operand = operands[i2];
                    JVMVisitor.this.visit(operand);
                }
            }
        };
        m.pushDRegexp(r, options2, operands.length);
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BuildRangeInstr(BuildRangeInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getBegin());
        this.visit(instr.getEnd());
        this.jvmAdapter().ldc(instr.isExclusive());
        this.jvmAdapter().invokestatic(CodegenUtils.p(RubyRange.class), "newRange", CodegenUtils.sig(RubyRange.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, java.lang.Boolean.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BuildSplatInstr(BuildSplatInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getArray());
        this.jvmMethod().invokeIRHelper("irSplat", CodegenUtils.sig(RubyArray.class, ThreadContext.class, IRubyObject.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void CallInstr(CallInstr callInstr) {
        if (callInstr.getCallSite() instanceof RefinedCachingCallSite) {
            throw new NotCompilableException("refinements are unsupported in JIT");
        }
        IRBytecodeAdapter m = this.jvmMethod();
        String name2 = callInstr.getName();
        Operand[] args2 = callInstr.getCallArgs();
        Operand receiver2 = callInstr.getReceiver();
        int numArgs = args2.length;
        Operand closure = callInstr.getClosureArg(null);
        boolean hasClosure = closure != null;
        CallType callType = callInstr.getCallType();
        Variable result2 = callInstr.getResult();
        this.compileCallCommon(m, name2, args2, receiver2, numArgs, closure, hasClosure, callType, result2, callInstr.isPotentiallyRefined());
    }

    private void compileCallCommon(IRBytecodeAdapter m, String name2, Operand[] args2, Operand receiver2, int numArgs, Operand closure, boolean hasClosure, CallType callType, Variable result2, boolean isPotentiallyRefined) {
        m.loadContext();
        m.loadSelf();
        this.visit(receiver2);
        int arity2 = numArgs;
        if (numArgs == 1 && args2[0] instanceof Splat) {
            this.visit(args2[0]);
            m.adapter.invokevirtual(CodegenUtils.p(RubyArray.class), "toJavaArray", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
            arity2 = -1;
        } else {
            if (CallBase.containsArgSplat(args2)) {
                throw new NotCompilableException("splat in non-initial argument for normal call is unsupported in JIT");
            }
            for (Operand operand : args2) {
                this.visit(operand);
            }
        }
        if (hasClosure) {
            m.loadContext();
            this.visit(closure);
            m.invokeIRHelper("getBlockFromObject", CodegenUtils.sig(Block.class, ThreadContext.class, Object.class));
        }
        switch (callType) {
            case FUNCTIONAL: {
                m.invokeSelf(name2, arity2, hasClosure, CallType.FUNCTIONAL, isPotentiallyRefined);
                break;
            }
            case VARIABLE: {
                m.invokeSelf(name2, arity2, hasClosure, CallType.VARIABLE, isPotentiallyRefined);
                break;
            }
            case NORMAL: {
                m.invokeOther(name2, arity2, hasClosure, isPotentiallyRefined);
            }
        }
        if (result2 != null) {
            this.jvmStoreLocal(result2);
        } else {
            m.adapter.pop();
        }
    }

    @Override
    public void CheckArgsArrayArityInstr(CheckArgsArrayArityInstr checkargsarrayarityinstr) {
        this.jvmMethod().loadContext();
        this.visit(checkargsarrayarityinstr.getArgsArray());
        this.jvmAdapter().pushInt(checkargsarrayarityinstr.required);
        this.jvmAdapter().pushInt(checkargsarrayarityinstr.opt);
        this.jvmAdapter().pushBoolean(checkargsarrayarityinstr.rest);
        this.jvmMethod().invokeStatic(Type.getType(Helpers.class), Method.getMethod("void irCheckArgsArrayArity(org.jruby.runtime.ThreadContext, org.jruby.RubyArray, int, int, boolean)"));
    }

    @Override
    public void CheckArityInstr(CheckArityInstr checkarityinstr) {
        if (this.jvm.methodData().specificArity < 0) {
            this.jvmMethod().loadContext();
            this.jvmMethod().loadArgs();
            this.jvmAdapter().ldc(checkarityinstr.required);
            this.jvmAdapter().ldc(checkarityinstr.opt);
            this.jvmAdapter().ldc(checkarityinstr.rest);
            this.jvmAdapter().ldc(checkarityinstr.receivesKeywords);
            this.jvmAdapter().ldc(checkarityinstr.restKey);
            this.jvmMethod().loadBlockType();
            this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "checkArity", CodegenUtils.sig(Void.TYPE, ThreadContext.class, Object[].class, Integer.TYPE, Integer.TYPE, java.lang.Boolean.TYPE, java.lang.Boolean.TYPE, Integer.TYPE, Block.Type.class));
        }
    }

    @Override
    public void CheckForLJEInstr(CheckForLJEInstr checkForljeinstr) {
        this.jvmMethod().loadContext();
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.jvmAdapter().ldc(checkForljeinstr.maybeLambda());
        this.jvmMethod().loadBlockType();
        this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "checkForLJE", CodegenUtils.sig(Void.TYPE, ThreadContext.class, DynamicScope.class, java.lang.Boolean.TYPE, Block.Type.class));
    }

    @Override
    public void ClassSuperInstr(ClassSuperInstr classsuperinstr) {
        String name2 = classsuperinstr.getName();
        Operand[] args2 = classsuperinstr.getCallArgs();
        Operand definingModule = classsuperinstr.getDefiningModule();
        boolean containsArgSplat = classsuperinstr.containsArgSplat();
        Operand closure = classsuperinstr.getClosureArg(null);
        this.superCommon(name2, classsuperinstr, args2, definingModule, containsArgSplat, closure);
    }

    @Override
    public void ConstMissingInstr(ConstMissingInstr constmissinginstr) {
        this.visit(constmissinginstr.getReceiver());
        this.jvmAdapter().checkcast("org/jruby/RubyModule");
        this.jvmMethod().loadContext();
        this.jvmAdapter().ldc("const_missing");
        this.jvmMethod().pushSymbol(constmissinginstr.getMissingConst(), USASCIIEncoding.INSTANCE);
        this.jvmMethod().invokeVirtual(Type.getType(RubyModule.class), Method.getMethod("org.jruby.runtime.builtin.IRubyObject callMethod(org.jruby.runtime.ThreadContext, java.lang.String, org.jruby.runtime.builtin.IRubyObject)"));
        this.jvmStoreLocal(constmissinginstr.getResult());
    }

    @Override
    public void CopyInstr(CopyInstr copyinstr) {
        Operand src = copyinstr.getSource();
        Variable res = copyinstr.getResult();
        if (res instanceof TemporaryFloatVariable) {
            this.loadFloatArg(src);
        } else if (res instanceof TemporaryFixnumVariable) {
            this.loadFixnumArg(src);
        } else {
            this.visit(src);
        }
        this.jvmStoreLocal(res);
    }

    @Override
    public void DefineClassInstr(DefineClassInstr defineclassinstr) {
        IRClassBody newIRClassBody = defineclassinstr.getNewIRClassBody();
        this.jvmMethod().loadContext();
        Handle handle = this.emitModuleBody(newIRClassBody);
        this.jvmMethod().pushHandle(handle);
        this.jvmAdapter().getstatic(this.jvm.clsData().clsName, handle.getName() + "_IRScope", CodegenUtils.ci(IRScope.class));
        this.visit(defineclassinstr.getContainer());
        this.visit(defineclassinstr.getSuperClass());
        this.jvmMethod().invokeIRHelper("newCompiledClassBody", CodegenUtils.sig(DynamicMethod.class, ThreadContext.class, MethodHandle.class, IRScope.class, Object.class, Object.class));
        this.jvmStoreLocal(defineclassinstr.getResult());
    }

    @Override
    public void DefineClassMethodInstr(DefineClassMethodInstr defineclassmethodinstr) {
        IRMethod method = defineclassmethodinstr.getMethod();
        this.jvmMethod().loadContext();
        JVMVisitorMethodContext context = new JVMVisitorMethodContext();
        this.emitMethod(method, context);
        Map<Integer, MethodType> signatures = context.getNativeSignatures();
        MethodType signature = signatures.get(-1);
        String defSignature = this.pushHandlesForDef(context.getJittedName(), signatures, signature, CodegenUtils.sig(Void.TYPE, ThreadContext.class, MethodHandle.class, IRScope.class, IRubyObject.class), CodegenUtils.sig(Void.TYPE, ThreadContext.class, MethodHandle.class, MethodHandle.class, Integer.TYPE, IRScope.class, IRubyObject.class));
        this.jvmAdapter().getstatic(this.jvm.clsData().clsName, context.getJittedName() + "_IRScope", CodegenUtils.ci(IRScope.class));
        this.visit(defineclassmethodinstr.getContainer());
        this.jvmMethod().adapter.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "defCompiledClassMethod", defSignature);
    }

    @Override
    public void DefineInstanceMethodInstr(DefineInstanceMethodInstr defineinstancemethodinstr) {
        IRMethod method = defineinstancemethodinstr.getMethod();
        JVMVisitorMethodContext context = new JVMVisitorMethodContext();
        IRBytecodeAdapter m = this.jvmMethod();
        SkinnyMethodAdapter a = m.adapter;
        m.loadContext();
        this.emitMethod(method, context);
        Map<Integer, MethodType> signatures = context.getNativeSignatures();
        MethodType variable = signatures.get(-1);
        String defSignature = this.pushHandlesForDef(context.getJittedName(), signatures, variable, CodegenUtils.sig(Void.TYPE, ThreadContext.class, MethodHandle.class, IRScope.class, DynamicScope.class, IRubyObject.class), CodegenUtils.sig(Void.TYPE, ThreadContext.class, MethodHandle.class, MethodHandle.class, Integer.TYPE, IRScope.class, DynamicScope.class, IRubyObject.class));
        a.getstatic(this.jvm.clsData().clsName, context.getJittedName() + "_IRScope", CodegenUtils.ci(IRScope.class));
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.jvmMethod().loadSelf();
        a.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "defCompiledInstanceMethod", defSignature);
    }

    public String pushHandlesForDef(String name2, Map<Integer, MethodType> signatures, MethodType variable, String variableOnly, String variableAndSpecific) {
        String defSignature;
        this.jvmMethod().pushHandle(new Handle(6, this.jvm.clsData().clsName, name2, CodegenUtils.sig((Class)variable.returnType(), variable.parameterArray())));
        if (signatures.size() == 1) {
            defSignature = variableOnly;
        } else {
            defSignature = variableAndSpecific;
            for (Map.Entry<Integer, MethodType> entry : signatures.entrySet()) {
                if (entry.getKey() == -1) continue;
                this.jvmMethod().pushHandle(new Handle(6, this.jvm.clsData().clsName, name2, CodegenUtils.sig((Class)entry.getValue().returnType(), entry.getValue().parameterArray())));
                this.jvmAdapter().pushInt(entry.getKey());
                break;
            }
        }
        return defSignature;
    }

    @Override
    public void DefineMetaClassInstr(DefineMetaClassInstr definemetaclassinstr) {
        IRModuleBody metaClassBody = definemetaclassinstr.getMetaClassBody();
        this.jvmMethod().loadContext();
        Handle handle = this.emitModuleBody(metaClassBody);
        this.jvmMethod().pushHandle(handle);
        this.jvmAdapter().getstatic(this.jvm.clsData().clsName, handle.getName() + "_IRScope", CodegenUtils.ci(IRScope.class));
        this.visit(definemetaclassinstr.getObject());
        this.jvmMethod().invokeIRHelper("newCompiledMetaClass", CodegenUtils.sig(DynamicMethod.class, ThreadContext.class, MethodHandle.class, IRScope.class, IRubyObject.class));
        this.jvmStoreLocal(definemetaclassinstr.getResult());
    }

    @Override
    public void DefineModuleInstr(DefineModuleInstr definemoduleinstr) {
        IRModuleBody newIRModuleBody = definemoduleinstr.getNewIRModuleBody();
        this.jvmMethod().loadContext();
        Handle handle = this.emitModuleBody(newIRModuleBody);
        this.jvmMethod().pushHandle(handle);
        this.jvmAdapter().getstatic(this.jvm.clsData().clsName, handle.getName() + "_IRScope", CodegenUtils.ci(IRScope.class));
        this.visit(definemoduleinstr.getContainer());
        this.jvmMethod().invokeIRHelper("newCompiledModuleBody", CodegenUtils.sig(DynamicMethod.class, ThreadContext.class, MethodHandle.class, IRScope.class, Object.class));
        this.jvmStoreLocal(definemoduleinstr.getResult());
    }

    @Override
    public void EQQInstr(EQQInstr eqqinstr) {
        this.jvmMethod().loadContext();
        this.visit(eqqinstr.getArg1());
        this.visit(eqqinstr.getArg2());
        this.jvmMethod().invokeIRHelper("isEQQ", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class));
        this.jvmStoreLocal(eqqinstr.getResult());
    }

    @Override
    public void ExceptionRegionEndMarkerInstr(ExceptionRegionEndMarkerInstr exceptionregionendmarkerinstr) {
        throw new NotCompilableException("Marker instructions shouldn't reach compiler: " + exceptionregionendmarkerinstr);
    }

    @Override
    public void ExceptionRegionStartMarkerInstr(ExceptionRegionStartMarkerInstr exceptionregionstartmarkerinstr) {
        throw new NotCompilableException("Marker instructions shouldn't reach compiler: " + exceptionregionstartmarkerinstr);
    }

    @Override
    public void GetClassVarContainerModuleInstr(GetClassVarContainerModuleInstr getclassvarcontainermoduleinstr) {
        this.jvmMethod().loadContext();
        this.visit(getclassvarcontainermoduleinstr.getStartingScope());
        if (getclassvarcontainermoduleinstr.getObject() != null) {
            this.visit(getclassvarcontainermoduleinstr.getObject());
        } else {
            this.jvmAdapter().aconst_null();
        }
        this.jvmMethod().invokeIRHelper("getModuleFromScope", CodegenUtils.sig(RubyModule.class, ThreadContext.class, StaticScope.class, IRubyObject.class));
        this.jvmStoreLocal(getclassvarcontainermoduleinstr.getResult());
    }

    @Override
    public void GetClassVariableInstr(GetClassVariableInstr getclassvariableinstr) {
        this.visit(getclassvariableinstr.getSource());
        this.jvmAdapter().checkcast(CodegenUtils.p(RubyModule.class));
        this.jvmAdapter().ldc(getclassvariableinstr.getRef());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(RubyModule.class), "getClassVar", CodegenUtils.sig(IRubyObject.class, String.class));
        this.jvmStoreLocal(getclassvariableinstr.getResult());
    }

    @Override
    public void GetFieldInstr(GetFieldInstr getfieldinstr) {
        this.visit(getfieldinstr.getSource());
        this.jvmMethod().getField(getfieldinstr.getRef());
        this.jvmStoreLocal(getfieldinstr.getResult());
    }

    @Override
    public void GetGlobalVariableInstr(GetGlobalVariableInstr getglobalvariableinstr) {
        this.jvmMethod().getGlobalVariable(getglobalvariableinstr.getTarget().getName());
        this.jvmStoreLocal(getglobalvariableinstr.getResult());
    }

    @Override
    public void GVarAliasInstr(GVarAliasInstr gvaraliasinstr) {
        this.jvmMethod().loadRuntime();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Ruby.class), "getGlobalVariables", CodegenUtils.sig(GlobalVariables.class, new Class[0]));
        this.visit(gvaraliasinstr.getNewName());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Object.class), "toString", CodegenUtils.sig(String.class, new Class[0]));
        this.visit(gvaraliasinstr.getOldName());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Object.class), "toString", CodegenUtils.sig(String.class, new Class[0]));
        this.jvmAdapter().invokevirtual(CodegenUtils.p(GlobalVariables.class), "alias", CodegenUtils.sig(Void.TYPE, String.class, String.class));
    }

    @Override
    public void InheritanceSearchConstInstr(InheritanceSearchConstInstr inheritancesearchconstinstr) {
        this.jvmMethod().loadContext();
        this.visit(inheritancesearchconstinstr.getCurrentModule());
        this.jvmMethod().inheritanceSearchConst(inheritancesearchconstinstr.getConstName(), inheritancesearchconstinstr.isNoPrivateConsts());
        this.jvmStoreLocal(inheritancesearchconstinstr.getResult());
    }

    @Override
    public void InstanceSuperInstr(InstanceSuperInstr instancesuperinstr) {
        String name2 = instancesuperinstr.getName();
        Operand[] args2 = instancesuperinstr.getCallArgs();
        Operand definingModule = instancesuperinstr.getDefiningModule();
        boolean containsArgSplat = instancesuperinstr.containsArgSplat();
        Operand closure = instancesuperinstr.getClosureArg(null);
        this.superCommon(name2, instancesuperinstr, args2, definingModule, containsArgSplat, closure);
    }

    private void superCommon(String name2, CallInstr instr, Operand[] args2, Operand definingModule, boolean containsArgSplat, Operand closure) {
        boolean hasClosure;
        IRBytecodeAdapter m = this.jvmMethod();
        Operation operation = instr.getOperation();
        m.loadContext();
        m.loadSelf();
        m.loadSelf();
        if (definingModule == UndefinedValue.UNDEFINED) {
            this.jvmAdapter().aconst_null();
        } else {
            this.visit(definingModule);
        }
        this.jvmAdapter().checkcast(CodegenUtils.p(RubyClass.class));
        for (int i2 = 0; i2 < args2.length; ++i2) {
            Operand operand = args2[i2];
            this.visit(operand);
        }
        boolean[] splatMap = IRRuntimeHelpers.buildSplatMap(args2, containsArgSplat);
        boolean bl = hasClosure = closure != null;
        if (hasClosure) {
            m.loadContext();
            this.visit(closure);
            m.invokeIRHelper("getBlockFromObject", CodegenUtils.sig(Block.class, ThreadContext.class, Object.class));
        }
        switch (operation) {
            case INSTANCE_SUPER: {
                m.invokeInstanceSuper(name2, args2.length, hasClosure, splatMap);
                break;
            }
            case CLASS_SUPER: {
                m.invokeClassSuper(name2, args2.length, hasClosure, splatMap);
                break;
            }
            case UNRESOLVED_SUPER: {
                m.invokeUnresolvedSuper(name2, args2.length, hasClosure, splatMap);
                break;
            }
            case ZSUPER: {
                m.invokeZSuper(name2, args2.length, hasClosure, splatMap);
                break;
            }
            default: {
                throw new NotCompilableException("unknown super type " + (Object)((Object)operation) + " in " + instr);
            }
        }
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void JumpInstr(JumpInstr jumpinstr) {
        this.jvmMethod().goTo(this.getJVMLabel(jumpinstr.getJumpTarget()));
    }

    @Override
    public void LabelInstr(LabelInstr labelinstr) {
    }

    @Override
    public void LexicalSearchConstInstr(LexicalSearchConstInstr lexicalsearchconstinstr) {
        this.jvmMethod().loadContext();
        this.visit(lexicalsearchconstinstr.getDefiningScope());
        this.jvmMethod().lexicalSearchConst(lexicalsearchconstinstr.getConstName());
        this.jvmStoreLocal(lexicalsearchconstinstr.getResult());
    }

    @Override
    public void LineNumberInstr(LineNumberInstr linenumberinstr) {
        this.jvmAdapter().line(linenumberinstr.getLineNumber() + 1);
    }

    @Override
    public void LoadLocalVarInstr(LoadLocalVarInstr loadlocalvarinstr) {
        IRBytecodeAdapter m = this.jvmMethod();
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        int depth = loadlocalvarinstr.getLocalVar().getScopeDepth();
        int location = loadlocalvarinstr.getLocalVar().getLocation();
        block0 : switch (depth) {
            case 0: {
                switch (location) {
                    case 0: {
                        m.pushNil();
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueZeroDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        break block0;
                    }
                    case 1: {
                        m.pushNil();
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueOneDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        break block0;
                    }
                    case 2: {
                        m.pushNil();
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueTwoDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        break block0;
                    }
                    case 3: {
                        m.pushNil();
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueThreeDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        break block0;
                    }
                }
                m.adapter.pushInt(location);
                m.pushNil();
                m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, Integer.TYPE, IRubyObject.class));
                break;
            }
            default: {
                m.adapter.pushInt(location);
                m.adapter.pushInt(depth);
                m.pushNil();
                m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueOrNil", CodegenUtils.sig(IRubyObject.class, Integer.TYPE, Integer.TYPE, IRubyObject.class));
            }
        }
        this.jvmStoreLocal(loadlocalvarinstr.getResult());
    }

    @Override
    public void LoadImplicitClosure(LoadImplicitClosureInstr loadimplicitclosureinstr) {
        this.jvmMethod().loadBlock();
        this.jvmStoreLocal(loadimplicitclosureinstr.getResult());
    }

    @Override
    public void LoadFrameClosure(LoadFrameClosureInstr loadframeclosureinstr) {
        this.jvmMethod().loadContext();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "getFrameBlock", CodegenUtils.sig(Block.class, new Class[0]));
        this.jvmStoreLocal(loadframeclosureinstr.getResult());
    }

    @Override
    public void MatchInstr(MatchInstr matchInstr) {
        this.compileCallCommon(this.jvmMethod(), "=~", matchInstr.getCallArgs(), matchInstr.getReceiver(), 1, null, false, CallType.NORMAL, matchInstr.getResult(), false);
    }

    @Override
    public void ModuleVersionGuardInstr(ModuleVersionGuardInstr moduleversionguardinstr) {
        throw new NotCompilableException("Unsupported instruction: " + moduleversionguardinstr);
    }

    @Override
    public void NopInstr(NopInstr nopinstr) {
    }

    @Override
    public void NoResultCallInstr(NoResultCallInstr noResultCallInstr) {
        IRBytecodeAdapter m = this.jvmMethod();
        String name2 = noResultCallInstr.getName();
        Operand[] args2 = noResultCallInstr.getCallArgs();
        Operand receiver2 = noResultCallInstr.getReceiver();
        int numArgs = args2.length;
        Operand closure = noResultCallInstr.getClosureArg(null);
        boolean hasClosure = closure != null;
        CallType callType = noResultCallInstr.getCallType();
        this.compileCallCommon(m, name2, args2, receiver2, numArgs, closure, hasClosure, callType, null, noResultCallInstr.isPotentiallyRefined());
    }

    @Override
    public void OneFixnumArgNoBlockCallInstr(OneFixnumArgNoBlockCallInstr oneFixnumArgNoBlockCallInstr) {
        if (MethodIndex.getFastFixnumOpsMethod(oneFixnumArgNoBlockCallInstr.getName()) == null) {
            this.CallInstr(oneFixnumArgNoBlockCallInstr);
            return;
        }
        IRBytecodeAdapter m = this.jvmMethod();
        String name2 = oneFixnumArgNoBlockCallInstr.getName();
        long fixnum = oneFixnumArgNoBlockCallInstr.getFixnumArg();
        Operand receiver2 = oneFixnumArgNoBlockCallInstr.getReceiver();
        Variable result2 = oneFixnumArgNoBlockCallInstr.getResult();
        m.loadContext();
        m.loadSelf();
        this.visit(receiver2);
        m.invokeOtherOneFixnum(name2, fixnum);
        if (result2 != null) {
            this.jvmStoreLocal(result2);
        } else {
            m.adapter.pop();
        }
    }

    @Override
    public void OneFloatArgNoBlockCallInstr(OneFloatArgNoBlockCallInstr oneFloatArgNoBlockCallInstr) {
        if (MethodIndex.getFastFloatOpsMethod(oneFloatArgNoBlockCallInstr.getName()) == null) {
            this.CallInstr(oneFloatArgNoBlockCallInstr);
            return;
        }
        IRBytecodeAdapter m = this.jvmMethod();
        String name2 = oneFloatArgNoBlockCallInstr.getName();
        double flote = oneFloatArgNoBlockCallInstr.getFloatArg();
        Operand receiver2 = oneFloatArgNoBlockCallInstr.getReceiver();
        Variable result2 = oneFloatArgNoBlockCallInstr.getResult();
        m.loadContext();
        m.loadSelf();
        this.visit(receiver2);
        m.invokeOtherOneFloat(name2, flote);
        if (result2 != null) {
            this.jvmStoreLocal(result2);
        } else {
            m.adapter.pop();
        }
    }

    @Override
    public void OneOperandArgNoBlockCallInstr(OneOperandArgNoBlockCallInstr oneOperandArgNoBlockCallInstr) {
        this.CallInstr(oneOperandArgNoBlockCallInstr);
    }

    @Override
    public void OptArgMultipleAsgnInstr(OptArgMultipleAsgnInstr optargmultipleasgninstr) {
        this.visit(optargmultipleasgninstr.getArray());
        this.jvmAdapter().checkcast(CodegenUtils.p(RubyArray.class));
        this.jvmAdapter().ldc(optargmultipleasgninstr.getMinArgsLength());
        this.jvmAdapter().ldc(optargmultipleasgninstr.getIndex());
        this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "extractOptionalArgument", CodegenUtils.sig(IRubyObject.class, RubyArray.class, Integer.TYPE, Integer.TYPE));
        this.jvmStoreLocal(optargmultipleasgninstr.getResult());
    }

    @Override
    public void PopBindingInstr(PopBindingInstr popbindinginstr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().invokeVirtual(Type.getType(ThreadContext.class), Method.getMethod("void popScope()"));
    }

    @Override
    public void PopFrameInstr(PopFrameInstr popframeinstr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().invokeVirtual(Type.getType(ThreadContext.class), Method.getMethod("void postMethodFrameOnly()"));
    }

    @Override
    public void ProcessModuleBodyInstr(ProcessModuleBodyInstr processmodulebodyinstr) {
        this.jvmMethod().loadContext();
        this.visit(processmodulebodyinstr.getModuleBody());
        this.visit(processmodulebodyinstr.getBlock());
        this.jvmMethod().invokeIRHelper("invokeModuleBody", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, DynamicMethod.class, Block.class));
        this.jvmStoreLocal(processmodulebodyinstr.getResult());
    }

    @Override
    public void PushBindingInstr(PushBindingInstr pushbindinginstr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadStaticScope();
        this.jvmAdapter().invokestatic(CodegenUtils.p(DynamicScope.class), "newDynamicScope", CodegenUtils.sig(DynamicScope.class, StaticScope.class));
        this.jvmAdapter().dup();
        this.jvmStoreLocal(DYNAMIC_SCOPE);
        this.jvmMethod().invokeVirtual(Type.getType(ThreadContext.class), Method.getMethod("void pushScope(org.jruby.runtime.DynamicScope)"));
    }

    @Override
    public void RaiseRequiredKeywordArgumentErrorInstr(RaiseRequiredKeywordArgumentError instr) {
        this.jvmMethod().loadContext();
        this.jvmAdapter().ldc(instr.getName());
        this.jvmMethod().invokeIRHelper("newRequiredKeywordArgumentError", CodegenUtils.sig(RaiseException.class, ThreadContext.class, String.class));
        this.jvmAdapter().athrow();
    }

    @Override
    public void PushFrameInstr(PushFrameInstr pushframeinstr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadFrameClass();
        this.jvmMethod().loadFrameName();
        this.jvmMethod().loadSelf();
        this.jvmMethod().loadBlock();
        this.jvmMethod().invokeVirtual(Type.getType(ThreadContext.class), Method.getMethod("void preMethodFrameOnly(org.jruby.RubyModule, String, org.jruby.runtime.builtin.IRubyObject, org.jruby.runtime.Block)"));
        this.jvmMethod().loadContext();
        this.jvmAdapter().getstatic(CodegenUtils.p(Visibility.class), "PUBLIC", CodegenUtils.ci(Visibility.class));
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "setCurrentVisibility", CodegenUtils.sig(Void.TYPE, Visibility.class));
    }

    @Override
    public void PutClassVariableInstr(PutClassVariableInstr putclassvariableinstr) {
        this.visit(putclassvariableinstr.getValue());
        this.visit(putclassvariableinstr.getTarget());
        if (putclassvariableinstr.getValue() instanceof CurrentScope) {
            this.jvmAdapter().pop2();
            return;
        }
        this.jvmAdapter().checkcast(CodegenUtils.p(RubyModule.class));
        this.jvmAdapter().swap();
        this.jvmAdapter().ldc(putclassvariableinstr.getRef());
        this.jvmAdapter().swap();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(RubyModule.class), "setClassVar", CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject.class));
        this.jvmAdapter().pop();
    }

    @Override
    public void PutConstInstr(PutConstInstr putconstinstr) {
        IRBytecodeAdapter m = this.jvmMethod();
        this.visit(putconstinstr.getTarget());
        m.adapter.checkcast(CodegenUtils.p(RubyModule.class));
        m.adapter.ldc(putconstinstr.getRef());
        this.visit(putconstinstr.getValue());
        m.adapter.invokevirtual(CodegenUtils.p(RubyModule.class), "setConstant", CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject.class));
        m.adapter.pop();
    }

    @Override
    public void PutFieldInstr(PutFieldInstr putfieldinstr) {
        this.visit(putfieldinstr.getTarget());
        this.visit(putfieldinstr.getValue());
        this.jvmMethod().putField(putfieldinstr.getRef());
    }

    @Override
    public void PutGlobalVarInstr(PutGlobalVarInstr putglobalvarinstr) {
        this.visit(putglobalvarinstr.getValue());
        this.jvmMethod().setGlobalVariable(putglobalvarinstr.getTarget().getName());
        this.jvmAdapter().pop();
    }

    @Override
    public void ReifyClosureInstr(ReifyClosureInstr reifyclosureinstr) {
        this.jvmMethod().loadRuntime();
        this.jvmLoadLocal("$block");
        this.jvmMethod().invokeIRHelper("newProc", CodegenUtils.sig(IRubyObject.class, Ruby.class, Block.class));
        this.jvmStoreLocal(reifyclosureinstr.getResult());
    }

    @Override
    public void ReceiveRubyExceptionInstr(ReceiveRubyExceptionInstr receiveexceptioninstr) {
        this.jvmStoreLocal(receiveexceptioninstr.getResult());
    }

    @Override
    public void ReceiveJRubyExceptionInstr(ReceiveJRubyExceptionInstr receiveexceptioninstr) {
        this.jvmStoreLocal(receiveexceptioninstr.getResult());
    }

    @Override
    public void ReceiveKeywordArgInstr(ReceiveKeywordArgInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadArgs();
        this.jvmAdapter().pushInt(instr.required);
        this.jvmAdapter().ldc(instr.argName);
        this.jvmAdapter().ldc(this.jvm.methodData().scope.receivesKeywordArgs());
        this.jvmMethod().invokeIRHelper("receiveKeywordArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject[].class, Integer.TYPE, String.class, java.lang.Boolean.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ReceiveKeywordRestArgInstr(ReceiveKeywordRestArgInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadArgs();
        this.jvmAdapter().pushInt(instr.required);
        this.jvmAdapter().ldc(this.jvm.methodData().scope.receivesKeywordArgs());
        this.jvmMethod().invokeIRHelper("receiveKeywordRestArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject[].class, Integer.TYPE, java.lang.Boolean.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ReceiveOptArgInstr(ReceiveOptArgInstr instr) {
        this.jvmMethod().loadArgs();
        this.jvmAdapter().pushInt(instr.requiredArgs);
        this.jvmAdapter().pushInt(instr.preArgs);
        this.jvmAdapter().pushInt(instr.getArgIndex());
        this.jvmAdapter().ldc(this.jvm.methodData().scope.receivesKeywordArgs());
        this.jvmMethod().invokeIRHelper("receiveOptArg", CodegenUtils.sig(IRubyObject.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, java.lang.Boolean.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ReceivePreReqdArgInstr(ReceivePreReqdArgInstr instr) {
        if (this.jvm.methodData().specificArity >= 0 && instr.getArgIndex() < this.jvm.methodData().specificArity) {
            this.jvmAdapter().aload(this.jvm.methodData().signature.argOffset("arg" + instr.getArgIndex()));
        } else {
            this.jvmMethod().loadContext();
            this.jvmMethod().loadArgs();
            this.jvmAdapter().pushInt(instr.getArgIndex());
            this.jvmMethod().invokeIRHelper("getPreArgSafe", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject[].class, Integer.TYPE));
        }
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ReceivePostReqdArgInstr(ReceivePostReqdArgInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadArgs();
        this.jvmAdapter().pushInt(instr.preReqdArgsCount);
        this.jvmAdapter().pushInt(instr.postReqdArgsCount);
        this.jvmAdapter().pushInt(instr.getArgIndex());
        this.jvmAdapter().ldc(this.jvm.methodData().scope.receivesKeywordArgs());
        this.jvmMethod().invokeIRHelper("receivePostReqdArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, java.lang.Boolean.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ReceiveRestArgInstr(ReceiveRestArgInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadArgs();
        this.jvmAdapter().pushInt(instr.required);
        this.jvmAdapter().pushInt(instr.getArgIndex());
        this.jvmAdapter().ldc(this.jvm.methodData().scope.receivesKeywordArgs());
        this.jvmMethod().invokeIRHelper("receiveRestArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Object[].class, Integer.TYPE, Integer.TYPE, java.lang.Boolean.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ReceiveSelfInstr(ReceiveSelfInstr receiveselfinstr) {
    }

    @Override
    public void RecordEndBlockInstr(RecordEndBlockInstr recordEndBlockInstr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadContext();
        this.visit(recordEndBlockInstr.getEndBlockClosure());
        this.jvmMethod().invokeIRHelper("getBlockFromObject", CodegenUtils.sig(Block.class, ThreadContext.class, Object.class));
        this.jvmMethod().invokeIRHelper("pushExitBlock", CodegenUtils.sig(Void.TYPE, ThreadContext.class, Block.class));
    }

    @Override
    public void ReqdArgMultipleAsgnInstr(ReqdArgMultipleAsgnInstr reqdargmultipleasgninstr) {
        this.jvmMethod().loadContext();
        this.visit(reqdargmultipleasgninstr.getArray());
        this.jvmAdapter().checkcast(CodegenUtils.p(RubyArray.class));
        this.jvmAdapter().pushInt(reqdargmultipleasgninstr.getPreArgsCount());
        this.jvmAdapter().pushInt(reqdargmultipleasgninstr.getIndex());
        this.jvmAdapter().pushInt(reqdargmultipleasgninstr.getPostArgsCount());
        this.jvmMethod().invokeIRHelper("irReqdArgMultipleAsgn", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, RubyArray.class, Integer.TYPE, Integer.TYPE, Integer.TYPE));
        this.jvmStoreLocal(reqdargmultipleasgninstr.getResult());
    }

    @Override
    public void RescueEQQInstr(RescueEQQInstr rescueeqqinstr) {
        this.jvmMethod().loadContext();
        this.visit(rescueeqqinstr.getArg1());
        this.visit(rescueeqqinstr.getArg2());
        this.jvmMethod().invokeIRHelper("isExceptionHandled", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, Object.class));
        this.jvmStoreLocal(rescueeqqinstr.getResult());
    }

    @Override
    public void RestArgMultipleAsgnInstr(RestArgMultipleAsgnInstr restargmultipleasgninstr) {
        this.jvmMethod().loadContext();
        this.visit(restargmultipleasgninstr.getArray());
        this.jvmAdapter().checkcast(CodegenUtils.p(RubyArray.class));
        this.jvmAdapter().pushInt(restargmultipleasgninstr.getPreArgsCount());
        this.jvmAdapter().pushInt(restargmultipleasgninstr.getPostArgsCount());
        this.jvmAdapter().invokestatic(CodegenUtils.p(Helpers.class), "viewArgsArray", CodegenUtils.sig(RubyArray.class, ThreadContext.class, RubyArray.class, Integer.TYPE, Integer.TYPE));
        this.jvmStoreLocal(restargmultipleasgninstr.getResult());
    }

    @Override
    public void RuntimeHelperCall(RuntimeHelperCall runtimehelpercall) {
        switch (runtimehelpercall.getHelperMethod()) {
            case HANDLE_PROPAGATE_BREAK: {
                this.jvmMethod().loadContext();
                this.jvmLoadLocal(DYNAMIC_SCOPE);
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmMethod().loadBlockType();
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "handlePropagatedBreak", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, DynamicScope.class, Object.class, Block.Type.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case HANDLE_NONLOCAL_RETURN: {
                this.jvmMethod().loadStaticScope();
                this.jvmLoadLocal(DYNAMIC_SCOPE);
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmMethod().loadBlockType();
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "handleNonlocalReturn", CodegenUtils.sig(IRubyObject.class, StaticScope.class, DynamicScope.class, Object.class, Block.Type.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case HANDLE_BREAK_AND_RETURNS_IN_LAMBDA: {
                this.jvmMethod().loadContext();
                this.jvmMethod().loadStaticScope();
                this.jvmLoadLocal(DYNAMIC_SCOPE);
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmMethod().loadBlockType();
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "handleBreakAndReturnsInLambdas", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, StaticScope.class, DynamicScope.class, Object.class, Block.Type.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_BACKREF: {
                this.jvmMethod().loadContext();
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedBackref", CodegenUtils.sig(IRubyObject.class, ThreadContext.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_CALL: {
                this.jvmMethod().loadContext();
                this.jvmMethod().loadSelf();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().ldc(((StringLiteral)runtimehelpercall.getArgs()[1]).getString());
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedCall", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_CONSTANT_OR_METHOD: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().ldc(((StringLiteral)runtimehelpercall.getArgs()[1]).getString());
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedConstantOrMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, String.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_NTH_REF: {
                this.jvmMethod().loadContext();
                this.jvmAdapter().ldc((int)((Fixnum)runtimehelpercall.getArgs()[0]).getValue());
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedNthRef", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Integer.TYPE));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_GLOBAL: {
                this.jvmMethod().loadContext();
                this.jvmAdapter().ldc(((StringLiteral)runtimehelpercall.getArgs()[0]).getString());
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedGlobal", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, String.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_INSTANCE_VAR: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().ldc(((StringLiteral)runtimehelpercall.getArgs()[1]).getString());
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedInstanceVar", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, String.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_CLASS_VAR: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().checkcast(CodegenUtils.p(RubyModule.class));
                this.jvmAdapter().ldc(((StringLiteral)runtimehelpercall.getArgs()[1]).getString());
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedClassVar", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, RubyModule.class, String.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_SUPER: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().ldc(((StringLiteral)runtimehelpercall.getArgs()[1]).getString());
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedSuper", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, String.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_METHOD: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().ldc(((StringLiteral)runtimehelpercall.getArgs()[1]).getString());
                this.jvmAdapter().ldc(((Boolean)runtimehelpercall.getArgs()[2]).isTrue());
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, String.class, java.lang.Boolean.TYPE));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case MERGE_KWARGS: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.visit(runtimehelpercall.getArgs()[1]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "mergeKeywordArguments", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case RESTORE_EXCEPTION_VAR: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.visit(runtimehelpercall.getArgs()[1]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "restoreExceptionVar", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            default: {
                throw new NotCompilableException("Unknown IR runtime helper method: " + (Object)((Object)runtimehelpercall.getHelperMethod()) + "; INSTR: " + this);
            }
        }
    }

    @Override
    public void ToggleBacktraceInstr(ToggleBacktraceInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmAdapter().pushBoolean(instr.requiresBacktrace());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "setExceptionRequiresBacktrace", CodegenUtils.sig(Void.TYPE, java.lang.Boolean.TYPE));
    }

    @Override
    public void NonlocalReturnInstr(NonlocalReturnInstr returninstr) {
        this.jvmMethod().loadContext();
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.jvmMethod().loadBlockType();
        this.visit(returninstr.getReturnValue());
        this.jvmMethod().invokeIRHelper("initiateNonLocalReturn", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, DynamicScope.class, Block.Type.class, IRubyObject.class));
        this.jvmMethod().returnValue();
    }

    @Override
    public void ReturnInstr(ReturnInstr returninstr) {
        this.visit(returninstr.getReturnValue());
        this.jvmMethod().returnValue();
    }

    @Override
    public void SearchConstInstr(SearchConstInstr searchconstinstr) {
        this.jvmMethod().loadContext();
        this.visit(searchconstinstr.getStartingScope());
        this.jvmMethod().searchConst(searchconstinstr.getConstName(), searchconstinstr.isNoPrivateConsts());
        this.jvmStoreLocal(searchconstinstr.getResult());
    }

    @Override
    public void SetCapturedVarInstr(SetCapturedVarInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getMatch2Result());
        this.jvmAdapter().ldc(instr.getVarName());
        this.jvmMethod().invokeIRHelper("setCapturedVar", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, String.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void StoreLocalVarInstr(StoreLocalVarInstr storelocalvarinstr) {
        IRBytecodeAdapter m = this.jvmMethod();
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        int depth = storelocalvarinstr.getLocalVar().getScopeDepth();
        int location = storelocalvarinstr.getLocalVar().getLocation();
        Operand storeValue = storelocalvarinstr.getValue();
        switch (depth) {
            case 0: {
                switch (location) {
                    case 0: {
                        storeValue.visit(this);
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueZeroDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        m.adapter.pop();
                        return;
                    }
                    case 1: {
                        storeValue.visit(this);
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueOneDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        m.adapter.pop();
                        return;
                    }
                    case 2: {
                        storeValue.visit(this);
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueTwoDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        m.adapter.pop();
                        return;
                    }
                    case 3: {
                        storeValue.visit(this);
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueThreeDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        m.adapter.pop();
                        return;
                    }
                }
                storeValue.visit(this);
                m.adapter.pushInt(location);
                m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, Integer.TYPE));
                m.adapter.pop();
                return;
            }
        }
        m.adapter.pushInt(location);
        storeValue.visit(this);
        m.adapter.pushInt(depth);
        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValue", CodegenUtils.sig(IRubyObject.class, Integer.TYPE, IRubyObject.class, Integer.TYPE));
        m.adapter.pop();
    }

    @Override
    public void ThreadPollInstr(ThreadPollInstr threadpollinstr) {
        this.jvmMethod().checkpoint();
    }

    @Override
    public void ThrowExceptionInstr(ThrowExceptionInstr throwexceptioninstr) {
        this.visit(throwexceptioninstr.getException());
        this.jvmAdapter().athrow();
    }

    @Override
    public void ToAryInstr(ToAryInstr toaryinstr) {
        this.jvmMethod().loadContext();
        this.visit(toaryinstr.getArray());
        this.jvmMethod().invokeIRHelper("irToAry", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
        this.jvmStoreLocal(toaryinstr.getResult());
    }

    @Override
    public void UndefMethodInstr(UndefMethodInstr undefmethodinstr) {
        this.jvmMethod().loadContext();
        this.visit(undefmethodinstr.getMethodName());
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.jvmMethod().loadSelf();
        this.jvmMethod().invokeIRHelper("undefMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Object.class, DynamicScope.class, IRubyObject.class));
        this.jvmStoreLocal(undefmethodinstr.getResult());
    }

    @Override
    public void UnresolvedSuperInstr(UnresolvedSuperInstr unresolvedsuperinstr) {
        String name2 = unresolvedsuperinstr.getName();
        Operand[] args2 = unresolvedsuperinstr.getCallArgs();
        UndefinedValue definingModule = UndefinedValue.UNDEFINED;
        boolean containsArgSplat = unresolvedsuperinstr.containsArgSplat();
        Operand closure = unresolvedsuperinstr.getClosureArg(null);
        this.superCommon(name2, unresolvedsuperinstr, args2, definingModule, containsArgSplat, closure);
    }

    @Override
    public void YieldInstr(YieldInstr yieldinstr) {
        this.jvmMethod().loadContext();
        this.visit(yieldinstr.getBlockArg());
        if (yieldinstr.getYieldArg() == UndefinedValue.UNDEFINED) {
            this.jvmMethod().invokeIRHelper("yieldSpecific", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Object.class));
        } else {
            this.visit(yieldinstr.getYieldArg());
            this.jvmAdapter().ldc(yieldinstr.isUnwrapArray());
            this.jvmMethod().invokeIRHelper("yield", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Object.class, Object.class, java.lang.Boolean.TYPE));
        }
        this.jvmStoreLocal(yieldinstr.getResult());
    }

    @Override
    public void ZeroOperandArgNoBlockCallInstr(ZeroOperandArgNoBlockCallInstr zeroOperandArgNoBlockCallInstr) {
        this.CallInstr(zeroOperandArgNoBlockCallInstr);
    }

    @Override
    public void ZSuperInstr(ZSuperInstr zsuperinstr) {
        String name2 = zsuperinstr.getName();
        Operand[] args2 = zsuperinstr.getCallArgs();
        UndefinedValue definingModule = UndefinedValue.UNDEFINED;
        boolean containsArgSplat = zsuperinstr.containsArgSplat();
        Operand closure = zsuperinstr.getClosureArg(null);
        this.superCommon(name2, zsuperinstr, args2, definingModule, containsArgSplat, closure);
    }

    @Override
    public void GetErrorInfoInstr(GetErrorInfoInstr geterrorinfoinstr) {
        this.jvmMethod().loadContext();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "getErrorInfo", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        this.jvmStoreLocal(geterrorinfoinstr.getResult());
    }

    @Override
    public void RestoreErrorInfoInstr(RestoreErrorInfoInstr restoreerrorinfoinstr) {
        this.jvmMethod().loadContext();
        this.visit(restoreerrorinfoinstr.getArg());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "setErrorInfo", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
        this.jvmAdapter().pop();
    }

    @Override
    public void BuildLambdaInstr(BuildLambdaInstr buildlambdainstr) {
        this.jvmMethod().loadRuntime();
        IRClosure body = ((WrappedIRClosure)buildlambdainstr.getLambdaBody()).getClosure();
        if (body == null) {
            this.jvmMethod().pushNil();
        } else {
            this.visit(buildlambdainstr.getLambdaBody());
        }
        this.jvmAdapter().getstatic(CodegenUtils.p(Block.Type.class), "LAMBDA", CodegenUtils.ci(Block.Type.class));
        this.jvmAdapter().ldc(buildlambdainstr.getFile());
        this.jvmAdapter().pushInt(buildlambdainstr.getLine());
        this.jvmAdapter().invokestatic(CodegenUtils.p(RubyProc.class), "newProc", CodegenUtils.sig(RubyProc.class, Ruby.class, Block.class, Block.Type.class, String.class, Integer.TYPE));
        this.jvmStoreLocal(buildlambdainstr.getResult());
    }

    @Override
    public void GetEncodingInstr(GetEncodingInstr getencodinginstr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().pushEncoding(getencodinginstr.getEncoding());
        this.jvmStoreLocal(getencodinginstr.getResult());
    }

    @Override
    public void Array(Array array) {
        this.jvmMethod().loadContext();
        for (Operand operand : array.getElts()) {
            this.visit(operand);
        }
        this.jvmMethod().array(array.getElts().length);
    }

    @Override
    public void AsString(AsString asstring) {
        this.visit(asstring.getSource());
        this.jvmAdapter().invokeinterface(CodegenUtils.p(IRubyObject.class), "asString", CodegenUtils.sig(RubyString.class, new Class[0]));
    }

    @Override
    public void Backref(Backref backref) {
        this.jvmMethod().loadContext();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "getBackRef", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        switch (backref.type) {
            case '&': {
                this.jvmAdapter().invokestatic(CodegenUtils.p(RubyRegexp.class), "last_match", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            case '`': {
                this.jvmAdapter().invokestatic(CodegenUtils.p(RubyRegexp.class), "match_pre", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            case '\'': {
                this.jvmAdapter().invokestatic(CodegenUtils.p(RubyRegexp.class), "match_post", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            case '+': {
                this.jvmAdapter().invokestatic(CodegenUtils.p(RubyRegexp.class), "match_last", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                assert (false) : "backref with invalid type";
                break;
            }
        }
    }

    @Override
    public void Bignum(Bignum bignum) {
        this.jvmMethod().pushBignum(bignum.value);
    }

    @Override
    public void Boolean(Boolean booleanliteral) {
        this.jvmMethod().pushBoolean(booleanliteral.isTrue());
    }

    @Override
    public void UnboxedBoolean(UnboxedBoolean bool2) {
        this.jvmAdapter().ldc(bool2.isTrue());
    }

    @Override
    public void ClosureLocalVariable(ClosureLocalVariable closurelocalvariable) {
        this.LocalVariable(closurelocalvariable);
    }

    @Override
    public void Complex(Complex complex) {
        this.jvmMethod().loadRuntime();
        this.jvmMethod().pushFixnum(0L);
        this.visit(complex.getNumber());
        this.jvmAdapter().invokestatic(CodegenUtils.p(RubyComplex.class), "newComplexRaw", CodegenUtils.sig(RubyComplex.class, Ruby.class, IRubyObject.class, IRubyObject.class));
    }

    @Override
    public void CurrentScope(CurrentScope currentscope) {
        this.jvmMethod().loadStaticScope();
    }

    @Override
    public void DynamicSymbol(DynamicSymbol dynamicsymbol) {
        this.jvmMethod().loadRuntime();
        this.visit(dynamicsymbol.getSymbolName());
        this.jvmAdapter().dup();
        this.jvmAdapter().invokeinterface(CodegenUtils.p(IRubyObject.class), "asJavaString", CodegenUtils.sig(String.class, new Class[0]));
        this.jvmAdapter().swap();
        this.jvmAdapter().invokeinterface(CodegenUtils.p(IRubyObject.class), "asString", CodegenUtils.sig(RubyString.class, new Class[0]));
        this.jvmAdapter().invokevirtual(CodegenUtils.p(RubyString.class), "getByteList", CodegenUtils.sig(ByteList.class, new Class[0]));
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ByteList.class), "getEncoding", CodegenUtils.sig(Encoding.class, new Class[0]));
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Ruby.class), "newSymbol", CodegenUtils.sig(RubySymbol.class, String.class, Encoding.class));
    }

    @Override
    public void Filename(Filename filename2) {
        this.jvmMethod().loadRuntime();
        this.jvmMethod().loadStaticScope();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(StaticScope.class), "getIRScope", CodegenUtils.sig(IRScope.class, new Class[0]));
        this.jvmAdapter().invokevirtual(CodegenUtils.p(IRScope.class), "getFileName", CodegenUtils.sig(String.class, new Class[0]));
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Ruby.class), "newString", CodegenUtils.sig(String.class, new Class[0]));
    }

    @Override
    public void Fixnum(Fixnum fixnum) {
        this.jvmMethod().pushFixnum(fixnum.getValue());
    }

    @Override
    public void FrozenString(FrozenString frozen) {
        this.jvmMethod().pushFrozenString(frozen.getByteList(), frozen.getCodeRange());
    }

    @Override
    public void UnboxedFixnum(UnboxedFixnum fixnum) {
        this.jvmAdapter().ldc(fixnum.getValue());
    }

    @Override
    public void Float(Float flote) {
        this.jvmMethod().pushFloat(flote.getValue());
    }

    @Override
    public void UnboxedFloat(UnboxedFloat flote) {
        this.jvmAdapter().ldc(flote.getValue());
    }

    @Override
    public void Hash(Hash hash2) {
        List<KeyValuePair<Operand, Operand>> pairs = hash2.getPairs();
        Iterator<KeyValuePair<Operand, Operand>> iter2 = pairs.iterator();
        boolean kwargs = hash2.isKWArgsHash && pairs.get(0).getKey() == Symbol.KW_REST_ARG_DUMMY;
        this.jvmMethod().loadContext();
        if (kwargs) {
            this.visit(pairs.get(0).getValue());
            this.jvmAdapter().checkcast(CodegenUtils.p(RubyHash.class));
            iter2.next();
        }
        while (iter2.hasNext()) {
            KeyValuePair<Operand, Operand> pair = iter2.next();
            this.visit(pair.getKey());
            this.visit(pair.getValue());
        }
        if (kwargs) {
            this.jvmMethod().kwargsHash(pairs.size() - 1);
        } else {
            this.jvmMethod().hash(pairs.size());
        }
    }

    @Override
    public void LocalVariable(LocalVariable localvariable) {
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.jvmAdapter().ldc(localvariable.getOffset());
        this.jvmAdapter().ldc(localvariable.getScopeDepth());
        this.jvmMethod().pushNil();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueOrNil", CodegenUtils.sig(IRubyObject.class, Integer.TYPE, Integer.TYPE, IRubyObject.class));
    }

    @Override
    public void Nil(Nil nil) {
        this.jvmMethod().pushNil();
    }

    @Override
    public void NthRef(NthRef nthref) {
        this.jvmMethod().loadContext();
        this.jvmAdapter().pushInt(nthref.matchNumber);
        this.jvmMethod().invokeIRHelper("nthMatch", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Integer.TYPE));
    }

    @Override
    public void NullBlock(NullBlock nullblock) {
        this.jvmAdapter().getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
    }

    @Override
    public void ObjectClass(ObjectClass objectclass) {
        this.jvmMethod().pushObjectClass();
    }

    @Override
    public void Rational(Rational rational) {
        this.jvmMethod().loadRuntime();
        this.jvmAdapter().ldc(rational.getNumerator());
        this.jvmAdapter().ldc(rational.getDenominator());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Ruby.class), "newRational", CodegenUtils.sig(RubyRational.class, Long.TYPE, Long.TYPE));
    }

    @Override
    public void Regexp(Regexp regexp2) {
        this.jvmMethod().pushRegexp(regexp2.getSource(), regexp2.options.toEmbeddedOptions());
    }

    @Override
    public void ScopeModule(ScopeModule scopemodule) {
        this.jvmMethod().loadStaticScope();
        this.jvmAdapter().pushInt(scopemodule.getScopeModuleDepth());
        this.jvmAdapter().invokestatic(CodegenUtils.p(Helpers.class), "getNthScopeModule", CodegenUtils.sig(RubyModule.class, StaticScope.class, Integer.TYPE));
    }

    @Override
    public void Self(Self self2) {
        this.jvmMethod().loadSelf();
    }

    @Override
    public void Splat(Splat splat) {
        this.visit(splat.getArray());
    }

    @Override
    public void StandardError(StandardError standarderror) {
        this.jvmMethod().loadRuntime();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Ruby.class), "getStandardError", CodegenUtils.sig(RubyClass.class, new Class[0]));
    }

    @Override
    public void StringLiteral(StringLiteral stringliteral) {
        this.jvmMethod().pushString(stringliteral.getByteList(), stringliteral.getCodeRange());
    }

    @Override
    public void SValue(SValue svalue) {
        this.visit(svalue.getArray());
        this.jvmAdapter().dup();
        this.jvmAdapter().instance_of(CodegenUtils.p(RubyArray.class));
        Label after = new Label();
        this.jvmAdapter().iftrue(after);
        this.jvmAdapter().pop();
        this.jvmMethod().pushNil();
        this.jvmAdapter().label(after);
    }

    @Override
    public void Symbol(Symbol symbol) {
        this.jvmMethod().pushSymbol(symbol.getName(), symbol.getEncoding());
    }

    @Override
    public void TemporaryVariable(TemporaryVariable temporaryvariable) {
        this.jvmLoadLocal(temporaryvariable);
    }

    @Override
    public void TemporaryLocalVariable(TemporaryLocalVariable temporarylocalvariable) {
        this.jvmLoadLocal(temporarylocalvariable);
    }

    @Override
    public void TemporaryFloatVariable(TemporaryFloatVariable temporaryfloatvariable) {
        this.jvmLoadLocal(temporaryfloatvariable);
    }

    @Override
    public void TemporaryFixnumVariable(TemporaryFixnumVariable temporaryfixnumvariable) {
        this.jvmLoadLocal(temporaryfixnumvariable);
    }

    @Override
    public void TemporaryBooleanVariable(TemporaryBooleanVariable temporarybooleanvariable) {
        this.jvmLoadLocal(temporarybooleanvariable);
    }

    @Override
    public void UndefinedValue(UndefinedValue undefinedvalue) {
        this.jvmMethod().pushUndefined();
    }

    @Override
    public void UnexecutableNil(UnexecutableNil unexecutablenil) {
        throw new NotCompilableException(this.getClass().getSimpleName() + " should never be directly executed!");
    }

    @Override
    public void WrappedIRClosure(WrappedIRClosure wrappedirclosure) {
        IRClosure closure = wrappedirclosure.getClosure();
        this.jvmAdapter().newobj(CodegenUtils.p(Block.class));
        this.jvmAdapter().dup();
        this.jvmMethod().pushBlockBody(closure.getHandle(), closure.getSignature(), this.jvm.clsData().clsName);
        this.jvmMethod().loadContext();
        this.visit(closure.getSelf());
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "currentBinding", CodegenUtils.sig(Binding.class, IRubyObject.class, DynamicScope.class));
        this.jvmAdapter().invokespecial(CodegenUtils.p(Block.class), "<init>", CodegenUtils.sig(Void.TYPE, BlockBody.class, Binding.class));
    }

    private SkinnyMethodAdapter jvmAdapter() {
        return this.jvmMethod().adapter;
    }

    private IRBytecodeAdapter jvmMethod() {
        return this.jvm.method();
    }
}

