/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.opto.ConstantCache;
import org.jruby.runtime.opto.Invalidator;

public class LexicalSearchConstInstr
extends ResultBaseInstr
implements FixedArityInstr {
    String constName;
    private volatile transient ConstantCache cache;

    public LexicalSearchConstInstr(Variable result2, Operand definingScope, String constName) {
        super(Operation.LEXICAL_SEARCH_CONST, result2, new Operand[]{definingScope});
        assert (result2 != null) : "LexicalSearchConstInstr result is null";
        this.constName = constName;
    }

    public Operand getDefiningScope() {
        return this.operands[0];
    }

    public String getConstName() {
        return this.constName;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + this.constName};
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new LexicalSearchConstInstr(ii.getRenamedVariable(this.result), this.getDefiningScope().cloneForInlining(ii), this.constName);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getDefiningScope());
        e.encode(this.getConstName());
    }

    public static LexicalSearchConstInstr decode(IRReaderDecoder d) {
        return new LexicalSearchConstInstr(d.decodeVariable(), d.decodeOperand(), d.decodeString());
    }

    private Object cache(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        StaticScope staticScope = (StaticScope)this.getDefiningScope().retrieve(context, self2, currScope, currDynScope, temp);
        IRubyObject constant = staticScope.getConstantInner(this.constName);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        } else {
            Invalidator invalidator = context.runtime.getConstantInvalidator(this.constName);
            this.cache = new ConstantCache(constant, invalidator.getData(), invalidator);
        }
        return constant;
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        ConstantCache cache = this.cache;
        if (!ConstantCache.isCached(cache)) {
            return this.cache(context, currScope, currDynScope, self2, temp);
        }
        return cache.value;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.LexicalSearchConstInstr(this);
    }
}

