/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jruby.RubyInstanceConfig;
import org.jruby.exceptions.MainExitException;
import org.jruby.runtime.profile.builtin.ProfileOutput;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.KCode;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.cli.Options;
import org.jruby.util.cli.OutputStrings;

public class ArgumentProcessor {
    private List<Argument> arguments;
    private int argumentIndex = 0;
    private boolean processArgv;
    private final boolean rubyOpts;
    RubyInstanceConfig config;
    private boolean endOfArguments = false;
    private int characterIndex = 0;

    public ArgumentProcessor(String[] arguments, RubyInstanceConfig config) {
        this(arguments, true, false, false, config);
    }

    public ArgumentProcessor(String[] arguments, boolean processArgv, boolean dashed, boolean rubyOpts, RubyInstanceConfig config) {
        this.config = config;
        this.arguments = new ArrayList<Argument>();
        if (arguments != null && arguments.length > 0) {
            for (String argument : arguments) {
                this.arguments.add(new Argument(argument, dashed));
            }
        }
        this.processArgv = processArgv;
        this.rubyOpts = rubyOpts;
    }

    public void processArguments() {
        this.processArguments(true);
    }

    public void processArguments(boolean inline) {
        this.checkProperties();
        while (this.argumentIndex < this.arguments.size() && this.isInterpreterArgument(this.arguments.get((int)this.argumentIndex).originalValue)) {
            this.processArgument();
            ++this.argumentIndex;
        }
        if (inline && !this.config.isInlineScript() && this.config.getScriptFileName() == null && !this.config.isForceStdin() && this.argumentIndex < this.arguments.size()) {
            this.config.setScriptFileName(this.arguments.get((int)this.argumentIndex).originalValue);
            ++this.argumentIndex;
        }
        if (this.processArgv) {
            this.processArgv();
        }
    }

    private void processArgv() {
        ArrayList<String> arglist = new ArrayList<String>();
        while (this.argumentIndex < this.arguments.size()) {
            String arg2 = this.arguments.get((int)this.argumentIndex).originalValue;
            if (this.config.isArgvGlobalsOn() && arg2.startsWith("-")) {
                if ((arg2 = arg2.substring(1)).indexOf(61) > 0) {
                    String[] keyvalue = arg2.split("=", 2);
                    String globalName = keyvalue[0].replaceAll("-", "_");
                    this.config.getOptionGlobals().put(globalName, keyvalue[1]);
                } else {
                    this.config.getOptionGlobals().put(arg2, null);
                }
            } else {
                this.config.setArgvGlobalsOn(false);
                arglist.add(arg2);
            }
            ++this.argumentIndex;
        }
        arglist.addAll(Arrays.asList(this.config.getArgv()));
        this.config.setArgv(arglist.toArray(new String[arglist.size()]));
    }

    private boolean isInterpreterArgument(String argument) {
        return argument.length() > 0 && (argument.charAt(0) == '-' || argument.charAt(0) == '+') && !this.endOfArguments;
    }

    private String getArgumentError(String additionalError) {
        return "jruby: invalid argument\n" + additionalError + "\n";
    }

    /*
     * Unable to fully structure code
     */
    private void processArgument() {
        argument = this.arguments.get((int)this.argumentIndex).dashedValue;
        if (argument.length() == 1) {
            this.endOfArguments = true;
            this.config.setForceStdin(true);
            return;
        }
        this.characterIndex = 1;
        block41: while (this.characterIndex < argument.length()) {
            switch (argument.charAt(this.characterIndex)) {
                case '0': {
                    this.disallowedInRubyOpts(argument);
                    temp = this.grabOptionalValue();
                    if (null == temp) {
                        this.config.setRecordSeparator("\u0000");
                        break block41;
                    }
                    if (temp.equals("0")) {
                        this.config.setRecordSeparator("\n\n");
                        break block41;
                    }
                    if (temp.equals("777")) {
                        this.config.setRecordSeparator("\uffff");
                        break block41;
                    }
                    try {
                        val = Integer.parseInt(temp, 8);
                        this.config.setRecordSeparator("" + (char)val);
                        break block41;
                    }
                    catch (Exception e) {
                        mee = new MainExitException(1, this.getArgumentError(" -0 must be followed by either 0, 777, or a valid octal value"));
                        mee.setUsageError(true);
                        throw mee;
                    }
                }
                case 'a': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setSplit(true);
                    break;
                }
                case 'c': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setShouldCheckSyntax(true);
                    break;
                }
                case 'C': {
                    this.disallowedInRubyOpts(argument);
                    try {
                        saved = this.grabValue(this.getArgumentError(" -C must be followed by a directory expression"));
                        base = new File(this.config.getCurrentDirectory());
                        newDir = new File(saved);
                        if (saved.startsWith("uri:classloader:")) {
                            this.config.setCurrentDirectory(saved);
                        } else if (newDir.isAbsolute()) {
                            this.config.setCurrentDirectory(newDir.getCanonicalPath());
                        } else {
                            this.config.setCurrentDirectory(new File(base, newDir.getPath()).getCanonicalPath());
                        }
                        if (!new File(this.config.getCurrentDirectory()).isDirectory() && !this.config.getCurrentDirectory().startsWith("uri:classloader:")) {
                            mee = new MainExitException(1, "jruby: Can't chdir to " + saved + " (fatal)");
                            throw mee;
                        }
                        break block41;
                    }
                    catch (IOException e) {
                        mee = new MainExitException(1, this.getArgumentError(" -C must be followed by a valid directory"));
                        throw mee;
                    }
                }
                case 'd': {
                    this.config.setDebug(true);
                    this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                    break;
                }
                case 'e': {
                    this.disallowedInRubyOpts(argument);
                    this.config.getInlineScript().append(this.grabValue(this.getArgumentError(" -e must be followed by an expression to report")));
                    this.config.getInlineScript().append('\n');
                    this.config.setHasInlineScript(true);
                    break block41;
                }
                case 'E': {
                    this.processEncodingOption(this.grabValue(this.getArgumentError("unknown encoding name")));
                    break block41;
                }
                case 'F': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setInputFieldSeparator(this.grabValue(this.getArgumentError(" -F must be followed by a pattern for input field separation")));
                    break block41;
                }
                case 'h': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setShouldPrintUsage(true);
                    this.config.setShouldRunInterpreter(false);
                    break;
                }
                case 'i': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setInPlaceBackupExtension(this.grabOptionalValue());
                    if (this.config.getInPlaceBackupExtension() != null) break block41;
                    this.config.setInPlaceBackupExtension("");
                    break block41;
                }
                case 'I': {
                    s = this.grabValue(this.getArgumentError("-I must be followed by a directory name to add to lib path"));
                    ls = s.split(File.pathSeparator);
                    this.config.getLoadPaths().addAll(Arrays.asList(ls));
                    break block41;
                }
                case 'J': {
                    js = this.grabOptionalValue();
                    this.config.getError().println("warning: " + argument + " argument ignored (launched in same VM?)");
                    if (!js.equals("-cp") && !js.equals("-classpath")) break block41;
                    while (this.grabOptionalValue() != null) {
                    }
                    this.grabValue(this.getArgumentError(" -J-cp must be followed by a path expression"));
                    break block41;
                }
                case 'K': {
                    eArg = this.grabValue(this.getArgumentError("provide a value for -K"));
                    this.config.setKCode(KCode.create(null, eArg));
                    this.config.setSourceEncoding(this.config.getKCode().getEncoding().toString());
                    if (this.config.getExternalEncoding() != null) break;
                    this.config.setExternalEncoding(this.config.getKCode().getEncoding().toString());
                    break;
                }
                case 'l': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setProcessLineEnds(true);
                    break;
                }
                case 'n': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setAssumeLoop(true);
                    this.config.setKernelGsubDefined(true);
                    break;
                }
                case 'p': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setAssumePrinting(true);
                    this.config.setAssumeLoop(true);
                    this.config.setKernelGsubDefined(true);
                    break;
                }
                case 'r': {
                    this.config.getRequiredLibraries().add(this.grabValue(this.getArgumentError("-r must be followed by a package to require")));
                    break block41;
                }
                case 's': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setArgvGlobalsOn(true);
                    break;
                }
                case 'G': {
                    this.config.setLoadGemfile(true);
                    break;
                }
                case 'S': {
                    this.disallowedInRubyOpts(argument);
                    this.runBinScript();
                    break block41;
                }
                case 'T': {
                    temp = this.grabOptionalValue();
                    break block41;
                }
                case 'U': {
                    this.config.setInternalEncoding("UTF-8");
                    break;
                }
                case 'v': {
                    this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                    this.config.setShowVersion(true);
                    break;
                }
                case 'w': {
                    this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                    break;
                }
                case 'W': {
                    temp = this.grabOptionalValue();
                    if (temp == null) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                        break block41;
                    }
                    if (temp.equals("0")) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.NIL);
                        break block41;
                    }
                    if (temp.equals("1")) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.FALSE);
                        break block41;
                    }
                    if (temp.equals("2")) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                        break block41;
                    }
                    mee = new MainExitException(1, this.getArgumentError(" -W must be followed by either 0, 1, 2 or nothing"));
                    mee.setUsageError(true);
                    throw mee;
                }
                case 'x': {
                    this.disallowedInRubyOpts(argument);
                    try {
                        saved = this.grabOptionalValue();
                        if (saved != null) {
                            base = new File(this.config.getCurrentDirectory());
                            newDir = new File(saved);
                            if (saved.startsWith("uri:classloader:")) {
                                this.config.setCurrentDirectory(saved);
                            } else if (newDir.isAbsolute()) {
                                this.config.setCurrentDirectory(newDir.getCanonicalPath());
                            } else {
                                this.config.setCurrentDirectory(new File(base, newDir.getPath()).getCanonicalPath());
                            }
                            if (!new File(this.config.getCurrentDirectory()).isDirectory() && !this.config.getCurrentDirectory().startsWith("uri:classloader:")) {
                                mee = new MainExitException(1, "jruby: Can't chdir to " + saved + " (fatal)");
                                throw mee;
                            }
                        }
                        this.config.setXFlag(true);
                        break block41;
                    }
                    catch (IOException e) {
                        mee = new MainExitException(1, this.getArgumentError(" -x must be followed by a valid directory"));
                        throw mee;
                    }
                }
                case 'X': {
                    this.disallowedInRubyOpts(argument);
                    extendedOption = this.grabOptionalValue();
                    if (extendedOption == null) {
                        if (SafePropertyAccessor.getBoolean("jruby.launcher.nopreamble", false)) {
                            throw new MainExitException(0, OutputStrings.getExtendedHelp());
                        }
                        throw new MainExitException(0, "jruby: missing argument\n" + OutputStrings.getExtendedHelp());
                    }
                    if (extendedOption.equals("-O")) {
                        this.config.setObjectSpaceEnabled(false);
                        break block41;
                    }
                    if (extendedOption.equals("+O")) {
                        this.config.setObjectSpaceEnabled(true);
                        break block41;
                    }
                    if (extendedOption.equals("-C") || extendedOption.equals("-CIR")) {
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
                        break block41;
                    }
                    if (extendedOption.equals("+C") || extendedOption.equals("+CIR")) {
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.FORCE);
                        break block41;
                    }
                    if (extendedOption.equals("+T")) {
                        ArgumentProcessor.checkGraalVersion();
                        Options.PARSER_WARN_GROUPED_EXPRESSIONS.force(Boolean.FALSE.toString());
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.TRUFFLE);
                        this.config.setDisableGems(true);
                        break block41;
                    }
                    if (extendedOption.endsWith("...")) {
                        Options.listPrefix(extendedOption.substring(0, extendedOption.length() - "...".length()));
                        this.config.setShouldRunInterpreter(false);
                        break block41;
                    }
                    if (extendedOption.endsWith("?")) {
                        Options.listContains(extendedOption.substring(0, extendedOption.length() - 1));
                        this.config.setShouldRunInterpreter(false);
                        break block41;
                    }
                    mee = new MainExitException(1, "jruby: invalid extended option " + extendedOption + " (-X will list valid options)\n");
                    mee.setUsageError(true);
                    throw mee;
                }
                case 'y': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setParserDebug(true);
                    break block41;
                }
                case '-': {
                    if (argument.equals("--command") || argument.equals("--bin")) {
                        this.characterIndex = argument.length();
                        this.runBinScript();
                        break;
                    }
                    if (argument.equals("--compat")) {
                        this.characterIndex = argument.length();
                        this.grabValue(this.getArgumentError("--compat takes an argument, but will be ignored"));
                        this.config.getError().println("warning: " + argument + " ignored");
                        break block41;
                    }
                    if (argument.equals("--copyright")) {
                        this.disallowedInRubyOpts(argument);
                        this.config.setShowCopyright(true);
                        this.config.setShouldRunInterpreter(false);
                        break block41;
                    }
                    if (argument.equals("--debug")) {
                        this.disallowedInRubyOpts(argument);
                        Options.DEBUG_FULLTRACE.force("true");
                        RubyInstanceConfig.FULL_TRACE_ENABLED = true;
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
                        break block41;
                    }
                    if (argument.equals("--jdb")) {
                        this.config.setDebug(true);
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                        break;
                    }
                    if (argument.equals("--help")) {
                        this.disallowedInRubyOpts(argument);
                        this.config.setShouldPrintUsage(true);
                        this.config.setShouldRunInterpreter(false);
                        break;
                    }
                    if (argument.equals("--properties")) {
                        this.config.setShouldPrintProperties(true);
                        this.config.setShouldRunInterpreter(false);
                        break;
                    }
                    if (argument.equals("--version")) {
                        this.disallowedInRubyOpts(argument);
                        this.config.setShowVersion(true);
                        this.config.setShouldRunInterpreter(false);
                        break block41;
                    }
                    if (argument.equals("--bytecode")) {
                        this.config.setShowBytecode(true);
                        break block41;
                    }
                    if (argument.equals("--fast")) {
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.FORCE);
                        break block41;
                    }
                    if (argument.startsWith("--profile")) {
                        this.characterIndex = argument.length();
                        dotIndex = argument.indexOf(".");
                        if (dotIndex == -1) {
                            this.config.setProfilingMode(RubyInstanceConfig.ProfilingMode.FLAT);
                            break block41;
                        }
                        profilingMode = argument.substring(dotIndex + 1, argument.length());
                        if (profilingMode.equals("out")) {
                            outputFile = this.grabValue(this.getArgumentError("--profile.out requires an output file argument"));
                            try {
                                this.config.setProfileOutput(new ProfileOutput(new File(outputFile)));
                                break block41;
                            }
                            catch (FileNotFoundException e) {
                                throw new MainExitException(1, String.format("jruby: %s", new Object[]{e.getMessage()}));
                            }
                        }
                        if (profilingMode.equals("service")) {
                            service = this.grabValue(this.getArgumentError("--profile.service requires an class name argument"));
                            this.config.setProfilingMode(RubyInstanceConfig.ProfilingMode.SERVICE);
                            this.config.setProfilingService(service);
                            break block41;
                        }
                        try {
                            this.config.setProfilingMode(RubyInstanceConfig.ProfilingMode.valueOf(profilingMode.toUpperCase()));
                            break block41;
                        }
                        catch (IllegalArgumentException e) {
                            throw new MainExitException(1, String.format("jruby: unknown profiler mode \"%s\"", new Object[]{profilingMode}));
                        }
                    }
                    if (argument.equals("--1.8")) {
                        this.config.getError().println("warning: " + argument + " ignored");
                        break block41;
                    }
                    if (argument.equals("--1.9")) {
                        this.config.getError().println("warning: " + argument + " ignored");
                        break block41;
                    }
                    if (argument.equals("--2.0")) {
                        this.config.getError().println("warning: " + argument + " ignored");
                        break block41;
                    }
                    if (argument.equals("--2.1")) break block41;
                    if (argument.equals("--disable-gems")) {
                        this.config.setDisableGems(true);
                        break block41;
                    }
                    if (!argument.equals("--disable")) ** GOTO lbl317
                    this.errorMissingDisable();
                    ** GOTO lbl376
lbl317:
                    // 1 sources

                    if (argument.startsWith("--disable=")) {
                        disablesStr = argument.substring("--disable=".length());
                        disables = disablesStr.split(",");
                        if (disables.length == 0) {
                            this.errorMissingDisable();
                        }
                        for (String disable : disables) {
                            all = disable.equals("all");
                            if (disable.equals("gems") || all) {
                                this.config.setDisableGems(true);
                                continue;
                            }
                            if (disable.equals("rubyopt") || all) {
                                this.config.setDisableRUBYOPT(true);
                                continue;
                            }
                            this.config.getError().println("warning: unknown argument for --disable: `" + disable + "'");
                        }
                        break block41;
                    }
                    if (argument.equals("--gemfile")) {
                        this.config.setLoadGemfile(true);
                        break block41;
                    }
                    if (argument.equals("--dump")) {
                        this.characterIndex = argument.length();
                        error = "--dump only supports [version, copyright, usage, yydebug, syntax, insns] on JRuby";
                        dumpArg = this.grabValue(this.getArgumentError(error));
                        if (dumpArg.equals("version")) {
                            this.config.setShowVersion(true);
                            this.config.setShouldRunInterpreter(false);
                            break block41;
                        }
                        if (dumpArg.equals("copyright")) {
                            this.config.setShowCopyright(true);
                            this.config.setShouldRunInterpreter(false);
                            break block41;
                        }
                        if (dumpArg.equals("usage")) {
                            this.config.setShouldPrintUsage(true);
                            this.config.setShouldRunInterpreter(false);
                            break block41;
                        }
                        if (dumpArg.equals("yydebug")) {
                            this.config.setParserDebug(true);
                            break block41;
                        }
                        if (dumpArg.equals("syntax")) {
                            this.config.setShouldCheckSyntax(true);
                            break;
                        }
                        if (dumpArg.equals("insns")) {
                            this.config.setShowBytecode(true);
                            break;
                        }
                        mee = new MainExitException(1, error);
                        mee.setUsageError(true);
                        throw mee;
                    }
                    if (argument.equals("--dev")) {
                        Options.COMPILE_INVOKEDYNAMIC.force("false");
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
                        break block41;
                    }
                    if (argument.equals("--server") || argument.equals("--client")) break block41;
                    if (!argument.equals("--yydebug")) ** GOTO lbl373
                    this.disallowedInRubyOpts(argument);
                    this.config.setParserDebug(true);
                    ** GOTO lbl376
lbl373:
                    // 1 sources

                    if (argument.equals("--")) {
                        this.endOfArguments = true;
                        break;
                    }
                }
lbl376:
                // 5 sources

                default: {
                    throw new MainExitException(1, "jruby: unknown option " + argument);
                }
            }
            ++this.characterIndex;
        }
    }

    private void disallowedInRubyOpts(String option) {
        if (this.rubyOpts) {
            throw new MainExitException(1, "jruby: invalid switch in RUBYOPT: " + option + " (RuntimeError)");
        }
    }

    private void errorMissingDisable() {
        MainExitException mee = new MainExitException(1, "missing argument for --disable\n");
        mee.setUsageError(true);
        throw mee;
    }

    private void processEncodingOption(String value2) {
        String[] encodings = value2.split(":", 3);
        switch (encodings.length) {
            case 3: {
                throw new MainExitException(1, "extra argument for -E: " + encodings[2]);
            }
            case 2: {
                this.config.setInternalEncoding(encodings[1]);
            }
            case 1: {
                this.config.setExternalEncoding(encodings[0]);
            }
        }
    }

    private void runBinScript() {
        String scriptName = this.grabValue("jruby: provide a bin script to execute");
        if (scriptName.equals("irb")) {
            scriptName = "jirb";
        }
        this.config.setScriptFileName(this.resolveScript(scriptName));
        if (this.config.getScriptFileName() == null) {
            this.config.setScriptFileName(scriptName);
            this.config.getRequiredLibraries().add("jruby/commands");
            this.config.getInlineScript().append("JRuby::Commands.").append(scriptName);
            this.config.getInlineScript().append("\n");
            this.config.setHasInlineScript(true);
        }
        this.endOfArguments = true;
    }

    private String resolve(String path2, String scriptName) {
        if (RubyInstanceConfig.DEBUG_SCRIPT_RESOLUTION) {
            this.config.getError().println("Trying path: " + path2);
        }
        try {
            FileResource fullName = JRubyFile.createRestrictedResource(path2, scriptName);
            if (fullName.exists() && fullName.isFile()) {
                if (RubyInstanceConfig.DEBUG_SCRIPT_RESOLUTION) {
                    this.config.getError().println("Found: " + fullName.absolutePath());
                }
                return fullName.absolutePath();
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return null;
    }

    private String resolveScript(String scriptName) {
        String result2 = this.resolve(this.config.getCurrentDirectory(), scriptName);
        if (result2 != null) {
            return scriptName;
        }
        result2 = this.resolve(this.config.getJRubyHome() + "/bin", scriptName);
        if (result2 != null) {
            return result2;
        }
        result2 = this.resolve("uri:classloader:/bin", scriptName);
        if (result2 != null) {
            return result2;
        }
        String path2 = this.config.getEnvironment().get("PATH").toString();
        if (path2 != null) {
            String[] paths = path2.split(System.getProperty("path.separator"));
            for (int i2 = 0; i2 < paths.length; ++i2) {
                result2 = this.resolve(paths[i2], scriptName);
                if (result2 == null) continue;
                return result2;
            }
        }
        if (this.config.isDebug()) {
            this.config.getError().println("warning: could not resolve -S script: " + scriptName);
        }
        return null;
    }

    public String resolveScriptUsingClassLoader(String scriptName) {
        if (RubyInstanceConfig.defaultClassLoader().getResourceAsStream("bin/" + scriptName) != null) {
            return "classpath:/bin/" + scriptName;
        }
        return null;
    }

    private String grabValue(String errorMessage) {
        String optValue = this.grabOptionalValue();
        if (optValue != null) {
            return optValue;
        }
        ++this.argumentIndex;
        if (this.argumentIndex < this.arguments.size()) {
            return this.arguments.get((int)this.argumentIndex).originalValue;
        }
        MainExitException mee = new MainExitException(1, errorMessage);
        mee.setUsageError(true);
        throw mee;
    }

    private String grabOptionalValue() {
        ++this.characterIndex;
        String argValue = this.arguments.get((int)this.argumentIndex).originalValue;
        if (this.characterIndex < argValue.length()) {
            return argValue.substring(this.characterIndex);
        }
        return null;
    }

    private void logScriptResolutionSuccess(String path2) {
        if (RubyInstanceConfig.DEBUG_SCRIPT_RESOLUTION) {
            this.config.getError().println("Found: " + path2);
        }
    }

    private void logScriptResolutionFailure(String path2) {
        if (RubyInstanceConfig.DEBUG_SCRIPT_RESOLUTION) {
            this.config.getError().println("Searched: " + path2);
        }
    }

    public static void checkGraalVersion() {
        if (Options.TRUFFLE_RUNTIME_VERSION_CHECK.load().booleanValue()) {
            String graalVersion = System.getProperty("graal.version", "unknown");
            String expectedGraalVersion = "0.7";
            if (graalVersion.equals("unknown")) {
                return;
            }
            if (!graalVersion.equals("0.7")) {
                throw new RuntimeException("This version of JRuby is built against Graal 0.7 but you are using it with version " + graalVersion + " - either update Graal or use with (-J)-original to disable Graal and ignore this error");
            }
        }
    }

    private void checkProperties() {
        HashSet<String> propertyNames = new HashSet<String>();
        propertyNames.addAll(Options.getPropertyNames());
        propertyNames.add("jruby.home");
        propertyNames.add("jruby.script");
        propertyNames.add("jruby.shell");
        propertyNames.add("jruby.lib");
        propertyNames.add("jruby.bindir");
        propertyNames.add("jruby.jar");
        propertyNames.add("jruby.compat.version");
        propertyNames.add("jruby.reflection");
        propertyNames.add("jruby.thread.pool.enabled");
        for (String propertyName : System.getProperties().stringPropertyNames()) {
            if (!propertyName.startsWith("jruby.") || propertyNames.contains(propertyName)) continue;
            System.err.println("jruby: warning: unknown property " + propertyName);
        }
    }

    private final class Argument {
        public final String originalValue;
        public final String dashedValue;

        public Argument(String value2, boolean dashed) {
            this.originalValue = value2;
            this.dashedValue = dashed && !value2.startsWith("-") ? "-" + value2 : value2;
        }

        public String toString() {
            return this.dashedValue;
        }
    }
}

