/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jnr.posix.util.Platform;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.util.ByteList;
import org.jruby.util.SafePropertyAccessor;

public class OSEnvironment {
    public Map<RubyString, RubyString> getEnvironmentVariableMap(Ruby runtime) {
        Map<RubyString, RubyString> envs;
        if (runtime.getInstanceConfig().getEnvironment() != null) {
            return OSEnvironment.getAsMapOfRubyStrings(runtime, runtime.getInstanceConfig().getEnvironment());
        }
        if (Ruby.isSecurityRestricted()) {
            envs = new HashMap<RubyString, RubyString>();
        } else {
            Map<String, String> variables = System.getenv();
            envs = OSEnvironment.getAsMapOfRubyStrings(runtime, variables);
        }
        return envs;
    }

    public Map<RubyString, RubyString> getSystemPropertiesMap(Ruby runtime) {
        if (Ruby.isSecurityRestricted()) {
            return new HashMap<RubyString, RubyString>();
        }
        return OSEnvironment.getAsMapOfRubyStrings(runtime, OSEnvironment.propertiesToStringMap(System.getProperties()));
    }

    public static Map<String, String> propertiesToStringMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        return map;
    }

    private static Map<RubyString, RubyString> getAsMapOfRubyStrings(Ruby runtime, Map<String, String> map) {
        HashMap<RubyString, RubyString> envs = new HashMap<RubyString, RubyString>();
        Encoding encoding2 = runtime.getEncodingService().getLocaleEncoding();
        if (Platform.IS_WINDOWS) {
            String home2 = SafePropertyAccessor.getProperty("user.home");
            String user = SafePropertyAccessor.getProperty("user.name");
            OSEnvironment.addRubyKeyValuePair(runtime, envs, "HOME", home2 == null ? "/" : home2, encoding2);
            OSEnvironment.addRubyKeyValuePair(runtime, envs, "USER", user == null ? "" : user, encoding2);
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String tmp = entry.getKey();
            if (!(tmp instanceof String)) continue;
            String key2 = tmp;
            if (Platform.IS_WINDOWS && key2.startsWith("=") || !((tmp = entry.getValue()) instanceof String)) continue;
            OSEnvironment.addRubyKeyValuePair(runtime, envs, key2, tmp, encoding2);
        }
        return envs;
    }

    private static void addRubyKeyValuePair(Ruby runtime, Map<RubyString, RubyString> map, String key2, String value2, Encoding encoding2) {
        ByteList keyBytes = new ByteList(key2.getBytes(), encoding2);
        ByteList valueBytes = new ByteList(value2.getBytes(), encoding2);
        RubyString keyString = runtime.newString(keyBytes);
        RubyString valueString = runtime.newString(valueBytes);
        keyString.setFrozen(true);
        valueString.setFrozen(true);
        map.put(keyString, valueString);
    }
}

