/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRMethod;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class DefineClassMethodInstr
extends Instr
implements FixedArityInstr {
    private final IRMethod method;

    public DefineClassMethodInstr(Operand container, IRMethod method) {
        super(Operation.DEF_CLASS_METH, new Operand[]{container});
        this.method = method;
    }

    public Operand getContainer() {
        return this.operands[0];
    }

    public IRMethod getMethod() {
        return this.method;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + this.method.getName()};
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new DefineClassMethodInstr(this.getContainer().cloneForInlining(ii), this.method);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getContainer());
        e.encode(this.getMethod());
    }

    public static DefineClassMethodInstr decode(IRReaderDecoder d) {
        return new DefineClassMethodInstr(d.decodeOperand(), (IRMethod)d.decodeScope());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRubyObject obj = (IRubyObject)this.getContainer().retrieve(context, self2, currScope, currDynScope, temp);
        IRRuntimeHelpers.defInterpretedClassMethod(context, this.method, obj);
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.DefineClassMethodInstr(this);
    }
}

