/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.ContextAwareBlockBody;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class MethodBlock
extends ContextAwareBlockBody {
    private final RubyMethod method;
    private final String filename;
    private final int line;

    public static Block createMethodBlock(ThreadContext context, IRubyObject self2, DynamicScope dynamicScope, MethodBlock body) {
        RubyMethod method = body.method;
        RubyModule module = method.getMethod().getImplementationClass();
        Frame frame = new Frame();
        frame.setKlazz(module);
        frame.setName(method.getMethodName());
        frame.setSelf(method.receiver(context));
        frame.setVisibility(method.getMethod().getVisibility());
        Binding binding2 = new Binding(frame, dynamicScope, method.getMethodName(), body.getFile(), body.getLine());
        return new Block(body, binding2);
    }

    public MethodBlock(RubyMethod method, StaticScope staticScope) {
        super(staticScope, Arity.createArity((int)method.arity().getLongValue()), 3);
        this.method = method;
        String filename2 = method.getFilename();
        if (filename2 == null) {
            filename2 = "(method)";
        }
        this.filename = filename2;
        this.line = method.getLine();
    }

    public abstract IRubyObject callback(IRubyObject var1, IRubyObject var2, IRubyObject var3, Block var4);

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        return this.yield(context, args2, null, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2, Block block) {
        return this.yield(context, args2, null, binding2, type2, block);
    }

    @Override
    protected Frame pre(ThreadContext context, Binding binding2) {
        return context.preYieldNoScope(binding2);
    }

    @Override
    protected void post(ThreadContext context, Binding binding2, Visibility visibility, Frame lastFrame) {
        context.postYieldNoScope(lastFrame);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, Binding binding2, Block.Type type2) {
        return this.yield(context, null, binding2, type2);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        return this.yield(context, arg0, binding2, type2);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        return this.yield(context, new IRubyObject[]{arg0, arg1}, null, binding2, type2);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        return this.yield(context, new IRubyObject[]{arg0, arg1, arg2}, null, binding2, type2);
    }

    @Override
    protected IRubyObject doYield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        return this.yield(context, value2, binding2, type2);
    }

    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2, Block block) {
        return this.yield(context, value2, binding2, type2);
    }

    @Override
    protected IRubyObject doYield(ThreadContext context, IRubyObject[] args2, IRubyObject self2, Binding binding2, Block.Type type2) {
        return this.yield(context, args2, self2, binding2, type2, Block.NULL_BLOCK);
    }

    protected IRubyObject prepareSelf(Binding binding2) {
        IRubyObject self2 = binding2.getSelf();
        binding2.getFrame().setSelf(self2);
        return self2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject[] args2, IRubyObject self2, Binding binding2, Block.Type type2, Block block) {
        self2 = this.prepareSelf(binding2);
        Frame lastFrame = this.pre(context, binding2);
        while (true) {
            try {
                IRubyObject[] preppedArgs = RubyProc.prepareArgs(context, type2, this, args2);
                IRubyObject iRubyObject = this.callback(context.runtime.newArrayNoCopyLight(preppedArgs), this.method, self2, block);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                try {
                    context.pollThreadEvents();
                    continue;
                    catch (JumpException.BreakJump bj) {
                        throw bj;
                    }
                }
                catch (JumpException.FlowControlException jump) {
                    IRubyObject iRubyObject = Helpers.handleBlockJump(context, jump, type2);
                    return iRubyObject;
                }
            }
            break;
        }
        finally {
            this.post(context, binding2, null, lastFrame);
        }
    }

    @Override
    public String getFile() {
        return this.filename;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    public RubyMethod getMethod() {
        return this.method;
    }
}

