/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CallBlock
extends BlockBody {
    private final Signature signature;
    private final BlockCallback callback;
    private final StaticScope dummyScope;

    public static Block newCallClosure(IRubyObject self2, RubyModule imClass, Signature signature, BlockCallback callback, ThreadContext context) {
        Binding binding2 = context.currentBinding(self2, Visibility.PUBLIC);
        CallBlock body = new CallBlock(signature, callback, context);
        return new Block(body, binding2);
    }

    @Deprecated
    public static Block newCallClosure(IRubyObject self2, RubyModule imClass, Arity arity2, BlockCallback callback, ThreadContext context) {
        Binding binding2 = context.currentBinding(self2, Visibility.PUBLIC);
        CallBlock body = new CallBlock(Signature.from(arity2), callback, context);
        return new Block(body, binding2);
    }

    private CallBlock(Signature signature, BlockCallback callback, ThreadContext context) {
        super(3);
        this.signature = signature;
        this.callback = callback;
        this.dummyScope = context.runtime.getStaticScopeFactory().getDummyScope();
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        return this.callback.call(context, args2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2, Block block) {
        return this.callback.call(context, args2, block);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, Binding binding2, Block.Type type2) {
        return this.callback.call(context, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        return this.callback.call(context, new IRubyObject[]{arg0}, Block.NULL_BLOCK);
    }

    @Override
    protected IRubyObject doYield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        return this.callback.call(context, new IRubyObject[]{value2}, Block.NULL_BLOCK);
    }

    @Override
    protected IRubyObject doYield(ThreadContext context, IRubyObject[] args2, IRubyObject self2, Binding binding2, Block.Type type2) {
        return this.callback.call(context, args2, Block.NULL_BLOCK);
    }

    @Override
    public StaticScope getStaticScope() {
        return this.dummyScope;
    }

    @Override
    public void setStaticScope(StaticScope newScope) {
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public Arity arity() {
        return this.signature.arity();
    }

    @Override
    public String getFile() {
        return "(internal)";
    }

    @Override
    public int getLine() {
        return -1;
    }
}

