/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import java.lang.invoke.MethodHandle;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ir.IRScope;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.ClassData;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.commons.Method;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CompiledIRBlockBody;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.RegexpOptions;

public abstract class IRBytecodeAdapter {
    public static final int MAX_ARGUMENTS = 250;
    public SkinnyMethodAdapter adapter;
    private int variableCount = 0;
    private Map<Integer, Type> variableTypes = new HashMap<Integer, Type>();
    private Map<Integer, String> variableNames = new HashMap<Integer, String>();
    protected final com.headius.invokebinder.Signature signature;
    private final ClassData classData;

    public IRBytecodeAdapter(SkinnyMethodAdapter adapter, com.headius.invokebinder.Signature signature, ClassData classData) {
        this.adapter = adapter;
        this.signature = signature;
        this.classData = classData;
    }

    public ClassData getClassData() {
        return this.classData;
    }

    public void startMethod() {
        this.adapter.start();
    }

    public void endMethod() {
        this.adapter.end(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : IRBytecodeAdapter.this.variableTypes.entrySet()) {
                    int i2 = (Integer)entry.getKey();
                    String name2 = (String)IRBytecodeAdapter.this.variableNames.get(i2);
                    IRBytecodeAdapter.this.adapter.local(i2, name2, (Type)entry.getValue());
                }
            }
        });
    }

    public void loadLocal(int i2) {
        this.adapter.aload(i2);
    }

    public void loadContext() {
        this.adapter.aload(this.signature.argOffset("context"));
    }

    public void loadStaticScope() {
        this.adapter.aload(this.signature.argOffset("scope"));
    }

    public void loadSelf() {
        this.adapter.aload(this.signature.argOffset("self"));
    }

    public void loadArgs() {
        this.adapter.aload(this.signature.argOffset("args"));
    }

    public void loadBlock() {
        this.adapter.aload(this.signature.argOffset("block"));
    }

    public void loadFrameClass() {
        this.adapter.aload(this.signature.argCount() - 2);
    }

    public void loadFrameName() {
        this.adapter.aload(this.signature.argCount() - 1);
    }

    public void loadSuperName() {
        this.adapter.aload(5);
    }

    public void loadBlockType() {
        if (this.signature.argOffset("type") == -1) {
            this.adapter.aconst_null();
        } else {
            this.adapter.aload(this.signature.argOffset("type"));
        }
    }

    public void storeLocal(int i2) {
        this.adapter.astore(i2);
    }

    public void invokeVirtual(Type type2, Method method) {
        this.adapter.invokevirtual(type2.getInternalName(), method.getName(), method.getDescriptor());
    }

    public void invokeStatic(Type type2, Method method) {
        this.adapter.invokestatic(type2.getInternalName(), method.getName(), method.getDescriptor());
    }

    public void invokeHelper(String name2, String sig) {
        this.adapter.invokestatic(CodegenUtils.p(Helpers.class), name2, sig);
    }

    public void invokeHelper(String name2, Class ... x) {
        this.adapter.invokestatic(CodegenUtils.p(Helpers.class), name2, CodegenUtils.sig(x));
    }

    public void invokeIRHelper(String name2, String sig) {
        this.adapter.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), name2, sig);
    }

    public void goTo(Label label2) {
        this.adapter.go_to(label2);
    }

    public void isTrue() {
        this.adapter.invokeinterface(CodegenUtils.p(IRubyObject.class), "isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
    }

    public void isNil() {
        this.adapter.invokeinterface(CodegenUtils.p(IRubyObject.class), "isNil", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
    }

    public void bfalse(Label label2) {
        this.adapter.iffalse(label2);
    }

    public void btrue(Label label2) {
        this.adapter.iftrue(label2);
    }

    public void poll() {
        this.loadContext();
        this.adapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "pollThreadEvents", CodegenUtils.sig(Void.TYPE, new Class[0]));
    }

    public void pushObjectClass() {
        this.loadRuntime();
        this.adapter.invokevirtual(CodegenUtils.p(Ruby.class), "getObject", CodegenUtils.sig(RubyClass.class, new Class[0]));
    }

    public void pushUndefined() {
        this.adapter.getstatic(CodegenUtils.p(UndefinedValue.class), "UNDEFINED", CodegenUtils.ci(UndefinedValue.class));
    }

    public void pushHandle(Handle handle) {
        this.adapter.getMethodVisitor().visitLdcInsn(handle);
    }

    public void mark(Label label2) {
        this.adapter.label(label2);
    }

    public void returnValue() {
        this.adapter.areturn();
    }

    public int newLocal(String name2, Type type2) {
        int index2 = this.variableCount++;
        if (type2 == Type.DOUBLE_TYPE || type2 == Type.LONG_TYPE) {
            ++this.variableCount;
        }
        this.variableTypes.put(index2, type2);
        this.variableNames.put(index2, name2);
        return index2;
    }

    public Label newLabel() {
        return new Label();
    }

    public void pushBlockBody(Handle handle, Signature signature, String className) {
        String cacheField = "blockBody" + this.getClassData().callSiteCount.getAndIncrement();
        Label done = new Label();
        this.adapter.getClassVisitor().visitField(10, cacheField, CodegenUtils.ci(CompiledIRBlockBody.class), null, null).visitEnd();
        this.adapter.getstatic(this.getClassData().clsName, cacheField, CodegenUtils.ci(CompiledIRBlockBody.class));
        this.adapter.dup();
        this.adapter.ifnonnull(done);
        this.adapter.pop();
        this.adapter.newobj(CodegenUtils.p(CompiledIRBlockBody.class));
        this.adapter.dup();
        this.adapter.ldc(handle);
        this.adapter.getstatic(className, handle.getName() + "_IRScope", CodegenUtils.ci(IRScope.class));
        this.adapter.ldc(signature.encode());
        this.adapter.invokespecial(CodegenUtils.p(CompiledIRBlockBody.class), "<init>", CodegenUtils.sig(Void.TYPE, MethodHandle.class, IRScope.class, Long.TYPE));
        this.adapter.dup();
        this.adapter.putstatic(this.getClassData().clsName, cacheField, CodegenUtils.ci(CompiledIRBlockBody.class));
        this.adapter.label(done);
    }

    public abstract void pushFixnum(long var1);

    public abstract void pushFloat(double var1);

    public abstract void pushString(ByteList var1, int var2);

    public abstract void pushFrozenString(ByteList var1, int var2);

    public abstract void pushByteList(ByteList var1);

    public abstract void pushRegexp(ByteList var1, int var2);

    public abstract void pushDRegexp(Runnable var1, RegexpOptions var2, int var3);

    public abstract void pushSymbol(String var1, Encoding var2);

    public abstract void loadRuntime();

    public abstract void pushEncoding(Encoding var1);

    public abstract void invokeOther(String var1, int var2, boolean var3, boolean var4);

    public abstract void invokeOtherOneFixnum(String var1, long var2);

    public abstract void invokeOtherOneFloat(String var1, double var2);

    public abstract void invokeSelf(String var1, int var2, boolean var3, CallType var4, boolean var5);

    public abstract void invokeInstanceSuper(String var1, int var2, boolean var3, boolean[] var4);

    public abstract void invokeClassSuper(String var1, int var2, boolean var3, boolean[] var4);

    public abstract void invokeUnresolvedSuper(String var1, int var2, boolean var3, boolean[] var4);

    public abstract void invokeZSuper(String var1, int var2, boolean var3, boolean[] var4);

    public abstract void searchConst(String var1, boolean var2);

    public abstract void inheritanceSearchConst(String var1, boolean var2);

    public abstract void lexicalSearchConst(String var1);

    public abstract void pushNil();

    public abstract void pushBoolean(boolean var1);

    public abstract void pushBignum(BigInteger var1);

    public abstract void putField(String var1);

    public abstract void getField(String var1);

    public abstract void array(int var1);

    public abstract void hash(int var1);

    public abstract void kwargsHash(int var1);

    public abstract void checkpoint();
}

