/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import java.util.Map;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class WrappedIRClosure
extends Operand {
    private final Variable self;
    private final IRClosure closure;

    public WrappedIRClosure(Variable self2, IRClosure closure) {
        super(OperandType.WRAPPED_IR_CLOSURE);
        this.self = self2;
        this.closure = closure;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        l.add(this.self);
    }

    public Variable getSelf() {
        return this.self;
    }

    public IRClosure getClosure() {
        return this.closure;
    }

    @Override
    public boolean canCopyPropagate() {
        return true;
    }

    public String toString() {
        return this.self + ":" + this.closure.toString();
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        Operand newSelf = this.self.getSimplifiedOperand(valueMap, force);
        return newSelf == this.self ? this : new WrappedIRClosure((Variable)newSelf, this.closure);
    }

    @Override
    public Operand cloneForInlining(CloneInfo info) {
        if (info instanceof SimpleCloneInfo && !((SimpleCloneInfo)info).isEnsureBlockCloneMode()) {
            return new WrappedIRClosure(info.getRenamedVariable(this.self), this.closure);
        }
        return new WrappedIRClosure(info.getRenamedVariable(this.self), this.closure.cloneForInlining(info));
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        BlockBody body = this.closure.getBlockBody();
        this.closure.getStaticScope().determineModule();
        IRubyObject selfVal = this.self instanceof Self ? self2 : (IRubyObject)this.self.retrieve(context, self2, currScope, currDynScope, temp);
        Binding binding2 = context.currentBinding(selfVal, currDynScope);
        return new Block(body, binding2);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.self);
        e.encode(this.closure);
    }

    public static WrappedIRClosure decode(IRReaderDecoder d) {
        return new WrappedIRClosure(d.decodeVariable(), (IRClosure)d.decodeScope());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.WrappedIRClosure(this);
    }
}

