/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jruby.RubyInstanceConfig;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.listeners.IRScopeListener;
import org.jruby.ir.listeners.InstructionsListener;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.passes.BasicCompilerPassListener;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.CompilerPassListener;
import org.jruby.ir.passes.CompilerPassScheduler;
import org.jruby.ir.passes.DeadCodeElimination;
import org.jruby.ir.passes.OptimizeDelegationPass;
import org.jruby.ir.passes.OptimizeDynScopesPass;
import org.jruby.ir.passes.OptimizeTempVarsPass;

public class IRManager {
    public static final String SAFE_COMPILER_PASSES = "";
    public static final String DEFAULT_BUILD_PASSES = "LocalOptimizationPass";
    public static final String DEFAULT_JIT_PASSES = "LocalOptimizationPass,OptimizeDelegationPass,DeadCodeElimination,AddLocalVarLoadStoreInstructions,OptimizeDynScopesPass,AddCallProtocolInstructions,EnsureTempsAssigned";
    public static final String DEFAULT_INLINING_COMPILER_PASSES = "LocalOptimizationPass";
    private final CompilerPass deadCodeEliminationPass = new DeadCodeElimination();
    private final CompilerPass optimizeDynScopesPass = new OptimizeDynScopesPass();
    private final CompilerPass optimizeDelegationPass = new OptimizeDelegationPass();
    private int dummyMetaClassCount = 0;
    private final IRModuleBody object = new IRClassBody(this, null, "Object", "", 0, null);
    private final Nil nil = new Nil();
    private final Boolean tru = new Boolean(true);
    private final Boolean fals = new Boolean(false);
    private Set<CompilerPassListener> passListeners = new HashSet<CompilerPassListener>();
    private CompilerPassListener defaultListener = new BasicCompilerPassListener();
    private InstructionsListener instrsListener = null;
    private IRScopeListener irScopeListener = null;
    private List<CompilerPass> compilerPasses;
    private List<CompilerPass> inliningCompilerPasses;
    private List<CompilerPass> jitPasses;
    private List<CompilerPass> safePasses;
    private final RubyInstanceConfig config;
    private boolean dryRun = false;
    private TemporaryLocalVariable[] temporaryLocalVariables = new TemporaryLocalVariable[1600];

    public IRManager(RubyInstanceConfig config) {
        this.config = config;
        this.compilerPasses = CompilerPass.getPassesFromString(RubyInstanceConfig.IR_COMPILER_PASSES, "LocalOptimizationPass");
        this.inliningCompilerPasses = CompilerPass.getPassesFromString(RubyInstanceConfig.IR_COMPILER_PASSES, "LocalOptimizationPass");
        this.jitPasses = CompilerPass.getPassesFromString(RubyInstanceConfig.IR_JIT_PASSES, DEFAULT_JIT_PASSES);
        this.safePasses = CompilerPass.getPassesFromString(null, SAFE_COMPILER_PASSES);
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean value2) {
        this.dryRun = value2;
    }

    public Nil getNil() {
        return this.nil;
    }

    public Boolean getTrue() {
        return this.tru;
    }

    public Boolean getFalse() {
        return this.fals;
    }

    public IRModuleBody getObject() {
        return this.object;
    }

    public CompilerPassScheduler schedulePasses() {
        return IRManager.schedulePasses(this.compilerPasses);
    }

    public static CompilerPassScheduler schedulePasses(final List<CompilerPass> passes) {
        CompilerPassScheduler scheduler = new CompilerPassScheduler(){
            private Iterator<CompilerPass> iterator;
            {
                this.iterator = passes.iterator();
            }

            @Override
            public Iterator<CompilerPass> iterator() {
                return this.iterator;
            }
        };
        return scheduler;
    }

    public List<CompilerPass> getCompilerPasses(IRScope scope) {
        return this.compilerPasses;
    }

    public List<CompilerPass> getInliningCompilerPasses(IRScope scope) {
        return this.inliningCompilerPasses;
    }

    public List<CompilerPass> getJITPasses(IRScope scope) {
        return this.jitPasses;
    }

    public List<CompilerPass> getSafePasses(IRScope scope) {
        return this.safePasses;
    }

    public Set<CompilerPassListener> getListeners() {
        if (RubyInstanceConfig.IR_COMPILER_DEBUG) {
            this.addListener(this.defaultListener);
        } else {
            this.removeListener(this.defaultListener);
        }
        return this.passListeners;
    }

    public InstructionsListener getInstructionsListener() {
        return this.instrsListener;
    }

    public IRScopeListener getIRScopeListener() {
        return this.irScopeListener;
    }

    public void addListener(CompilerPassListener listener) {
        this.passListeners.add(listener);
    }

    public void removeListener(CompilerPassListener listener) {
        this.passListeners.remove(listener);
    }

    public void addListener(InstructionsListener listener) {
        if (RubyInstanceConfig.IR_COMPILER_DEBUG || RubyInstanceConfig.IR_VISUALIZER) {
            if (this.instrsListener != null) {
                throw new RuntimeException("InstructionsListener is set and other are currently not allowed");
            }
            this.instrsListener = listener;
        }
    }

    public void removeListener(InstructionsListener listener) {
        if (this.instrsListener.equals(listener)) {
            this.instrsListener = null;
        }
    }

    public void addListener(IRScopeListener listener) {
        if (RubyInstanceConfig.IR_COMPILER_DEBUG || RubyInstanceConfig.IR_VISUALIZER) {
            if (this.irScopeListener != null) {
                throw new RuntimeException("IRScopeListener is set and other are currently not allowed");
            }
            this.irScopeListener = listener;
        }
    }

    public void removeListener(IRScopeListener listener) {
        if (this.irScopeListener.equals(listener)) {
            this.irScopeListener = null;
        }
    }

    public String getMetaClassName() {
        return "<DUMMY_MC:" + this.dummyMetaClassCount++ + ">";
    }

    protected TemporaryLocalVariable[] growTemporaryVariablePool(int index2) {
        int newLength = index2 * 2;
        TemporaryLocalVariable[] newPool = new TemporaryLocalVariable[newLength];
        System.arraycopy(this.temporaryLocalVariables, 0, newPool, 0, this.temporaryLocalVariables.length);
        this.temporaryLocalVariables = newPool;
        return newPool;
    }

    public TemporaryLocalVariable newTemporaryLocalVariable(int index2) {
        TemporaryLocalVariable tempVar;
        if (index2 >= this.temporaryLocalVariables.length - 1) {
            this.growTemporaryVariablePool(index2);
        }
        if ((tempVar = this.temporaryLocalVariables[index2]) == null) {
            this.temporaryLocalVariables[index2] = tempVar = new TemporaryLocalVariable(index2);
        }
        return tempVar;
    }

    public Instr[] optimizeTemporaryVariablesIfEnabled(IRScope scope, Instr[] instrs) {
        return OptimizeTempVarsPass.optimizeTmpVars(scope, instrs);
    }

    protected void optimizeIfSimpleScope(IRScope scope) {
        if (RubyInstanceConfig.IR_COMPILER_PASSES != null) {
            return;
        }
        EnumSet<IRFlags> flags2 = scope.getFlags();
        if (!scope.isUnsafeScope() && !flags2.contains((Object)IRFlags.REQUIRES_DYNSCOPE)) {
            if (flags2.contains((Object)IRFlags.RECEIVES_CLOSURE_ARG)) {
                this.optimizeDelegationPass.run(scope);
            }
            this.deadCodeEliminationPass.run(scope);
            this.optimizeDynScopesPass.run(scope);
        }
    }

    public RubyInstanceConfig getInstanceConfig() {
        return this.config;
    }
}

