/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.unsafe;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import sun.misc.Unsafe;

public final class UnsafeHolder {
    public static final Unsafe U = UnsafeHolder.loadUnsafe();
    public static final boolean SUPPORTS_FENCES = UnsafeHolder.supportsFences();
    public static final long ARRAY_OBJECT_BASE_OFFSET = UnsafeHolder.arrayObjectBaseOffset();
    public static final long ARRAY_OBJECT_INDEX_SCALE = UnsafeHolder.arrayObjectIndexScale();

    private UnsafeHolder() {
    }

    private static Unsafe loadUnsafe() {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field f = unsafeClass.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return (Unsafe)f.get(null);
        }
        catch (Exception e) {
            return null;
        }
        catch (NoClassDefFoundError ncdfe) {
            return null;
        }
    }

    private static long arrayObjectBaseOffset() {
        if (U == null) {
            return 0L;
        }
        return U.arrayBaseOffset(Object[].class);
    }

    private static long arrayObjectIndexScale() {
        if (U == null) {
            return 0L;
        }
        return U.arrayIndexScale(Object[].class);
    }

    private static boolean supportsFences() {
        if (U == null) {
            return false;
        }
        try {
            Method m = U.getClass().getDeclaredMethod("fullFence", new Class[0]);
            if (m != null) {
                return true;
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return false;
    }

    public static long fieldOffset(Class clazz, String name2) {
        if (U == null) {
            return -1L;
        }
        try {
            return U.objectFieldOffset(clazz.getDeclaredField(name2));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static void fullFence() {
    }

    public static void loadFence() {
    }

    public static void storeFence() {
    }
}

