/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jruby.ast.visitor.AbstractNodeVisitor;
import org.jruby.lexer.yacc.DetailedSourcePosition;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.InvalidSourcePosition;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.util.cli.Options;

public abstract class Translator
extends AbstractNodeVisitor<RubyNode> {
    public static final Set<String> PRINT_AST_METHOD_NAMES = new HashSet<String>(Arrays.asList(Options.TRUFFLE_TRANSLATOR_PRINT_AST.load().split(",")));
    public static final Set<String> PRINT_FULL_AST_METHOD_NAMES = new HashSet<String>(Arrays.asList(Options.TRUFFLE_TRANSLATOR_PRINT_FULL_AST.load().split(",")));
    public static final Set<String> PRINT_PARSE_TREE_METHOD_NAMES = new HashSet<String>(Arrays.asList(Options.TRUFFLE_TRANSLATOR_PRINT_PARSE_TREE.load().split(",")));
    protected final RubyNode currentNode;
    protected final RubyContext context;
    protected final Source source;
    protected SourceSection parentSourceSection;

    public Translator(RubyNode currentNode, RubyContext context, Source source2) {
        this.currentNode = currentNode;
        this.context = context;
        this.source = source2;
    }

    protected SourceSection translate(ISourcePosition sourcePosition) {
        return this.translate(this.source, sourcePosition);
    }

    public SourceSection translate(Source source2, ISourcePosition sourcePosition) {
        if (sourcePosition == InvalidSourcePosition.INSTANCE) {
            if (this.parentSourceSection == null) {
                throw new UnsupportedOperationException("Truffle doesn't want invalid positions - find a way to give me a real position!");
            }
            return this.parentSourceSection;
        }
        if (sourcePosition instanceof DetailedSourcePosition) {
            DetailedSourcePosition detailedSourcePosition = (DetailedSourcePosition)sourcePosition;
            try {
                return source2.createSection(this.getIdentifier(), detailedSourcePosition.getOffset(), detailedSourcePosition.getLength());
            }
            catch (IllegalArgumentException e) {
                return source2.createSection(this.getIdentifier(), sourcePosition.getLine() + 1);
            }
        }
        if (Options.TRUFFLE_ALLOW_SIMPLE_SOURCE_SECTIONS.load().booleanValue()) {
            return source2.createSection(this.getIdentifier(), sourcePosition.getLine() + 1);
        }
        throw new UnsupportedOperationException("Truffle needs detailed source positions unless you know what you are doing and set truffle.allow_simple_source_sections - got " + sourcePosition.getClass());
    }

    protected abstract String getIdentifier();
}

