/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.util;

import com.oracle.truffle.api.CompilerAsserts;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;

public abstract class ArrayUtils {
    public static int[] extractRange(int[] source2, int start2, int end2) {
        assert (ArrayUtils.assertExtractRangeArgs(source2, start2, end2));
        int length2 = end2 - start2;
        int[] result2 = new int[length2];
        System.arraycopy(source2, start2, result2, 0, length2);
        return result2;
    }

    public static long[] extractRange(long[] source2, int start2, int end2) {
        assert (ArrayUtils.assertExtractRangeArgs(source2, start2, end2));
        int length2 = end2 - start2;
        long[] result2 = new long[length2];
        System.arraycopy(source2, start2, result2, 0, length2);
        return result2;
    }

    public static double[] extractRange(double[] source2, int start2, int end2) {
        assert (ArrayUtils.assertExtractRangeArgs(source2, start2, end2));
        int length2 = end2 - start2;
        double[] result2 = new double[length2];
        System.arraycopy(source2, start2, result2, 0, length2);
        return result2;
    }

    public static Object[] extractRange(Object[] source2, int start2, int end2) {
        assert (ArrayUtils.assertExtractRangeArgs(source2, start2, end2));
        int length2 = end2 - start2;
        Object[] result2 = new Object[length2];
        System.arraycopy(source2, start2, result2, 0, length2);
        return result2;
    }

    private static boolean assertExtractRangeArgs(Object source2, int start2, int end2) {
        assert (source2 != null);
        assert (start2 >= 0);
        assert (start2 <= Array.getLength(source2));
        assert (end2 >= start2);
        assert (end2 <= Array.getLength(source2));
        return true;
    }

    public static boolean contains(int[] array, int value2) {
        for (int n = 0; n < array.length; ++n) {
            if (array[n] != value2) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(long[] array, long value2) {
        for (int n = 0; n < array.length; ++n) {
            if (array[n] != value2) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(double[] array, double value2) {
        for (int n = 0; n < array.length; ++n) {
            if (array[n] != value2) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Object[] array, int length2, Object value2) {
        for (int n = 0; n < length2; ++n) {
            if (!array[n].equals(value2)) continue;
            return true;
        }
        return false;
    }

    public static Object[] box(int[] unboxed) {
        return ArrayUtils.box(unboxed, 0);
    }

    public static Object[] box(long[] unboxed) {
        return ArrayUtils.box(unboxed, 0);
    }

    public static Object[] box(double[] unboxed) {
        return ArrayUtils.box(unboxed, 0);
    }

    public static Object[] box(Object array) {
        return ArrayUtils.box(array, 0);
    }

    public static Object[] box(int[] unboxed, int extra) {
        Object[] boxed = new Object[unboxed.length + extra];
        for (int n = 0; n < unboxed.length; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] box(long[] unboxed, int extra) {
        Object[] boxed = new Object[unboxed.length + extra];
        for (int n = 0; n < unboxed.length; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] box(double[] unboxed, int extra) {
        Object[] boxed = new Object[unboxed.length + extra];
        for (int n = 0; n < unboxed.length; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] boxUntil(int[] unboxed, int length2) {
        Object[] boxed = new Object[length2];
        for (int n = 0; n < length2; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] boxUntil(long[] unboxed, int length2) {
        Object[] boxed = new Object[length2];
        for (int n = 0; n < length2; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] boxUntil(double[] unboxed, int length2) {
        Object[] boxed = new Object[length2];
        for (int n = 0; n < length2; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] box(Object array, int extra) {
        CompilerAsserts.neverPartOfCompilation();
        if (array == null) {
            return new Object[extra];
        }
        if (array instanceof int[]) {
            return ArrayUtils.box((int[])array, extra);
        }
        if (array instanceof long[]) {
            return ArrayUtils.box((long[])array, extra);
        }
        if (array instanceof double[]) {
            return ArrayUtils.box((double[])array, extra);
        }
        if (array instanceof Object[]) {
            Object[] objectArray = (Object[])array;
            return Arrays.copyOf(objectArray, objectArray.length + extra);
        }
        throw new UnsupportedOperationException();
    }

    public static int[] unboxInteger(Object[] unboxed, int length2) {
        CompilerAsserts.neverPartOfCompilation();
        int[] boxed = new int[length2];
        for (int n = 0; n < length2; ++n) {
            boxed[n] = (Integer)unboxed[n];
        }
        return boxed;
    }

    public static long[] unboxLong(Object[] unboxed, int length2) {
        CompilerAsserts.neverPartOfCompilation();
        long[] boxed = new long[length2];
        for (int n = 0; n < length2; ++n) {
            Object value2 = unboxed[n];
            if (value2 instanceof Integer) {
                boxed[n] = ((Integer)unboxed[n]).intValue();
                continue;
            }
            if (!(value2 instanceof Long)) continue;
            boxed[n] = (Long)unboxed[n];
        }
        return boxed;
    }

    public static double[] unboxDouble(Object[] unboxed, int length2) {
        CompilerAsserts.neverPartOfCompilation();
        double[] boxed = new double[length2];
        for (int n = 0; n < length2; ++n) {
            boxed[n] = (Double)unboxed[n];
        }
        return boxed;
    }

    public static void copy(Object source2, Object[] destination, int destinationStart, int length2) {
        RubyNode.notDesignedForCompilation();
        if (length2 == 0) {
            return;
        }
        if (source2 instanceof int[]) {
            int[] unboxedSource = (int[])source2;
            for (int n = 0; n < length2; ++n) {
                destination[destinationStart + n] = unboxedSource[n];
            }
        } else if (source2 instanceof long[]) {
            long[] unboxedSource = (long[])source2;
            for (int n = 0; n < length2; ++n) {
                destination[destinationStart + n] = unboxedSource[n];
            }
        } else if (source2 instanceof double[]) {
            double[] unboxedSource = (double[])source2;
            for (int n = 0; n < length2; ++n) {
                destination[destinationStart + n] = unboxedSource[n];
            }
        } else if (source2 instanceof Object[]) {
            RubyArguments.arraycopy((Object[])source2, 0, destination, destinationStart, length2);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static long[] longCopyOf(int[] ints) {
        long[] longs = new long[ints.length];
        for (int n = 0; n < ints.length; ++n) {
            longs[n] = ints[n];
        }
        return longs;
    }

    public static int capacity(int current2, int needed) {
        int capacity;
        if (needed < 16) {
            return 16;
        }
        for (capacity = current2; capacity < needed; capacity *= 2) {
        }
        return capacity;
    }
}

